/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.httpstreamer.model.IHTTPStreamerAdapter;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.util.IIdleNotify;
import com.wowza.wms.vhost.VHostSessionHolder;
import com.wowza.wms.vhost.VHostSessionIdleBase;
import com.wowza.wms.vhost.VHostSessionIdleRTSP;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;

public class VHostSessionIdleHTTPStreamer
extends VHostSessionIdleBase
implements IIdleNotify {
    public VHostSessionIdleHTTPStreamer(VHostSessionHolder vHostSessionHolder) {
        super(vHostSessionHolder);
    }

    public void onIdle(long l) {
        try {
            IHTTPStreamerAdapter iHTTPStreamerAdapter;
            RtmpSessionInfo rtmpSessionInfo;
            if (this.sessionHolder.vhost != null && this.sessionHolder.session != null && (rtmpSessionInfo = (RtmpSessionInfo)this.sessionHolder.session.getAttribute("wmsSessionInfo")) != null && (iHTTPStreamerAdapter = rtmpSessionInfo.getHTTPStreamerAdapter()) != null) {
                long l2 = iHTTPStreamerAdapter.getIdleFrequency();
                long l3 = Math.max(this.sessionHolder.session.getLastIoTime(), this.sessionHolder.session.getLastIdleTime(IdleStatus.BOTH_IDLE));
                long l4 = this.sessionHolder.session.getLastIdleTime(IdleStatus.BOTH_IDLE);
                if (l2 > 0L && l3 != 0L && l - l4 >= l2) {
                    this.sessionHolder.session.increaseIdleCount(IdleStatus.BOTH_IDLE);
                    this.sessionHolder.session.getFilterChain().fireSessionIdle((IoSession)this.sessionHolder.session, IdleStatus.BOTH_IDLE);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostSessionIdleRTSP.class).error("VHostSessionIdleRTSP.onIdle: " + exception.toString());
        }
    }
}

