/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.file;

import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.LiveStreamPacketizerCupertinoUtils;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.media.mp3.model.idtags.ID3Frames;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.ModuleUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPStreamerCupertinoIndexBase
implements IHTTPStreamerCupertinoIndex {
    protected List<IHTTPStreamerCupertinoIndexItem> items = new ArrayList<IHTTPStreamerCupertinoIndexItem>();
    protected String titleStr = "";
    protected CupertinoEncInfo encInfo = null;
    protected IHTTPStreamerApplicationContext appContext = null;
    protected IApplicationInstance appInstance = null;
    protected String streamExt = null;
    protected String streamName = null;
    protected IMediaStream stream = null;
    protected IHTTPStreamerSession httpStreamerSession = null;
    protected int chunkDurationTarget = 10000;
    protected boolean init = true;
    protected boolean relativePlaylistItems = true;
    protected boolean relativePlaylistPlaylists = false;
    protected int streamMode = 1;
    protected int audioBitrate = -1;
    protected int audioCodec = 10;
    protected int videoBitrate = -1;
    protected MediaCodecInfoVideo codecInfoVideo = new MediaCodecInfoVideo();
    protected MediaCodecInfoAudio codecInfoAudio = new MediaCodecInfoAudio();

    @Override
    public void init(IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, IHTTPStreamerSession iHTTPStreamerSession, String string, String string2, String string3) {
        this.appContext = iHTTPStreamerApplicationContext;
        this.appInstance = iHTTPStreamerApplicationContext.getAppInstance();
        this.streamExt = string2;
        this.streamName = string3;
        this.httpStreamerSession = iHTTPStreamerSession;
        this.codecInfoVideo.setCodecId(7);
        this.codecInfoAudio.setCodecId(10);
        WMSProperties wMSProperties = iHTTPStreamerApplicationContext.getProperties();
        WMSProperties wMSProperties2 = this.appInstance.getProperties();
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean("relativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean("relativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean("cupertinoRelativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean("cupertinoRelativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistPlaylists = wMSProperties.getPropertyBoolean("relativePlaylistPlaylists", this.relativePlaylistPlaylists);
        this.relativePlaylistPlaylists = wMSProperties2.getPropertyBoolean("relativePlaylistPlaylists", this.relativePlaylistPlaylists);
        this.relativePlaylistPlaylists = wMSProperties.getPropertyBoolean("cupertinoRelativePlaylistPlaylists", this.relativePlaylistPlaylists);
        this.relativePlaylistPlaylists = wMSProperties2.getPropertyBoolean("cupertinoRelativePlaylistPlaylists", this.relativePlaylistPlaylists);
    }

    protected String adjustStreamName(String string) {
        String string2 = "";
        String string3 = "mp4";
        if ((string = ((ApplicationInstance)this.appInstance).internalResolvePlayAlias(string, this.httpStreamerSession)) != null) {
            String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string3);
            string = stringArray[0];
            string3 = stringArray[1];
            boolean bl = string.indexOf("://") >= 0;
            int n = string.indexOf("?");
            if (!bl && n >= 0) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
        }
        return string;
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }

    @Override
    public IHTTPStreamerApplicationContext getApplicationContext() {
        return this.appContext;
    }

    @Override
    public List<String> getStreamNamesRaw() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.streamName);
        return arrayList;
    }

    @Override
    public List<String> getStreamNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.adjustStreamName(this.streamName);
        if (string != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public LiveStreamPacketizerCupertinoChunk getChunk(String string, boolean bl) {
        LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk;
        block1: {
            IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem;
            liveStreamPacketizerCupertinoChunk = null;
            int n = LiveStreamPacketizerCupertinoUtils.chunkFilenameToIndex(string);
            if (n <= 0) break block1;
            int n2 = n - 1;
            IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem2 = iHTTPStreamerCupertinoIndexItem = n2 < this.items.size() ? this.items.get(n - 1) : null;
            if (iHTTPStreamerCupertinoIndexItem != null) {
                liveStreamPacketizerCupertinoChunk = new LiveStreamPacketizerCupertinoChunk(n);
                this.fillChunk(iHTTPStreamerCupertinoIndexItem, liveStreamPacketizerCupertinoChunk, bl);
            }
        }
        return liveStreamPacketizerCupertinoChunk;
    }

    public void init() {
        if (this.init) {
            WMSProperties wMSProperties = this.appContext.getProperties();
            WMSProperties wMSProperties2 = this.appContext.getAppInstance().getHTTPStreamerProperties();
            this.chunkDurationTarget = wMSProperties.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
            this.chunkDurationTarget = wMSProperties2.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
            this.chunkDurationTarget = wMSProperties.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
            this.chunkDurationTarget = wMSProperties2.getPropertyInt("cupertinoChunkDurationTarget", this.chunkDurationTarget);
            this.init = false;
        }
    }

    @Override
    public String getPlaylistStr(boolean bl) {
        this.init();
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        long l2 = 0L;
        String string = Math.round(this.chunkDurationTarget / 1000) + "";
        stringBuffer.append("#EXTM3U\n");
        if (this.encInfo != null) {
            Object object = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"".replace("{encmethod}", "AES-128");
            String object2 = this.encInfo.getEncUrl();
            if (object2 != null) {
                String string2 = "?";
                if (object2.indexOf("?") >= 0) {
                    string2 = "&";
                }
                object = ((String)object).replace("{enckeyurl}", object2 + string2 + "{query}");
            }
            stringBuffer.append((String)object + "\n");
        }
        stringBuffer.append("#EXT-X-TARGETDURATION:" + string + "\n");
        stringBuffer.append("#EXT-X-MEDIA-SEQUENCE:1\n");
        for (IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem : this.items) {
            int n = (int)Math.round((double)(iHTTPStreamerCupertinoIndexItem.getStopTimecode() - l) / 1000.0);
            if (n <= 0) {
                n = 1;
            }
            l += (long)(n * 1000);
            ++l2;
            String string3 = this.relativePlaylistItems ? "{filename}?{query}" : "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
            int n2 = this.streamMode;
            if (bl) {
                n2 = this.audioCodec == 2 ? 2 : 3;
            }
            stringBuffer.append("#EXTINF:" + n + "," + this.titleStr + "\n");
            stringBuffer.append(string3.replace("{filename}", "media_{index}{ext}".replace("{index}", l2 + "")).replace("{ext}", LiveStreamPacketizerCupertinoUtils.streamModeToFileExtension(n2)) + "\n");
        }
        stringBuffer.append("#EXT-X-ENDLIST\n");
        return stringBuffer.toString();
    }

    @Override
    public int addIndexItem(IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem) {
        this.items.add(iHTTPStreamerCupertinoIndexItem);
        return this.items.size() - 1;
    }

    @Override
    public int getIndexCount() {
        return this.items.size();
    }

    @Override
    public IHTTPStreamerCupertinoIndexItem getIndexItem(int n) {
        if (n < this.items.size()) {
            return this.items.get(n);
        }
        return null;
    }

    @Override
    public String getTitleStr() {
        return this.titleStr;
    }

    @Override
    public void setTitleStr(String string) {
        this.titleStr = string;
    }

    @Override
    public boolean isDoEncryption() {
        return this.encInfo != null;
    }

    @Override
    public CupertinoEncInfo getEncInfo() {
        return this.encInfo;
    }

    @Override
    public String getEncURL() {
        return this.encInfo == null ? null : this.encInfo.getEncUrl();
    }

    @Override
    public IHTTPStreamerSession getHttpStreamerSession() {
        return this.httpStreamerSession;
    }

    @Override
    public String getStreamName() {
        return this.streamName;
    }

    @Override
    public int getStreamMode() {
        return this.streamMode;
    }

    @Override
    public void setStreamMode(int n) {
        this.streamMode = n;
    }

    @Override
    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    @Override
    public int getID3Bitrate(boolean bl) {
        return 0;
    }

    @Override
    public void setAudioBitrate(int n) {
        this.audioBitrate = n;
    }

    @Override
    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    @Override
    public void setVideoBitrate(int n) {
        this.videoBitrate = n;
    }

    @Override
    public int getAudioCodec() {
        return this.audioCodec;
    }

    @Override
    public void setAudioCodec(int n) {
        this.audioCodec = n;
    }

    @Override
    public ID3Frames getID3FramesHeader() {
        return null;
    }

    @Override
    public ID3Frames getID3FramesFooter() {
        return null;
    }

    @Override
    public ID3Frames getID3FramesHeaderAudio() {
        return null;
    }

    @Override
    public ID3Frames getID3FramesFooterAudio() {
        return null;
    }

    @Override
    public MediaCodecInfoVideo getCodecInfoVideo() {
        return this.codecInfoVideo;
    }

    @Override
    public MediaCodecInfoAudio getCodecInfoAudio() {
        return this.codecInfoAudio;
    }

    @Override
    public String getCodecsStr() {
        String string = null;
        String string2 = this.codecInfoAudioToCodecsStr(this.codecInfoAudio);
        String string3 = this.codecInfoVideoToCodecsStr(this.codecInfoVideo);
        string = string3 != null && string2 != null ? string3 + ", " + string2 : (string3 != null ? string3 : (string2 != null ? string2 : null));
        return string;
    }

    @Override
    public String getCodecsAudioStr() {
        return this.codecInfoAudioToCodecsStr(this.codecInfoAudio);
    }

    @Override
    public String getResolutionStr() {
        return this.codecInfoVideoToResolutionStr(this.codecInfoVideo);
    }

    private String codecInfoAudioToCodecsStr(MediaCodecInfoAudio mediaCodecInfoAudio) {
        String string = null;
        if (mediaCodecInfoAudio != null) {
            switch (mediaCodecInfoAudio.getCodecId()) {
                case 10: {
                    if (mediaCodecInfoAudio.getAudioObjectType() <= 0) break;
                    string = "mp4a.40." + mediaCodecInfoAudio.getAudioObjectType();
                    break;
                }
                case 2: {
                    string = "mp4a.40.34";
                }
            }
        }
        return string;
    }

    private String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo != null) {
            switch (mediaCodecInfoVideo.getCodecId()) {
                case 7: {
                    int n = mediaCodecInfoVideo.getVideoLevel();
                    int n2 = mediaCodecInfoVideo.getVideoProfile();
                    if (n <= 0 || n2 <= 0) break;
                    string = "avc1." + n2 + "." + n;
                }
            }
        }
        return string;
    }

    private String codecInfoVideoToResolutionStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo != null) {
            int n = mediaCodecInfoVideo.getDisplayWidth();
            int n2 = mediaCodecInfoVideo.getDisplayHeight();
            if (n > 0 && n2 > 0) {
                string = n + "x" + n2;
            }
        }
        return string;
    }
}

