/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.ts.TransportStreamUtils;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.packetizer.RTPMPEGTSFill;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamPacketizerCupertinoChunker {
    public static final int PATINTERVAL = 90;
    public static final int PCRINTERVAL = 36;
    public static final int TS_PACKETLEN = 188;
    public static final int TS_RTPHEADER = 12;
    public static final int TS_SYNCBYTE = 71;
    public static final int TS_PACKETPERBLOCK = 8;
    public static final int MP3BLOCKSIZE = 4096;
    private boolean isRTPWrapped = false;
    private long lastPAT = -1L;
    private long lastPCR = -1L;
    private long startPCRRT = -1L;
    private long startPCRTimecode = -1L;
    private byte[] block = null;
    private int pcount = 0;
    private int pptr = 0;
    private int videoPID = 256;
    private int audioPID = 257;
    private byte videoStreamID = (byte)-32;
    private byte audioStreamID = (byte)-64;
    private long videoCCounter = -1L;
    private long audioCCounter = -1L;
    private long patCCounter = 0L;
    private AACFrame aacFrame = null;
    private H264CodecConfigParts h264CodecConfigPart = null;
    private long lastAudioTimecode = -1L;
    private long lastVideoTimecode = -1L;
    private long lastPCRTimecode = -1L;
    private boolean isFirstAudioPacket = true;
    private boolean isFirstVideoPacket = false;
    private WaitingAudio waitingAudio = new WaitingAudio();
    private int nextChunkId = 0;
    private boolean sendAudio = true;
    private int audioGroupCount = 3;
    private boolean forceH264BaselineProfile = false;
    private int forceAACProfile = -1;
    private byte[] pendingMP3Block = null;
    private int pendingMP3Index = 0;

    private void nextBlock(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk) {
        if (this.block == null || this.pcount >= 8) {
            if (this.block != null) {
                this.flushBlock(liveStreamPacketizerCupertinoChunk, false);
            }
            this.block = new byte[(this.isRTPWrapped ? 12 : 0) + 1504];
            this.pcount = 1;
            this.pptr = this.isRTPWrapped ? 12 : 0;
        } else {
            ++this.pcount;
            this.pptr += 188;
        }
    }

    private void flushBlock(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, boolean bl) {
        block2: {
            int n;
            if (this.block == null) break block2;
            if (this.isRTPWrapped) {
                // empty if block
            }
            if ((n = (this.isRTPWrapped ? 12 : 0) + this.pcount * 188) > 0) {
                liveStreamPacketizerCupertinoChunk.addBlock(this.block, 0, n);
            }
        }
    }

    private void resetBlocks() {
        this.block = null;
        this.pcount = 0;
    }

    private void sendPAT(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, int n, int n2) {
        this.nextBlock(liveStreamPacketizerCupertinoChunk);
        int n3 = TransportStreamUtils.videoCodecToStreamType((int)n);
        int n4 = TransportStreamUtils.audioCodecToStreamType((int)n2);
        TransportStreamUtils.fillPAT((byte[])this.block, (int)this.pptr, (long)this.patCCounter);
        this.nextBlock(liveStreamPacketizerCupertinoChunk);
        TransportStreamUtils.fillPMT((byte[])this.block, (int)this.pptr, (long)this.patCCounter, (int)this.videoPID, (int)this.audioPID, (int)n3, (int)n4);
        ++this.patCCounter;
    }

    private long getPCRTimecode() {
        long l = -1L;
        if (this.lastAudioTimecode >= 0L && this.lastVideoTimecode >= 0L) {
            l = Math.min(this.lastAudioTimecode, this.lastVideoTimecode);
        } else if (this.lastAudioTimecode >= 0L) {
            l = this.lastAudioTimecode;
        } else if (this.lastVideoTimecode >= 0L) {
            l = this.lastVideoTimecode;
        }
        if (this.lastPCRTimecode != -1L && l < this.lastPCRTimecode) {
            l = this.lastPCRTimecode;
        }
        if (l < 0L) {
            l = 0L;
        }
        this.lastPCRTimecode = l;
        return l;
    }

    private void writeAudioPackets(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, WaitingAudio waitingAudio, long l, boolean bl) {
        long l2;
        int n = waitingAudio.size;
        long l3 = l2 = waitingAudio.timecode;
        boolean bl2 = false;
        int n2 = 0;
        RTPPacketFragment rTPPacketFragment = waitingAudio.fragments.remove(0);
        int n3 = 0;
        int n4 = rTPPacketFragment.getOffset();
        int n5 = rTPPacketFragment.getLen();
        byte[] byArray = rTPPacketFragment.getBuffer();
        boolean bl3 = true;
        do {
            long l4;
            int n6;
            int n7;
            int n8;
            int n9 = 0;
            this.nextBlock(liveStreamPacketizerCupertinoChunk);
            this.block[this.pptr + n9] = 71;
            this.block[this.pptr + ++n9] = (byte)((bl3 ? 64 : 0) + (0x1F & this.audioPID >> 8));
            this.block[this.pptr + ++n9] = (byte)(this.audioPID & 0xFF);
            this.audioCCounter = this.audioCCounter == -1L ? 1L : ++this.audioCCounter;
            this.block[this.pptr + ++n9] = (byte)(16L + (this.audioCCounter & 0xFL));
            ++n9;
            int n10 = 0;
            if (bl3) {
                n10 = 9 + (bl2 ? 10 : 5);
            }
            if ((n8 = 188 - n9 - n10) > n - n2) {
                n8 = n - n2;
            }
            if (bl) {
                int n11 = this.pptr + 3;
                this.block[n11] = (byte)(this.block[n11] | 0x20);
                n7 = 8;
                n8 = 188 - n9 - n10 - n7;
                if (n8 > n - n2) {
                    n8 = n - n2;
                }
                if ((n6 = 188 - (n9 + n8 + n10 + n7)) < 0) {
                    n6 = 0;
                }
                this.block[this.pptr + n9] = (byte)(n7 - 1 + n6 & 0xFF);
                this.block[this.pptr + ++n9] = (byte)(this.isFirstAudioPacket ? 144 : 16);
                l4 = l;
                byte[] byArray2 = BufferUtils.longToByteArray((long)(l4 <<= 7));
                this.block[this.pptr + ++n9 + 4] = (byte)((byArray2[7] & 0x80) + 126);
                this.block[this.pptr + n9 + 3] = (byte)(byArray2[6] & 0xFF);
                this.block[this.pptr + n9 + 2] = (byte)(byArray2[5] & 0xFF);
                this.block[this.pptr + n9 + 1] = (byte)(byArray2[4] & 0xFF);
                this.block[this.pptr + n9 + 0] = (byte)(byArray2[3] & 0xFF);
                n9 += 6;
                if (n6 > 0) {
                    System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n9, n6);
                    n9 += n6;
                }
                if ((n8 = 188 - n9 - n10) > n - n2) {
                    n8 = n - n2;
                }
            } else if (n9 + n8 + n10 < 188) {
                n7 = 188 - (n9 + n8 + n10);
                int n12 = this.pptr + 3;
                this.block[n12] = (byte)(this.block[n12] | 0x20);
                if (n7 > 1) {
                    this.block[this.pptr + n9] = (byte)(--n7 & 0xFF);
                    this.block[this.pptr + ++n9] = 0;
                    ++n9;
                    if (--n7 > 0) {
                        System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n9, n7);
                    }
                    n9 += n7;
                } else {
                    this.block[this.pptr + n9] = 0;
                    ++n9;
                }
            }
            if (bl3) {
                this.block[this.pptr + n9] = 0;
                this.block[this.pptr + ++n9] = 0;
                this.block[this.pptr + ++n9] = 1;
                this.block[this.pptr + ++n9] = this.audioStreamID;
                n7 = bl2 ? 10 : 5;
                n6 = n + n7 + 3;
                BufferUtils.intToByteArray((int)n6, (byte[])this.block, (int)(this.pptr + ++n9), (int)2);
                this.block[this.pptr + (n9 += 2)] = -128;
                this.block[this.pptr + ++n9] = (byte)(bl2 ? 192 : 128);
                this.block[this.pptr + ++n9] = (byte)n7;
                l4 = l3;
                this.block[this.pptr + ++n9 + 4] = (byte)(((l4 & 0x7FL) << 1) + 1L);
                this.block[this.pptr + n9 + 3] = (byte)((l4 >>= 7) & 0xFFL);
                this.block[this.pptr + n9 + 2] = (byte)((((l4 >>= 8) & 0x7FL) << 1) + 1L);
                this.block[this.pptr + n9 + 1] = (byte)((l4 >>= 7) & 0xFFL);
                this.block[this.pptr + n9 + 0] = (byte)((((l4 >>= 8) & 7L) << 1) + 1L + (long)(bl2 ? 48 : 32));
                n9 += 5;
                if (bl2) {
                    l4 = l2;
                    this.block[this.pptr + n9 + 4] = (byte)(((l4 & 0x7FL) << 1) + 1L);
                    this.block[this.pptr + n9 + 3] = (byte)((l4 >>= 7) & 0xFFL);
                    this.block[this.pptr + n9 + 2] = (byte)((((l4 >>= 8) & 0x7FL) << 1) + 1L);
                    this.block[this.pptr + n9 + 1] = (byte)((l4 >>= 7) & 0xFFL);
                    this.block[this.pptr + n9 + 0] = (byte)((((l4 >>= 8) & 7L) << 1) + 1L + 32L);
                    n9 += 5;
                }
            }
            do {
                if ((n7 = n8) > n5 - n3) {
                    n7 = n5 - n3;
                }
                liveStreamPacketizerCupertinoChunk.incDataSize(n7);
                System.arraycopy(byArray, n4 + n3, this.block, this.pptr + n9, n7);
                n9 += n7;
                n2 += n7;
                n8 -= n7;
                if ((n3 += n7) < n5) continue;
                n3 = 0;
                if (waitingAudio.fragments.size() <= 0) continue;
                rTPPacketFragment = waitingAudio.fragments.remove(0);
                n4 = rTPPacketFragment.getOffset();
                n5 = rTPPacketFragment.getLen();
                byArray = rTPPacketFragment.getBuffer();
            } while (n9 < 188 && n2 < n);
            bl3 = false;
            this.isFirstAudioPacket = false;
        } while (n2 < n);
    }

    private LiveStreamingCupertinoBlock rewriteH264Profile(byte[] byArray, int n, int n2) {
        byte by;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (byArray2.length > 1) {
            byArray2[1] = 66;
        }
        if (byArray2.length > 3 && (by = byArray2[3]) > 30) {
            byArray2[3] = 30;
        }
        return new LiveStreamingCupertinoBlock(byArray2, 0, n2);
    }

    public int handleAMFPacket(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, AMFPacket aMFPacket, long l, int n, int n2, int n3) {
        int n4;
        block41: {
            int n5;
            Object object;
            int n6;
            int n7;
            byte[] byArray;
            int n8;
            int n9;
            int n10;
            block44: {
                Object object2;
                int n11;
                int n12;
                block42: {
                    int n13;
                    byte[] byArray2;
                    block43: {
                        n4 = 0;
                        long l2 = l;
                        if (liveStreamPacketizerCupertinoChunk.isWritePAT()) {
                            this.lastPAT = l2;
                            this.sendPAT(liveStreamPacketizerCupertinoChunk, n, n2);
                            liveStreamPacketizerCupertinoChunk.setWritePAT(false);
                        }
                        if (aMFPacket.getSize() < 2) break block41;
                        n12 = aMFPacket.getType();
                        n10 = aMFPacket.getFirstByte();
                        n11 = aMFPacket.getSecondByte();
                        if (n12 != 8) break block42;
                        if (!this.sendAudio) break block41;
                        byArray2 = aMFPacket.getData();
                        n13 = aMFPacket.getSize();
                        n9 = FLVUtils.getAudioCodec((int)n10);
                        if (n9 != 10 || n11 == 1) break block43;
                        if (n11 != 0) break block41;
                        this.aacFrame = AACUtils.decodeAACCodecConfig((byte[])byArray2, (int)2);
                        break block41;
                    }
                    if (n9 != 10 && n9 != 2 || n9 == 10 && this.aacFrame == null) break block41;
                    if (n9 == 10) {
                        this.aacFrame.setSize(n13 - 2 + 7);
                        object2 = new byte[7];
                        AACUtils.frameToDTSBuffer((AACFrame)this.aacFrame, (byte[])object2, (int)0);
                        this.waitingAudio.fragments.add(new RTPPacketFragment(object2, 0, ((byte[])object2).length));
                        this.waitingAudio.size += ((byte[])object2).length;
                        this.waitingAudio.fragments.add(new RTPPacketFragment(byArray2, 2, n13 - 2));
                        this.waitingAudio.size += n13 - 2;
                        this.waitingAudio.codec = n9;
                    } else if (n9 == 2) {
                        this.waitingAudio.fragments.add(new RTPPacketFragment(byArray2, 1, n13 - 1));
                        this.waitingAudio.size += n13 - 1;
                        this.waitingAudio.codec = n9;
                    }
                    ++this.waitingAudio.count;
                    if (this.waitingAudio.timecode == -1L) {
                        this.waitingAudio.timecode = l;
                    }
                    this.waitingAudio.lastTimecode = l;
                    if (this.waitingAudio.count < n3) break block41;
                    this.lastAudioTimecode = this.waitingAudio.timecode;
                    this.writeAudioPackets(liveStreamPacketizerCupertinoChunk, this.waitingAudio, l, false);
                    this.waitingAudio.clear();
                }
                if (n12 != 9) break block41;
                this.lastVideoTimecode = l;
                n8 = FLVUtils.getVideoCodec((int)n10);
                byArray = aMFPacket.getData();
                n9 = aMFPacket.getSize();
                if (n8 != 7 || n11 == 1) break block44;
                if (n11 != 0) break block41;
                this.h264CodecConfigPart = H264Utils.breakApartAVCC((byte[])byArray, (int)5, (int)(n9 - 5));
                object2 = H264Utils.decodeAVCC((byte[])byArray, (int)5);
                break block41;
            }
            if (n8 != 7) break block41;
            int n14 = BufferUtils.byteArrayToInt((byte[])byArray, (int)2, (int)3);
            long l3 = l;
            long l4 = n14 == 0 ? l3 : l + (long)(n14 * 90);
            boolean bl = true;
            ArrayList<RTPPacketFragment> arrayList = new ArrayList<RTPPacketFragment>();
            byte[] byArray3 = new byte[4];
            byArray3[3] = 1;
            int n15 = 0;
            int n16 = 0;
            int n17 = 5;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n18 = FLVUtils.getFrameType((int)n10);
            while (n17 + 4 <= n9 && (n7 = BufferUtils.byteArrayToInt((byte[])byArray, (int)n17, (int)4)) > 0 && (n17 += 4) + n7 <= n9) {
                n6 = byArray[n17] & 0x1F;
                if (n6 == 7) {
                    bl2 = true;
                } else if (n6 == 8) {
                    bl3 = true;
                } else if (n6 == 9) {
                    bl4 = true;
                }
                arrayList.add(new RTPPacketFragment(byArray3, 0, byArray3.length));
                object = byArray;
                int n19 = n17;
                n5 = n7;
                if (n6 == 7 && this.forceH264BaselineProfile) {
                    LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = this.rewriteH264Profile((byte[])object, n19, n5);
                    object = liveStreamingCupertinoBlock.buffer;
                    n19 = liveStreamingCupertinoBlock.offset;
                    n5 = liveStreamingCupertinoBlock.len;
                }
                arrayList.add(new RTPPacketFragment(object, n19, n5));
                n15 += n7 + byArray3.length;
                ++n16;
                if ((n17 += n7) < n9) continue;
                break;
            }
            n7 = 0;
            n6 = 0;
            if (!bl4) {
                if (!bl4) {
                    object = new byte[6];
                    object[3] = 1;
                    object[4] = 9;
                    object[5] = n18 == 1 ? 16 : (n18 == 3 ? 80 : 48);
                    arrayList.add(n6, new RTPPacketFragment(object, 0, ((byte[])object).length));
                    ++n6;
                    n15 += ((Object)object).length;
                    ++n16;
                    n7 = 1;
                }
            } else {
                n6 = 2;
            }
            if (!(n18 != 1 || bl3 && bl4)) {
                if (n18 == 1 && !bl2 && this.h264CodecConfigPart != null && this.h264CodecConfigPart.sps != null) {
                    object = new byte[4];
                    object[3] = 1;
                    arrayList.add(n6, new RTPPacketFragment(object, 0, ((Object)object).length));
                    ++n6;
                    byte[] byArray4 = this.h264CodecConfigPart.sps;
                    n5 = 0;
                    int n20 = this.h264CodecConfigPart.sps.length;
                    if (this.forceH264BaselineProfile) {
                        LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = this.rewriteH264Profile(byArray4, n5, n20);
                        byArray4 = liveStreamingCupertinoBlock.buffer;
                        n5 = liveStreamingCupertinoBlock.offset;
                        n20 = liveStreamingCupertinoBlock.len;
                    }
                    arrayList.add(n6, new RTPPacketFragment(byArray4, n5, n20));
                    ++n6;
                    n15 += this.h264CodecConfigPart.sps.length + ((byte[])object).length;
                    ++n16;
                    n7 = 1;
                }
                if (n18 == 1 && !bl3 && this.h264CodecConfigPart != null && this.h264CodecConfigPart.ppss != null) {
                    object = this.h264CodecConfigPart.ppss.iterator();
                    while (object.hasNext()) {
                        byte[] byArray5 = (byte[])object.next();
                        byte[] byArray6 = new byte[4];
                        byArray6[3] = 1;
                        arrayList.add(n6, new RTPPacketFragment(byArray6, 0, byArray6.length));
                        arrayList.add(++n6, new RTPPacketFragment(byArray5, 0, byArray5.length));
                        ++n6;
                        n15 += byArray5.length + byArray6.length;
                        ++n16;
                        n7 = 1;
                    }
                }
            }
            if (n16 > 0) {
                int n21 = 0;
                RTPPacketFragment rTPPacketFragment = (RTPPacketFragment)arrayList.remove(0);
                int n22 = 0;
                int n23 = rTPPacketFragment.getOffset();
                int n24 = rTPPacketFragment.getLen();
                byte[] byArray7 = rTPPacketFragment.getBuffer();
                long l5 = this.getPCRTimecode();
                boolean bl5 = true;
                int n25 = 32725;
                int n26 = 0;
                do {
                    bl5 = true;
                    boolean bl6 = true;
                    int n27 = 0;
                    int n28 = n15 - n21;
                    if (n28 > n25) {
                        n28 = n25;
                    }
                    ++n26;
                    do {
                        long l6;
                        int n29;
                        int n30;
                        int n31;
                        int n32 = 0;
                        this.nextBlock(liveStreamPacketizerCupertinoChunk);
                        this.block[this.pptr + n32] = 71;
                        this.block[this.pptr + ++n32] = (byte)((bl5 ? 64 : 0) + (0x1F & this.videoPID >> 8));
                        this.block[this.pptr + ++n32] = (byte)(this.videoPID & 0xFF);
                        this.videoCCounter = this.videoCCounter == -1L ? 1L : ++this.videoCCounter;
                        this.block[this.pptr + ++n32] = (byte)(16L + (this.videoCCounter & 0xFL));
                        ++n32;
                        int n33 = 0;
                        if (bl5) {
                            n33 = 9 + (bl ? 10 : 5);
                        }
                        if ((n31 = 188 - n32 - n33) > n28 - n27) {
                            n31 = n28 - n27;
                        }
                        if (bl6) {
                            int n34 = this.pptr + 3;
                            this.block[n34] = (byte)(this.block[n34] | 0x20);
                            n30 = 8;
                            n31 = 188 - n32 - n33 - n30;
                            if (n31 > n28 - n27) {
                                n31 = n28 - n27;
                            }
                            n29 = 0;
                            if (n32 + n31 + n33 + n30 < 188) {
                                n29 = 188 - (n32 + n31 + n33 + n30);
                            }
                            this.block[this.pptr + n32] = (byte)(n30 - 1 + n29 & 0xFF);
                            this.block[this.pptr + ++n32] = (byte)((this.isFirstVideoPacket ? 144 : 16) | (n18 == 1 ? 64 : 0));
                            l6 = l5;
                            byte[] byArray8 = BufferUtils.longToByteArray((long)(l6 <<= 7));
                            this.block[this.pptr + ++n32 + 4] = (byte)((byArray8[7] & 0x80) + 126);
                            this.block[this.pptr + n32 + 3] = (byte)(byArray8[6] & 0xFF);
                            this.block[this.pptr + n32 + 2] = (byte)(byArray8[5] & 0xFF);
                            this.block[this.pptr + n32 + 1] = (byte)(byArray8[4] & 0xFF);
                            this.block[this.pptr + n32 + 0] = (byte)(byArray8[3] & 0xFF);
                            n32 += 6;
                            if (n29 > 0) {
                                System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n32, n29);
                                n32 += n29;
                            }
                            if ((n31 = 188 - n32 - n33) > n28 - n27) {
                                n31 = n28 - n27;
                            }
                            bl6 = false;
                        } else if (n32 + n31 + n33 < 188) {
                            n30 = 188 - (n32 + n31 + n33);
                            int n35 = this.pptr + 3;
                            this.block[n35] = (byte)(this.block[n35] | 0x20);
                            if (n30 > 1) {
                                this.block[this.pptr + n32] = (byte)(--n30 & 0xFF);
                                this.block[this.pptr + ++n32] = 0;
                                ++n32;
                                if (--n30 > 0) {
                                    System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n32, n30);
                                }
                                n32 += n30;
                            } else {
                                this.block[this.pptr + n32] = 0;
                                ++n32;
                            }
                        }
                        if (bl5) {
                            this.block[this.pptr + n32] = 0;
                            this.block[this.pptr + ++n32] = 0;
                            this.block[this.pptr + ++n32] = 1;
                            this.block[this.pptr + ++n32] = this.videoStreamID;
                            ++n32;
                            n30 = bl ? 10 : 5;
                            n29 = n28 + n30 + 3;
                            if (n29 >= 65536) {
                                System.out.println("toolong: " + n29);
                            }
                            BufferUtils.intToByteArray((int)n29, (byte[])this.block, (int)(this.pptr + n32), (int)2);
                            this.block[this.pptr + (n32 += 2)] = -124;
                            this.block[this.pptr + ++n32] = (byte)(bl ? 192 : 128);
                            this.block[this.pptr + ++n32] = (byte)n30;
                            l6 = l4;
                            this.block[this.pptr + ++n32 + 4] = (byte)(((l6 & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n32 + 3] = (byte)((l6 >>= 7) & 0xFFL);
                            this.block[this.pptr + n32 + 2] = (byte)((((l6 >>= 8) & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n32 + 1] = (byte)((l6 >>= 7) & 0xFFL);
                            this.block[this.pptr + n32 + 0] = (byte)((((l6 >>= 8) & 7L) << 1) + 1L + (long)(bl ? 48 : 32));
                            n32 += 5;
                            if (bl) {
                                l6 = l3;
                                this.block[this.pptr + n32 + 4] = (byte)(((l6 & 0x7FL) << 1) + 1L);
                                this.block[this.pptr + n32 + 3] = (byte)((l6 >>= 7) & 0xFFL);
                                this.block[this.pptr + n32 + 2] = (byte)((((l6 >>= 8) & 0x7FL) << 1) + 1L);
                                this.block[this.pptr + n32 + 1] = (byte)((l6 >>= 7) & 0xFFL);
                                this.block[this.pptr + n32 + 0] = (byte)((((l6 >>= 8) & 7L) << 1) + 1L + (long)(bl ? 16 : 32));
                                n32 += 5;
                            }
                        }
                        do {
                            if ((n30 = n31) > n24 - n22) {
                                n30 = n24 - n22;
                            }
                            liveStreamPacketizerCupertinoChunk.incDataSize(n30);
                            System.arraycopy(byArray7, n23 + n22, this.block, this.pptr + n32, n30);
                            n32 += n30;
                            n21 += n30;
                            n31 -= n30;
                            n27 += n30;
                            if ((n22 += n30) < n24) continue;
                            n22 = 0;
                            if (arrayList.size() <= 0) continue;
                            rTPPacketFragment = (RTPPacketFragment)arrayList.remove(0);
                            n23 = rTPPacketFragment.getOffset();
                            n24 = rTPPacketFragment.getLen();
                            byArray7 = rTPPacketFragment.getBuffer();
                        } while (n32 < 188 && n27 < n28 && n21 < n15);
                        bl5 = false;
                        this.isFirstVideoPacket = false;
                    } while (n27 < n28 && n21 < n15);
                } while (n21 < n15);
            }
        }
        return n4;
    }

    private void startChunk(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk) {
        this.lastPAT = -1L;
    }

    private void stopChunk(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, int n, int n2) {
        if (!this.waitingAudio.isEmpty()) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("LiveStreamPacketizerCupertinoChunker.stopChunk: audio leftover: " + this.waitingAudio.size());
            this.lastAudioTimecode = this.waitingAudio.timecode;
            this.writeAudioPackets(liveStreamPacketizerCupertinoChunk, this.waitingAudio, this.waitingAudio.lastTimecode, false);
            this.waitingAudio.clear();
        }
        this.flushBlock(liveStreamPacketizerCupertinoChunk, true);
        this.resetBlocks();
    }

    private int getRealAudioPacketCount(List<CupertinoPacketHolder> list) {
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            CupertinoPacketHolder cupertinoPacketHolder = list.get(i);
            AMFPacket aMFPacket = cupertinoPacketHolder.getPacket();
            int n3 = aMFPacket.getType();
            if (n3 != 8 || (bl = FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket))) continue;
            ++n2;
        }
        return n2;
    }

    public byte[] getAudioID3TagHeader(long l) {
        byte[] byArray = BufferUtils.decodeHexString((String)"4944330400000000003F50524956000000350000636F6D2E6170706C652E73747265616D696E672E7472616E73706F727453747265616D54696D657374616D700000000000018092A0");
        long l2 = 0x1FFFFFFFFL;
        BufferUtils.longToByteArray((long)(l & l2), (byte[])byArray, (int)(byArray.length - 8), (int)8);
        return byArray;
    }

    public void fillChunk(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, List<CupertinoPacketHolder> list, int n, int n2) {
        if (n2 == 2 && n == -1) {
            this.startupMP3Chunck(liveStreamPacketizerCupertinoChunk);
            boolean bl = true;
            for (CupertinoPacketHolder cupertinoPacketHolder : list) {
                if (bl) {
                    byte[] byArray = this.getAudioID3TagHeader(cupertinoPacketHolder.getTimecode90());
                    liveStreamPacketizerCupertinoChunk.addBlock(byArray, 0, byArray.length);
                    bl = false;
                }
                this.handleAMFPacketMP3(liveStreamPacketizerCupertinoChunk, cupertinoPacketHolder.getPacket(), cupertinoPacketHolder.getTimecode90());
            }
            this.stopMP3Chunck(liveStreamPacketizerCupertinoChunk);
        } else if (n2 == 10 && n == -1) {
            this.startupAACChunck(liveStreamPacketizerCupertinoChunk);
            boolean bl = true;
            for (CupertinoPacketHolder cupertinoPacketHolder : list) {
                if (bl) {
                    byte[] byArray = this.getAudioID3TagHeader(cupertinoPacketHolder.getTimecode90());
                    liveStreamPacketizerCupertinoChunk.addBlock(byArray, 0, byArray.length);
                    bl = false;
                }
                this.handleAMFPacketAAC(liveStreamPacketizerCupertinoChunk, cupertinoPacketHolder.getPacket(), cupertinoPacketHolder.getTimecode90());
            }
            this.stopAACChunck(liveStreamPacketizerCupertinoChunk);
        } else {
            this.startChunk(liveStreamPacketizerCupertinoChunk);
            int n3 = this.getRealAudioPacketCount(list);
            int n4 = n3 / this.audioGroupCount;
            int n5 = n3 % this.audioGroupCount;
            n3 = 0;
            int n6 = list.size();
            for (int i = 0; i < n6; ++i) {
                CupertinoPacketHolder cupertinoPacketHolder = list.get(i);
                AMFPacket aMFPacket = cupertinoPacketHolder.getPacket();
                int n7 = aMFPacket.getType();
                int n8 = this.audioGroupCount + (n3 / this.audioGroupCount + 1 >= n4 ? n5 : 0);
                if (n4 <= 0) {
                    n8 = n5;
                }
                this.handleAMFPacket(liveStreamPacketizerCupertinoChunk, cupertinoPacketHolder.getPacket(), cupertinoPacketHolder.getTimecode90(), n, n2, n8);
                if (n7 != 8 || FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket)) continue;
                ++n3;
            }
            this.stopChunk(liveStreamPacketizerCupertinoChunk, n, n2);
        }
    }

    private void startupMP3Chunck(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk) {
        this.pendingMP3Block = new byte[4096];
        this.pendingMP3Index = 0;
    }

    private void stopMP3Chunck(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk) {
        if (this.pendingMP3Index > 0) {
            liveStreamPacketizerCupertinoChunk.addBlock(this.pendingMP3Block, 0, this.pendingMP3Index);
        }
        this.pendingMP3Block = null;
        this.pendingMP3Index = 0;
    }

    private void addMP3Frame(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, byte[] byArray, int n, int n2) {
        int n3 = 0;
        do {
            int n4;
            if ((n4 = n2 - n3) > this.pendingMP3Block.length - this.pendingMP3Index) {
                n4 = this.pendingMP3Block.length - this.pendingMP3Index;
            }
            System.arraycopy(byArray, n + n3, this.pendingMP3Block, this.pendingMP3Index, n4);
            this.pendingMP3Index += n4;
            n3 += n4;
            if (this.pendingMP3Index < this.pendingMP3Block.length) continue;
            liveStreamPacketizerCupertinoChunk.addBlock(this.pendingMP3Block, 0, this.pendingMP3Index);
            this.pendingMP3Block = new byte[4096];
            this.pendingMP3Index = 0;
        } while (n3 < n2);
    }

    private void handleAMFPacketMP3(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, AMFPacket aMFPacket, long l) {
        if (aMFPacket.getSize() < 2) {
            return;
        }
        int n = 1;
        this.addMP3Frame(liveStreamPacketizerCupertinoChunk, aMFPacket.getData(), n, aMFPacket.getSize() - n);
    }

    private void startupAACChunck(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk) {
        this.pendingMP3Block = new byte[4096];
        this.pendingMP3Index = 0;
    }

    private void stopAACChunck(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk) {
        if (this.pendingMP3Index > 0) {
            liveStreamPacketizerCupertinoChunk.addBlock(this.pendingMP3Block, 0, this.pendingMP3Index);
        }
        this.pendingMP3Block = null;
        this.pendingMP3Index = 0;
    }

    private void addAACFrame(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, byte[] byArray, int n, int n2) {
        int n3 = 0;
        do {
            int n4;
            if ((n4 = n2 - n3) > this.pendingMP3Block.length - this.pendingMP3Index) {
                n4 = this.pendingMP3Block.length - this.pendingMP3Index;
            }
            System.arraycopy(byArray, n + n3, this.pendingMP3Block, this.pendingMP3Index, n4);
            this.pendingMP3Index += n4;
            n3 += n4;
            if (this.pendingMP3Index < this.pendingMP3Block.length) continue;
            liveStreamPacketizerCupertinoChunk.addBlock(this.pendingMP3Block, 0, this.pendingMP3Index);
            this.pendingMP3Block = new byte[4096];
            this.pendingMP3Index = 0;
        } while (n3 < n2);
    }

    private void handleAMFPacketAAC(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, AMFPacket aMFPacket, long l) {
        block1: {
            int n;
            int n2;
            byte[] byArray;
            block2: {
                if (aMFPacket.getSize() < 2) {
                    return;
                }
                int n3 = aMFPacket.getType();
                int n4 = aMFPacket.getFirstByte();
                int n5 = aMFPacket.getSecondByte();
                if (n3 != 8) break block1;
                byArray = aMFPacket.getData();
                n2 = aMFPacket.getSize();
                n = FLVUtils.getAudioCodec((int)n4);
                if (n != 10 || n5 == 1) break block2;
                if (n5 != 0) break block1;
                this.aacFrame = AACUtils.decodeAACCodecConfig((byte[])byArray, (int)2);
                break block1;
            }
            if (n != 10 && n != 2 || n == 10 && this.aacFrame == null || n != 10) break block1;
            this.aacFrame.setSize(n2 - 2 + 7);
            byte[] byArray2 = new byte[7];
            AACUtils.frameToDTSBuffer((AACFrame)this.aacFrame, (byte[])byArray2, (int)0);
            this.addAACFrame(liveStreamPacketizerCupertinoChunk, byArray2, 0, byArray2.length);
            this.addAACFrame(liveStreamPacketizerCupertinoChunk, byArray, 2, n2 - 2);
        }
    }

    public boolean isSendAudio() {
        return this.sendAudio;
    }

    public void setSendAudio(boolean bl) {
        this.sendAudio = bl;
    }

    public int getAudioGroupCount() {
        return this.audioGroupCount;
    }

    public void setAudioGroupCount(int n) {
        this.audioGroupCount = n;
    }

    public boolean isForceH264BaselineProfile() {
        return this.forceH264BaselineProfile;
    }

    public void setForceH264BaselineProfile(boolean bl) {
        this.forceH264BaselineProfile = bl;
    }

    public int getForceAACProfile() {
        return this.forceAACProfile;
    }

    public void setForceAACProfile(int n) {
        this.forceAACProfile = n;
    }

    class WaitingAudio {
        long timecode = -1L;
        long lastTimecode = -1L;
        int count = 0;
        int size = 0;
        int codec = 0;
        List<RTPPacketFragment> fragments = new ArrayList<RTPPacketFragment>();

        WaitingAudio() {
        }

        public void clear() {
            this.timecode = -1L;
            this.lastTimecode = -1L;
            this.count = 0;
            this.size = 0;
            this.fragments.clear();
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }
    }
}

