/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.pattern.FormattingInfo;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.pattern.PatternConverter;

public final class PatternParser {
    private static final char ESCAPE_CHAR = '%';
    private static final int LITERAL_STATE = 0;
    private static final int CONVERTER_STATE = 1;
    private static final int DOT_STATE = 3;
    private static final int MIN_STATE = 4;
    private static final int MAX_STATE = 5;
    private static final Map PATTERN_LAYOUT_RULES;
    private static final Map FILENAME_PATTERN_RULES;
    static /* synthetic */ Class class$org$apache$log4j$pattern$LoggerPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$ClassNamePatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$DatePatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$FileLocationPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$FullLocationPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$LineLocationPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$MessagePatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$LineSeparatorPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$MethodLocationPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$LevelPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$RelativeTimePatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$ThreadPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$NDCPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$PropertiesPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$SequenceNumberPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$ThrowableInformationPatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$FileDatePatternConverter;
    static /* synthetic */ Class class$org$apache$log4j$pattern$IntegerPatternConverter;

    private PatternParser() {
    }

    public static Map getPatternLayoutRules() {
        return PATTERN_LAYOUT_RULES;
    }

    public static Map getFileNamePatternRules() {
        return FILENAME_PATTERN_RULES;
    }

    private static int extractConverter(char c, String string, int n, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        stringBuffer.setLength(0);
        if (!Character.isUnicodeIdentifierStart(c)) {
            return n;
        }
        stringBuffer.append(c);
        while (n < string.length() && Character.isUnicodeIdentifierPart(string.charAt(n))) {
            stringBuffer.append(string.charAt(n));
            stringBuffer2.append(string.charAt(n));
            ++n;
        }
        return n;
    }

    private static int extractOptions(String string, int n, List list) {
        int n2;
        while (n < string.length() && string.charAt(n) == '{' && (n2 = string.indexOf(125, n)) != -1) {
            String string2 = string.substring(n + 1, n2);
            list.add(string2);
            n = n2 + 1;
        }
        return n;
    }

    public static void parse(String string, List list, List list2, Map map, Map map2) {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        FormattingInfo formattingInfo = FormattingInfo.getDefault();
        while (n3 < n) {
            char c = string.charAt(n3++);
            block0 : switch (n2) {
                case 0: {
                    if (n3 == n) {
                        stringBuffer.append(c);
                        break;
                    }
                    if (c == '%') {
                        switch (string.charAt(n3)) {
                            case '%': {
                                stringBuffer.append(c);
                                ++n3;
                                break block0;
                            }
                        }
                        if (stringBuffer.length() != 0) {
                            list.add(new LiteralPatternConverter(stringBuffer.toString()));
                            list2.add(FormattingInfo.getDefault());
                        }
                        stringBuffer.setLength(0);
                        stringBuffer.append(c);
                        n2 = 1;
                        formattingInfo = FormattingInfo.getDefault();
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 1: {
                    stringBuffer.append(c);
                    switch (c) {
                        case '-': {
                            formattingInfo = new FormattingInfo(true, formattingInfo.getMinLength(), formattingInfo.getMaxLength());
                            break block0;
                        }
                        case '.': {
                            n2 = 3;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), c - 48, formattingInfo.getMaxLength());
                        n2 = 4;
                        break;
                    }
                    n3 = PatternParser.finalizeConverter(c, string, n3, stringBuffer, formattingInfo, map, map2, list, list2);
                    n2 = 0;
                    formattingInfo = FormattingInfo.getDefault();
                    stringBuffer.setLength(0);
                    break;
                }
                case 4: {
                    stringBuffer.append(c);
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength() * 10 + (c - 48), formattingInfo.getMaxLength());
                        break;
                    }
                    if (c == '.') {
                        n2 = 3;
                        break;
                    }
                    n3 = PatternParser.finalizeConverter(c, string, n3, stringBuffer, formattingInfo, map, map2, list, list2);
                    n2 = 0;
                    formattingInfo = FormattingInfo.getDefault();
                    stringBuffer.setLength(0);
                    break;
                }
                case 3: {
                    stringBuffer.append(c);
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), c - 48);
                        n2 = 5;
                        break;
                    }
                    LogLog.error("Error occured in position " + n3 + ".\n Was expecting digit, instead got char \"" + c + "\".");
                    n2 = 0;
                    break;
                }
                case 5: {
                    stringBuffer.append(c);
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), formattingInfo.getMaxLength() * 10 + (c - 48));
                        break;
                    }
                    n3 = PatternParser.finalizeConverter(c, string, n3, stringBuffer, formattingInfo, map, map2, list, list2);
                    n2 = 0;
                    formattingInfo = FormattingInfo.getDefault();
                    stringBuffer.setLength(0);
                }
            }
        }
        if (stringBuffer.length() != 0) {
            list.add(new LiteralPatternConverter(stringBuffer.toString()));
            list2.add(FormattingInfo.getDefault());
        }
    }

    private static PatternConverter createConverter(String string, StringBuffer stringBuffer, Map map, Map map2, List list) {
        String string2 = string;
        Object var6_6 = null;
        for (int i = string.length(); i > 0 && var6_6 == null; --i) {
            string2 = string2.substring(0, i);
            if (map != null) {
                var6_6 = map.get(string2);
            }
            if (var6_6 != null || map2 == null) continue;
            var6_6 = map2.get(string2);
        }
        if (var6_6 == null) {
            LogLog.error("Unrecognized format specifier [" + string + "]");
            return null;
        }
        Class clazz = null;
        if (var6_6 instanceof Class) {
            clazz = var6_6;
        } else if (var6_6 instanceof String) {
            try {
                clazz = Loader.loadClass(var6_6);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogLog.warn("Class for conversion pattern %" + string2 + " not found", classNotFoundException);
                return null;
            }
        } else {
            LogLog.warn("Bad map entry for conversion pattern %" + string2 + ".");
            return null;
        }
        try {
            Method method = clazz.getMethod("newInstance", Class.forName("[Ljava.lang.String;"));
            String[] stringArray = new String[list.size()];
            stringArray = list.toArray(stringArray);
            Object object = method.invoke(null, new Object[]{stringArray});
            if (object instanceof PatternConverter) {
                stringBuffer.delete(0, stringBuffer.length() - (string.length() - string2.length()));
                return (PatternConverter)object;
            }
            LogLog.warn("Class " + clazz.getName() + " does not extend PatternConverter.");
        }
        catch (Exception exception) {
            LogLog.error("Error creating converter for " + string, exception);
            try {
                PatternConverter patternConverter = (PatternConverter)clazz.newInstance();
                stringBuffer.delete(0, stringBuffer.length() - (string.length() - string2.length()));
                return patternConverter;
            }
            catch (Exception exception2) {
                LogLog.error("Error creating converter for " + string, exception2);
            }
        }
        return null;
    }

    private static int finalizeConverter(char c, String string, int n, StringBuffer stringBuffer, FormattingInfo formattingInfo, Map map, Map map2, List list, List list2) {
        StringBuffer stringBuffer2 = new StringBuffer();
        n = PatternParser.extractConverter(c, string, n, stringBuffer2, stringBuffer);
        String string2 = stringBuffer2.toString();
        ArrayList arrayList = new ArrayList();
        n = PatternParser.extractOptions(string, n, arrayList);
        PatternConverter patternConverter = PatternParser.createConverter(string2, stringBuffer, map, map2, arrayList);
        if (patternConverter == null) {
            StringBuffer stringBuffer3;
            if (string2 == null || string2.length() == 0) {
                stringBuffer3 = new StringBuffer("Empty conversion specifier starting at position ");
            } else {
                stringBuffer3 = new StringBuffer("Unrecognized conversion specifier [");
                stringBuffer3.append(string2);
                stringBuffer3.append("] starting at position ");
            }
            stringBuffer3.append(Integer.toString(n));
            stringBuffer3.append(" in conversion pattern.");
            LogLog.error(stringBuffer3.toString());
            list.add(new LiteralPatternConverter(stringBuffer.toString()));
            list2.add(FormattingInfo.getDefault());
        } else {
            list.add(patternConverter);
            list2.add(formattingInfo);
            if (stringBuffer.length() > 0) {
                list.add(new LiteralPatternConverter(stringBuffer.toString()));
                list2.add(FormattingInfo.getDefault());
            }
        }
        stringBuffer.setLength(0);
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        HashMap<String, Class> hashMap = new HashMap<String, Class>(17);
        hashMap.put("c", class$org$apache$log4j$pattern$LoggerPatternConverter == null ? (class$org$apache$log4j$pattern$LoggerPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LoggerPatternConverter")) : class$org$apache$log4j$pattern$LoggerPatternConverter);
        hashMap.put("logger", class$org$apache$log4j$pattern$LoggerPatternConverter == null ? (class$org$apache$log4j$pattern$LoggerPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LoggerPatternConverter")) : class$org$apache$log4j$pattern$LoggerPatternConverter);
        hashMap.put("C", class$org$apache$log4j$pattern$ClassNamePatternConverter == null ? (class$org$apache$log4j$pattern$ClassNamePatternConverter = PatternParser.class$("org.apache.log4j.pattern.ClassNamePatternConverter")) : class$org$apache$log4j$pattern$ClassNamePatternConverter);
        hashMap.put("class", class$org$apache$log4j$pattern$ClassNamePatternConverter == null ? (class$org$apache$log4j$pattern$ClassNamePatternConverter = PatternParser.class$("org.apache.log4j.pattern.ClassNamePatternConverter")) : class$org$apache$log4j$pattern$ClassNamePatternConverter);
        hashMap.put("d", class$org$apache$log4j$pattern$DatePatternConverter == null ? (class$org$apache$log4j$pattern$DatePatternConverter = PatternParser.class$("org.apache.log4j.pattern.DatePatternConverter")) : class$org$apache$log4j$pattern$DatePatternConverter);
        hashMap.put("date", class$org$apache$log4j$pattern$DatePatternConverter == null ? (class$org$apache$log4j$pattern$DatePatternConverter = PatternParser.class$("org.apache.log4j.pattern.DatePatternConverter")) : class$org$apache$log4j$pattern$DatePatternConverter);
        hashMap.put("F", class$org$apache$log4j$pattern$FileLocationPatternConverter == null ? (class$org$apache$log4j$pattern$FileLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.FileLocationPatternConverter")) : class$org$apache$log4j$pattern$FileLocationPatternConverter);
        hashMap.put("file", class$org$apache$log4j$pattern$FileLocationPatternConverter == null ? (class$org$apache$log4j$pattern$FileLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.FileLocationPatternConverter")) : class$org$apache$log4j$pattern$FileLocationPatternConverter);
        hashMap.put("l", class$org$apache$log4j$pattern$FullLocationPatternConverter == null ? (class$org$apache$log4j$pattern$FullLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.FullLocationPatternConverter")) : class$org$apache$log4j$pattern$FullLocationPatternConverter);
        hashMap.put("L", class$org$apache$log4j$pattern$LineLocationPatternConverter == null ? (class$org$apache$log4j$pattern$LineLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LineLocationPatternConverter")) : class$org$apache$log4j$pattern$LineLocationPatternConverter);
        hashMap.put("line", class$org$apache$log4j$pattern$LineLocationPatternConverter == null ? (class$org$apache$log4j$pattern$LineLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LineLocationPatternConverter")) : class$org$apache$log4j$pattern$LineLocationPatternConverter);
        hashMap.put("m", class$org$apache$log4j$pattern$MessagePatternConverter == null ? (class$org$apache$log4j$pattern$MessagePatternConverter = PatternParser.class$("org.apache.log4j.pattern.MessagePatternConverter")) : class$org$apache$log4j$pattern$MessagePatternConverter);
        hashMap.put("message", class$org$apache$log4j$pattern$MessagePatternConverter == null ? (class$org$apache$log4j$pattern$MessagePatternConverter = PatternParser.class$("org.apache.log4j.pattern.MessagePatternConverter")) : class$org$apache$log4j$pattern$MessagePatternConverter);
        hashMap.put("n", class$org$apache$log4j$pattern$LineSeparatorPatternConverter == null ? (class$org$apache$log4j$pattern$LineSeparatorPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LineSeparatorPatternConverter")) : class$org$apache$log4j$pattern$LineSeparatorPatternConverter);
        hashMap.put("M", class$org$apache$log4j$pattern$MethodLocationPatternConverter == null ? (class$org$apache$log4j$pattern$MethodLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.MethodLocationPatternConverter")) : class$org$apache$log4j$pattern$MethodLocationPatternConverter);
        hashMap.put("method", class$org$apache$log4j$pattern$MethodLocationPatternConverter == null ? (class$org$apache$log4j$pattern$MethodLocationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.MethodLocationPatternConverter")) : class$org$apache$log4j$pattern$MethodLocationPatternConverter);
        hashMap.put("p", class$org$apache$log4j$pattern$LevelPatternConverter == null ? (class$org$apache$log4j$pattern$LevelPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LevelPatternConverter")) : class$org$apache$log4j$pattern$LevelPatternConverter);
        hashMap.put("level", class$org$apache$log4j$pattern$LevelPatternConverter == null ? (class$org$apache$log4j$pattern$LevelPatternConverter = PatternParser.class$("org.apache.log4j.pattern.LevelPatternConverter")) : class$org$apache$log4j$pattern$LevelPatternConverter);
        hashMap.put("r", class$org$apache$log4j$pattern$RelativeTimePatternConverter == null ? (class$org$apache$log4j$pattern$RelativeTimePatternConverter = PatternParser.class$("org.apache.log4j.pattern.RelativeTimePatternConverter")) : class$org$apache$log4j$pattern$RelativeTimePatternConverter);
        hashMap.put("relative", class$org$apache$log4j$pattern$RelativeTimePatternConverter == null ? (class$org$apache$log4j$pattern$RelativeTimePatternConverter = PatternParser.class$("org.apache.log4j.pattern.RelativeTimePatternConverter")) : class$org$apache$log4j$pattern$RelativeTimePatternConverter);
        hashMap.put("t", class$org$apache$log4j$pattern$ThreadPatternConverter == null ? (class$org$apache$log4j$pattern$ThreadPatternConverter = PatternParser.class$("org.apache.log4j.pattern.ThreadPatternConverter")) : class$org$apache$log4j$pattern$ThreadPatternConverter);
        hashMap.put("thread", class$org$apache$log4j$pattern$ThreadPatternConverter == null ? (class$org$apache$log4j$pattern$ThreadPatternConverter = PatternParser.class$("org.apache.log4j.pattern.ThreadPatternConverter")) : class$org$apache$log4j$pattern$ThreadPatternConverter);
        hashMap.put("x", class$org$apache$log4j$pattern$NDCPatternConverter == null ? (class$org$apache$log4j$pattern$NDCPatternConverter = PatternParser.class$("org.apache.log4j.pattern.NDCPatternConverter")) : class$org$apache$log4j$pattern$NDCPatternConverter);
        hashMap.put("ndc", class$org$apache$log4j$pattern$NDCPatternConverter == null ? (class$org$apache$log4j$pattern$NDCPatternConverter = PatternParser.class$("org.apache.log4j.pattern.NDCPatternConverter")) : class$org$apache$log4j$pattern$NDCPatternConverter);
        hashMap.put("X", class$org$apache$log4j$pattern$PropertiesPatternConverter == null ? (class$org$apache$log4j$pattern$PropertiesPatternConverter = PatternParser.class$("org.apache.log4j.pattern.PropertiesPatternConverter")) : class$org$apache$log4j$pattern$PropertiesPatternConverter);
        hashMap.put("properties", class$org$apache$log4j$pattern$PropertiesPatternConverter == null ? (class$org$apache$log4j$pattern$PropertiesPatternConverter = PatternParser.class$("org.apache.log4j.pattern.PropertiesPatternConverter")) : class$org$apache$log4j$pattern$PropertiesPatternConverter);
        hashMap.put("sn", class$org$apache$log4j$pattern$SequenceNumberPatternConverter == null ? (class$org$apache$log4j$pattern$SequenceNumberPatternConverter = PatternParser.class$("org.apache.log4j.pattern.SequenceNumberPatternConverter")) : class$org$apache$log4j$pattern$SequenceNumberPatternConverter);
        hashMap.put("sequenceNumber", class$org$apache$log4j$pattern$SequenceNumberPatternConverter == null ? (class$org$apache$log4j$pattern$SequenceNumberPatternConverter = PatternParser.class$("org.apache.log4j.pattern.SequenceNumberPatternConverter")) : class$org$apache$log4j$pattern$SequenceNumberPatternConverter);
        hashMap.put("throwable", class$org$apache$log4j$pattern$ThrowableInformationPatternConverter == null ? (class$org$apache$log4j$pattern$ThrowableInformationPatternConverter = PatternParser.class$("org.apache.log4j.pattern.ThrowableInformationPatternConverter")) : class$org$apache$log4j$pattern$ThrowableInformationPatternConverter);
        PATTERN_LAYOUT_RULES = new ReadOnlyMap(hashMap);
        HashMap<String, Class> hashMap2 = new HashMap<String, Class>(4);
        hashMap2.put("d", class$org$apache$log4j$pattern$FileDatePatternConverter == null ? (class$org$apache$log4j$pattern$FileDatePatternConverter = PatternParser.class$("org.apache.log4j.pattern.FileDatePatternConverter")) : class$org$apache$log4j$pattern$FileDatePatternConverter);
        hashMap2.put("date", class$org$apache$log4j$pattern$FileDatePatternConverter == null ? (class$org$apache$log4j$pattern$FileDatePatternConverter = PatternParser.class$("org.apache.log4j.pattern.FileDatePatternConverter")) : class$org$apache$log4j$pattern$FileDatePatternConverter);
        hashMap2.put("i", class$org$apache$log4j$pattern$IntegerPatternConverter == null ? (class$org$apache$log4j$pattern$IntegerPatternConverter = PatternParser.class$("org.apache.log4j.pattern.IntegerPatternConverter")) : class$org$apache$log4j$pattern$IntegerPatternConverter);
        hashMap2.put("index", class$org$apache$log4j$pattern$IntegerPatternConverter == null ? (class$org$apache$log4j$pattern$IntegerPatternConverter = PatternParser.class$("org.apache.log4j.pattern.IntegerPatternConverter")) : class$org$apache$log4j$pattern$IntegerPatternConverter);
        FILENAME_PATTERN_RULES = new ReadOnlyMap(hashMap2);
    }

    private static class ReadOnlyMap
    implements Map {
        private final Map map;

        public ReadOnlyMap(Map map) {
            this.map = map;
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        public Set entrySet() {
            return this.map.entrySet();
        }

        public Object get(Object object) {
            return this.map.get(object);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Set keySet() {
            return this.map.keySet();
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }

        public Collection values() {
            return this.map.values();
        }
    }
}

