/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.reflect;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.reflect.MemberUtils;

public class FieldUtils {
    public static Field getField(Class clazz, String string) {
        Field field = FieldUtils.getField(clazz, string, false);
        MemberUtils.setAccessibleWorkaround(field);
        return field;
    }

    public static Field getField(Class clazz, String string, boolean bl) {
        Object object;
        AnnotatedElement annotatedElement;
        if (clazz == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("The field name must not be null");
        }
        for (annotatedElement = clazz; annotatedElement != null; annotatedElement = annotatedElement.getSuperclass()) {
            try {
                object = annotatedElement.getDeclaredField(string);
                if (!Modifier.isPublic(((Field)object).getModifiers())) {
                    if (!bl) continue;
                    ((Field)object).setAccessible(true);
                }
                return object;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        annotatedElement = null;
        object = ClassUtils.getAllInterfaces(clazz).iterator();
        while (object.hasNext()) {
            try {
                Field field = ((Class)object.next()).getField(string);
                if (annotatedElement != null) {
                    throw new IllegalArgumentException("Reference to field " + string + " is ambiguous relative to " + clazz + "; a matching field exists on two or more implemented interfaces.");
                }
                annotatedElement = field;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return annotatedElement;
    }

    public static Field getDeclaredField(Class clazz, String string) {
        return FieldUtils.getDeclaredField(clazz, string, false);
    }

    public static Field getDeclaredField(Class clazz, String string, boolean bl) {
        if (clazz == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("The field name must not be null");
        }
        try {
            Field field = clazz.getDeclaredField(string);
            if (!MemberUtils.isAccessible(field)) {
                if (bl) {
                    field.setAccessible(true);
                } else {
                    return null;
                }
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Object readStaticField(Field field) throws IllegalAccessException {
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readStaticField(Field field, boolean bl) throws IllegalAccessException {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("The field '" + field.getName() + "' is not static");
        }
        return FieldUtils.readField(field, (Object)null, bl);
    }

    public static Object readStaticField(Class clazz, String string) throws IllegalAccessException {
        return FieldUtils.readStaticField(clazz, string, false);
    }

    public static Object readStaticField(Class clazz, String string, boolean bl) throws IllegalAccessException {
        Field field = FieldUtils.getField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate field " + string + " on " + clazz);
        }
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readDeclaredStaticField(Class clazz, String string) throws IllegalAccessException {
        return FieldUtils.readDeclaredStaticField(clazz, string, false);
    }

    public static Object readDeclaredStaticField(Class clazz, String string, boolean bl) throws IllegalAccessException {
        Field field = FieldUtils.getDeclaredField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + clazz.getName() + "." + string);
        }
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readField(Field field, Object object) throws IllegalAccessException {
        return FieldUtils.readField(field, object, false);
    }

    public static Object readField(Field field, Object object, boolean bl) throws IllegalAccessException {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (bl && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        return field.get(object);
    }

    public static Object readField(Object object, String string) throws IllegalAccessException {
        return FieldUtils.readField(object, string, false);
    }

    public static Object readField(Object object, String string, boolean bl) throws IllegalAccessException {
        if (object == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate field " + string + " on " + clazz);
        }
        return FieldUtils.readField(field, object);
    }

    public static Object readDeclaredField(Object object, String string) throws IllegalAccessException {
        return FieldUtils.readDeclaredField(object, string, false);
    }

    public static Object readDeclaredField(Object object, String string, boolean bl) throws IllegalAccessException {
        if (object == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getDeclaredField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + clazz.getName() + "." + string);
        }
        return FieldUtils.readField(field, object);
    }

    public static void writeStaticField(Field field, Object object) throws IllegalAccessException {
        FieldUtils.writeStaticField(field, object, false);
    }

    public static void writeStaticField(Field field, Object object, boolean bl) throws IllegalAccessException {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("The field '" + field.getName() + "' is not static");
        }
        FieldUtils.writeField(field, (Object)null, object, bl);
    }

    public static void writeStaticField(Class clazz, String string, Object object) throws IllegalAccessException {
        FieldUtils.writeStaticField(clazz, string, object, false);
    }

    public static void writeStaticField(Class clazz, String string, Object object, boolean bl) throws IllegalAccessException {
        Field field = FieldUtils.getField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate field " + string + " on " + clazz);
        }
        FieldUtils.writeStaticField(field, object);
    }

    public static void writeDeclaredStaticField(Class clazz, String string, Object object) throws IllegalAccessException {
        FieldUtils.writeDeclaredStaticField(clazz, string, object, false);
    }

    public static void writeDeclaredStaticField(Class clazz, String string, Object object, boolean bl) throws IllegalAccessException {
        Field field = FieldUtils.getDeclaredField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + clazz.getName() + "." + string);
        }
        FieldUtils.writeField(field, (Object)null, object);
    }

    public static void writeField(Field field, Object object, Object object2) throws IllegalAccessException {
        FieldUtils.writeField(field, object, object2, false);
    }

    public static void writeField(Field field, Object object, Object object2, boolean bl) throws IllegalAccessException {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (bl && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        field.set(object, object2);
    }

    public static void writeField(Object object, String string, Object object2) throws IllegalAccessException {
        FieldUtils.writeField(object, string, object2, false);
    }

    public static void writeField(Object object, String string, Object object2, boolean bl) throws IllegalAccessException {
        if (object == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + clazz.getName() + "." + string);
        }
        FieldUtils.writeField(field, object, object2);
    }

    public static void writeDeclaredField(Object object, String string, Object object2) throws IllegalAccessException {
        FieldUtils.writeDeclaredField(object, string, object2, false);
    }

    public static void writeDeclaredField(Object object, String string, Object object2, boolean bl) throws IllegalAccessException {
        if (object == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getDeclaredField(clazz, string, bl);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + clazz.getName() + "." + string);
        }
        FieldUtils.writeField(field, object, object2);
    }
}

