/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.h264.atom;

import com.wowza.util.BufferUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;

public class QTFragmentTrakData {
    private int trackId = 0;
    private long currSample = 0L;
    private DataOutputStream sttsOut = null;
    private DataOutputStream stssOut = null;
    private DataOutputStream stscOut = null;
    private DataOutputStream stszOut = null;
    private DataOutputStream stcoOut = null;
    private DataOutputStream cttsOut = null;
    private ByteArrayOutputStream sttsBytes = null;
    private ByteArrayOutputStream stssBytes = null;
    private ByteArrayOutputStream stscBytes = null;
    private ByteArrayOutputStream stszBytes = null;
    private ByteArrayOutputStream stcoBytes = null;
    private ByteArrayOutputStream cttsBytes = null;
    private int stscLastChunk = 0;
    private int cttsZeroCount = 0;
    private boolean allZero = true;
    private int sttsLastDuration = -1;
    private int sttsLastDurationCount = 0;
    private int cttsLastDuration = -1;
    private int cttsLastDurationCount = 0;
    private byte[] buffer = new byte[8];

    public QTFragmentTrakData(int n) {
        this.trackId = n;
        this.init();
    }

    public void init() {
        this.sttsBytes = new ByteArrayOutputStream(2048);
        this.sttsOut = new DataOutputStream(this.sttsBytes);
        this.stssBytes = new ByteArrayOutputStream(2048);
        this.stssOut = new DataOutputStream(this.stssBytes);
        this.stscBytes = new ByteArrayOutputStream(2048);
        this.stscOut = new DataOutputStream(this.stscBytes);
        this.stszBytes = new ByteArrayOutputStream(2048);
        this.stszOut = new DataOutputStream(this.stszBytes);
        this.stcoBytes = new ByteArrayOutputStream(2048);
        this.stcoOut = new DataOutputStream(this.stcoBytes);
        this.cttsBytes = new ByteArrayOutputStream(2048);
        this.cttsOut = new DataOutputStream(this.cttsBytes);
    }

    public byte[] getSTTSBytes() {
        return this.sttsBytes.toByteArray();
    }

    public byte[] getSTSSBytes() {
        return this.stssBytes.toByteArray();
    }

    public byte[] getSTSCBytes() {
        return this.stscBytes.toByteArray();
    }

    public byte[] getSTSZBytes() {
        return this.stszBytes.toByteArray();
    }

    public byte[] getSTCOBytes() {
        return this.stcoBytes.toByteArray();
    }

    public byte[] getCTTSBytes() {
        return this.cttsBytes.toByteArray();
    }

    public void flush() {
        try {
            if (this.sttsLastDuration >= 0) {
                this.sttsOut.writeInt(this.sttsLastDurationCount);
                this.sttsOut.writeInt(this.sttsLastDuration);
                this.sttsLastDuration = -1;
                this.sttsLastDurationCount = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!this.allZero) {
                if (this.cttsLastDuration >= 0) {
                    this.cttsOut.writeInt(this.cttsLastDurationCount);
                    this.cttsOut.writeInt(this.cttsLastDuration);
                    this.cttsLastDuration = -1;
                    this.cttsLastDurationCount = 0;
                }
                this.allZero = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getCurrentSample() {
        return this.currSample;
    }

    public void incCurrentSample(long l) {
        this.currSample += l;
    }

    public void addTimeToSample(int n) {
        try {
            if (this.sttsLastDuration == -1 || this.sttsLastDuration == n) {
                ++this.sttsLastDurationCount;
                this.sttsLastDuration = n;
            } else {
                this.sttsOut.writeInt(this.sttsLastDurationCount);
                this.sttsOut.writeInt(this.sttsLastDuration);
                this.sttsLastDurationCount = 1;
                this.sttsLastDuration = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addSyncSample(long l) {
        try {
            BufferUtils.longToByteArray((long)(l + 1L), (byte[])this.buffer, (int)0, (int)4);
            this.stssOut.write(this.buffer, 0, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addChunk(int n, int n2) {
        try {
            this.stscOut.writeInt(this.stscLastChunk + 1);
            this.stscOut.writeInt(n);
            this.stscOut.writeInt(n2);
            ++this.stscLastChunk;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addSampleSize(int n) {
        try {
            this.stszOut.writeInt(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isCTTS() {
        return !this.allZero;
    }

    public void addCTTS(int n) {
        try {
            if (this.allZero && n == 0) {
                ++this.cttsZeroCount;
            } else {
                if (this.allZero) {
                    this.cttsOut.writeInt(this.cttsZeroCount);
                    this.cttsOut.writeInt(0);
                    this.allZero = false;
                }
                if (this.cttsLastDuration == -1 || this.cttsLastDuration == n) {
                    ++this.cttsLastDurationCount;
                    this.cttsLastDuration = n;
                } else {
                    this.cttsOut.writeInt(this.cttsLastDurationCount);
                    this.cttsOut.writeInt(this.cttsLastDuration);
                    this.cttsLastDurationCount = 1;
                    this.cttsLastDuration = n;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addChunkFileOffset(long l) {
        try {
            this.stcoOut.writeLong(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

