/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.publish;

import com.wowza.wms.stream.publish.PlaylistItem;
import com.wowza.wms.stream.publish.Stream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Playlist {
    private String mName;
    private boolean mRepeat;
    private List<PlaylistItem> mList = new ArrayList<PlaylistItem>();

    public Playlist(String string) {
        this.mName = string;
        this.mRepeat = false;
    }

    public List<PlaylistItem> getItems() {
        ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>();
        arrayList.addAll(this.mList);
        return arrayList;
    }

    public boolean getRepeat() {
        return this.mRepeat;
    }

    public void setRepeat(boolean bl) {
        this.mRepeat = bl;
    }

    public void addItem(String string, int n, int n2) {
        int n3 = this.mList.size();
        this.mList.add(new PlaylistItem(string, n, n2, n3));
    }

    private void reIndex() {
        Iterator<PlaylistItem> iterator = this.mList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PlaylistItem playlistItem = iterator.next();
            playlistItem.setIndex(++n);
        }
    }

    public void removeItem(int n) {
        if (n < this.mList.size()) {
            this.mList.remove(n);
            this.reIndex();
        }
    }

    public boolean open(Stream stream) {
        stream.setRepeat(this.mRepeat);
        for (int i = 0; i < this.mList.size(); ++i) {
            int n;
            int n2;
            PlaylistItem playlistItem = this.mList.get(i);
            String string = playlistItem.getName();
            if (stream.play(string, n2 = playlistItem.getStart(), n = playlistItem.getLength(), i == 0)) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.mName;
    }
}

