/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.io;

import com.wowza.io.ITextReader;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class DirectTextFileReader
implements ITextReader {
    private static final Class<DirectTextFileReader> CLASS = DirectTextFileReader.class;
    private static final String CLASSNAME = "DirectTextFileReader";
    protected IApplicationInstance appInstance;
    protected IMediaStream stream;
    protected String basePath;
    protected String mediaName;
    protected File file;
    protected String fullPath;
    protected Object fileLock = new Object();
    protected FileReader fileReader = null;

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.basePath = string;
        this.mediaName = string2;
        this.file = new File(string, string2);
        this.fullPath = this.file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            if (this.fileReader != null) {
                this.close();
            }
            this.fileReader = new FileReader(this.file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            if (this.fileReader == null) {
                return 0;
            }
            return this.fileReader.read(cArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            if (this.fileReader == null) {
                return false;
            }
            return this.fileReader.ready();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            if (this.fileReader != null) {
                this.fileReader.close();
            }
            this.fileReader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.fileLock;
        synchronized (object) {
            return this.fileReader != null;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long lastModified() {
        try {
            return this.file.lastModified();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("lastModified: " + exception.toString());
            return 0L;
        }
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error("length: " + exception.toString());
            return 0L;
        }
    }

    public String getPath() {
        return this.fullPath;
    }
}

