/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import java.nio.ByteBuffer;

public class BufferUtils {
    private static final String[] hexadecimal = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static final int[] CRC32INIT = new int[]{0, -1222786812, 1849393673, -651803891, -596245485, 1802224919, -1303542246, 89147166, -1192425434, 267438370, -690582993, 1640713003, 1687882805, -746140367, 178294332, -1111666888, 1893405004, -943271864, 518034245, -1443016127, -1397942945, 464573531, -1030318250, 1972065874, -935978646, 2133579886, -1509057693, 286284391, 339746169, -1554129795, 2054922096, -848929164, -524934248, 1470882460, -1903320687, 965763221, 1019225995, -1948391793, 1392223618, -437885818, 1482369982, -280565062, 912304567, -2122487629, -2077413459, 858844841, -367612508, 1561029792, -1871891756, 661713872, -27873059, 1229681113, 1276851911, -83429437, 572568782, -1791134262, 679492338, -1617036298, 1186707707, -240748033, -185188639, 1139539941, -1697792792, 768638444, 2003863092, -1066580176, 424346685, -1370045127, -1425636825, 471548707, -985858002, 1914749226, -811758062, 2021674774, -1582953445, 381406495, 334203393, -1527362811, 2110785544, -892483316, 128685944, -1330227588, 1771050353, -561130379, -606235797, 1824543343, -1243213470, 50057318, -1085890722, 140205658, -780329641, 1717623891, 1664129869, -735225271, 218831172, -1172907968, -1748589140, 551249064, -100849755, 1323361953, 1269866943, -55746373, 629875638, -1835605326, 791391626, -1741263730, 1091579779, -166859129, -211965543, 1145071773, -1654248560, 712764052, -417483552, 1342207460, -1993984279, 1044117485, 996913395, -1938394633, 1431319290, -498207746, 1609612486, -387088958, 835403471, -2032730165, -2088322859, 882604497, -306365732, 1520499672, -287306647, 1509805421, -2133094816, 935743332, 848693370, -2054436482, 1554877043, -340767881, 1443693647, -518994613, 943097414, -1892989118, -1971650468, 1030144344, -465534379, 1398621009, -1640293083, 690412577, -268394708, 1193106984, 1112348982, -179251150, 745970495, -1687463365, 651564291, -1848912889, 1223530250, -1026546, -90173168, 1304285204, -1801743591, 596005405, 240529393, -1186205963, 1617800696, -680497924, -769643550, 1698556646, -1139037717, 184969455, -1229248553, 27715283, -662657570, 1872585946, 1791828932, -573513024, 83272141, -1276419895, 2123185853, -913244231, 280411316, -1481933392, -1560593746, 367459242, -859785049, 2078112163, -966773093, 1904080799, -1470385006, 524711318, 437662344, -1391725684, 1949151361, -1020235387, -1718580643, 781011801, -139786156, 1085720912, 1172737614, -218411190, 735906887, -1665086141, 561873531, -1772076161, 1329987698, -128204426, -49576344, 1242974060, -1825569695, 606979429, -380921071, 1582717461, -2022696680, 812505116, 893230850, -2111807994, 1527127307, -333718513, 1369871159, -423931341, 1067258174, -2004824006, -1915709660, 986535456, -471132883, 1425462313, 2032576965, -834967359, 387787724, -1610552632, -1521439274, 307064018, -882167841, 2088169179, -1043619357, 1993760999, -1343216662, 418243310, 498968048, -1432328972, 1938171897, -996415747, 167622793, -1092585075, 1741044352, -790889596, -712262502, 1654029726, -1146077549, 212729751, -1324306257, 101544363, -550817114, 1748431778, 1835447484, -629443144, 56440501, -1270810703, 1};

    public static String encodeHexString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xF;
            int n2 = (byArray[i] & 0xF0) >> 4;
            string = string + hexadecimal[n2];
            string = string + hexadecimal[n];
        }
        return string;
    }

    public static String encodeHexString(byte[] byArray, int n, int n2) {
        String string = "";
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + i] & 0xF;
            int n4 = (byArray[n + i] & 0xF0) >> 4;
            string = string + hexadecimal[n4];
            string = string + hexadecimal[n3];
        }
        return string;
    }

    public static byte[] decodeHexString(String string) {
        byte[] byArray = null;
        try {
            if (string.length() % 2 == 1) {
                string = "0" + string;
            }
            byArray = new byte[string.length() / 2];
            int n = 0;
            int n2 = string.length();
            do {
                String string2 = string.substring(n, n + 2);
                byArray[n / 2] = (byte)(Integer.parseInt(string2, 16) & 0xFF);
            } while ((n += 2) < n2);
        }
        catch (Exception exception) {
            System.out.println("BufferUtils.decodeHexString: " + exception.toString());
        }
        return byArray;
    }

    public static String byteArrayToString(byte[] byArray) {
        return BufferUtils.byteArrayToString(byArray, 0, byArray.length);
    }

    public static String byteArrayToString(byte[] byArray, int n, int n2) {
        String string = null;
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            string = new String(byArray2, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static long byteArrayToLong(byte[] byArray) {
        long l = 0L;
        l |= (long)(byArray[0] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[1] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[2] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[3] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[4] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[5] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[6] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[7] & 0xFF);
    }

    public static long byteArrayToLong(byte[] byArray, int n) {
        long l = 0L;
        l |= (long)(byArray[n + 0] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 1] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 2] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 3] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 4] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 5] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + 6] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[n + 7] & 0xFF);
    }

    public static long byteArrayToLong(byte[] byArray, int n, int n2) {
        return BufferUtils.byteArrayToLong(byArray, n, n2, false);
    }

    public static long byteArrayToLong(byte[] byArray, int n, int n2, boolean bl) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                l <<= 8;
            }
            if (bl) {
                l |= (long)(byArray[n + (n2 - (i + 1))] & 0xFF);
                continue;
            }
            l |= (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    public static int byteArrayToInt(byte[] byArray) {
        return byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static int byteArrayToInt(byte[] byArray, int n) {
        return byArray[n + 0] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static int byteArrayToInt(byte[] byArray, int n, int n2) {
        return BufferUtils.byteArrayToInt(byArray, n, n2, false);
    }

    public static int byteArrayToInt(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                n3 <<= 8;
            }
            if (bl) {
                n3 |= byArray[n + (n2 - (i + 1))] & 0xFF;
                continue;
            }
            n3 |= byArray[n + i] & 0xFF;
        }
        return n3;
    }

    public static int byteArrayToShort(byte[] byArray) {
        return BufferUtils.byteArrayToShort(byArray, 0, 2, false);
    }

    public static int byteArrayToShort(byte[] byArray, int n) {
        return BufferUtils.byteArrayToShort(byArray, n, 2, false);
    }

    public static int byteArrayToShort(byte[] byArray, int n, int n2) {
        return BufferUtils.byteArrayToShort(byArray, n, n2, false);
    }

    public static int byteArrayToShort(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                n3 = (short)(n3 << 8);
            }
            n3 = bl ? (int)((short)(n3 | byArray[n + (n2 - (i + 1))] & 0xFF)) : (int)((short)(n3 | byArray[n + i] & 0xFF));
        }
        return n3;
    }

    public static byte[] intToByteArray(int n) {
        return BufferUtils.intToByteArray(n, 4);
    }

    public static byte[] intToByteArray(int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < Math.min(n2, 4); ++i) {
            int n3 = n2 - i - 1;
            byArray[n3] = (byte)(n & 0xFF);
            if ((n >>= 8) == 0) break;
        }
        return byArray;
    }

    public static void intToByteArray(int n, byte[] byArray, int n2, int n3) {
        BufferUtils.intToByteArray(n, byArray, n2, n3, false);
    }

    public static void intToByteArray(int n, byte[] byArray, int n2, int n3, boolean bl) {
        for (int i = 0; i < Math.min(n3, 4); ++i) {
            int n4 = bl ? i : n3 - (i + 1);
            byArray[n2 + n4] = (byte)(n & 0xFF);
            n >>= 8;
        }
    }

    public static byte[] longToByteArray(long l) {
        return BufferUtils.longToByteArray(l, 8);
    }

    public static byte[] longToByteArray(long l, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < Math.min(n, 8); ++i) {
            int n2 = n - i - 1;
            byArray[n2] = (byte)(l & 0xFFL);
            if ((l >>= 8) == 0L) break;
        }
        return byArray;
    }

    public static void longToByteArray(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < Math.min(n2, 8); ++i) {
            int n3 = n2 - i - 1;
            byArray[n + n3] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static void longToByteArray(long l, byte[] byArray, int n, int n2, boolean bl) {
        for (int i = 0; i < Math.min(n2, 8); ++i) {
            int n3 = bl ? i : n2 - (i + 1);
            byArray[n + n3] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static int getUnsignedShort(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[2];
        byteBuffer.get(byArray);
        return BufferUtils.byteArrayToInt(byArray, 0, 2);
    }

    public static int doCRC32(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = (n ^ byArray[i + n2]) & 0xFF;
            n = CRC32INIT[n4] ^ n >> 8 & 0xFFFFFF;
        }
        return n;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return -1;
        }
        int n = byArray.length;
        int n2 = byArray2.length;
        if (n == 0 || n2 == 0) {
            return -1;
        }
        byte by = byArray2[0];
        int n3 = n - n2;
        for (int i = 0; i <= n3; ++i) {
            if (byArray[i] != by) {
                while (++i <= n3 && byArray[i] != by) {
                }
            }
            if (i > n3) continue;
            int n4 = i + 1;
            int n5 = n4 + n2 - 1;
            int n6 = 1;
            while (n4 < n5 && byArray[n4] == byArray2[n6]) {
                ++n4;
                ++n6;
            }
            if (n4 != n5) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfDifferent(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return -1;
        }
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean startsWith(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            return true;
        }
        if (byArray == null) {
            return false;
        }
        int n = byArray.length;
        int n2 = byArray2.length;
        if (n2 == 0) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        if (n2 > n) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

