/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.File;
import java.io.RandomAccessFile;

public final class DebugUtils {
    public static String formatBytesShort(byte[] byArray) {
        if (byArray == null) {
            return "<null ptr>";
        }
        return DebugUtils.formatBytesShort(byArray, 0, byArray.length);
    }

    public static String formatBytesShort(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "<null ptr>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 > 20480) {
            n2 = 20480;
        }
        for (int i = 0; i < n2; ++i) {
            if (i + n >= byArray.length) continue;
            int n3 = 0xFF & byArray[i + n];
            String string = DebugUtils.toTwoDigitHex(n3);
            stringBuffer.append(string + " ");
        }
        return stringBuffer.toString();
    }

    public static String formatBytes(byte[] byArray) {
        if (byArray == null) {
            return "<null ptr>";
        }
        return DebugUtils.formatBytes(byArray, 0, byArray.length);
    }

    public static String formatBytes(byte[] byArray, boolean bl) {
        if (byArray == null) {
            return "<null ptr>";
        }
        return DebugUtils.formatBytes(byArray, 0, byArray.length, bl);
    }

    public static String formatBytes(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "<null ptr>";
        }
        return DebugUtils.formatBytes(byArray, n, n2, false);
    }

    public static String formatBytes(byte[] byArray, int n, int n2, boolean bl) {
        if (byArray == null) {
            return "<null ptr>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = 0;
        if (n2 > 20480) {
            n2 = 20480;
        }
        for (int i = 0; i < n2; ++i) {
            if (i + n >= byArray.length) continue;
            if (bl && n3 % 16 == 0) {
                stringBuffer.append(String.format("%5d: ", i + n));
            }
            int n4 = 0xFF & byArray[i + n];
            String string = DebugUtils.toTwoDigitHex(n4);
            stringBuffer.append(string + " ");
            if (n4 < 32) {
                stringBuffer2.append(".");
            } else {
                stringBuffer2.append((char)byArray[i + n]);
            }
            if (++n3 % 16 == 0) {
                stringBuffer.append(" " + stringBuffer2.toString() + "\n");
                stringBuffer2.setLength(0);
                continue;
            }
            if (n3 % 8 != 0) continue;
            stringBuffer.append("  ");
            stringBuffer2.append(" ");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(" " + stringBuffer2.toString() + "\n");
        } else {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String formatBytesStruct(byte[] byArray) {
        if (byArray == null) {
            return "<null ptr>";
        }
        return DebugUtils.formatBytesStruct(byArray, 0, byArray.length);
    }

    public static String formatBytesStruct(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return "<null ptr>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (i + n >= byArray.length) continue;
            int n4 = 0xFF & byArray[i + n];
            String string = DebugUtils.toTwoDigitHex(n4);
            stringBuffer.append("(byte)0x" + string + ", ");
            if (++n3 % 8 != 0) continue;
            stringBuffer.append("\n");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(" " + stringBuffer2.toString() + "\n");
        } else {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String toHex(byte by) {
        String string = Integer.toHexString(by & 0xFF);
        while (string.length() < 2) {
            string = "0" + string;
        }
        string = "0x" + string;
        return string;
    }

    public static String toHex(int n) {
        String string = Integer.toHexString(n);
        string = "0x" + string;
        return string;
    }

    public static String toLong(long l) {
        String string = Long.toHexString(l);
        string = "0x" + string;
        return string;
    }

    private static String toTwoDigitHex(int n) {
        String string = Integer.toHexString(n);
        if (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public static File byteArrayToFile(byte[] byArray, String string) {
        File file = new File(string);
        if (!file.canWrite() && byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.write(byArray);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DebugUtils.class).error("Error creating file " + file.getAbsolutePath(), exception);
            file = null;
        }
        return file;
    }

    public static String formatMilliseconds(long l) {
        double d = (double)l / 1000.0;
        return String.format("%12.3f", d);
    }
}

