/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static String getNodeValueByTagName(Element element, String string) {
        Node node;
        String string2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0 && (node = nodeList.item(0)) != null) {
            string2 = XMLUtils.getNodeValue(node);
        }
        return string2;
    }

    public static Node getNodeByTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            return nodeList.item(0);
        }
        return null;
    }

    public static String getNodeValue(Node node) {
        String string = "";
        if (node != null) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                string = string + node2.getNodeValue();
            }
        }
        return string;
    }

    private static void loadConfigProperty(Element element, WMSProperties wMSProperties) {
        Node node = XMLUtils.getNodeByTagName(element, "Name");
        Node node2 = XMLUtils.getNodeByTagName(element, "Value");
        Node node3 = XMLUtils.getNodeByTagName(element, "Type");
        if (node != null && node2 != null) {
            String string = XMLUtils.getNodeValue(node);
            String string2 = XMLUtils.getNodeValue(node2);
            if (node3 == null) {
                wMSProperties.setProperty(string, string2);
            } else {
                String string3 = XMLUtils.getNodeValue(node3);
                if (string3.compareToIgnoreCase("class") == 0) {
                    try {
                        Class<?> clazz = Class.forName(string2);
                        Object obj = clazz.newInstance();
                        wMSProperties.setProperty(string, obj);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(XMLUtils.class).error("loadConfigProperty: type Class (" + string2 + "): " + exception.toString());
                    }
                } else if (string3.compareToIgnoreCase("string") == 0) {
                    try {
                        wMSProperties.setProperty(string, string2);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(XMLUtils.class).error("loadConfigProperty: type String (" + string2 + "): " + exception.toString());
                    }
                } else if (string3.compareToIgnoreCase("integer") == 0) {
                    try {
                        wMSProperties.setProperty(string, new Integer(Integer.parseInt(string2)));
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(XMLUtils.class).error("loadConfigProperty: type Integer (" + string2 + "): " + exception.toString());
                    }
                } else if (string3.compareToIgnoreCase("double") == 0) {
                    try {
                        wMSProperties.setProperty(string, new Double(Double.parseDouble(string2)));
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(XMLUtils.class).error("loadConfigProperty: type Double (" + string2 + "): " + exception.toString());
                    }
                } else if (string3.compareToIgnoreCase("long") == 0) {
                    try {
                        wMSProperties.setProperty(string, new Long(Long.parseLong(string2)));
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(XMLUtils.class).error("loadConfigProperty: type Long (" + string2 + "): " + exception.toString());
                    }
                } else if (string3.compareToIgnoreCase("boolean") == 0) {
                    try {
                        wMSProperties.setProperty(string, new Boolean(Boolean.parseBoolean(string2)));
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(XMLUtils.class).error("loadConfigProperty: type Boolean (" + string2 + "): " + exception.toString());
                    }
                } else {
                    WMSLoggerFactory.getLogger(XMLUtils.class).error("loadConfigProperty: type unknown: " + string3);
                }
            }
        }
    }

    public static void loadConfigProperies(Element element, String string, WMSProperties wMSProperties) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    XMLUtils.loadConfigProperty(element2, wMSProperties);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(XMLUtils.class).error("error parsing application properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigProperies(NodeList nodeList, WMSProperties wMSProperties) {
        try {
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element = (Element)node;
                    XMLUtils.loadConfigProperty(element, wMSProperties);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(XMLUtils.class).error("error parsing application properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static String getXMLPropertyStr(XPath xPath, String string, Element element) {
        return XMLUtils.getXMLPropertyStr(xPath, string, element, null);
    }

    public static String getXMLPropertyStr(XPath xPath, String string, Element element, String string2) {
        String string3 = string2;
        try {
            String string4 = xPath.evaluate(string, element);
            if (string4.length() > 0) {
                string3 = string4;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(XMLUtils.class).debug("getXMLPropertyStr: " + exception.toString());
        }
        return string3;
    }

    public static boolean getXMLPropertyExists(XPath xPath, String string, Element element) {
        boolean bl = false;
        try {
            String string2 = xPath.evaluate(string, element);
            bl = string2.length() > 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(XMLUtils.class).error("getXMLPropertyExists: " + exception.toString());
        }
        return bl;
    }

    public static int getXMLPropertyInt(XPath xPath, String string, Element element, int n) {
        int n2 = n;
        try {
            String string2 = xPath.evaluate(string, element);
            if (string2.length() > 0) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(XMLUtils.class).error("getXMLPropertyInt: " + exception.toString());
        }
        return n2;
    }

    public static long getXMLPropertyLong(XPath xPath, String string, Element element, long l) {
        long l2 = l;
        try {
            String string2 = xPath.evaluate(string, element);
            if (string2.length() > 0) {
                l2 = Long.parseLong(string2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(XMLUtils.class).error("getXMLPropertyLong: " + exception.toString());
        }
        return l2;
    }

    public static double getXMLPropertyDouble(XPath xPath, String string, Element element, double d) {
        double d2 = d;
        try {
            String string2 = xPath.evaluate(string, element);
            if (string2.length() > 0) {
                d2 = Double.parseDouble(string2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(XMLUtils.class).error("getXMLPropertyDouble: " + exception.toString());
        }
        return d2;
    }

    public static boolean getXMLPropertyBool(XPath xPath, String string, Element element, boolean bl) {
        boolean bl2 = bl;
        try {
            String string2 = xPath.evaluate(string, element);
            if (string2.length() > 0) {
                bl2 = Boolean.parseBoolean(string2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(XMLUtils.class).error("getXMLPropertyBool: " + exception.toString());
        }
        return bl2;
    }

    public static XPathFactory newXPathFactory() {
        XPathFactory xPathFactory = null;
        if (xPathFactory == null) {
            try {
                xPathFactory = XPathFactory.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (xPathFactory == null) {
            try {
                new XPathFactoryImpl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (xPathFactory == null) {
            System.out.println("Error: Can't find XPathFactory");
        }
        return xPathFactory;
    }
}

