/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.client;

import com.wowza.wms.client.ClientResponseTracker;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IResponseListener;
import com.wowza.wms.server.RtmpResponseEncoder;
import com.wowza.wms.server.RtmpResponseMessage;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.support.IWriteListener;
import org.apache.mina.transport.socket.nio.FastMinaMessage;

public class ClientWriteListener
implements IWriteListener,
IResponseListener {
    private IClient client = null;
    private ClientResponseTracker pendingTracker = null;
    private ClientResponseTracker lastTracker = null;
    private Map<Long, ClientResponseTracker> pendingRequests = new HashMap<Long, ClientResponseTracker>();
    private boolean multiSessionDetected = false;

    public ClientWriteListener(IClient iClient) {
        this.client = iClient;
    }

    public synchronized void onQueWriteRequest(IoFilter.WriteRequest writeRequest) {
        if (this.pendingTracker != null) {
            Object object;
            boolean bl = true;
            int n = 0;
            Object object2 = writeRequest.getMessage();
            if (object2 instanceof ByteBuffer) {
                object = (ByteBuffer)object2;
                n = object.limit();
                Object object3 = object.getExtra();
                if (object3 != null && object3 instanceof FastMinaMessage) {
                    n = ((FastMinaMessage)object3).getSize();
                }
            } else if (object2 instanceof RtmpResponseMessage) {
                object = (RtmpResponseMessage)object2;
                n = RtmpResponseEncoder.outputHeader((RtmpResponseMessage)object, null) + ((RtmpResponseMessage)object).getBodyLength();
                if (((RtmpResponseMessage)object).getClientId() == this.client.getClientId()) {
                    writeRequest.setClientId(this.client.getClientId());
                } else {
                    bl = false;
                    if (!this.multiSessionDetected) {
                        WMSLoggerFactory.getLogger(ClientWriteListener.class).debug("ClientWriteListener.onQueWriteRequest: Multi session RTMPT detected: This is not a problem: msgClientId" + ((RtmpResponseMessage)object).getClientId() + " listenerClientId:" + this.client.getClientId() + " protocol:" + this.client.getProtocol());
                        this.multiSessionDetected = true;
                    }
                }
            } else {
                WMSLoggerFactory.getLogger(ClientWriteListener.class).warn("ClientWriteListener.onQueWriteRequest: cannot calculate packetSize");
            }
            if (bl) {
                long l = this.pendingTracker.incTotalSize(n);
                this.pendingTracker.incPacketCount();
                if (l == (long)n) {
                    this.pendingTracker.setSendTime(System.currentTimeMillis());
                }
                this.pendingRequests.put(new Long(writeRequest.getWriteId()), this.pendingTracker);
            }
        }
    }

    public void onWriteWriteRequest(IoFilter.WriteRequest writeRequest, long l) {
        long l2 = writeRequest.getWriteId();
        if (l2 < 0L) {
            return;
        }
        int n = writeRequest.getClientId();
        if (n >= 0 && n != this.client.getClientId()) {
            return;
        }
        ClientResponseTracker clientResponseTracker = this.pendingRequests.get(new Long(l2));
        if (clientResponseTracker != null) {
            long l3 = clientResponseTracker.decRemaingSize(l);
            this.lastTracker = clientResponseTracker;
        }
    }

    public synchronized void onCompleteWriteRequest(IoFilter.WriteRequest writeRequest) {
        long l = writeRequest.getWriteId();
        if (l < 0L) {
            return;
        }
        int n = writeRequest.getClientId();
        if (n >= 0 && n != this.client.getClientId()) {
            return;
        }
        ClientResponseTracker clientResponseTracker = this.pendingRequests.remove(new Long(l));
        if (clientResponseTracker != null) {
            clientResponseTracker.decPacketCount();
            if (clientResponseTracker.getPacketCount() == 0) {
                long l2 = clientResponseTracker.getRemaining();
                if (l2 != 0L) {
                    clientResponseTracker.decRemaingSize(l2);
                }
                clientResponseTracker.setCompleteTime(System.currentTimeMillis());
            }
        }
    }

    public synchronized void onResponseWriteStart(RtmpResponseMessage rtmpResponseMessage) {
    }

    public synchronized void onResponseWriteStop(RtmpResponseMessage rtmpResponseMessage) {
        this.pendingTracker = null;
    }

    public synchronized ClientResponseTracker getLastTracker() {
        return this.lastTracker;
    }

    public synchronized ClientResponseTracker getPendingTracker() {
        if (this.pendingTracker == null) {
            this.pendingTracker = new ClientResponseTracker();
        }
        return this.pendingTracker;
    }
}

