/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.commandinterface;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.CommandInterfaceRequestMessage;
import com.wowza.wms.server.CommandInterfaceResponseMessage;
import com.wowza.wms.server.ICommandInterfaceCommand;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.VHostItem;
import java.util.Map;

public class CommandInterfaceCommandVHostStatus
implements ICommandInterfaceCommand {
    public static final String COMMAND = "vhoststatus";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(CommandInterfaceRequestMessage commandInterfaceRequestMessage, CommandInterfaceResponseMessage commandInterfaceResponseMessage) {
        try {
            Object object;
            Server server = Server.getInstance();
            server.reloadVHostConfig();
            Map<String, VHostItem> map = server.getVHostList().getVHostMap();
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = commandInterfaceRequestMessage.getQueryParam("vhost");
            if (string2 != null) {
                object = server.getVHostList().getVHostMap().get(string2);
                if (object == null) {
                    WMSLoggerFactory.getLogger(CommandInterfaceCommandVHostStatus.class).warn("CommandInterfaceCommandVHostStatus.invoke: VHost name not found: " + string2);
                    commandInterfaceResponseMessage.setResponseCode(404);
                    return;
                }
                boolean bl = server.isVHostRunning(string2);
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                stringBuffer.append("<ListWmsVHostStatusResult>");
                stringBuffer.append("<WmsName>_defaultserver_</WmsName>");
                stringBuffer.append("<VHosts>");
                stringBuffer.append("<VHost>");
                stringBuffer.append("<Name>" + string2 + "</Name>");
                stringBuffer.append("<Status>" + (bl ? "running" : "stopped") + "</Status>");
                stringBuffer.append("</VHost>");
                stringBuffer.append("</VHosts>");
                stringBuffer.append("</ListWmsVHostStatusResult>");
            } else {
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                stringBuffer.append("<ListWmsVHostStatusResult>");
                stringBuffer.append("<WmsName>_defaultserver_</WmsName>");
                stringBuffer.append("<VHosts>");
                for (String string2 : map.keySet()) {
                    VHostItem vHostItem = server.getVHostList().getVHostMap().get(string2);
                    if (vHostItem == null) continue;
                    boolean bl = server.isVHostRunning(string2);
                    stringBuffer.append("<VHost>");
                    stringBuffer.append("<Name><![CDATA[" + string2 + "]]></Name>");
                    stringBuffer.append("<Status>" + (bl ? "running" : "stopped") + "</Status>");
                    stringBuffer.append("</VHost>");
                }
                stringBuffer.append("</VHosts>");
                stringBuffer.append("</ListWmsVHostStatusResult>");
            }
            if (stringBuffer.length() > 0) {
                object = stringBuffer.toString();
                commandInterfaceResponseMessage.setBody(((String)object).getBytes("UTF-8"));
            }
            commandInterfaceResponseMessage.setResponseCode(200);
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CommandInterfaceCommandVHostStatus.class).warn("CommandInterfaceCommandVHostStart.invoke: " + exception.toString());
            commandInterfaceResponseMessage.setResponseCode(500);
        }
    }

    public boolean canHandle(CommandInterfaceRequestMessage commandInterfaceRequestMessage) {
        return true;
    }
}

