/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.wms.dvr.IDvrManifest;
import com.wowza.wms.dvr.IDvrPersistentStorageHandler;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.dvr.io.IDvrFileSystem;
import com.wowza.wms.dvr.io.manifest.DvrManifestHolder;
import com.wowza.wms.dvr.io.manifest.DvrManifestReader;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DefaultDvrPersistentStorageHandler
implements IDvrPersistentStorageHandler {
    private static final Class<DefaultDvrPersistentStorageHandler> CLASS = DefaultDvrPersistentStorageHandler.class;
    private static final String CLASSNAME = "DefaultDvrPersistentStorageHandler";

    public boolean reloadPreviousStore(IDvrStreamStore iDvrStreamStore, IDvrFileSystem iDvrFileSystem) {
        boolean bl = false;
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
        wMSLogger.info("DefaultDvrPersistentStorageHandler.reloadPreviousStore:" + iDvrFileSystem);
        DvrManifestReader dvrManifestReader = new DvrManifestReader(iDvrStreamStore, iDvrStreamStore.getAppInstance());
        if (dvrManifestReader.loadManifestFromFileSystem()) {
            IDvrManifest iDvrManifest = dvrManifestReader.getManifest();
            DvrManifestHolder dvrManifestHolder = dvrManifestReader.getMainManifestInfo();
            iDvrStreamStore.getManifest().importManifest(iDvrManifest, false);
            iDvrStreamStore.getChunker().setChunkGroupDuration(dvrManifestHolder.chunkGrouping);
            bl = true;
        }
        return bl;
    }

    public boolean deletePreviousStore(IDvrStreamStore iDvrStreamStore, IDvrFileSystem iDvrFileSystem) {
        boolean bl = false;
        WMSLoggerFactory.getLogger(CLASS).info("DefaultDvrPersistentStorageHandler.deletePreviousStore file system:" + iDvrFileSystem);
        bl = iDvrFileSystem.deleteFileSystem();
        if (!bl) {
            WMSLoggerFactory.getLogger(CLASS).warn("DefaultDvrPersistentStorageHandler.deletePreviousStore unable to delete old store.  Filesystem:" + iDvrFileSystem);
        }
        return bl;
    }

    public boolean backupPreviousStore(String string, IDvrFileSystem iDvrFileSystem, IDvrStreamStore iDvrStreamStore) {
        boolean bl = false;
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
        String string2 = this.generateVersionedDirectoryName(iDvrFileSystem.getStreamContainer(), string, iDvrFileSystem);
        try {
            wMSLogger.info(String.format("%s.versionDvrStreamStore from '%s' to '%s'.", CLASSNAME, iDvrFileSystem.getStreamContainer(), string2));
            bl = iDvrFileSystem.moveFileSystem(string2);
            if (!bl) {
                WMSLoggerFactory.getLogger(CLASS).warn("DefaultDvrPersistentStorageHandler.backupPreviousStore unable to move old store to %s." + string2);
            }
        }
        catch (Exception exception) {
            wMSLogger.error(String.format("Error while versioning DVR folder from '%s' to '%s'.", iDvrFileSystem.getStreamContainer(), string2), exception);
        }
        return bl;
    }

    protected String generateVersionedDirectoryName(String string, String string2, IDvrFileSystem iDvrFileSystem) {
        String string3 = "";
        string3 = "versionByDate".equals(string2) ? this.generateVersionedDirectoryNameByDate(string, iDvrFileSystem) : this.generateVersionedDirectoryNameByNumber(string, iDvrFileSystem);
        return string3;
    }

    protected String generateVersionedDirectoryNameByNumber(String string, IDvrFileSystem iDvrFileSystem) {
        String string2;
        int n = 1;
        while (iDvrFileSystem.doesStreamContainerExist(string2 = String.format("%s_%d", string, n++))) {
        }
        return string2;
    }

    protected String generateVersionedDirectoryNameByDate(String string, IDvrFileSystem iDvrFileSystem) {
        String string2 = String.format("%s_%s", string, this.generateDateString());
        if (iDvrFileSystem.doesStreamContainerExist(string2)) {
            string2 = this.generateVersionedDirectoryNameByNumber(string2, iDvrFileSystem);
        }
        return string2;
    }

    private Object generateDateString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH_mm");
        return simpleDateFormat.format(new Date());
    }
}

