/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr;

import com.wowza.util.DebugUtils;
import com.wowza.util.SetUtils;
import com.wowza.wms.dvr.DvrChannelManifest;
import com.wowza.wms.dvr.DvrManifestChannelsGroup;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.IDvrManifest;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DvrManifestBase
implements IDvrManifest {
    private static final Class<DvrManifestBase> CLASS = DvrManifestBase.class;
    private static final String CLASSNAME = "DvrManifestBase";
    protected DvrChannelManifest audioManifest = new DvrChannelManifest(8);
    protected DvrChannelManifest videoManifest = new DvrChannelManifest(9);
    protected DvrChannelManifest dataManifest = new DvrChannelManifest(18);
    protected DvrChannelManifest onMetadataManifest = new DvrChannelManifest(0);
    private int metaIndex;
    private int chunkIndex;

    @Override
    public void initialize() {
    }

    @Override
    public void addToManifest(DvrManifestEntry dvrManifestEntry) {
        this.internalAddToManifest(dvrManifestEntry);
    }

    protected void internalAddToManifest(DvrManifestEntry dvrManifestEntry) {
        if (dvrManifestEntry == null) {
            return;
        }
        int n = dvrManifestEntry.getType();
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            dvrChannelManifest.addToManifest(dvrManifestEntry);
        }
    }

    @Override
    public void importManifest(IDvrManifest iDvrManifest, boolean bl) {
        Map<Integer, DvrManifestEntry> map = iDvrManifest.getIndexMap(8);
        Map<Integer, DvrManifestEntry> map2 = iDvrManifest.getIndexMap(9);
        Map<Integer, DvrManifestEntry> map3 = iDvrManifest.getIndexMap(18);
        SortedSet<Integer> sortedSet = this.pruneMapsBasedOnCommonIndices(map2, map, map3);
        for (Integer n : sortedSet) {
            this.internalAddToManifest(map2.get(n));
            this.internalAddToManifest(map.get(n));
            this.internalAddToManifest(map3.get(n));
        }
        Collection<DvrManifestEntry> collection = iDvrManifest.getIndexMap(0).values();
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DvrManifestEntry dvrManifestEntry = (DvrManifestEntry)iterator.next();
            this.internalAddToManifest(dvrManifestEntry);
            n = dvrManifestEntry.getIndex();
        }
        if (!sortedSet.isEmpty()) {
            this.chunkIndex = sortedSet.last() + 1;
        }
        if (!collection.isEmpty()) {
            this.metaIndex = n + 1;
        }
    }

    @Override
    public long getChunksSize(int n) {
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            return dvrChannelManifest.getChunksSize();
        }
        return -1L;
    }

    @Override
    public long getTotalChunksSize() {
        long l = this.videoManifest.getChunksSize();
        l += this.audioManifest.getChunksSize();
        l += this.dataManifest.getChunksSize();
        return l += this.onMetadataManifest.getChunksSize();
    }

    public DvrChannelManifest getManifestChannel(int n) {
        switch (n) {
            case 8: {
                return this.audioManifest;
            }
            case 9: {
                return this.videoManifest;
            }
            case 18: {
                return this.dataManifest;
            }
            case 0: {
                return this.onMetadataManifest;
            }
        }
        return null;
    }

    @Override
    public long calculateClosestTime(int n, long l) {
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            return dvrChannelManifest.calculateClosestTime(l);
        }
        return l;
    }

    @Override
    public DvrManifestEntry getDvrEntryAtTime(int n, long l) {
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            return dvrChannelManifest.getDvrEntryAtTime(l);
        }
        return null;
    }

    @Override
    public DvrManifestEntry getDvrEntryByIndex(int n, int n2) {
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            return dvrChannelManifest.getDvrEntryByIndex(n2);
        }
        return null;
    }

    @Override
    public List<DvrManifestEntry> getDvrEntriesAtTime(int n, long l) {
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            return dvrChannelManifest.getDvrEntriesStartingAtTime(l);
        }
        return new ArrayList<DvrManifestEntry>();
    }

    @Override
    public List<DvrManifestEntry> getDvrEntriesAtTime(int n, long l, int n2) {
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            return dvrChannelManifest.getDvrEntriesStartingAtTime(l, n2);
        }
        return new ArrayList<DvrManifestEntry>();
    }

    @Override
    public DvrManifestEntry getMetadataEntryForTime(long l) {
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(0);
        if (dvrChannelManifest != null) {
            return dvrChannelManifest.getDvrEntryStartingBeforeTime(l);
        }
        return null;
    }

    @Override
    public long getDvrTime(int n) {
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            return dvrChannelManifest.getDvrTime();
        }
        return 0L;
    }

    @Override
    public int getLastIndex(int n) {
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            return dvrChannelManifest.getLastIndex();
        }
        return 0;
    }

    public void purgeChunksBeforeTime(long l) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
        wMSLogger.info("DvrManifestBase.purgeChunksBeforeTime t=" + DebugUtils.formatMilliseconds(l));
        if (l <= 0L) {
            return;
        }
        DvrManifestChannelsGroup dvrManifestChannelsGroup = this.getEntriesToPurge(l);
        this.purgeChunks(dvrManifestChannelsGroup);
    }

    private void tossOutInvalidEntries(Set<Integer> set, Map<Integer, DvrManifestEntry> map) {
        Integer[] integerArray;
        if (map == null || map.isEmpty() || set == null || set.isEmpty()) {
            return;
        }
        for (Integer n : integerArray = map.keySet().toArray(new Integer[map.size()])) {
            if (set.contains(n)) continue;
            System.out.println("...Removing key=" + n + " v=" + map.get(n));
            map.remove(n);
        }
    }

    @Override
    public Map<Long, DvrManifestEntry> getTimeMap(int n) {
        TreeMap<Long, DvrManifestEntry> treeMap = new TreeMap<Long, DvrManifestEntry>();
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            treeMap.putAll(dvrChannelManifest.getTimeMap());
        }
        return treeMap;
    }

    @Override
    public Map<Integer, DvrManifestEntry> getIndexMap(int n) {
        TreeMap<Integer, DvrManifestEntry> treeMap = new TreeMap<Integer, DvrManifestEntry>();
        DvrChannelManifest dvrChannelManifest = this.getManifestChannel(n);
        if (dvrChannelManifest != null) {
            treeMap.putAll(dvrChannelManifest.getIndexMap());
        }
        return treeMap;
    }

    @Override
    public DvrManifestChannelsGroup getEntriesToPurge(long l) {
        DvrManifestChannelsGroup dvrManifestChannelsGroup = new DvrManifestChannelsGroup();
        SortedMap<Integer, DvrManifestEntry> sortedMap = this.videoManifest.getIndexMapEndingBeforeTime(l);
        SortedMap<Integer, DvrManifestEntry> sortedMap2 = this.audioManifest.getIndexMapEndingBeforeTime(l);
        SortedMap<Integer, DvrManifestEntry> sortedMap3 = this.dataManifest.getIndexMapEndingBeforeTime(l);
        this.pruneMapsBasedOnCommonIndices(sortedMap, sortedMap2, sortedMap3);
        dvrManifestChannelsGroup.aEntries = new ArrayList<DvrManifestEntry>();
        dvrManifestChannelsGroup.vEntries = new ArrayList<DvrManifestEntry>();
        dvrManifestChannelsGroup.dEntries = new ArrayList<DvrManifestEntry>();
        dvrManifestChannelsGroup.aEntries.addAll(sortedMap2.values());
        dvrManifestChannelsGroup.vEntries.addAll(sortedMap.values());
        dvrManifestChannelsGroup.dEntries.addAll(sortedMap3.values());
        dvrManifestChannelsGroup.mEntries = this.getOnMetadataEntriesBeforeTime(l);
        return dvrManifestChannelsGroup;
    }

    protected SortedSet<Integer> pruneMapsBasedOnCommonIndices(Map<Integer, DvrManifestEntry> map, Map<Integer, DvrManifestEntry> map2, Map<Integer, DvrManifestEntry> map3) {
        boolean bl = !map2.isEmpty();
        boolean bl2 = !map.isEmpty();
        boolean bl3 = !map3.isEmpty();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Set<Integer> set = map.keySet();
        Set<Integer> set2 = map2.keySet();
        if (bl2 && bl) {
            treeSet.addAll(SetUtils.intersection(set, set2));
        } else if (bl) {
            treeSet.addAll(set2);
        } else if (bl2) {
            treeSet.addAll(set);
        }
        if (bl2) {
            this.tossOutInvalidEntries(treeSet, map);
        }
        if (bl) {
            this.tossOutInvalidEntries(treeSet, map2);
        }
        if (bl3) {
            this.tossOutInvalidEntries(treeSet, map3);
        }
        return treeSet;
    }

    @Override
    public DvrManifestChannelsGroup getDvrEntriesEndingBeforeTime(long l) {
        DvrManifestChannelsGroup dvrManifestChannelsGroup = new DvrManifestChannelsGroup();
        dvrManifestChannelsGroup.vEntries = this.videoManifest.getDvrEntriesEndingBeforeTime(l);
        dvrManifestChannelsGroup.aEntries = this.audioManifest.getDvrEntriesEndingBeforeTime(l);
        dvrManifestChannelsGroup.dEntries = this.dataManifest.getDvrEntriesEndingBeforeTime(l);
        dvrManifestChannelsGroup.mEntries = this.getOnMetadataEntriesBeforeTime(l);
        return dvrManifestChannelsGroup;
    }

    @Override
    public DvrManifestChannelsGroup getDvrEntriesStartingAfterTime(long l) {
        DvrManifestChannelsGroup dvrManifestChannelsGroup = new DvrManifestChannelsGroup();
        dvrManifestChannelsGroup.vEntries = this.videoManifest.getDvrEntriesStartingAfterTime(l);
        dvrManifestChannelsGroup.aEntries = this.audioManifest.getDvrEntriesStartingAfterTime(l);
        dvrManifestChannelsGroup.dEntries = this.dataManifest.getDvrEntriesStartingAfterTime(l);
        dvrManifestChannelsGroup.mEntries = this.onMetadataManifest.getDvrEntriesStartingAfterTime(l);
        return dvrManifestChannelsGroup;
    }

    @Override
    public DvrManifestChannelsGroup getDvrEntriesStartingAtTime(long l) {
        DvrManifestChannelsGroup dvrManifestChannelsGroup = new DvrManifestChannelsGroup();
        dvrManifestChannelsGroup.vEntries = this.videoManifest.getDvrEntriesStartingAtTime(l);
        dvrManifestChannelsGroup.aEntries = this.audioManifest.getDvrEntriesStartingAtTime(l);
        dvrManifestChannelsGroup.dEntries = this.dataManifest.getDvrEntriesStartingAtTime(l);
        dvrManifestChannelsGroup.mEntries = this.onMetadataManifest.getDvrEntriesStartingAtTime(l);
        return dvrManifestChannelsGroup;
    }

    public void purgeChunksAfterTime(long l) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
        wMSLogger.info("DvrManifestBase.purgeChunksAfterTime t=" + DebugUtils.formatMilliseconds(l));
        if (l <= 0L) {
            return;
        }
        DvrManifestChannelsGroup dvrManifestChannelsGroup = this.getDvrEntriesStartingAfterTime(l);
        this.purgeChunks(dvrManifestChannelsGroup);
    }

    @Override
    public void purgeChunks(DvrManifestChannelsGroup dvrManifestChannelsGroup) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(CLASS);
        wMSLogger.info("DvrManifestBase.purgeChunks");
        this.purgeInMemoryManifest(dvrManifestChannelsGroup);
    }

    private void purgeInMemoryManifest(DvrManifestChannelsGroup dvrManifestChannelsGroup) {
        this.videoManifest.remove(dvrManifestChannelsGroup.vEntries);
        this.audioManifest.remove(dvrManifestChannelsGroup.aEntries);
        this.dataManifest.remove(dvrManifestChannelsGroup.dEntries);
        this.onMetadataManifest.remove(dvrManifestChannelsGroup.mEntries);
    }

    private List<DvrManifestEntry> getOnMetadataEntriesBeforeTime(long l) {
        List<DvrManifestEntry> list = this.onMetadataManifest.getDvrEntriesEndingBeforeTime(l);
        int n = list.size();
        if (list != null && n > 0) {
            list.remove(n - 1);
        }
        return list;
    }

    @Override
    public int getNextMetadataIndex() {
        int n = this.metaIndex++;
        return n;
    }

    @Override
    public int getNextIndex() {
        int n = this.chunkIndex++;
        return n;
    }
}

