/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr.io;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrChunkCreator;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.dvr.io.DvrChunkReaderFactory;
import com.wowza.wms.dvr.io.IDvrChunkReader;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.parsers.atom.AtomBytesToTree;
import com.wowza.wms.parsers.atom.AtomDetailParser;
import com.wowza.wms.parsers.atom.IAtom;
import com.wowza.wms.parsers.atom.UUIDCodecInfoData;
import com.wowza.wms.parsers.atom.UUIDDvrHeaderData;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import java.io.IOException;

public class DvrChunkReaderUtils {
    private static final Class<DvrChunkReaderUtils> CLASS = DvrChunkReaderUtils.class;
    private static final String CLASSNAME = "DvrChunkReaderUtils";

    private static byte[] readChunkFile(IDvrStreamStore iDvrStreamStore, IApplicationInstance iApplicationInstance, String string) {
        byte[] byArray = null;
        try {
            String string2 = iApplicationInstance.getContextStr();
            String string3 = "com.wowza.wms.dvr.impl.io.DvrFileChunkReader";
            string3 = iDvrStreamStore.getProperties().getPropertyStr("dvrChunkReaderClass", string3);
            IDvrChunkReader iDvrChunkReader = DvrChunkReaderFactory.createInstance(iApplicationInstance, null, string3, iDvrStreamStore.getFileSystem(), string);
            if (iDvrChunkReader == null) {
                WMSLoggerFactory.getLogger(CLASS).warn(String.format("%s.readChunkFile[%s]: Reader class '%s' not found.", CLASSNAME, string2, string3));
                return null;
            }
            byArray = DvrChunkReaderUtils.readChunkFile(iDvrChunkReader);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.readChunkFile: Error reading DVR file '%s'.", CLASSNAME, string), exception);
            exception.printStackTrace();
        }
        return byArray;
    }

    public static byte[] readChunkFile(IDvrChunkReader iDvrChunkReader) throws IOException {
        byte[] byArray = null;
        if (iDvrChunkReader == null) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.readChunkFile: Null IDvrChunkReader.", CLASSNAME));
            return null;
        }
        String string = iDvrChunkReader.getMediaName();
        try {
            iDvrChunkReader.open();
            byArray = new byte[(int)iDvrChunkReader.length()];
            int n = iDvrChunkReader.read(byArray, 0, byArray.length);
            if (n != byArray.length) {
                WMSLoggerFactory.getLogger(CLASS).warn(String.format("%s.readChunkFile[%s]: Error reading file: %d != %d ", CLASSNAME, string, n, byArray.length));
                return null;
            }
            try {
                iDvrChunkReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            iDvrChunkReader = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveChunk: Error reading DVR file '%s'.", CLASSNAME, string), exception);
            exception.printStackTrace();
        }
        return byArray;
    }

    public static DvrChunk retrieveChunk(IDvrStreamStore iDvrStreamStore, IApplicationInstance iApplicationInstance, String string) {
        DvrChunk dvrChunk = new DvrChunk();
        try {
            byte[] byArray = DvrChunkReaderUtils.readChunkFile(iDvrStreamStore, iApplicationInstance, string);
            if (byArray == null) {
                WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveChunk: Error reading DVR chunk '%s'.", CLASSNAME, string));
                return null;
            }
            RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, 0, byArray.length);
            dvrChunk.getFragmentList().addPacketFragment(rTPPacketFragment);
            IAtom iAtom = new AtomBytesToTree().bytesToAtoms(rTPPacketFragment.getBuffer());
            IAtom iAtom2 = iAtom.getAtom("moof");
            if (iAtom2 != null) {
                Object object;
                IAtom iAtom3 = iAtom2.getAtom("uuid", DvrChunkCreator.DVR_HEADER_INFO_GUID_BYTES);
                if (iAtom3 != null) {
                    object = AtomDetailParser.parseUUIDDvrHeader(iAtom3);
                    dvrChunk.setStartTimecode(((UUIDDvrHeaderData)object).dvrStart);
                    dvrChunk.setStopTimecode(((UUIDDvrHeaderData)object).dvrStart + (long)((UUIDDvrHeaderData)object).duration);
                    dvrChunk.setBitrate(((UUIDDvrHeaderData)object).bitrate);
                }
                if ((object = iAtom2.getAtom("uuid", DvrChunkCreator.CODEC_INFO_GUID_BYTES)) != null) {
                    UUIDCodecInfoData uUIDCodecInfoData = AtomDetailParser.parseUUIDCodecAtom((IAtom)object);
                    if (uUIDCodecInfoData.type == 9) {
                        dvrChunk.setMediaInfoVideo(uUIDCodecInfoData.codecInfo);
                    } else if (uUIDCodecInfoData.type == 8) {
                        dvrChunk.setMediaInfoAudio(uUIDCodecInfoData.codecInfo);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveChunk: Error reading DVR file '%s'.", CLASSNAME, string), exception);
            exception.printStackTrace();
        }
        return dvrChunk;
    }

    public static DvrChunk retrieveChunk(IDvrChunkReader iDvrChunkReader) {
        if (iDvrChunkReader == null) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveChunk: Null IDvrChunkReader.", CLASSNAME));
            return null;
        }
        String string = iDvrChunkReader.getMediaName();
        DvrChunk dvrChunk = new DvrChunk();
        try {
            byte[] byArray = DvrChunkReaderUtils.readChunkFile(iDvrChunkReader);
            if (byArray == null) {
                WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveChunk: Error reading DVR chunk '%s'.", CLASSNAME, string));
                return null;
            }
            RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, 0, byArray.length);
            dvrChunk.getFragmentList().addPacketFragment(rTPPacketFragment);
            IAtom iAtom = new AtomBytesToTree().bytesToAtoms(rTPPacketFragment.getBuffer());
            IAtom iAtom2 = iAtom.getAtom("moof");
            if (iAtom2 != null) {
                Object object;
                IAtom iAtom3 = iAtom2.getAtom("uuid", DvrChunkCreator.DVR_HEADER_INFO_GUID_BYTES);
                if (iAtom3 != null) {
                    object = AtomDetailParser.parseUUIDDvrHeader(iAtom3);
                    dvrChunk.setStartTimecode(((UUIDDvrHeaderData)object).dvrStart);
                    dvrChunk.setStopTimecode(((UUIDDvrHeaderData)object).dvrStart + (long)((UUIDDvrHeaderData)object).duration);
                    dvrChunk.setBitrate(((UUIDDvrHeaderData)object).bitrate);
                }
                if ((object = iAtom2.getAtom("uuid", DvrChunkCreator.CODEC_INFO_GUID_BYTES)) != null) {
                    UUIDCodecInfoData uUIDCodecInfoData = AtomDetailParser.parseUUIDCodecAtom((IAtom)object);
                    if (uUIDCodecInfoData.type == 9) {
                        dvrChunk.setMediaInfoVideo(uUIDCodecInfoData.codecInfo);
                    } else if (uUIDCodecInfoData.type == 8) {
                        dvrChunk.setMediaInfoAudio(uUIDCodecInfoData.codecInfo);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(CLASS).error(String.format("%s.retrieveChunk: Error reading DVR file '%s'.", CLASSNAME, string), exception);
            exception.printStackTrace();
        }
        return dvrChunk;
    }
}

