/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.dvr.io;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.dvr.io.DvrChunkWriterFactory;
import com.wowza.wms.dvr.io.IDvrChunkWriter;
import com.wowza.wms.logging.WMSLoggerFactory;

public class DvrChunkWriterUtils {
    private static final String CLASSNAME = "DvrChunkWriterUtils";

    private static void writeChunkFile(IDvrStreamStore iDvrStreamStore, IApplicationInstance iApplicationInstance, String string, DvrChunk dvrChunk) {
        try {
            String string2 = iApplicationInstance.getContextStr();
            String string3 = "com.wowza.wms.dvr.impl.io.DvrFileChunkWriter";
            string3 = iDvrStreamStore.getProperties().getPropertyStr("dvrChunkWriterClass", string3);
            IDvrChunkWriter iDvrChunkWriter = DvrChunkWriterFactory.createInstance(iApplicationInstance, null, string3, iDvrStreamStore.getFileSystem(), string);
            if (iDvrChunkWriter == null) {
                WMSLoggerFactory.getLogger(DvrChunkWriterUtils.class).warn(String.format("%s.writeChunkFile[%s]: Writer class '%s' not found.", CLASSNAME, string2, string3));
                return;
            }
            iDvrChunkWriter.open();
            byte[] byArray = dvrChunk.getFragmentList().toByteArray();
            iDvrChunkWriter.write(byArray, 0, byArray.length);
            try {
                iDvrChunkWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            iDvrChunkWriter = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DvrChunkWriterUtils.class).error(String.format("%s.writeChunkFile: Error writing DVR file '%s'.", CLASSNAME, string), exception);
            exception.printStackTrace();
        }
    }

    public static DvrChunk persistChunk(IDvrStreamStore iDvrStreamStore, IApplicationInstance iApplicationInstance, String string, DvrChunk dvrChunk) {
        try {
            DvrChunkWriterUtils.writeChunkFile(iDvrStreamStore, iApplicationInstance, string, dvrChunk);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DvrChunkWriterUtils.class).error(String.format("%s.retrieveChunk: Error writing DVR file '%s'.", CLASSNAME, string), exception);
            exception.printStackTrace();
        }
        return dvrChunk;
    }
}

