/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.parsers.abst;

import com.wowza.util.BufferUtils;
import com.wowza.wms.parsers.abst.AbstData;
import com.wowza.wms.parsers.abst.AfrtData;
import com.wowza.wms.parsers.abst.AfrtFragmentEntry;
import com.wowza.wms.parsers.abst.AsrtData;
import com.wowza.wms.parsers.abst.AsrtFragmentPair;

public class AbstParser {
    public AbstData parseAbstBytes(byte[] byArray) {
        String string;
        AbstData abstData = new AbstData();
        int n = 0;
        abstData.bytes = byArray;
        abstData.version = BufferUtils.byteArrayToInt(byArray, n += 8, 1);
        abstData.flags = BufferUtils.byteArrayToInt(byArray, ++n, 3);
        abstData.bootstrapVersion = BufferUtils.byteArrayToInt(byArray, n += 3, 4);
        abstData.profile = BufferUtils.byteArrayToInt(byArray, n += 4, 1);
        abstData.timescale = BufferUtils.byteArrayToInt(byArray, ++n, 4);
        abstData.mediaTime = BufferUtils.byteArrayToLong(byArray, n += 4, 8);
        abstData.timeCodeOffset = BufferUtils.byteArrayToLong(byArray, n += 8, 8);
        abstData.movieId = string = this.parseAbstString(byArray, n += 8);
        abstData.serverEntryCount = BufferUtils.byteArrayToInt(byArray, n += string.length() + 1, 1);
        abstData.serverBaseURL = BufferUtils.byteArrayToInt(byArray, ++n, 1);
        abstData.qualityEntryCount = BufferUtils.byteArrayToInt(byArray, ++n, 1);
        abstData.qualitySegmentURLModifier = string = this.parseAbstString(byArray, ++n);
        n += string.length() + 1;
        abstData.drmData = string = this.parseAbstString(byArray, n);
        n += string.length() + 1;
        abstData.metadata = string = this.parseAbstString(byArray, n);
        abstData.segmentRunTableCount = BufferUtils.byteArrayToInt(byArray, n += string.length() + 1, 1);
        ++n;
        abstData.asrt = new AsrtData();
        abstData.asrt.version = BufferUtils.byteArrayToInt(byArray, n += 8, 1);
        abstData.asrt.flags = BufferUtils.byteArrayToInt(byArray, ++n, 3);
        abstData.asrt.qualityEntryCount = BufferUtils.byteArrayToInt(byArray, n += 3, 1);
        abstData.asrt.qualitySegmentURLModifier = string = this.parseAbstString(byArray, ++n);
        int n2 = BufferUtils.byteArrayToInt(byArray, n += string.length() + 1, 4);
        n += 4;
        AsrtFragmentPair[] asrtFragmentPairArray = new AsrtFragmentPair[n2];
        for (int i = 0; i < n2; ++i) {
            asrtFragmentPairArray[i] = new AsrtFragmentPair();
            asrtFragmentPairArray[i].fp1 = BufferUtils.byteArrayToInt(byArray, n, 4);
            asrtFragmentPairArray[i].fp2 = BufferUtils.byteArrayToInt(byArray, n += 4, 4);
            n += 4;
        }
        abstData.asrt.fragmentPair = asrtFragmentPairArray;
        abstData.asrt.fragmentRunTableCount = BufferUtils.byteArrayToInt(byArray, n, 1);
        ++n;
        abstData.afrt = new AfrtData();
        abstData.afrt.version = BufferUtils.byteArrayToInt(byArray, n += 8, 1);
        abstData.afrt.flags = BufferUtils.byteArrayToInt(byArray, ++n, 3);
        abstData.afrt.timescale = BufferUtils.byteArrayToInt(byArray, n += 3, 4);
        abstData.afrt.qualityEntryCount = BufferUtils.byteArrayToInt(byArray, n += 4, 1);
        abstData.afrt.qualitySegmentURLModifier = string = this.parseAbstString(byArray, ++n);
        n2 = BufferUtils.byteArrayToInt(byArray, n += string.length() + 1, 4);
        n += 4;
        AfrtFragmentEntry[] afrtFragmentEntryArray = new AfrtFragmentEntry[n2];
        for (int i = 0; i < n2; ++i) {
            afrtFragmentEntryArray[i] = new AfrtFragmentEntry();
            afrtFragmentEntryArray[i].fragmentId = BufferUtils.byteArrayToInt(byArray, n, 4);
            afrtFragmentEntryArray[i].accruedDuration = BufferUtils.byteArrayToInt(byArray, n += 4, 8);
            afrtFragmentEntryArray[i].duration = BufferUtils.byteArrayToInt(byArray, n += 8, 4);
            n += 4;
        }
        abstData.afrt.fragmentEntries = afrtFragmentEntryArray;
        return abstData;
    }

    private String parseAbstString(byte[] byArray, int n) {
        int n2 = n;
        String string = "";
        int n3 = 0;
        while (byArray[n++] != 0) {
            ++n3;
        }
        if (n3 > 0) {
            string = BufferUtils.byteArrayToString(byArray, n2, n3);
        }
        return string;
    }
}

