/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.util.SystemUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerVideoBase;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;

public class RTPDePacketizerQuicktimeH264
extends RTPDePacketizerVideoBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    private RTPSequence seq = new RTPSequence();
    private RTPPacket workingPacket = null;
    private byte[] payloadDescription = null;
    private long payloadSeq = -1L;
    private Object payloadLock = new Object();
    private long lastTimecode = -1L;
    private long lastSeq = -1L;
    private boolean waitForEnd = true;
    private int waitForDropped = 0;
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private RolloverLong timecode = new RolloverLong(32);
    private boolean isCodecConfig = false;

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerQuicktimeH264.init");
        }
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        String string;
        return rTPTrack.isVideo() && (string = rTPTrack.getSampleType()) != null && string.toLowerCase().startsWith("x-qt");
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtcp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTCPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.rtcpHandler.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodecConfig(RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        Object object = this.payloadLock;
        synchronized (object) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            rTPTrack.setCodecConfig(byArray2);
            this.isCodecConfig = true;
        }
    }

    protected boolean isCodecConfig(RTPTrack rTPTrack) {
        if (!this.isCodecConfig) {
            this.isCodecConfig = rTPTrack.isCodecConfig();
        }
        return this.isCodecConfig;
    }

    protected byte[] getCodecConfig(RTPTrack rTPTrack) {
        return rTPTrack.getCodecConfig();
    }

    public static String logTimeContext(RTPTrack rTPTrack) {
        String string = "";
        Date date = new Date();
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"HH:mm:ss", (TimeZone)SystemUtils.defaultTimeZone, (Locale)SystemUtils.defaultLocale);
        string = (rTPTrack == null ? "unknown" : rTPTrack.getStream().getStreamName()) + ": " + fastDateFormat.format(date) + ": ";
        return string;
    }

    public void parsePayloadDescription(RTPTrack rTPTrack, byte[] byArray) {
        String string = "";
        if (byArray.length >= 4) {
            string = BufferUtils.byteArrayToString(byArray, 0, 4);
        }
        if (!string.equals("vide")) {
            return;
        }
        int n = 8;
        while (n < byArray.length) {
            int n2;
            block7: {
                n2 = BufferUtils.byteArrayToInt(byArray, n, 2);
                String string2 = BufferUtils.byteArrayToString(byArray, n + 2, 2);
                try {
                    int n3;
                    if (!string2.equals("sd")) break block7;
                    int n4 = n + 4;
                    int n5 = BufferUtils.byteArrayToInt(byArray, n4, 4);
                    int n6 = n4 + n5;
                    String string3 = BufferUtils.byteArrayToString(byArray, n4 + 4, 4);
                    if (!string3.equals("avc1")) break block7;
                    int n7 = n4 + 8;
                    int n8 = 8;
                    n8 += 4;
                    n8 += 4;
                    n8 += 4;
                    n8 += 4;
                    n8 += 2;
                    n8 += 2;
                    n8 += 4;
                    n8 += 4;
                    n8 += 4;
                    int n9 = BufferUtils.byteArrayToInt(byArray, n7 + (n8 += 2), 1);
                    String string4 = BufferUtils.byteArrayToString(byArray, n7 + n8 + 1, n9);
                    n8 += n9 + 1;
                    int n10 = n7 + (n8 += 30);
                    while ((n3 = BufferUtils.byteArrayToInt(byArray, n10, 4)) != 0) {
                        String string5 = BufferUtils.byteArrayToString(byArray, n10 + 4, 4);
                        if (string5.equals("avcC")) {
                            this.setCodecConfig(rTPTrack, byArray, n10 + 8, n3 - 8);
                        }
                        if ((n10 += n3) < n6) continue;
                        break;
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).warn("RTPDePacketizerQuicktimeH264.parsePayloadDescription: " + exception.toString());
                    exception.printStackTrace();
                }
            }
            if ((n += n2 + 4) + 4 < byArray.length) continue;
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        this.timecode.set(l);
        this.setVideoCodecId(rTPTrack, 7);
        try {
            int n4;
            int n5;
            boolean bl = (byArray[n + 1] >> 7 & 1) == 1;
            int n6 = this.skipRTPExtensions(byArray, n, n2, 12);
            int n7 = 4;
            int n8 = byArray[n + n6 + 0] >> 2 & 3;
            boolean bl2 = (byArray[n + n6 + 0] >> 1 & 1) == 1;
            boolean bl3 = (byArray[n + n6 + 0] >> 0 & 1) == 1;
            boolean bl4 = (byArray[n + n6 + 1] >> 7 & 1) == 1;
            boolean bl5 = (byArray[n + n6 + 2] >> 7 & 1) == 1;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            if (bl3) {
                n5 = (byArray[n + n6 + n7 + 0] >> 7 & 1) == 1 ? 1 : 0;
                boolean bl6 = (byArray[n + n6 + n7 + 0] >> 6 & 1) == 1;
                n4 = (byArray[n + n6 + n7 + 0] >> 5 & 1) == 1 ? 1 : 0;
                boolean bl7 = (byArray[n + n6 + n7 + 0] >> 4 & 1) == 1;
                n9 = byArray[n + n6 + n7 + 2];
                n9 <<= 8;
                int n12 = 4 - (n9 += byArray[n + n6 + n7 + 3] & 0xFF) % 4;
                if (n12 == 4) {
                    n12 = 0;
                }
                n9 += n12;
                if (!this.isCodecConfig(rTPTrack)) {
                    if (n4 != 0) {
                        this.payloadDescription = new byte[n9 - 4];
                        System.arraycopy(byArray, n + n6 + n7 + 4, this.payloadDescription, 0, this.payloadDescription.length);
                        this.payloadSeq = this.seq.longValue();
                    } else if (this.payloadDescription != null && this.payloadSeq != -1L && this.seq.longValue() == this.payloadSeq + 1L) {
                        byte[] byArray2 = new byte[this.payloadDescription.length + n9 - 4];
                        System.arraycopy(this.payloadDescription, 0, byArray2, 0, this.payloadDescription.length);
                        System.arraycopy(byArray, n + n6 + n7 + 4, byArray2, this.payloadDescription.length, n9 - 4);
                        this.payloadDescription = byArray2;
                        this.payloadSeq = this.seq.longValue();
                    }
                    if (bl7) {
                        if (this.payloadDescription != null) {
                            this.parsePayloadDescription(rTPTrack, this.payloadDescription);
                            this.payloadDescription = null;
                        }
                        this.payloadSeq = -1L;
                    }
                }
                n11 += n9;
            }
            if (bl4) {
                n10 = byArray[n + n6 + n7 + n11 + 2];
                n10 <<= 8;
                n5 = 4 - (n10 += byArray[n + n6 + n7 + n11 + 3] & 0xFF) % 4;
                if (n5 == 4) {
                    n5 = 0;
                }
                n11 += (n10 += n5);
            }
            if (this.waitForEnd) {
                if (bl) {
                    this.lastTimecode = this.timecode.get();
                    this.lastSeq = this.seq.longValue();
                    this.waitForEnd = false;
                }
                ++this.waitForDropped;
                this.workingPacket = null;
                if (!this.debugLog) return;
                WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerQuicktimeH264.logTimeContext(rTPTrack) + "  waitforend: dropped:" + this.waitForDropped);
                return;
            }
            long l2 = this.seq.longValue();
            if (this.lastSeq != -1L && this.lastSeq + 1L != l2) {
                n4 = 0;
                if (l2 <= this.lastSeq) {
                    if (!this.debugLog) return;
                    WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerQuicktimeH264.logTimeContext(rTPTrack) + "  latepacket: curr:" + l2 + " last:" + this.lastSeq);
                    return;
                }
                if (this.lastSeq + 2L == l2) {
                    n4 = 1;
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerQuicktimeH264.logTimeContext(rTPTrack) + "  dropone: curr:" + l2 + " last:" + this.lastSeq);
                    }
                    if (this.lastTimecode == -1L || this.workingPacket == null || this.lastTimecode == this.timecode.get()) {
                        this.waitForEnd = true;
                        this.waitForDropped = 0;
                    }
                } else {
                    n4 = 1;
                    this.waitForEnd = true;
                    this.waitForDropped = 0;
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerQuicktimeH264.logTimeContext(rTPTrack) + "  dropmany: curr:" + l2 + " last:" + this.lastSeq);
                    }
                }
                if (n4 != 0) {
                    if (this.workingPacket != null) {
                        if (this.debugLog) {
                            WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerQuicktimeH264.logTimeContext(rTPTrack) + "  sendPartial");
                        }
                        this.sendPacket(rTPTrack, this.workingPacket, true);
                    }
                    this.workingPacket = null;
                }
                if (this.waitForEnd) {
                    this.workingPacket = null;
                    return;
                }
            }
            this.lastTimecode = this.timecode.get();
            this.lastSeq = this.seq.longValue();
            if (this.debugLog) {
                WMSLoggerFactory.getLogger(null).debug("  header: sz:" + (n2 - (n6 + n7 + n11)) + " tc:" + this.timecode + " end:" + bl + " seq:" + this.seq.longValue());
            }
            if (n6 + n7 + n11 < n2) {
                if (this.workingPacket == null) {
                    n4 = bl2 ? 1 : 2;
                    this.workingPacket = new RTPPacket();
                    this.workingPacket.setType(9);
                    this.workingPacket.setCodec(7);
                    this.workingPacket.setFrameType(n4);
                    this.workingPacket.setTimecode(this.timecode.get());
                }
                RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, n + n6 + n7 + n11, n2 - (n6 + n7 + n11));
                this.workingPacket.addFragment(rTPPacketFragment);
            }
            if (!bl) {
                return;
            }
            if (this.workingPacket == null) {
                return;
            }
            this.sendPacket(rTPTrack, this.workingPacket, false);
            this.workingPacket = null;
            return;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).error("RTPDePacketizerQuicktimeH264.handleRTPPacket: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void startup(RTPTrack rTPTrack) {
        this.waitForEnd = rTPTrack.isWaitForFirstEnd();
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }
}

