/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.dvrpacketizer;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.dvr.IDvrStore;
import com.wowza.wms.dvr.model.DvrStoreItem;
import com.wowza.wms.dvr.model.DvrStoreList;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.dvrpacketizer.DvrPacketizerItem;
import com.wowza.wms.stream.dvrpacketizer.IDvrPacketizer;
import com.wowza.wms.util.IIdleNotify;
import com.wowza.wms.util.IdleWorkersUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DvrPacketizerBase
implements IDvrPacketizer,
IIdleNotify,
Runnable {
    public static final int EVENT_PACKET = 0;
    public static final int EVENT_STARTSTREAM = 1;
    public static final int EVENT_RESETSTREAM = 2;
    public static final int MAXEVENTSPERRUN = 20;
    private static final String CLASSNAME = "DvrPacketizerBase";
    protected DvrPacketizerItem dvrPacketizerItem = null;
    protected IApplicationInstance appInstance = null;
    protected int streamTimeout = 12000;
    protected int streamStartupTimeout = this.streamTimeout * 2;
    protected int maxEventsPerRun = 20;
    protected long lastStreamUpdate = -1L;
    protected long lastStreamStartTime = -1L;
    protected long lastCheckTime = -1L;
    protected int checkTimeoutInterval = 250;
    protected Object timeoutLock = new Object();
    protected String streamName = null;
    protected String packetizerName = null;
    protected boolean isActive = true;
    protected WMSProperties properties = new WMSProperties();
    protected List<PacketizerEventHolder> events = new ArrayList<PacketizerEventHolder>();
    protected boolean isRunning = false;
    protected Object runnerLock = new Object();
    protected String id = null;
    protected boolean packetizeAudio = true;
    protected boolean packetizeVideo = true;
    protected boolean packetizeData = true;
    protected IMediaStream stream = null;
    private IDvrStore dvrStorage;

    public abstract void internalHandlePacket(IMediaStream var1, AMFPacket var2);

    public abstract void internalStartStream(IMediaStream var1);

    public abstract void internalResetStream(IMediaStream var1);

    @Override
    public void init(String string, String string2, IApplicationInstance iApplicationInstance, DvrPacketizerItem dvrPacketizerItem) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DvrPacketizerBase.class);
        this.streamName = string;
        this.packetizerName = string2;
        this.appInstance = iApplicationInstance;
        this.dvrPacketizerItem = dvrPacketizerItem;
        this.properties.putAll(dvrPacketizerItem.getProperties());
        this.properties.putAll(iApplicationInstance.getDvrPacketizerProperties());
        wMSLogger.info("DvrPacketizerBase.initProperties propertes: " + this.properties);
        this.streamTimeout = this.properties.getPropertyInt("streamTimeout", this.streamTimeout);
        this.streamStartupTimeout = this.properties.getPropertyInt("streamStartupTimeout", this.streamStartupTimeout);
        this.checkTimeoutInterval = this.properties.getPropertyInt("checkTimeoutInterval", this.checkTimeoutInterval);
        this.maxEventsPerRun = this.properties.getPropertyInt("maxEventsPerRun", this.maxEventsPerRun);
        IdleWorkersUtil idleWorkersUtil = this.appInstance.getVHost().getIdleWorkers();
        idleWorkersUtil.registerIdleClient(this);
    }

    private ArrayList<String> getPossibleDvrStores() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.appInstance.getDvrStoreList();
        if (string != null) {
            string = string.replace(",", "|");
            string = string.replace(";", "|");
            String[] stringArray = string.split("[|]");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    @Override
    public IDvrStore getDvrStore(boolean bl) {
        if (this.dvrStorage == null && bl) {
            this.createDvrStore();
        }
        return this.dvrStorage;
    }

    protected void createDvrStore() {
        if (this.appInstance == null || this.streamName == null) {
            return;
        }
        try {
            MediaStreamMap mediaStreamMap = this.appInstance.getStreams();
            IMediaStream iMediaStream = mediaStreamMap.getStream(this.streamName);
            DvrStoreList dvrStoreList = this.appInstance.getVHost().getDvrStoreList();
            ArrayList<String> arrayList = this.getPossibleDvrStores();
            for (String string : arrayList) {
                IDvrStore iDvrStore;
                DvrStoreItem dvrStoreItem = dvrStoreList.getDvrStoreDef(string);
                if (dvrStoreItem == null || (iDvrStore = mediaStreamMap.getDvrStore(string, true)) == null) continue;
                this.dvrStorage = iDvrStore;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DvrPacketizerBase.class).error("DvrPacketizerBase.initDvrStore", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        int n = 0;
        boolean bl = false;
        PacketizerEventHolder packetizerEventHolder = null;
        while (true) {
            if (packetizerEventHolder != null) {
                switch (packetizerEventHolder.event) {
                    case 0: {
                        this.internalHandlePacket(packetizerEventHolder.stream, packetizerEventHolder.packet);
                        break;
                    }
                    case 1: {
                        this.internalStartStream(packetizerEventHolder.stream);
                        break;
                    }
                    case 2: {
                        this.internalResetStream(packetizerEventHolder.stream);
                    }
                }
                ++n;
            }
            object = this.runnerLock;
            synchronized (object) {
                if (n > this.maxEventsPerRun) {
                    this.isRunning = false;
                    bl = true;
                    break;
                }
                if (this.events.size() <= 0) {
                    this.isRunning = false;
                    break;
                }
                packetizerEventHolder = this.events.remove(0);
            }
        }
        if (bl) {
            object = this.runnerLock;
            synchronized (object) {
                if (!this.isRunning) {
                    this.isRunning = true;
                    this.appInstance.getVHost().getHandlerThreadPool().execute(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPacketizerEvent(PacketizerEventHolder packetizerEventHolder) {
        Object object = this.runnerLock;
        synchronized (object) {
            this.events.add(packetizerEventHolder);
            if (!this.isRunning) {
                this.isRunning = true;
                this.appInstance.getVHost().getHandlerThreadPool().execute(this);
            }
        }
    }

    @Override
    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        PacketizerEventHolder packetizerEventHolder = new PacketizerEventHolder(0, iMediaStream, aMFPacket);
        this.addPacketizerEvent(packetizerEventHolder);
    }

    @Override
    public IMediaStream getStream() {
        return this.stream;
    }

    @Override
    public void startStream(IMediaStream iMediaStream) {
        this.stream = iMediaStream;
        PacketizerEventHolder packetizerEventHolder = new PacketizerEventHolder(1, iMediaStream);
        this.addPacketizerEvent(packetizerEventHolder);
    }

    @Override
    public void resetStream(IMediaStream iMediaStream) {
        this.stream = iMediaStream;
        PacketizerEventHolder packetizerEventHolder = new PacketizerEventHolder(2, iMediaStream);
        this.addPacketizerEvent(packetizerEventHolder);
    }

    public String getContextStr() {
        String string = this.appInstance.getApplication().getName() + "/" + this.appInstance.getName() + "/" + this.streamName;
        return string;
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    @Override
    public void onIdle(long l) {
        if (this.lastCheckTime == -1L || l - this.lastCheckTime >= (long)this.checkTimeoutInterval) {
            this.lastCheckTime = l;
            this.checkTimeout(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.timeoutLock;
        synchronized (object) {
            this.isActive = false;
        }
        if (this.dvrStorage != null) {
            this.dvrStorage.removeStream(this.streamName);
        }
        if (this.appInstance != null) {
            object = this.appInstance.getVHost().getIdleWorkers();
            ((IdleWorkersUtil)object).unregisterIdleClient(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.timeoutLock;
        synchronized (object) {
            return this.isActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void touch(long l) {
        Object object = this.timeoutLock;
        synchronized (object) {
            this.lastStreamUpdate = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeout(long l) {
        boolean bl = false;
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.lastStreamUpdate == -1L) {
                if (this.lastStreamStartTime == -1L) {
                    this.lastStreamStartTime = l;
                } else if (l - this.lastStreamStartTime > (long)this.streamStartupTimeout) {
                    bl = true;
                }
            } else if (l - this.lastStreamUpdate > (long)this.streamTimeout) {
                bl = true;
            }
        }
        if (bl) {
            this.appInstance.getStreams().removeDvrPacketizer(this.packetizerName, this.streamName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamTimeout() {
        Object object = this.timeoutLock;
        synchronized (object) {
            return this.streamTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamTimeout(int n) {
        Object object = this.timeoutLock;
        synchronized (object) {
            this.streamTimeout = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamStartupTimeout() {
        Object object = this.timeoutLock;
        synchronized (object) {
            return this.streamStartupTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamStartupTimeout(int n) {
        Object object = this.timeoutLock;
        synchronized (object) {
            this.streamStartupTimeout = n;
        }
    }

    @Override
    public String getDvrPacketizerId() {
        return this.id;
    }

    @Override
    public void setDvrPacketizerId(String string) {
        this.id = string;
    }

    @Override
    public boolean canPacketizeAudio() {
        return this.packetizeAudio;
    }

    @Override
    public void setPacketizeAudio(boolean bl) {
        this.packetizeAudio = bl;
    }

    @Override
    public boolean canPacketizeVideo() {
        return this.packetizeVideo;
    }

    @Override
    public void setPacketizeVideo(boolean bl) {
        this.packetizeVideo = bl;
    }

    @Override
    public boolean canPacketizeData() {
        return this.packetizeData;
    }

    @Override
    public void setPacketizeData(boolean bl) {
        this.packetizeData = bl;
    }

    class PacketizerEventHolder {
        int event = 0;
        IMediaStream stream = null;
        AMFPacket packet = null;

        public PacketizerEventHolder(int n, IMediaStream iMediaStream, AMFPacket aMFPacket) {
            this.event = n;
            this.stream = iMediaStream;
            this.packet = aMFPacket;
        }

        public PacketizerEventHolder(int n, IMediaStream iMediaStream) {
            this.event = n;
            this.stream = iMediaStream;
        }
    }
}

