/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.file;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.model.HTTPStreamerFileInfo;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.HTTPStreamerSanJoseIndexItem;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.HTTPStreamerSanJoseIndexItemH264;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.IHTTPStreamerSanJoseIndexItem;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.IMediaReaderSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseHTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.mp3.MediaReaderMP3;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.PlaylistSeekResult;

public class MediaReaderMP3SanJose
extends MediaReaderMP3
implements IMediaReaderSanJose {
    private int chunkDurationTolerance = 500;
    private int chunkDurationTarget = 10000;
    private boolean init = true;

    private void init(HTTPStreamerSanJoseIndexItem hTTPStreamerSanJoseIndexItem) {
        if (this.init) {
            IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = hTTPStreamerSanJoseIndexItem.getIndex().getApplicationContext();
            if (iHTTPStreamerApplicationContext != null) {
                WMSProperties wMSProperties = iHTTPStreamerApplicationContext.getProperties();
                WMSProperties wMSProperties2 = iHTTPStreamerApplicationContext.getAppInstance().getHTTPStreamerProperties();
                this.chunkDurationTolerance = wMSProperties.getPropertyInt("sanjoseChunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTolerance = wMSProperties2.getPropertyInt("sanjoseChunkDurationTolerance", this.chunkDurationTolerance);
                this.chunkDurationTarget = wMSProperties.getPropertyInt("sanjoseChunkDurationTarget", this.chunkDurationTarget);
                this.chunkDurationTarget = wMSProperties2.getPropertyInt("sanjoseChunkDurationTarget", this.chunkDurationTarget);
            }
            this.init = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFile(HTTPStreamerSanJoseIndexItem hTTPStreamerSanJoseIndexItem) {
        this.init(hTTPStreamerSanJoseIndexItem);
        Object object = this.lock;
        synchronized (object) {
            try {
                long l;
                long l2 = 0L;
                int n = 0;
                do {
                    if (l2 + (l = (long)this.chunkDurationTarget) > this.duration) {
                        l = this.duration - l2;
                    }
                    if (l <= 0L) break;
                    String string = SanJoseHTTPStreamerUtils.extractMetaDataString(this);
                    String string2 = "audio/mpeg";
                    if (string != null) {
                        hTTPStreamerSanJoseIndexItem.setMetaData(string);
                    }
                    hTTPStreamerSanJoseIndexItem.setDuration(this.duration);
                    hTTPStreamerSanJoseIndexItem.setMimeType(string2);
                    if (this.streamSize > 0L && this.duration > 0L) {
                        hTTPStreamerSanJoseIndexItem.setCalculatedBitrate((int)(this.streamSize * 8L * 1000L / this.duration));
                    }
                    HTTPStreamerSanJoseIndexItemH264 hTTPStreamerSanJoseIndexItemH264 = new HTTPStreamerSanJoseIndexItemH264();
                    hTTPStreamerSanJoseIndexItemH264.setIndex(++n);
                    hTTPStreamerSanJoseIndexItemH264.setStartTimecode(l2);
                    hTTPStreamerSanJoseIndexItemH264.setStopTimecode(l2 + l);
                    hTTPStreamerSanJoseIndexItemH264.setStartVideoSample(-1L);
                    hTTPStreamerSanJoseIndexItemH264.setLastVideoSample(-1L);
                    hTTPStreamerSanJoseIndexItem.addIndexItem(hTTPStreamerSanJoseIndexItemH264);
                } while ((l2 += l) < this.duration);
                IHTTPStreamerSession iHTTPStreamerSession = hTTPStreamerSanJoseIndexItem.getIndex().getHttpStreamerSession();
                if (iHTTPStreamerSession != null) {
                    HTTPStreamerFileInfo hTTPStreamerFileInfo = new HTTPStreamerFileInfo(hTTPStreamerSanJoseIndexItem.getStreamName(), this.length, (double)this.duration / 1000.0);
                    iHTTPStreamerSession.putFileInfo(hTTPStreamerSanJoseIndexItem.getStreamName(), hTTPStreamerFileInfo);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderMP3SanJose.class).error("MediaReaderMP3SanJose.indexFile:" + exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillChunk(IHTTPStreamerSanJoseIndexItem iHTTPStreamerSanJoseIndexItem, LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Object object2;
                PlaylistSeekResult playlistSeekResult;
                long l = iHTTPStreamerSanJoseIndexItem.getStartTimecode();
                long l2 = iHTTPStreamerSanJoseIndexItem.getStopTimecode();
                liveStreamPacketizerSanJoseChunk.setStartTimecode(l);
                liveStreamPacketizerSanJoseChunk.setDuration(l2 - l);
                liveStreamPacketizerSanJoseChunk.setStreamMode(2);
                long l3 = this.sample2TC(this.currentSample);
                if ((l3 < l || l3 >= l + (long)(this.chunkDurationTarget / 2)) && (playlistSeekResult = this.seek(l, 3)) != null) {
                    object2 = playlistSeekResult.getStreamPos();
                    this.setStreamPosition((IMediaReaderStreamPosition)object2);
                    l3 = this.sample2TC(this.currentSample);
                }
                while ((this.h = this.bitstream.readFrame()) != null) {
                    if (this.bitstream.framesize <= 0) {
                        if (!this.bitrateErrorSent) {
                            WMSLoggerFactory.getLogger(MediaReaderMP3.class).error("MediaReaderMP3.writePackets: Negative frame size (" + this.bitstream.framesize + "). May be due to unsupported MP3 bitrate higher than 128 kbps.");
                            this.bitrateErrorSent = true;
                        }
                    } else {
                        int n = this.bitstream.framesize + 5;
                        if (n > 0) {
                            object2 = new byte[1 + this.syncHeader.length + this.bitstream.framesize];
                            this.h.getSyncHeader(this.syncHeader);
                            int n2 = 0;
                            object2[n2] = (IMediaReaderStreamPosition)this.packetHeader[0];
                            System.arraycopy(this.syncHeader, 0, object2, ++n2, this.syncHeader.length);
                            System.arraycopy(this.bitstream.frame_bytes, 0, object2, n2 += this.syncHeader.length, this.bitstream.framesize);
                            n2 += this.bitstream.framesize;
                            liveStreamPacketizerSanJoseChunk.addRTMPHeader(8, ((IMediaReaderStreamPosition)object2).length, l3);
                            liveStreamPacketizerSanJoseChunk.addBlock((byte[])object2, 0, ((IMediaReaderStreamPosition)object2).length);
                            liveStreamPacketizerSanJoseChunk.addRTMPFooter(((IMediaReaderStreamPosition)object2).length);
                        }
                        this.bitstream.closeFrame();
                        this.currentSample += (long)this.samplesPerFrame;
                        l3 = this.sample2TC(this.currentSample);
                        if (l3 < l2) continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderMP3SanJose.class).error("MediaReaderMP3SanJose.fillChunk: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }
}

