/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer;

import com.wowza.util.DebugUtils;
import com.wowza.util.HTTPUtils;
import com.wowza.util.IFasterByteArrayWriteReference;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.IDvrPlayerAdapter;
import com.wowza.wms.dvr.IDvrStore;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerAdapterBase;
import com.wowza.wms.httpstreamer.model.HTTPStreamerContext;
import com.wowza.wms.httpstreamer.model.HTTPStreamerRequest;
import com.wowza.wms.httpstreamer.model.HTTPStreamerResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerStreamNameParts;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.sanjosestreaming.dvr.DvrPlayerAdapterSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.IHTTPStreamerSanJoseIndex;
import com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer.HTTPStreamerApplicationContextSanJoseStreamer;
import com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer.HTTPStreamerSessionSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer.SanJoseFragmentId;
import com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer.SanJoseStreamingURL;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamingSanJoseBlock;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerAdapterSmoothStreamer;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.vhost.IVHost;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoSession;

public class HTTPStreamerAdapterSanJoseStreamer
extends HTTPStreamerAdapterBase {
    protected boolean debugLog = false;
    public static final int CROSSDOMAIN_READ_FREQUENCY = 5000;
    private static final String CLASSNAME = "HTTPStreamerAdapterSanJoseStreamer";
    protected int requestTimeout = 8000;
    protected int tcpTimeToLive = 500;
    protected int tcpKeepAliveTimeout = 5000;
    protected String playlistMimeType = "application/vnd.apple.mpegurl";
    protected String videoMimeType = "video/MP2T";
    protected String audioAACMimeType = "audio/x-aac";
    protected String audioMP3MimeType = "audio/mpeg";
    protected String keyMimeType = "binary/octet-stream";
    protected String crossdomainPath = "${com.wowza.wms.context.VHostConfigHome}/conf/crossdomain.xml";
    protected boolean crossdomainResolved = false;
    protected long lastCrossdomainRead = -1L;
    protected String crossdomainStr = null;
    private IDvrPlayerAdapter dvrPlayerAdapter = new DvrPlayerAdapterSanJose();

    public HTTPStreamerAdapterSanJoseStreamer() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
    }

    public void init() {
        super.init();
        this.crossdomainPath = this.properties.getPropertyStr("crossdomainPath", this.crossdomainPath);
        this.playlistMimeType = this.getProperties().getPropertyStr("playlistMimeType", this.playlistMimeType);
        this.videoMimeType = this.getProperties().getPropertyStr("videoMimeType", this.videoMimeType);
        this.audioAACMimeType = this.getProperties().getPropertyStr("videoAACMimeType", this.audioAACMimeType);
        this.audioMP3MimeType = this.getProperties().getPropertyStr("videoMP3MimeType", this.audioMP3MimeType);
        this.keyMimeType = this.getProperties().getPropertyStr("keyMimeType", this.keyMimeType);
        this.requestTimeout = this.getProperties().getPropertyInt("requestTimeout", this.requestTimeout);
        this.tcpTimeToLive = this.getProperties().getPropertyInt("tcpTimeToLive", this.tcpTimeToLive);
        this.tcpKeepAliveTimeout = this.getProperties().getPropertyInt("tcpKeepAliveTimeout", this.tcpKeepAliveTimeout);
        if (WMSLoggerFactory.getLogger(null).isDebugEnabled()) {
            this.debugLog = true;
        }
    }

    public boolean canHandle(String string) {
        boolean bl;
        int n = string.indexOf("?");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if (!(bl = super.canHandle(string))) {
            boolean bl2 = bl = string.indexOf(".abst/") >= 0;
        }
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).info("HTTPStreamerAdapterSanJoseStreaming.canHandle[" + string + "]: " + bl);
        }
        return bl;
    }

    public void service(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        long l = System.currentTimeMillis();
        if (rtmpRequestMessage.getType() == 3) {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            RtmpRequestMessage rtmpRequestMessage2 = rtmpSessionInfo.getAndClearPendingRequest();
            if (rtmpRequestMessage2 != null) {
                this.serviceMsg(l, ioSession, rtmpRequestMessage2, rtmpResponseMessage);
                if (rtmpSessionInfo.isPendingRequest() && l - rtmpRequestMessage2.getCreateTime() > (long)this.requestTimeout) {
                    WMSLoggerFactory.getLogger(null).warn("HTTPStreamerAdapterSanJoseStreaming.service: Request timeout: " + this.requestTimeout);
                    rtmpSessionInfo.getAndClearPendingRequest();
                    rtmpResponseMessage.setResponseCode(404);
                }
            } else {
                long l2 = l - ioSession.getLastIoTime();
                long l3 = ioSession.getScheduledWriteBytes();
                boolean bl = false;
                if (l3 <= 0L) {
                    rtmpSessionInfo.setLastBytesToWriteBytes(-1L);
                    if (rtmpSessionInfo.isCloseOnIdle()) {
                        if (l2 >= (long)this.tcpTimeToLive) {
                            ioSession.close();
                        }
                    } else if (l2 >= (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                } else {
                    long l4 = rtmpSessionInfo.getLastBytesToWriteBytes();
                    long l5 = rtmpSessionInfo.getLastBytesToWriteTimecode();
                    if (l4 == -1L || l4 != l3) {
                        rtmpSessionInfo.setLastBytesToWriteBytes(l3);
                        rtmpSessionInfo.setLastBytesToWriteTimecode(l);
                    } else if (l - l5 > (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                }
                if (!bl) {
                    Set set = rtmpSessionInfo.getHTTPSession();
                    for (IHTTPStreamerSession iHTTPStreamerSession : set) {
                        iHTTPStreamerSession.touch(l);
                    }
                }
            }
        } else {
            this.serviceMsg(l, ioSession, rtmpRequestMessage, rtmpResponseMessage);
        }
    }

    public void serviceMsg(long l, IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        try {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            String string = rtmpRequestMessage.getPath();
            if (string.endsWith(".abst/")) {
                string = string.substring(0, string.length() - 1);
            }
            if (this.debugLog) {
                WMSLoggerFactory.getLogger(null).info("HTTPStreamerAdapterSanJoseStreaming.service: " + string);
            }
            HTTPStreamerRequest hTTPStreamerRequest = new HTTPStreamerRequest(rtmpRequestMessage);
            HTTPStreamerResponse hTTPStreamerResponse = new HTTPStreamerResponse(rtmpResponseMessage);
            IVHost iVHost = rtmpRequestMessage.getVHost();
            String string2 = hTTPStreamerRequest.getHeader("range");
            String string3 = hTTPStreamerRequest.getHeader("connection");
            boolean bl = false;
            if (string3 != null && string3.equalsIgnoreCase("close")) {
                bl = true;
            }
            rtmpSessionInfo.setCloseOnIdle(bl);
            int n = string.indexOf("?");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (string.endsWith(".f4m") || string.endsWith(".abst")) {
                this.onPlaylist(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse, string.endsWith(".f4m"));
            } else if (string.indexOf(".abst/") >= 0) {
                this.onMediaFile(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith("crossdomain.xml")) {
                this.onCrossdomain(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).error("HTTPStreamerAdapterSanJoseStreaming.service: " + exception.toString());
            exception.printStackTrace();
        }
    }

    protected IHTTPStreamerSession createSession(IHTTPRequest iHTTPRequest, IApplicationInstance iApplicationInstance, String string, String string2) {
        int n;
        int n2;
        HTTPStreamerSessionSanJose hTTPStreamerSessionSanJose = new HTTPStreamerSessionSanJose();
        String string3 = iHTTPRequest.getHeader("referrer");
        hTTPStreamerSessionSanJose.setReferrer(string3);
        String string4 = iHTTPRequest.getHeader("host");
        int n3 = iHTTPRequest.getServerPort();
        if (string4 != null && (n2 = string4.indexOf(":")) >= 0) {
            try {
                n3 = Integer.parseInt(string4.substring(n2 + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string4 = string4.substring(0, n2);
        }
        hTTPStreamerSessionSanJose.setServerIp(string4);
        hTTPStreamerSessionSanJose.setServerPort(n3);
        String string5 = iHTTPRequest.getHeader("context");
        String string6 = null;
        if (string5 != null && (n = (string5 = HTTPStreamerUtils.urlDecode((String)string5)).indexOf("?")) > 0) {
            string6 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        hTTPStreamerSessionSanJose.setUri(string5);
        hTTPStreamerSessionSanJose.setQueryStr(string6);
        hTTPStreamerSessionSanJose.setUserAgent(iHTTPRequest.getHeader("user-agent"));
        hTTPStreamerSessionSanJose.setCookieStr(iHTTPRequest.getHeader("cookie"));
        hTTPStreamerSessionSanJose.addStreamDomainStr(string2);
        this.createSession((IHTTPStreamerSession)hTTPStreamerSessionSanJose, iApplicationInstance, string);
        return hTTPStreamerSessionSanJose;
    }

    public File getCrossdomainFile() {
        if (!this.crossdomainResolved && this.vhost != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.wowza.wms.context.VHost", this.vhost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", this.vhost.getHomePath());
            this.crossdomainPath = SystemUtils.expandEnvironmentVariables((String)this.crossdomainPath, hashMap);
            this.crossdomainResolved = true;
        }
        return new File(this.crossdomainPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCrossdomain(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        block23: {
            try {
                Object object;
                Closeable closeable;
                File file;
                if ((this.crossdomainStr == null || l - this.lastCrossdomainRead > 5000L) && (file = this.getCrossdomainFile()).exists()) {
                    closeable = null;
                    try {
                        object = new StringBuffer();
                        closeable = new BufferedReader(new FileReader(file));
                        String string = null;
                        while ((string = ((BufferedReader)closeable).readLine()) != null) {
                            ((StringBuffer)object).append(string + "\n");
                        }
                        this.crossdomainStr = ((StringBuffer)object).toString();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (closeable != null) {
                            try {
                                ((BufferedReader)closeable).close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    this.lastCrossdomainRead = l;
                }
                boolean bl = true;
                if (this.crossdomainStr == null) {
                    bl = false;
                } else if (this.crossdomainStr.length() == 0) {
                    bl = false;
                }
                try {
                    if (bl) {
                        iHTTPResponse.setHeader("Content-Type", "text/xml");
                        closeable = iHTTPResponse.getOutputStream();
                        object = this.crossdomainStr.getBytes();
                        ((OutputStream)closeable).write((byte[])object);
                        break block23;
                    }
                    iHTTPResponse.setResponseCode(404);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).error("HTTPStreamerAdapterSanJoseStreamer.onCrossdomain: " + exception.toString());
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).error("HTTPStreamerAdapterSanJoseStreamer.onCrossdomain: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlaylist(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse, boolean bl) {
        String string;
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl2;
        boolean bl3;
        block85: {
            bl3 = false;
            bl2 = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            String string2 = null;
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts;
                Object object5;
                SanJoseStreamingURL sanJoseStreamingURL;
                string = iHTTPRequest.getHeader("context");
                if (string == null) break block85;
                if ((string = HTTPStreamerUtils.urlDecode((String)string)).endsWith(".abst/")) {
                    string = string.substring(0, string.length() - 1);
                }
                if ((sanJoseStreamingURL = new SanJoseStreamingURL(string, 1)) == null) break block85;
                String string3 = sanJoseStreamingURL.getAppName();
                String string4 = sanJoseStreamingURL.getAppInstanceName();
                String string5 = sanJoseStreamingURL.getStreamName();
                String string6 = iHTTPRequest.getHeader("host");
                String string7 = sanJoseStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string7);
                String string8 = HTTPUtils.assembleQueryStr((Map)map);
                String string9 = null;
                String string10 = this.determineDvrId(map);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string3, string4, this.getAdapterName(), true);
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("HTTPStreamerAdapterSanJoseStreaming.onPlaylist: Application context not loaded [" + string + "]: " + string3 + "/" + string4);
                    break block85;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string11 = this.getStreamDomainStr(iApplicationInstance, string5);
                String string12 = null;
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                boolean bl4 = this.isDvr(iApplicationInstance, string10);
                boolean bl5 = this.isLive(iApplicationInstance);
                boolean bl6 = this.isRepeater(iApplicationInstance);
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (!bl && (object5 = SanJoseFragmentId.parseURL(string, false)) != null) {
                    string2 = ((SanJoseFragmentId)object5).getSessionId();
                    if (((SanJoseFragmentId)object5).getBitrate() > 0) {
                        string12 = ((SanJoseFragmentId)object5).getBitrate() + "";
                    }
                    if (string2 != null) {
                        iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string2);
                    }
                }
                object5 = null;
                if (bl6 && bl5) {
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    hTTPStreamerStreamNameParts = this.resolveStreamName(null, iApplicationInstance, bl6, string5);
                    if (hTTPStreamerStreamNameParts.resolvedName == null) break block85;
                    if (hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                        object5 = iHTTPStreamerSession != null ? ((HTTPStreamerSessionSanJose)iHTTPStreamerSession).getIndexLive(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string5, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName) : HTTPStreamerSessionSanJose.createIndexLive(iHTTPStreamerApplicationContext, null, string5, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                        if (object5 == null) break block85;
                        object4 = object5.getStreamNames();
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            String string13;
                            object2 = (String)object3.next();
                            if (bl6) {
                                string13 = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, null, (String)object2);
                                this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, string13);
                            }
                            if ((string13 = mediaStreamMap.getLiveStreamPacketizer((String)object2, this.liveStreamPacketizer, false)) == null) {
                                bl2 = true;
                                continue;
                            }
                            if (((LiveStreamPacketizerSanJose)((Object)string13)).isPlaylistReady()) continue;
                            bl2 = true;
                        }
                        if (bl2) {
                            break block85;
                        }
                    } else {
                        if (bl6) {
                            this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                        }
                        if ((object4 = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                            bl2 = true;
                            break block85;
                        }
                        object3 = (LiveStreamPacketizerSanJose)object4;
                        if (!((LiveStreamPacketizerSanJose)object3).isPlaylistReady()) {
                            bl2 = true;
                            break block85;
                        }
                    }
                }
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).info("HTTPStreamerAdapterSanJoseStreaming.onPlaylist: sessionId: " + string2);
                }
                boolean bl7 = false;
                if (iHTTPStreamerSession == null) {
                    bl7 = true;
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, string2, string11);
                }
                hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl6, string5);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block85;
                if (iHTTPStreamerSession == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("HTTPStreamerAdapterSanJoseStreaming.onPlaylist: Should not get here [" + string + "]: " + string3 + "/" + string4);
                    break block85;
                }
                if (bl7) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                map.put("wowzasessionid", iHTTPStreamerSession.getSessionId());
                rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        iHTTPStreamerSession.setLiveStreamingPacketizer(this.liveStreamPacketizer);
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string7, "sanjose", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                        iHTTPStreamerSession.setSessionType(bl5 ? 1 : 2);
                    }
                    iHTTPStreamerSession.touch(l);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("HTTPStreamerAdapterSanJoseStreaming.onPlaylist: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl3 = true;
                    break block85;
                }
                if (bl7) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl3 = true;
                    break block85;
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string11)) {
                    iHTTPResponse.setResponseCode(403);
                    bl3 = true;
                    break block85;
                }
                object4 = iHTTPStreamerSession.getUserQueryStr();
                if (object4 != null) {
                    if (string8.length() > 0) {
                        string8 = string8 + "&";
                    }
                    string8 = string8 + (String)object4;
                }
                object3 = null;
                object2 = null;
                int n = -1;
                long[] lArray = null;
                boolean bl8 = false;
                if (bl4) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).info("We're in DVR!");
                    object = iApplicationInstance.getStreams();
                    long l2 = 0L;
                    if (map.containsKey("delta") && map.containsKey("time")) {
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).warn("HTTPStreamerAdapterSanJoseStreamer.onPlaylist()  Either 'delta' or 'time' param should be specified.");
                    }
                    if (map.containsKey("delta")) {
                        long l3 = this.parseLongQueryParam(map, "delta");
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).info("delta=" + l3);
                        l2 += l3;
                    } else if (map.containsKey("time")) {
                        l2 = this.parseLongQueryParam(map, "time");
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).info("t=" + l2);
                    } else {
                        l2 = 0L;
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).info("t= 0");
                    }
                    if (!this.dvrPlayerAdapter.isPlaylistReady(string, iApplicationInstance, string10, string5, l2)) {
                        bl2 = true;
                        break block85;
                    }
                    boolean bl9 = this.dvrPlayerAdapter.isPlaylistEmpty(string, iApplicationInstance, string10, string5, l2);
                    if (bl9) {
                        bl2 = true;
                        break block85;
                    }
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).info("DVR isF4M:" + bl);
                    object3 = this.dvrPlayerAdapter.getAbsolutePlaylist(string, iApplicationInstance, string10, string5, l2);
                } else if (bl5) {
                    Object object6;
                    object = iApplicationInstance.getStreams();
                    if (hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                        object5 = ((HTTPStreamerSessionSanJose)iHTTPStreamerSession).getIndexLive(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string5, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                        if (object5 == null) break block85;
                        if (iHTTPStreamerSession != null) {
                            object6 = object5.getStreamNames();
                            iHTTPStreamerSession.addStreamDomainStrs((List)object6);
                            if (bl6) {
                                iHTTPStreamerSession.lockRepeaterStreams((List)object6, this.liveStreamPacketizer, this.liveStreamRepeater, iHTTPStreamerApplicationContext.getStreamTypeStr());
                            }
                        }
                        if (bl) {
                            object6 = new HashMap();
                            List<String> list = object5.getStreamNames();
                            Iterator<String> iterator = list.iterator();
                            boolean bl10 = true;
                            while (iterator.hasNext()) {
                                String string14 = iterator.next();
                                ILiveStreamPacketizer iLiveStreamPacketizer = object.getLiveStreamPacketizer(string14, this.liveStreamPacketizer, false);
                                if (iLiveStreamPacketizer == null) {
                                    bl10 = false;
                                    if (bl6) {
                                        bl2 = true;
                                        continue;
                                    }
                                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("HTTPStreamerAdapterSanJoseStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                                    continue;
                                }
                                LiveStreamPacketizerSanJose liveStreamPacketizerSanJose = (LiveStreamPacketizerSanJose)iLiveStreamPacketizer;
                                if (!liveStreamPacketizerSanJose.isPlaylistReady()) {
                                    bl10 = false;
                                    bl2 = true;
                                    continue;
                                }
                                object6.put(string14, liveStreamPacketizerSanJose);
                            }
                            if (!bl10) break block85;
                            object3 = LiveStreamPacketizerSanJose.getMultibitratePlaylistF4M(hTTPStreamerStreamNameParts.resolvedName, (IHTTPStreamerSanJoseIndex)object5, (Map<String, LiveStreamPacketizerSanJose>)object6);
                        } else {
                            object6 = object5.bitrateStrToStreamName(string12);
                            if (object6 != null) {
                                string9 = object6;
                                ILiveStreamPacketizer iLiveStreamPacketizer = object.getLiveStreamPacketizer((String)object6, this.liveStreamPacketizer, false);
                                if (iLiveStreamPacketizer == null) {
                                    if (bl6) {
                                        bl2 = true;
                                    } else {
                                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("HTTPStreamerAdapterSanJoseStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                                    }
                                    break block85;
                                }
                                LiveStreamPacketizerSanJose liveStreamPacketizerSanJose = (LiveStreamPacketizerSanJose)iLiveStreamPacketizer;
                                Object object7 = liveStreamPacketizerSanJose.getLock();
                                boolean bl11 = ((HTTPStreamerSessionSanJose)iHTTPStreamerSession).isFirstABSTRequest(string9);
                                Object object8 = object7;
                                synchronized (object8) {
                                    object2 = bl11 ? liveStreamPacketizerSanJose.getABSTStartData() : liveStreamPacketizerSanJose.getABSTFullData();
                                    if (((HTTPStreamerApplicationContextSanJoseStreamer)iHTTPStreamerApplicationContext).isSanjoseDebugFragmentRequestErrors()) {
                                        lArray = liveStreamPacketizerSanJose.getChunkRange();
                                        n = liveStreamPacketizerSanJose.getABSTBoostrapVersion();
                                    }
                                }
                            }
                        }
                    } else {
                        string9 = hTTPStreamerStreamNameParts.resolvedName;
                        object6 = object.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                        if (object6 == null) {
                            if (bl6) {
                                bl2 = true;
                            } else {
                                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("HTTPStreamerAdapterSanJoseStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                            }
                            break block85;
                        }
                        LiveStreamPacketizerSanJose liveStreamPacketizerSanJose = (LiveStreamPacketizerSanJose)object6;
                        if (!liveStreamPacketizerSanJose.isPlaylistReady()) {
                            bl2 = true;
                            break block85;
                        }
                        if (bl) {
                            object3 = liveStreamPacketizerSanJose.getPlaylistStr();
                        } else {
                            Object object9 = liveStreamPacketizerSanJose.getLock();
                            boolean bl12 = ((HTTPStreamerSessionSanJose)iHTTPStreamerSession).isFirstABSTRequest(string9);
                            Object object10 = object9;
                            synchronized (object10) {
                                object2 = bl12 ? liveStreamPacketizerSanJose.getABSTStartData() : liveStreamPacketizerSanJose.getABSTFullData();
                                if (((HTTPStreamerApplicationContextSanJoseStreamer)iHTTPStreamerApplicationContext).isSanjoseDebugFragmentRequestErrors()) {
                                    lArray = liveStreamPacketizerSanJose.getChunkRange();
                                    n = liveStreamPacketizerSanJose.getABSTBoostrapVersion();
                                }
                            }
                        }
                    }
                } else {
                    object5 = ((HTTPStreamerSessionSanJose)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string5, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object5 == null) break block85;
                    if (bl) {
                        object3 = object5.getPlaylistStr();
                    } else {
                        object2 = object5.getABSTData(string12);
                    }
                }
                bl8 = true;
                if (object3 != null && bl8) {
                    object = string8.replace("&", "&amp;");
                    object3 = ((String)object3).replace("{query}", ((String)object).length() > 0 ? "?" + (String)object : "");
                    object3 = ((String)object3).replace("{session-id}", iHTTPStreamerSession.getSessionId());
                }
                object = "";
                if (object3 != null) {
                    object2 = ((String)object3).getBytes();
                    object = "text/xml";
                } else {
                    object = "binary/octet";
                }
                if (object2 == null) {
                    if (bl6) {
                        bl2 = true;
                    }
                } else {
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).info((String)object + ":\n" + DebugUtils.formatBytes((byte[])object2));
                    }
                    iHTTPResponse.setHeader("Content-Type", (String)object);
                    iHTTPResponse.setHeader("Cache-Control", "no-cache");
                    iHTTPResponse.setHeader("Date", this.getHTTPDate());
                    if (n >= 0) {
                        iHTTPResponse.setHeader("X-Wowza-Boostrap-Version", n + "");
                    }
                    if (lArray != null) {
                        iHTTPResponse.setHeader("X-Wowza-Chunk-Range", lArray[0] + "-" + lArray[1]);
                    }
                    OutputStream outputStream = iHTTPResponse.getOutputStream();
                    outputStream.write((byte[])object2);
                    bl3 = true;
                    if (!bl && string9 != null) {
                        ((HTTPStreamerSessionSanJose)iHTTPStreamerSession).addFirstABSTRequest(string9);
                    }
                    if (object2 != null && iHTTPStreamerSession != null) {
                        iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(((Object)object2).length + iHTTPResponse.getHeaderSize()), 1L);
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).error("HTTPStreamerAdapterSanJoseStreaming.onPlaylist: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl3) {
            if (bl2) {
                string = ((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest();
                rtmpSessionInfo.setPendingRequest((RtmpRequestMessage)string);
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMediaFile(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block39: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            int n = 0;
            try {
                Object object;
                IHTTPStreamerSanJoseIndex iHTTPStreamerSanJoseIndex;
                Object object2;
                SanJoseStreamingURL sanJoseStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block39;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).info("onMediaFile: " + string);
                }
                if ((sanJoseStreamingURL = new SanJoseStreamingURL(string, 2)) == null) break block39;
                String string2 = sanJoseStreamingURL.getAppName();
                String string3 = sanJoseStreamingURL.getAppInstanceName();
                String string4 = sanJoseStreamingURL.getStreamName();
                String string5 = sanJoseStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName());
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("HTTPStreamerAdapterSanJoseStreaming.onMediaFile: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block39;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string6 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl3 = this.isLive(iApplicationInstance);
                boolean bl4 = this.isRepeater(iApplicationInstance);
                String string7 = this.parseUrlForDvr(string);
                boolean bl5 = this.isDvr(iApplicationInstance, string7);
                SanJoseFragmentId sanJoseFragmentId = SanJoseFragmentId.parseURL(string, true);
                String string8 = sanJoseFragmentId.getSessionId();
                String string9 = "0";
                if (sanJoseFragmentId.getBitrate() > 0) {
                    string9 = sanJoseFragmentId.getBitrate() + "";
                }
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (string8 != null) {
                    iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string8);
                }
                boolean bl6 = false;
                if (iHTTPStreamerSession == null) {
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, string8, string6);
                    bl6 = true;
                }
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl4, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block39;
                if (bl6) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                boolean bl7 = true;
                int n2 = 0;
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "sanjose", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                    }
                    iHTTPStreamerSession.touch(l);
                    bl7 = iHTTPStreamerSession.isActive();
                    n2 = iHTTPStreamerSession.getSessionType();
                    rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("HTTPStreamerAdapterSanJoseStreaming.onMediaFile: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block39;
                }
                if (bl6) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string6)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block39;
                }
                if (!bl7) break block39;
                if (iHTTPStreamerSession != null && !iHTTPStreamerSession.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block39;
                }
                int n3 = string.lastIndexOf("/");
                if (n3 < 0) break block39;
                String string10 = string.substring(n3 + 1);
                int n4 = string10.indexOf("?");
                if (n4 >= 0) {
                    string10 = string10.substring(0, n4);
                }
                if (n2 == 0) {
                    n2 = bl3 ? 1 : 2;
                }
                LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk = null;
                long[] lArray = null;
                if (bl5) {
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    liveStreamPacketizerSanJoseChunk = this.getDvrSanJoseFragments(mediaStreamMap, string7, string4, sanJoseFragmentId.getFragmentId());
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("Cool.  Chunk from DVR!  chunk=" + liveStreamPacketizerSanJoseChunk);
                } else if (n2 == 2) {
                    IHTTPStreamerSanJoseIndex iHTTPStreamerSanJoseIndex2;
                    IHTTPStreamerSanJoseIndex iHTTPStreamerSanJoseIndex3 = iHTTPStreamerSanJoseIndex2 = iHTTPStreamerSession == null ? null : ((HTTPStreamerSessionSanJose)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (iHTTPStreamerSanJoseIndex2 == null) break block39;
                    liveStreamPacketizerSanJoseChunk = iHTTPStreamerSanJoseIndex2.getChunk(sanJoseFragmentId.getBitrate(), sanJoseFragmentId.getFragmentId());
                    ((HTTPStreamerSessionSanJose)iHTTPStreamerSession).logVODChunk(liveStreamPacketizerSanJoseChunk);
                } else {
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    object2 = null;
                    if (hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                        iHTTPStreamerSanJoseIndex = ((HTTPStreamerSessionSanJose)iHTTPStreamerSession).getIndexLive(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                        object = iHTTPStreamerSanJoseIndex.bitrateStrToStreamName(string9);
                        if (object != null && (object2 = mediaStreamMap.getLiveStreamPacketizer((String)object, this.liveStreamPacketizer, false)) == null) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("HTTPStreamerAdapterSanJoseStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                            break block39;
                        }
                    } else {
                        object2 = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                        if (object2 == null) {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).warn("HTTPStreamerAdapterSanJoseStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                            break block39;
                        }
                    }
                    if (object2 != null) {
                        if (((HTTPStreamerApplicationContextSanJoseStreamer)iHTTPStreamerApplicationContext).isSanjoseDebugFragmentRequestErrors()) {
                            lArray = ((LiveStreamPacketizerSanJose)object2).getChunkRange();
                        }
                        if ((liveStreamPacketizerSanJoseChunk = ((LiveStreamPacketizerSanJose)object2).getChunkByIndex(sanJoseFragmentId.getFragmentId())) != null) {
                            ((HTTPStreamerSessionSanJose)iHTTPStreamerSession).logLiveChunk(liveStreamPacketizerSanJoseChunk);
                        } else if (((HTTPStreamerApplicationContextSanJoseStreamer)iHTTPStreamerApplicationContext).isSanjoseDebugFragmentRequestErrors() && lArray != null) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).info("HTTPStreamerAdapterSanJoseStreaming.onMediaFile[" + iApplicationInstance.getContextStr() + ":" + string4 + "] Missing chunk: req:" + sanJoseFragmentId.getFragmentId() + " range:" + lArray[0] + "-" + lArray[1]);
                        }
                    }
                }
                if (liveStreamPacketizerSanJoseChunk != null) {
                    LiveStreamingSanJoseBlock liveStreamingSanJoseBlock;
                    if (!iHTTPStreamerSession.checkAndSetPlayLogged()) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iHTTPStreamerSession.getStream(), "stream", "play", 200, iHTTPStreamerSession.getStreamName());
                    }
                    String string11 = "video/mp4";
                    iHTTPResponse.setHeader("Content-Type", string11);
                    iHTTPResponse.setHeader("Cache-Control", liveStreamPacketizerSanJoseChunk.isCacheable() ? "public" : "no-cache");
                    iHTTPResponse.setHeader("Date", this.getHTTPDate());
                    if (lArray != null) {
                        iHTTPResponse.setHeader("X-Wowza-Chunk-Range", lArray[0] + "-" + lArray[1]);
                    }
                    object2 = iHTTPResponse.getOutputStream();
                    iHTTPStreamerSanJoseIndex = null;
                    if (object2 instanceof IFasterByteArrayWriteReference) {
                        iHTTPStreamerSanJoseIndex = (IFasterByteArrayWriteReference)object2;
                    }
                    object = liveStreamPacketizerSanJoseChunk.getBlockList();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        liveStreamingSanJoseBlock = (LiveStreamingSanJoseBlock)iterator.next();
                        if (iHTTPStreamerSanJoseIndex != null) {
                            iHTTPStreamerSanJoseIndex.write(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen(), true);
                        } else {
                            ((OutputStream)object2).write(liveStreamingSanJoseBlock.getBuffer(), liveStreamingSanJoseBlock.getOffset(), liveStreamingSanJoseBlock.getLen());
                        }
                        n += liveStreamingSanJoseBlock.getLen();
                    }
                    if (iHTTPStreamerSession != null) {
                        liveStreamingSanJoseBlock = iHTTPStreamerSession.getStream();
                        if (liveStreamingSanJoseBlock != null) {
                            liveStreamingSanJoseBlock.getMediaIOPerformance().incrementMessagesOut((long)n, 1L);
                        }
                        iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(n + iHTTPResponse.getHeaderSize()), 1L);
                    }
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class).error("HTTPStreamerAdapterSanJoseStreaming.onMediaFile: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (bl2) return;
        if (bl) {
            rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            return;
        }
        iHTTPResponse.setResponseCode(404);
    }

    private LiveStreamPacketizerSanJoseChunk getDvrSanJoseFragments(MediaStreamMap mediaStreamMap, String string, String string2, long l) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(HTTPStreamerAdapterSanJoseStreamer.class);
        wMSLogger.info(String.format("%s.getDvrSanJoseFragments: get DVR for A/V %s.", CLASSNAME, l));
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string, false);
        wMSLogger.info(String.format("%s.getDvrSanJoseFragments: dvr=%s", CLASSNAME, iDvrStore));
        DvrChunk dvrChunk = null;
        DvrManifestEntry dvrManifestEntry = null;
        DvrChunk dvrChunk2 = null;
        DvrManifestEntry dvrManifestEntry2 = null;
        if (iDvrStore != null) {
            dvrManifestEntry = iDvrStore.getDvrEntryByIndex(string2, 9, (int)l);
            dvrChunk = iDvrStore.getDvrChunkByIndex(string2, 9, (int)l);
            dvrManifestEntry2 = iDvrStore.getDvrEntryByIndex(string2, 8, (int)l);
            dvrChunk2 = iDvrStore.getDvrChunkByIndex(string2, 8, (int)l);
        }
        wMSLogger.info("HTTPStreamerAdapterSanJoseStreamer.getDvrSanJoseFragments: chunk=" + dvrChunk);
        return (LiveStreamPacketizerSanJoseChunk)this.dvrPlayerAdapter.convertDvrChunks(dvrManifestEntry, dvrChunk, dvrManifestEntry2, dvrChunk2);
    }

    private String parseUrlForDvr(String string) {
        String string2;
        block0: {
            String string3;
            String[] stringArray;
            String[] stringArray2;
            string2 = null;
            int n = string.lastIndexOf("/");
            if (n < 0 || (stringArray2 = (string = string.substring(0, n)).split("[/]")).length < 1 || (stringArray = (string3 = stringArray2[stringArray2.length - 1]).split("[_]")).length < 1 || !stringArray[0].startsWith("DVR")) break block0;
            string2 = stringArray[0].substring(3);
        }
        return string2;
    }
}

