/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.sanjosestreaming.file.IHTTPStreamerSanJoseIndex;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.ISanJoseChunkWriter;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJoseChunk;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamingSanJoseBlock;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJoseEncryptor;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJosePacketHandler;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJosePacketHolder;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJoseRepeaterHolder;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJoseTSHolder;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.LiveStreamPacketizerSanJoseUtils;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseEncInfo;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseRandomAccessBuffer;
import com.wowza.wms.httpstreamer.sanjosestreaming.util.SanJoseUtilities;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.LiveStreamPacketizerSmoothStreaming;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerBase;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerItem;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamPacketizerSanJose
extends LiveStreamPacketizerBase
implements ISanJoseChunkWriter {
    public static final int STREAMMODE_TS = 1;
    public static final int STREAMMODE_MP3 = 2;
    public static final int STREAMMODE_AAC = 3;
    private int maxChunkCount = 10;
    private int minChunkCount = 1;
    private int maxChunkLogCount = 10;
    private int playlistChunkCount = 4;
    private int repeaterChunkCount = 4;
    private int chunkDurationTarget = 10000;
    private int chunkDurationTolerance = 500;
    private int waitForCodecTime = 8000;
    private boolean forceH264BaselineProfile = false;
    private boolean debugAACTimecodes = false;
    private int maxSaveHolderSize = 500;
    private int maxChunkKeyCount = 50;
    private String sanjoseEncryptionBaseURL = null;
    private String sanjoseEncryptionLiveRepeaterSharedSecret = null;
    private boolean relativePlaylistItems = true;
    private boolean sanjoseDebugPacketizationOverhead = false;
    private String titleStr = null;
    private boolean allowCaching = false;
    private Object lock = new Object();
    private SortedMap<Integer, LiveStreamPacketizerSanJoseChunk> chunks = new TreeMap<Integer, LiveStreamPacketizerSanJoseChunk>();
    private int nextChunkId = 0;
    private String playListStr = "";
    private String playListFragmentStr = "";
    private ABSTData playListFullABST = new ABSTData();
    private ABSTData playListStartABST = new ABSTData();
    private int playListBoostrapVersion = -1;
    private SanJoseEncInfo encInfo = null;
    private boolean encInfoRepeaterSet = false;
    private SanJosePacketHandler packetHandler = new SanJosePacketHandler();
    private long repeaterSeq = 0L;
    private List<SanJoseRepeaterHolder> repeaterItems = new ArrayList<SanJoseRepeaterHolder>();
    private int streamMode = -1;
    private int videoCodec = -1;
    private int audioCodec = -1;
    private LiveStreamPacketizerSanJoseChunk pendingChunk = null;
    private SanJoseTSHolder pendingTS = null;
    private SanJoseEncryptor encryptor = null;
    private List<SanJoseTSHolder> audioTSs = new ArrayList<SanJoseTSHolder>();
    private List<SanJoseTSHolder> videoTSs = new ArrayList<SanJoseTSHolder>();
    private String streamName = null;
    private int bootstrapVersion = 0;

    public LiveStreamPacketizerSanJose() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
    }

    public void init(String string, String string2, IApplicationInstance iApplicationInstance, LiveStreamPacketizerItem liveStreamPacketizerItem) {
        Object object;
        super.init(string, string2, iApplicationInstance, liveStreamPacketizerItem);
        WMSProperties wMSProperties = this.getProperties();
        WMSProperties wMSProperties2 = iApplicationInstance.getProperties();
        this.streamName = string;
        this.titleStr = wMSProperties.getPropertyStr("sanjoseTitleStr", this.titleStr);
        if (this.titleStr == null) {
            this.titleStr = string;
        }
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean("relativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties.getPropertyBoolean("sanjoseRelativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean("relativePlaylistItems", this.relativePlaylistItems);
        this.relativePlaylistItems = wMSProperties2.getPropertyBoolean("sanjoseRelativePlaylistItems", this.relativePlaylistItems);
        this.maxChunkCount = wMSProperties.getPropertyInt("maxChunkCount", this.maxChunkCount);
        this.maxChunkCount = wMSProperties.getPropertyInt("sanjoseMaxChunkCount", this.maxChunkCount);
        this.minChunkCount = wMSProperties.getPropertyInt("minChunkCount", this.minChunkCount);
        this.minChunkCount = wMSProperties.getPropertyInt("sanjoseMinChunkCount", this.minChunkCount);
        this.maxChunkLogCount = wMSProperties.getPropertyInt("maxChunkLogCount", this.maxChunkLogCount);
        this.maxChunkLogCount = wMSProperties.getPropertyInt("sanjoseMaxChunkLogCount", this.maxChunkLogCount);
        this.playlistChunkCount = wMSProperties.getPropertyInt("playlistChunkCount", this.playlistChunkCount);
        this.playlistChunkCount = wMSProperties.getPropertyInt("sanjosePlaylistChunkCount", this.playlistChunkCount);
        this.repeaterChunkCount = wMSProperties.getPropertyInt("repeaterChunkCount", this.repeaterChunkCount);
        this.repeaterChunkCount = wMSProperties.getPropertyInt("sanjoseRepeaterChunkCount", this.repeaterChunkCount);
        this.chunkDurationTarget = wMSProperties.getPropertyInt("chunkDurationTarget", this.chunkDurationTarget);
        this.chunkDurationTarget = wMSProperties.getPropertyInt("sanjoseChunkDurationTarget", this.chunkDurationTarget);
        this.chunkDurationTolerance = wMSProperties.getPropertyInt("chunkDurationTolerance", this.chunkDurationTolerance);
        this.chunkDurationTolerance = wMSProperties.getPropertyInt("sanjoseChunkDurationTolerance", this.chunkDurationTolerance);
        this.waitForCodecTime = wMSProperties.getPropertyInt("waitForCodecTime", this.waitForCodecTime);
        this.waitForCodecTime = wMSProperties.getPropertyInt("sanjoseWaitForCodecTime", this.waitForCodecTime);
        this.maxSaveHolderSize = wMSProperties.getPropertyInt("maxSaveHolderSize", this.maxSaveHolderSize);
        this.maxSaveHolderSize = wMSProperties.getPropertyInt("sanjoseMaxSaveHolderSize", this.maxSaveHolderSize);
        this.maxChunkKeyCount = wMSProperties.getPropertyInt("maxChunkKeyCount", this.maxChunkKeyCount);
        this.maxChunkKeyCount = wMSProperties.getPropertyInt("sanjoseMaxChunkKeyCount", this.maxChunkKeyCount);
        this.forceH264BaselineProfile = wMSProperties.getPropertyBoolean("forceH264BaselineProfile", this.forceH264BaselineProfile);
        this.forceH264BaselineProfile = wMSProperties.getPropertyBoolean("sanjoseForceH264BaselineProfile", this.forceH264BaselineProfile);
        this.debugAACTimecodes = wMSProperties.getPropertyBoolean("debugAACTimecodes", this.debugAACTimecodes);
        this.debugAACTimecodes = wMSProperties.getPropertyBoolean("sanjoseDebugAACTimecodes", this.debugAACTimecodes);
        this.sanjoseDebugPacketizationOverhead = wMSProperties.getPropertyBoolean("sanjoseDebugPacketizationOverhead", this.sanjoseDebugPacketizationOverhead);
        this.allowCaching = wMSProperties.getPropertyBoolean("allowCaching", this.allowCaching);
        this.allowCaching = wMSProperties.getPropertyBoolean("sanjoseAllowCaching", this.allowCaching);
        this.sanjoseEncryptionBaseURL = wMSProperties.getPropertyStr("sanjoseEncryptionBaseURL", this.sanjoseEncryptionBaseURL);
        this.sanjoseEncryptionBaseURL = wMSProperties2.getPropertyStr("sanjoseEncryptionBaseURL", this.sanjoseEncryptionBaseURL);
        this.sanjoseEncryptionLiveRepeaterSharedSecret = wMSProperties.getPropertyStr("sanjoseEncryptionLiveRepeaterSharedSecret", this.sanjoseEncryptionLiveRepeaterSharedSecret);
        this.sanjoseEncryptionLiveRepeaterSharedSecret = wMSProperties2.getPropertyStr("sanjoseEncryptionLiveRepeaterSharedSecret", this.sanjoseEncryptionLiveRepeaterSharedSecret);
        this.initPacketHandler();
        String string3 = this.getContextStr();
        WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info("LiveStreamPacketizerSanJose.init[" + string3 + "]: chunkDurationTarget: " + this.chunkDurationTarget);
        WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info("LiveStreamPacketizerSanJose.init[" + string3 + "]: chunkDurationTolerance: " + this.chunkDurationTolerance);
        WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info("LiveStreamPacketizerSanJose.init[" + string3 + "]: playlistChunkCount:" + this.playlistChunkCount);
        if (this.forceH264BaselineProfile) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info("LiveStreamPacketizerSanJose.init[" + string3 + "]: Forcing H.264 profile to Baseline");
        }
        if (this.sanjoseEncryptionBaseURL != null) {
            object = iApplicationInstance.getVHost().getHTTPStreamerContext();
            byte[] byArray = object.getEncKey(iApplicationInstance, string);
            if (byArray != null) {
                iApplicationInstance.getModFunctions().onHTTPSanJoseEncryptionKeyCreateLive(iApplicationInstance, string, byArray);
                String string4 = this.sanjoseEncryptionBaseURL;
                if (!string4.endsWith("/")) {
                    string4 = string4 + "/";
                }
                string4 = string4 + iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName() + "/" + string + "/key.m3u8key";
                this.encInfo = new SanJoseEncInfo(BufferUtils.encodeHexString((byte[])byArray), byArray, string4);
                this.encInfo.setInternal(true);
            }
        } else {
            this.encInfo = LiveStreamPacketizerSanJoseUtils.getEncInfo(iApplicationInstance, string);
        }
        if (this.encInfo != null) {
            object = null;
            if (this.sanjoseEncryptionLiveRepeaterSharedSecret != null) {
                object = SanJoseEncInfo.encryptionKeyToRepeaterKey(this.encInfo.getEncKeyBytes(), this.sanjoseEncryptionLiveRepeaterSharedSecret);
            }
            if (object != null) {
                this.encInfo.setEncRepeaterBytes((byte[])object);
            }
            if (this.encInfo.getEncKey() != null) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info("LiveStreamPacketizerSanJose.init[" + string3 + "]: Encrypt SanJose stream: key: *" + this.encInfo.getEncKey().substring(28));
            }
            if (this.encInfo.getEncUrl() != null) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info("LiveStreamPacketizerSanJose.init[" + string3 + "]: Encrypt SanJose stream: url: " + this.encInfo.getEncUrl());
            }
        }
    }

    private void initPacketHandler() {
        this.packetHandler.setWaitForCodecTime(this.waitForCodecTime);
        this.packetHandler.setChunkDurationTarget(this.chunkDurationTarget);
        this.packetHandler.setChunkDurationTolerance(this.chunkDurationTolerance);
        this.packetHandler.setChunkWriter(this);
        this.packetHandler.setDebugAACTimecodes(this.debugAACTimecodes);
        this.packetHandler.setMaxSaveHolderSize(this.maxSaveHolderSize);
        this.packetHandler.setMaxChunkKeyCount(this.maxChunkKeyCount);
    }

    public byte[] getEncryptionKeyBytes() {
        return this.encInfo == null ? null : this.encInfo.getEncKeyBytes();
    }

    public String getEncryptionURL() {
        return this.encInfo == null ? null : this.encInfo.getEncUrl();
    }

    public SanJoseEncInfo getEncryptionInfo() {
        return this.encInfo;
    }

    public void internalStartStream(IMediaStream iMediaStream) {
        this.packetHandler.startStream(iMediaStream);
    }

    public void internalResetStream(IMediaStream iMediaStream) {
        WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).info("SanJosePacketHandler.resetStream[" + iMediaStream.getContextStr() + "]");
        this.packetHandler = new SanJosePacketHandler();
        this.initPacketHandler();
        this.resetStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStream() {
        this.pendingChunk = null;
        this.pendingTS = null;
        this.audioTSs.clear();
        this.videoTSs.clear();
        if (this.encryptor != null) {
            this.encryptor.close();
        }
        this.encryptor = null;
        Object object = this.lock;
        synchronized (object) {
            this.chunks.clear();
            this.updatePlaylistStr();
        }
        object = new SanJoseRepeaterHolder(this.repeaterSeq);
        Object object2 = this.lock;
        synchronized (object2) {
            SanJoseRepeaterHolder sanJoseRepeaterHolder;
            boolean bl = true;
            int n = this.repeaterItems.size();
            if (n > 0 && (sanJoseRepeaterHolder = this.repeaterItems.get(n - 1)).getRepeaterType() == ((SanJoseRepeaterHolder)object).getRepeaterType()) {
                bl = false;
            }
            if (bl) {
                ++this.repeaterSeq;
                this.repeaterItems.add((SanJoseRepeaterHolder)object);
            }
        }
    }

    public void internalHandlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        long l = System.currentTimeMillis();
        this.touch(l);
        this.packetHandler.handlePacket(iMediaStream, aMFPacket);
    }

    @Override
    public void setMetaData(SanJosePacketHolder sanJosePacketHolder) {
        byte[] byArray = SanJoseUtilities.holderToRTMPBlock(sanJosePacketHolder);
        if (byArray != null) {
            SanJoseTSHolder sanJoseTSHolder = new SanJoseTSHolder(sanJosePacketHolder.getType(), sanJosePacketHolder.getCodec(), byArray, 0, byArray.length, sanJosePacketHolder.getTimecode());
            this.setMetaData(sanJoseTSHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaData(SanJoseTSHolder sanJoseTSHolder) {
        long l = System.currentTimeMillis();
        this.touch(l);
        if (this.pendingChunk != null) {
            this.pendingChunk.setMetaDataHolder(sanJoseTSHolder);
        }
        SanJoseRepeaterHolder sanJoseRepeaterHolder = new SanJoseRepeaterHolder(this.repeaterSeq, 0, sanJoseTSHolder);
        sanJoseRepeaterHolder.setRepeaterType(7);
        ++this.repeaterSeq;
        Object object = this.lock;
        synchronized (object) {
            this.repeaterItems.add(sanJoseRepeaterHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCodecInfoAudio(MediaCodecInfoAudio mediaCodecInfoAudio) {
        long l = System.currentTimeMillis();
        this.touch(l);
        if (this.pendingChunk != null) {
            this.pendingChunk.setCodecInfoAudio(mediaCodecInfoAudio);
        }
        SanJoseRepeaterHolder sanJoseRepeaterHolder = new SanJoseRepeaterHolder(this.repeaterSeq);
        sanJoseRepeaterHolder.setRepeaterType(6);
        sanJoseRepeaterHolder.setCodecInfoAudio(mediaCodecInfoAudio);
        ++this.repeaterSeq;
        Object object = this.lock;
        synchronized (object) {
            this.repeaterItems.add(sanJoseRepeaterHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCodecInfoVideo(MediaCodecInfoVideo mediaCodecInfoVideo) {
        long l = System.currentTimeMillis();
        this.touch(l);
        if (this.pendingChunk != null) {
            this.pendingChunk.setCodecInfoVideo(mediaCodecInfoVideo);
        }
        SanJoseRepeaterHolder sanJoseRepeaterHolder = new SanJoseRepeaterHolder(this.repeaterSeq);
        sanJoseRepeaterHolder.setRepeaterType(5);
        sanJoseRepeaterHolder.setCodecInfoVideo(mediaCodecInfoVideo);
        ++this.repeaterSeq;
        Object object = this.lock;
        synchronized (object) {
            this.repeaterItems.add(sanJoseRepeaterHolder);
        }
    }

    public void debugDumpRepeater() {
        System.out.println("************** debugDumpRepeater ********************");
        int n = -1;
        for (SanJoseRepeaterHolder sanJoseRepeaterHolder : this.repeaterItems) {
            if (sanJoseRepeaterHolder.getRepeaterType() == n) continue;
            n = sanJoseRepeaterHolder.getRepeaterType();
            System.out.println(SanJoseRepeaterHolder.repeaterTypeToString(n));
        }
    }

    @Override
    public void startChunk(int n, int n2, int n3, long l) {
        ++this.nextChunkId;
        this.streamMode = n;
        this.videoCodec = n2;
        this.audioCodec = n3;
        String string = "";
        byte[] byArray = null;
        if (this.encInfo != null) {
            string = this.encInfo.getEncUrl();
            byArray = this.encInfo.getEncRepeaterBytes();
        }
        this.startChunkTS(this.nextChunkId, false, n, n2, n3, l, string, byArray);
        byte[] byArray2 = new byte[8];
        System.arraycopy("mdat".getBytes(), 0, byArray2, 4, 4);
        SanJoseTSHolder sanJoseTSHolder = new SanJoseTSHolder(18, -1, byArray2, 0, byArray2.length, l);
        this.sortTS(sanJoseTSHolder, false);
    }

    @Override
    public void endChunk(long l) {
        this.sortTS(null, true);
        List<LiveStreamingSanJoseBlock> list = this.pendingChunk.getBlockList();
        if (list.size() > 0) {
            LiveStreamingSanJoseBlock liveStreamingSanJoseBlock = this.pendingChunk.getBlockList().get(0);
            long l2 = this.pendingChunk.getSize();
            BufferUtils.longToByteArray((long)l2, (byte[])liveStreamingSanJoseBlock.getBuffer(), (int)liveStreamingSanJoseBlock.getOffset(), (int)4);
        }
        this.endChunkTS(l);
        if (this.encryptor != null) {
            this.encryptor.close();
        }
        this.encryptor = null;
    }

    public void sortTS(SanJoseTSHolder sanJoseTSHolder, boolean bl) {
        if (this.videoCodec != -1 && this.audioCodec != -1) {
            if (sanJoseTSHolder != null) {
                switch (sanJoseTSHolder.getType()) {
                    case 8: {
                        this.audioTSs.add(sanJoseTSHolder);
                        break;
                    }
                    case 9: {
                        this.videoTSs.add(sanJoseTSHolder);
                        break;
                    }
                    default: {
                        this.encryptTS(sanJoseTSHolder);
                    }
                }
            }
            boolean bl2 = true;
            if (bl) {
                if (this.audioTSs.size() <= 0 && this.videoTSs.size() <= 0) {
                    bl2 = false;
                }
            } else if (this.audioTSs.size() <= 0 || this.videoTSs.size() <= 0) {
                bl2 = false;
            }
            while (bl2) {
                long l;
                long l2 = this.audioTSs.size() > 0 ? this.audioTSs.get(0).getTimecode() : Long.MAX_VALUE;
                long l3 = l = this.videoTSs.size() > 0 ? this.videoTSs.get(0).getTimecode() : Long.MAX_VALUE;
                if (l < l2) {
                    sanJoseTSHolder = this.videoTSs.remove(0);
                    this.encryptTS(sanJoseTSHolder);
                } else {
                    sanJoseTSHolder = this.audioTSs.remove(0);
                    this.encryptTS(sanJoseTSHolder);
                }
                if (!(bl ? this.audioTSs.size() <= 0 && this.videoTSs.size() <= 0 : this.audioTSs.size() <= 0 || this.videoTSs.size() <= 0)) continue;
                break;
            }
        } else if (sanJoseTSHolder != null) {
            this.encryptTS(sanJoseTSHolder);
        }
        if (bl) {
            this.encryptTS(null);
        }
    }

    public void encryptTS(SanJoseTSHolder sanJoseTSHolder) {
        if (this.pendingTS != null) {
            int n;
            int n2;
            byte[] byArray;
            byte[] byArray2;
            if (this.encryptor != null && (byArray2 = this.encryptor.encryptChunk(byArray = this.pendingTS.getBlock(), n2 = this.pendingTS.getOffset(), n = this.pendingTS.getLen(), sanJoseTSHolder == null)) != null) {
                this.pendingTS.setBlock(byArray2);
                this.pendingTS.setOffset(0);
                this.pendingTS.setLen(byArray2.length);
            }
            this.addToChunkTS(this.pendingTS);
            this.pendingTS = null;
        }
        this.pendingTS = sanJoseTSHolder;
    }

    @Override
    public void addToChunk(SanJosePacketHolder sanJosePacketHolder) {
        SanJoseTSHolder sanJoseTSHolder = null;
        if (sanJosePacketHolder.getType() == 8) {
            byte[] byArray;
            if (!sanJosePacketHolder.isCodecConfig() && (byArray = SanJoseUtilities.holderToRTMPBlock(sanJosePacketHolder)) != null) {
                sanJoseTSHolder = new SanJoseTSHolder(sanJosePacketHolder.getType(), sanJosePacketHolder.getCodec(), byArray, 0, byArray.length, sanJosePacketHolder.getTimecode());
                sanJoseTSHolder.setDataLen(sanJosePacketHolder.getDataLen());
                this.sortTS(sanJoseTSHolder, false);
            }
        } else if (sanJosePacketHolder.getType() == 9) {
            byte[] byArray;
            if (!sanJosePacketHolder.isCodecConfig() && (byArray = SanJoseUtilities.holderToRTMPBlock(sanJosePacketHolder)) != null) {
                sanJoseTSHolder = new SanJoseTSHolder(sanJosePacketHolder.getType(), sanJosePacketHolder.getCodec(), byArray, 0, byArray.length, sanJosePacketHolder.getTimecode());
                sanJoseTSHolder.setDataLen(sanJosePacketHolder.getDataLen());
                if (sanJosePacketHolder.getType() == 9) {
                    sanJoseTSHolder.setKey(sanJosePacketHolder.isKey());
                }
                this.sortTS(sanJoseTSHolder, false);
            }
        } else {
            byte[] byArray = SanJoseUtilities.holderToRTMPBlock(sanJosePacketHolder);
            if (byArray != null) {
                sanJoseTSHolder = new SanJoseTSHolder(sanJosePacketHolder.getType(), sanJosePacketHolder.getCodec(), byArray, 0, byArray.length, sanJosePacketHolder.getTimecode());
                sanJoseTSHolder.setDataLen(sanJosePacketHolder.getDataLen());
                this.sortTS(sanJoseTSHolder, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startChunkTS(int n, boolean bl, int n2, int n3, int n4, long l, String string, byte[] byArray) {
        Object object;
        long l2 = System.currentTimeMillis();
        this.touch(l2);
        if (bl && !this.encInfoRepeaterSet) {
            if (byArray != null && this.sanjoseEncryptionLiveRepeaterSharedSecret != null && this.encInfo != null && (object = SanJoseEncInfo.repeaterKeyToEncryptionKey(byArray, this.sanjoseEncryptionLiveRepeaterSharedSecret)) != null) {
                this.encInfo.setEncKeyBytes((byte[])object);
                this.encInfo.setEncKey(BufferUtils.encodeHexString((byte[])object));
                this.encInfo.setEncRepeaterBytes(byArray);
            }
            this.encInfoRepeaterSet = true;
        }
        this.pendingChunk = new LiveStreamPacketizerSanJoseChunk(n);
        this.pendingChunk.setStartTimecode(l);
        this.pendingChunk.setCacheable(this.allowCaching);
        this.pendingChunk.setEncUrl(string);
        this.pendingChunk.setEncRepeaterBytes(byArray);
        this.pendingChunk.setStreamMode(n2);
        object = new SanJoseRepeaterHolder(this.repeaterSeq, n, n2, n3, n4, string, l, byArray);
        ++this.repeaterSeq;
        Object object2 = this.lock;
        synchronized (object2) {
            this.repeaterItems.add((SanJoseRepeaterHolder)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endChunkTS(long l) {
        long l2 = System.currentTimeMillis();
        this.touch(l2);
        if (this.pendingChunk != null) {
            try {
                SanJoseRepeaterHolder sanJoseRepeaterHolder = new SanJoseRepeaterHolder(this.repeaterSeq, this.pendingChunk.getChunkIndex(), l);
                ++this.repeaterSeq;
                Object object = this.lock;
                synchronized (object) {
                    this.repeaterItems.add(sanJoseRepeaterHolder);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.endChunkTS[" + this.getContextStr() + ",1]: " + exception.toString());
            }
        }
        long l3 = 0L;
        if (this.pendingChunk != null) {
            try {
                l3 = l - this.pendingChunk.getStartTimecode();
                this.pendingChunk.setDuration(l3);
                if (this.maxChunkLogCount == 0 || this.pendingChunk.getChunkIndex() <= this.maxChunkLogCount) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info("LiveStreamPacketizerSanJose.endChunkTS[" + this.getContextStr() + "]: Add chunk: id:" + this.pendingChunk.getChunkIndex() + " a/v/k:" + this.pendingChunk.getAudioCount() + "/" + this.pendingChunk.getVideoCount() + "/" + this.pendingChunk.getVideoKeyCount() + " duration:" + l3);
                }
                if (this.sanjoseDebugPacketizationOverhead) {
                    long l4 = 0L;
                    long l5 = this.pendingChunk.getDataSize();
                    List<LiveStreamingSanJoseBlock> list = this.pendingChunk.getBlockList();
                    for (LiveStreamingSanJoseBlock liveStreamingSanJoseBlock : list) {
                        l4 += (long)liveStreamingSanJoseBlock.getLen();
                    }
                    long l6 = (l4 - l5) * 10000L / l5;
                    double d = (double)l6 / 100.0;
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).info("LiveStreamPacketizerSanJose.endChunkTS[" + this.getContextStr() + "]: id:" + this.pendingChunk.getChunkIndex() + " overhead[" + l4 + ":" + l5 + "]:" + d + "%");
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.endChunkTS[" + this.getContextStr() + ",2]: " + exception.toString());
            }
        }
        try {
            int n = this.nextChunkId;
            Object object = this.lock;
            synchronized (object) {
                if (this.pendingChunk != null) {
                    this.chunks.put(this.pendingChunk.getChunkIndex(), this.pendingChunk);
                    n = this.pendingChunk.getChunkIndex();
                }
                this.trim(n);
                this.updatePlaylistStr();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.endChunkTS[" + this.getContextStr() + ",3]: " + exception.toString());
        }
        this.pendingChunk = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToChunkTS(SanJoseTSHolder sanJoseTSHolder) {
        long l = System.currentTimeMillis();
        this.touch(l);
        SanJoseRepeaterHolder sanJoseRepeaterHolder = new SanJoseRepeaterHolder(this.repeaterSeq, this.pendingChunk.getChunkIndex(), sanJoseTSHolder);
        ++this.repeaterSeq;
        Object object = this.lock;
        synchronized (object) {
            this.repeaterItems.add(sanJoseRepeaterHolder);
        }
        if (this.pendingChunk != null) {
            object = sanJoseTSHolder.getBlock();
            switch (sanJoseTSHolder.getType()) {
                case 8: {
                    this.pendingChunk.incAudioCount();
                    break;
                }
                case 9: {
                    this.pendingChunk.incVideoCount();
                    if (!sanJoseTSHolder.isKey()) break;
                    this.pendingChunk.incVideoKeyCount();
                }
            }
            this.pendingChunk.addBlock((byte[])object, sanJoseTSHolder.getOffset(), sanJoseTSHolder.getLen());
            this.pendingChunk.incDataSize(sanJoseTSHolder.getDataLen());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRepeaterLastSeqence() {
        long l = -1L;
        Object object = this.lock;
        synchronized (object) {
            int n = this.repeaterItems.size();
            if (n > 0) {
                l = this.repeaterItems.get(n - 1).getSequence();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRepeaterItemsSanJose(List<SanJoseRepeaterHolder> list, long l) {
        Object object = this.lock;
        synchronized (object) {
            if (l < 0L) {
                list.addAll(this.repeaterItems);
            } else {
                long l2;
                int n;
                int n2 = this.repeaterItems.size();
                if (n2 > 0 && (n = (int)(l - (l2 = this.repeaterItems.get(0).getSequence()))) >= 0) {
                    for (int i = n; i < n2; ++i) {
                        list.add(this.repeaterItems.get(i));
                    }
                }
            }
        }
    }

    private void trim(int n) {
        SanJoseRepeaterHolder sanJoseRepeaterHolder;
        while (this.chunks.size() > this.maxChunkCount) {
            this.chunks.remove(this.chunks.firstKey());
        }
        for (int i = this.repeaterItems.size(); i > 0 && (sanJoseRepeaterHolder = this.repeaterItems.get(0)).getChunkId() < n - this.repeaterChunkCount; --i) {
            this.repeaterItems.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveStreamPacketizerSanJoseChunk getChunkByFilename(String string) {
        LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk;
        block5: {
            liveStreamPacketizerSanJoseChunk = null;
            try {
                int n = LiveStreamPacketizerSanJoseUtils.chunkFilenameToIndex(string);
                if (n < 0) break block5;
                Object object = this.lock;
                synchronized (object) {
                    liveStreamPacketizerSanJoseChunk = (LiveStreamPacketizerSanJoseChunk)this.chunks.get(new Integer(n));
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.getChunkByFilename: " + exception.toString());
            }
        }
        return liveStreamPacketizerSanJoseChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getChunkRange() {
        long[] lArray = new long[2];
        try {
            Object object = this.lock;
            synchronized (object) {
                lArray[0] = this.chunks.firstKey().longValue();
                lArray[1] = this.chunks.lastKey().longValue();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.getChunkByIndex: " + exception.toString());
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LiveStreamPacketizerSanJoseChunk getChunkByIndex(long l) {
        LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk;
        block5: {
            liveStreamPacketizerSanJoseChunk = null;
            try {
                if (l < 0L) break block5;
                Object object = this.lock;
                synchronized (object) {
                    liveStreamPacketizerSanJoseChunk = (LiveStreamPacketizerSanJoseChunk)this.chunks.get(new Integer((int)l));
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.getChunkByIndex: " + exception.toString());
            }
        }
        return liveStreamPacketizerSanJoseChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaylistReady() {
        Object object = this.lock;
        synchronized (object) {
            return this.chunks.size() >= this.minChunkCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlaylistStr() {
        Object object = this.lock;
        synchronized (object) {
            return this.playListStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlaylistFragmentStr() {
        Object object = this.lock;
        synchronized (object) {
            return this.playListFragmentStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getABSTFullData() {
        Object object = this.lock;
        synchronized (object) {
            return this.playListFullABST.buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getABSTStartData() {
        Object object = this.lock;
        synchronized (object) {
            return this.playListStartABST.buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getABSTBoostrapVersion() {
        Object object = this.lock;
        synchronized (object) {
            return this.playListBoostrapVersion;
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public String getTitleStr() {
        return this.titleStr;
    }

    public void setTitleStr(String string) {
        this.titleStr = string;
    }

    private void updatePlaylistStr() {
        try {
            int n = this.chunks.size();
            if (n > 0) {
                this.updatePlaylistF4M();
                ++this.bootstrapVersion;
                this.playListBoostrapVersion = this.bootstrapVersion;
                this.playListFullABST = this.updatePlaylistABST(true, this.bootstrapVersion);
                this.playListStartABST = this.updatePlaylistABST(false, this.bootstrapVersion);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.updatePlaylistStr: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static String xmlCleanStr(String string) {
        return string;
    }

    public static String getMultibitratePlaylistF4M(String string, IHTTPStreamerSanJoseIndex iHTTPStreamerSanJoseIndex, Map<String, LiveStreamPacketizerSanJose> map) {
        Iterator<String> iterator = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            Object object;
            Object object2;
            Object object3;
            int n2 = 0;
            int n3 = 0;
            List<Long> list = iHTTPStreamerSanJoseIndex.getBitrates();
            for (String string2 : map.keySet()) {
                object3 = map.get(string2);
                object2 = null;
                int n4 = 0;
                SanJoseTSHolder sanJoseTSHolder = ((LiveStreamPacketizerSanJose)object3).getMetaDataChunk();
                if (sanJoseTSHolder == null) continue;
                object2 = sanJoseTSHolder.getBlock();
                n = sanJoseTSHolder.getOffset() + 11;
                n4 = sanJoseTSHolder.getLen() - 15;
                AMFDataList aMFDataList = null;
                try {
                    aMFDataList = new AMFDataList((byte[])object2, n, n4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (aMFDataList == null || aMFDataList.size() < 2) break;
                int n5 = 0;
                int n6 = 0;
                int n7 = aMFDataList.getType(1);
                if (n7 == 3) {
                    object = (AMFDataObj)aMFDataList.get(1);
                    n5 = object.getInt("width");
                    n6 = object.getInt("height");
                } else if (n7 == 8) {
                    object = (AMFDataMixedArray)aMFDataList.get(1);
                    n5 = object.getInt("width");
                    n6 = object.getInt("height");
                }
                if (n5 <= n2) continue;
                n2 = n5;
                n3 = n6;
            }
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            stringBuffer.append("<manifest xmlns=\"http://ns.adobe.com/f4m/1.0\">\n");
            if (string != null) {
                stringBuffer.append("\t<id>" + LiveStreamPacketizerSanJose.xmlCleanStr(string) + "</id>" + "\n");
            }
            if (n2 > 0 && n3 > 0) {
                stringBuffer.append("\t<width>" + n2 + "</width>" + "\n");
                stringBuffer.append("\t<height>" + n3 + "</height>" + "\n");
            }
            stringBuffer.append("\t<mimeType>video/mp4</mimeType>\n");
            stringBuffer.append("\t<streamType>live</streamType>\n");
            stringBuffer.append("\t<deliveryType>streaming</deliveryType>\n");
            iterator = map.keySet().iterator();
            int n8 = 0;
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = map.get(object3);
                long l = list.get(n8);
                long l2 = l / 1024L;
                if (l2 <= 0L) {
                    l2 = 1L;
                }
                String string3 = l + "";
                String string4 = l2 + "";
                object = string3;
                String string5 = ((LiveStreamPacketizerSanJose)object2).getPlaylistFragmentStr();
                string5 = string5.replace("{bitrate}", string3);
                string5 = string5.replace("{kbitrate}", string4);
                string5 = string5.replace("{bootstrapId}", (CharSequence)object);
                stringBuffer.append(string5);
                ++n8;
            }
            stringBuffer.append("</manifest>\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.updatePlaylistF4M: " + exception.toString());
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlaylistF4M() {
        byte[] byArray = null;
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            int n3 = 0;
            int n4 = 0;
            Object object = this.getMetaDataChunk();
            if (object != null) {
                byArray = ((SanJoseTSHolder)object).getBlock();
                n2 = ((SanJoseTSHolder)object).getOffset() + 11;
                n = ((SanJoseTSHolder)object).getLen() - 15;
                int n5 = 0;
                if (byArray[n2 + n5] == 0) {
                    ++n5;
                }
                AMFDataList aMFDataList = null;
                try {
                    aMFDataList = new AMFDataList(byArray, n2, n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (aMFDataList != null && aMFDataList.size() >= 2) {
                    int n6 = aMFDataList.getType(1);
                    if (n6 == 3) {
                        AMFDataObj aMFDataObj = (AMFDataObj)aMFDataList.get(1);
                        n3 = aMFDataObj.getInt("width");
                        n4 = aMFDataObj.getInt("height");
                    } else if (n6 == 8) {
                        AMFDataMixedArray aMFDataMixedArray = (AMFDataMixedArray)aMFDataList.get(1);
                        n3 = aMFDataMixedArray.getInt("width");
                        n4 = aMFDataMixedArray.getInt("height");
                    }
                }
            }
            object = null;
            if (byArray != null) {
                object = Base64.encodeBytes((byte[])byArray, (int)n2, (int)n, (int)8);
            }
            String string = "named";
            int n7 = this.getProfileIDC();
            if (n7 > 0) {
                string = n7 + "";
            }
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            stringBuffer.append("<manifest xmlns=\"http://ns.adobe.com/f4m/1.0\">\n");
            if (this.streamName != null) {
                stringBuffer.append("\t<id>" + LiveStreamPacketizerSanJose.xmlCleanStr(this.streamName) + "</id>" + "\n");
            }
            if (n3 > 0 && n4 > 0) {
                stringBuffer.append("\t<width>" + n3 + "</width>" + "\n");
                stringBuffer.append("\t<height>" + n4 + "</height>" + "\n");
            }
            stringBuffer.append("\t<mimeType>video/mp4</mimeType>\n");
            stringBuffer.append("\t<streamType>live</streamType>\n");
            stringBuffer.append("\t<deliveryType>streaming</deliveryType>\n");
            stringBuffer.append("\t<media url=\"" + "media_b{bitrate}_w{session-id}.abst/".replace("{bitrate}", "125000") + "\">" + "\n");
            if (object != null) {
                stringBuffer.append("\t\t<metadata>" + (String)object + "</metadata>" + "\n");
            }
            stringBuffer.append("\t</media>\n");
            stringBuffer.append("\t<bootstrapInfo profile=\"" + string + "\" url=\"" + "playlist_b{bitrate}_w{session-id}.abst{query}".replace("{bitrate}", "125000") + "\"/>" + "\n");
            stringBuffer.append("</manifest>\n");
            stringBuffer2.append("\t<bootstrapInfo id=\"bootstrap{bootstrapId}\" profile=\"" + string + "\" url=\"" + "playlist_b{bitrate}_w{session-id}.abst{query}".replace("{bitrate}", "{bitrate}") + "\"/>" + "\n");
            stringBuffer2.append("\t<media bootstrapInfoId=\"bootstrap{bootstrapId}\" bitrate=\"{kbitrate}\" url=\"" + "media_b{bitrate}_w{session-id}.abst/".replace("{bitrate}", "{bitrate}") + "\">" + "\n");
            if (object != null) {
                stringBuffer2.append("\t\t<metadata>" + (String)object + "</metadata>" + "\n");
            }
            stringBuffer2.append("\t</media>\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.updatePlaylistF4M: " + exception.toString());
            exception.printStackTrace();
        }
        Object object = this.lock;
        synchronized (object) {
            this.playListStr = stringBuffer.toString();
            this.playListFragmentStr = stringBuffer2.toString();
        }
    }

    private ABSTData updatePlaylistABST(boolean bl, int n) {
        ABSTData aBSTData = null;
        SanJoseRandomAccessBuffer sanJoseRandomAccessBuffer = null;
        int n2 = 0;
        long l = -1L;
        long l2 = -1L;
        try {
            int n3 = this.chunks.size();
            if (n3 > 0) {
                int n4;
                int n5 = 1;
                String string = this.titleStr;
                String string2 = "low";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                int n6 = n4 = bl ? n3 - (this.playlistChunkCount + 1) : n3 - this.playlistChunkCount;
                if (n4 < 0) {
                    n4 = 0;
                }
                LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk = (LiveStreamPacketizerSanJoseChunk)this.chunks.get(this.chunks.firstKey());
                int n7 = n3 - n4;
                int n8 = liveStreamPacketizerSanJoseChunk.getChunkIndex();
                int n9 = n7;
                n2 += 8;
                n2 += 4;
                n2 += 4;
                ++n2;
                n2 += 4;
                n2 += 8;
                n2 += 8;
                n2 += SanJoseUtilities.getABSTStringLength(string);
                ++n2;
                ++n2;
                ++n2;
                n2 += SanJoseUtilities.getABSTStringLength(string2);
                n2 += SanJoseUtilities.getABSTStringLength(string3);
                n2 += SanJoseUtilities.getABSTStringLength(string4);
                ++n2;
                n2 += 8;
                n2 += 4;
                ++n2;
                n2 += SanJoseUtilities.getABSTStringLength(string5);
                n2 += 4;
                n2 += n5 * 8;
                ++n2;
                n2 += 8;
                n2 += 4;
                n2 += 4;
                ++n2;
                n2 += SanJoseUtilities.getABSTStringLength(string6);
                n2 += 4;
                sanJoseRandomAccessBuffer = new SanJoseRandomAccessBuffer(n2 += n9 * 16);
                byte[] byArray = new byte[4];
                byte[] byArray2 = new byte[8];
                long l3 = sanJoseRandomAccessBuffer.getFilePointer();
                sanJoseRandomAccessBuffer.write(byArray);
                sanJoseRandomAccessBuffer.write("abst".getBytes());
                int n10 = 1;
                BufferUtils.longToByteArray((long)n10, (byte[])byArray, (int)0, (int)1);
                sanJoseRandomAccessBuffer.write(byArray, 0, 1);
                int n11 = 0;
                BufferUtils.longToByteArray((long)n11, (byte[])byArray, (int)0, (int)3);
                sanJoseRandomAccessBuffer.write(byArray, 0, 3);
                BufferUtils.intToByteArray((int)n, (byte[])byArray, (int)0, (int)4);
                sanJoseRandomAccessBuffer.write(byArray);
                int n12 = 0;
                boolean bl2 = true;
                boolean bl3 = true;
                int n13 = (n12 << 6) + (bl2 ? 32 : 0) + (bl3 ? 1 : 0);
                BufferUtils.intToByteArray((int)n13, (byte[])byArray, (int)0, (int)1);
                sanJoseRandomAccessBuffer.write(byArray, 0, 1);
                int n14 = 1000;
                BufferUtils.longToByteArray((long)n14, (byte[])byArray2, (int)0, (int)4);
                sanJoseRandomAccessBuffer.write(byArray2, 0, 4);
                long l4 = 0L;
                BufferUtils.longToByteArray((long)l4, (byte[])byArray2, (int)0, (int)8);
                sanJoseRandomAccessBuffer.write(byArray2);
                long l5 = 0L;
                BufferUtils.longToByteArray((long)l5, (byte[])byArray2, (int)0, (int)8);
                sanJoseRandomAccessBuffer.write(byArray2);
                sanJoseRandomAccessBuffer.write(string.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                sanJoseRandomAccessBuffer.write(1);
                sanJoseRandomAccessBuffer.write(0);
                sanJoseRandomAccessBuffer.write(1);
                sanJoseRandomAccessBuffer.write(string2.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                sanJoseRandomAccessBuffer.write(string3.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                sanJoseRandomAccessBuffer.write(string4.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                sanJoseRandomAccessBuffer.write(1);
                long l6 = sanJoseRandomAccessBuffer.getFilePointer();
                sanJoseRandomAccessBuffer.write(byArray);
                sanJoseRandomAccessBuffer.write("asrt".getBytes());
                int n15 = 1;
                BufferUtils.longToByteArray((long)n15, (byte[])byArray, (int)0, (int)1);
                sanJoseRandomAccessBuffer.write(byArray, 0, 1);
                int n16 = bl3 ? 1 : 0;
                BufferUtils.longToByteArray((long)n16, (byte[])byArray, (int)0, (int)3);
                sanJoseRandomAccessBuffer.write(byArray, 0, 3);
                sanJoseRandomAccessBuffer.write(1);
                sanJoseRandomAccessBuffer.write(string5.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                BufferUtils.longToByteArray((long)n5, (byte[])byArray, (int)0, (int)4);
                sanJoseRandomAccessBuffer.write(byArray);
                int n17 = 1;
                for (int i = 0; i < n5; ++i) {
                    BufferUtils.longToByteArray((long)n17, (byte[])byArray, (int)0, (int)4);
                    sanJoseRandomAccessBuffer.write(byArray);
                    BufferUtils.longToByteArray((long)-1L, (byte[])byArray, (int)0, (int)4);
                    sanJoseRandomAccessBuffer.write(byArray);
                    ++n17;
                }
                sanJoseRandomAccessBuffer.writeAtomSize(l6);
                sanJoseRandomAccessBuffer.write(1);
                long l7 = sanJoseRandomAccessBuffer.getFilePointer();
                sanJoseRandomAccessBuffer.write(byArray);
                sanJoseRandomAccessBuffer.write("afrt".getBytes());
                int n18 = 1;
                BufferUtils.longToByteArray((long)n18, (byte[])byArray, (int)0, (int)1);
                sanJoseRandomAccessBuffer.write(byArray, 0, 1);
                int n19 = bl3 ? 1 : 0;
                BufferUtils.longToByteArray((long)n19, (byte[])byArray, (int)0, (int)3);
                sanJoseRandomAccessBuffer.write(byArray, 0, 3);
                int n20 = 1000;
                BufferUtils.longToByteArray((long)n20, (byte[])byArray, (int)0, (int)4);
                sanJoseRandomAccessBuffer.write(byArray);
                sanJoseRandomAccessBuffer.write(1);
                sanJoseRandomAccessBuffer.write(string6.getBytes());
                sanJoseRandomAccessBuffer.write(0);
                BufferUtils.longToByteArray((long)n9, (byte[])byArray, (int)0, (int)4);
                sanJoseRandomAccessBuffer.write(byArray);
                for (int i = n4; i < n3; ++i) {
                    int n21 = n8 + i;
                    if (l < 0L) {
                        l = n21;
                    }
                    l2 = n21;
                    LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk2 = (LiveStreamPacketizerSanJoseChunk)this.chunks.get(new Integer(n8 + i));
                    long l8 = liveStreamPacketizerSanJoseChunk2.getDuration();
                    long l9 = liveStreamPacketizerSanJoseChunk2.getStartTimecode();
                    BufferUtils.longToByteArray((long)n21, (byte[])byArray, (int)0, (int)4);
                    sanJoseRandomAccessBuffer.write(byArray);
                    BufferUtils.longToByteArray((long)l9, (byte[])byArray2, (int)0, (int)8);
                    sanJoseRandomAccessBuffer.write(byArray2);
                    BufferUtils.longToByteArray((long)l8, (byte[])byArray, (int)0, (int)4);
                    sanJoseRandomAccessBuffer.write(byArray);
                    l9 += l8;
                    ++n21;
                }
                sanJoseRandomAccessBuffer.writeAtomSize(l7);
                sanJoseRandomAccessBuffer.writeAtomSize(l3);
                sanJoseRandomAccessBuffer.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("LiveStreamPacketizerSanJose.updatePlaylistABST: " + exception.toString());
            exception.printStackTrace();
        }
        if (sanJoseRandomAccessBuffer != null) {
            aBSTData = new ABSTData();
            aBSTData.buffer = sanJoseRandomAccessBuffer.toArray();
            aBSTData.rangeStart = l;
            aBSTData.rangeStop = l2;
        }
        return aBSTData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SanJoseTSHolder getMetaDataChunk() {
        SanJoseTSHolder sanJoseTSHolder = null;
        Object object = this.lock;
        synchronized (object) {
            SanJoseTSHolder sanJoseTSHolder2;
            LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk;
            if (this.chunks.size() > 0 && (liveStreamPacketizerSanJoseChunk = (LiveStreamPacketizerSanJoseChunk)this.chunks.get(this.chunks.firstKey())) != null && (sanJoseTSHolder2 = liveStreamPacketizerSanJoseChunk.getMetaDataHolder()) != null) {
                sanJoseTSHolder = sanJoseTSHolder2;
            }
        }
        return sanJoseTSHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProfileIDC() {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            MediaCodecInfoVideo mediaCodecInfoVideo;
            LiveStreamPacketizerSanJoseChunk liveStreamPacketizerSanJoseChunk;
            if (this.chunks.size() > 0 && (liveStreamPacketizerSanJoseChunk = (LiveStreamPacketizerSanJoseChunk)this.chunks.get(this.chunks.firstKey())) != null && (mediaCodecInfoVideo = liveStreamPacketizerSanJoseChunk.getCodecInfoVideo()) != null) {
                n = mediaCodecInfoVideo.getVideoProfile();
            }
        }
        return n;
    }

    class ABSTData {
        byte[] buffer = null;
        long rangeStart = -1L;
        long rangeStop = -1L;

        ABSTData() {
        }
    }

    class FlushResults {
        int lastVideoIndex = -1;
        int lastAudioIndex = -1;

        FlushResults() {
        }
    }
}

