/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ClientResponseTracker;
import com.wowza.wms.client.ClientWriteListener;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.ILivePlayer;
import com.wowza.wms.stream.live.LivePlayerSwitch;
import com.wowza.wms.stream.live.LiveReceiver;
import com.wowza.wms.stream.live.MediaStreamLivePlay;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivePlayer
implements ILivePlayer {
    protected long trackerSeqSource = 0L;
    protected IMediaStreamPlay stream = null;
    protected byte[] workBuffer = null;
    protected boolean isDebugLog = false;
    protected long lastSeq = -1L;
    protected long lastAudioTC = -1L;
    protected long lastVideoTC = -1L;
    protected long lastDataTC = -1L;
    protected long lastTC = -1L;
    protected long firstPacketTC = -1L;
    protected boolean isEnhancedSeekCapable = false;
    protected boolean isBurstCapable = false;
    protected boolean sendFirstKeyFrame = true;
    protected boolean checkStreamProperties = true;
    protected boolean sendFirstVideoFrame = true;
    protected boolean sendFirstAudioFrame = true;
    protected boolean sentPlayStart = false;
    protected boolean sendPlayStop = false;
    protected boolean sendPlaySwitch = false;
    protected long lastSendTime = -1L;
    protected boolean waitForKeyFrame = true;
    protected long lastTCOffset = 0L;
    protected int lastTCFilter = 7;
    protected LiveTracker lastSentLiveTracker = null;
    protected long trackerBufferTime = 0L;
    protected long trackerStartSeq = -1L;
    protected boolean sendStreamNotFound = true;
    protected boolean waitForBufferFill = true;
    protected boolean waitForBufferKeyFrame = false;
    protected long waitForBufferFillStarTime = -1L;
    protected int maximumLiveLatency = 8000;
    protected boolean disableLowBandwidthThrottling = false;
    protected boolean instantOn = false;
    protected int instantOnBufferTime = 0;
    protected int behindDropDFrames = 500;
    protected int behindDropPFrames = 1500;
    protected int behindDropKFrames = 3000;
    protected int behindDropAudio = 3000;
    protected boolean lastReceiveAudio = true;
    protected boolean lastReceiveVideo = true;
    protected int lastReceiveVideoFPS = -1;
    protected double playStart = 0.0;
    protected double playLen = -1.0;
    protected int playTransition = 0;
    protected boolean playlistEnd = false;
    protected boolean bufferEmptyOnce = false;
    protected Object lock = new Object();
    protected AtomicReference<LivePlayerSwitch> liveSwitch = new AtomicReference<Object>(null);
    protected boolean sendOriginalTimecodes = false;
    protected int packetsSent = 0;
    protected int startPacketsSent = 0;
    protected boolean referenceWrite = true;
    protected int[] avgPacketSizes = new int[8];
    protected long avgPacketSizeCount = 0L;
    protected long avgPacketSizeTotal = 0L;
    protected int referenceWritePacketSizeThreshold = 500;
    private boolean enableDynamicStreamMarkers = true;

    public LivePlayer(IMediaStreamPlay iMediaStreamPlay) {
        this.stream = iMediaStreamPlay;
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object object) {
        this.lock = object;
    }

    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient != null) {
            int[] nArray = new int[]{9, 0, 0, 0};
            int n = iClient.testFlashVersion(nArray);
            return n >= 0;
        }
        return false;
    }

    protected boolean isBurstCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient != null) {
            int[] nArray = new int[]{10, 0, 0, 0};
            int n = iClient.testFlashVersion(nArray);
            return n >= 0;
        }
        return false;
    }

    protected void sendBurstStart(OutputStream outputStream, IMediaStream iMediaStream) {
        if (this.isBurstCapable) {
            byte[] byArray = iMediaStream.getBurstStartStop(true);
            try {
                outputStream.write(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void sendBurstEnd(OutputStream outputStream, IMediaStream iMediaStream) {
        if (this.isBurstCapable) {
            byte[] byArray = iMediaStream.getBurstStartStop(false);
            try {
                outputStream.write(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected int packetOutput(OutputStream outputStream, IMediaStream iMediaStream, AMFPacket aMFPacket, long l, AMFObj aMFObj, byte[] byArray, int n) {
        if (this.startPacketsSent == this.packetsSent) {
            this.sendBurstStart(outputStream, iMediaStream);
        }
        ++this.packetsSent;
        return StreamUtils.packetOutput((OutputStream)outputStream, (IMediaStream)iMediaStream, (AMFPacket)aMFPacket, (long)l, (AMFObj)aMFObj, (byte[])byArray, (int)n, (boolean)this.referenceWrite);
    }

    protected int doSwitch(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray, long l, byte by, AMFPacket aMFPacket, AMFPacket aMFPacket2, AMFPacket aMFPacket3) {
        AMFPacket aMFPacket4;
        Object object;
        int n = 0;
        Client client = (Client)iMediaStream.getClient();
        int n2 = client.getSendChunkSize();
        this.checkWorkBuffer(n2);
        AMFPacket aMFPacket5 = new AMFPacket(8, iMediaStream.getSrc(), 0);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        AMFPacket aMFPacket6 = null;
        if ((by & 0xF) == 7 && (aMFPacket6 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
            object = new byte[]{(byte)(16 + (byte)(by & 0xF)), 2, 0, 0, 0};
            aMFPacket6.addData(object, 0, ((byte[])object).length);
        }
        if (aMFPacket6 != null) {
            lArray[2] = lArray[2] + (long)aMFPacket6.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket6, l, aMFObj2, this.workBuffer, n2);
            aMFObj2.setNew(true);
        }
        n += iMediaStream.sendPlayStatus(outputStream, l, 1, 0.0, 0.0);
        n += iMediaStream.sendPlayStart(outputStream, iMediaStream.getName(), true, true, l, null);
        if (aMFPacket5 != null) {
            lArray[0] = lArray[0] + 0L;
            lArray[1] = lArray[1] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket5, l, aMFObj, this.workBuffer, n2);
            aMFObj.setNew(true);
        }
        if (aMFPacket != null) {
            object = null;
            aMFPacket4 = null;
            object = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
            object.createSeekMessage("onStatus");
            object.setSrc(iMediaStream.getSrc());
            object.setType(18);
            object.setTimecode(l);
            aMFPacket4 = new AMFDataObj();
            aMFPacket4.put("code", (AMFData)new AMFDataItem("NetStream.Data.Start"));
            object.addBody((AMFData)aMFPacket4);
            n += object.write(outputStream, true, n2);
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket, l, aMFObj3, this.workBuffer, n2);
        }
        if (aMFPacket3 != null) {
            byte by2 = (byte)aMFPacket3.getFirstByte();
            aMFPacket4 = null;
            if ((by2 & 0xF) == 7 && (aMFPacket4 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
                byte[] byArray = new byte[]{(byte)(16 + (byte)(by2 & 0xF)), 2, 0, 0, 0};
                aMFPacket4.addData(byArray, 0, byArray.length);
            }
            if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
                n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, true), l, aMFObj2, this.workBuffer, n2);
            }
            if (aMFPacket4 != null) {
                lArray[2] = lArray[2] + (long)aMFPacket4.getSize();
                lArray[3] = lArray[3] + 1L;
                n += this.packetOutput(outputStream, iMediaStream, aMFPacket4, l, aMFObj2, this.workBuffer, n2);
            }
            lArray[2] = lArray[2] + (long)aMFPacket3.getSize();
            lArray[3] = lArray[3] + 1L;
            n += this.packetOutput(outputStream, iMediaStream, aMFPacket3, l, aMFObj2, this.workBuffer, n2);
            if (this.isEnhancedSeekCapable && aMFPacket4 != null) {
                n += this.packetOutput(outputStream, iMediaStream, this.getEnhanceSeekPacket(iMediaStream, by2, false), l, aMFObj2, this.workBuffer, n2);
            }
            if (aMFPacket2 != null) {
                n += this.packetOutput(outputStream, iMediaStream, aMFPacket2, l, aMFObj2, this.workBuffer, n2);
            }
        }
        return n;
    }

    @Override
    public void init(IMediaStream iMediaStream, MediaStreamMap mediaStreamMap) {
        WMSProperties wMSProperties = this.stream.getParent().getProperties();
        if (wMSProperties != null) {
            this.disableLowBandwidthThrottling = wMSProperties.getPropertyBoolean("disableLowBandwidthThrottling", this.disableLowBandwidthThrottling);
            this.instantOn = wMSProperties.getPropertyBoolean("instantOn", this.instantOn);
            this.instantOnBufferTime = wMSProperties.getPropertyInt("instantOnBufferTime", this.instantOnBufferTime);
            this.waitForBufferFill = wMSProperties.getPropertyBoolean("waitForBufferFill", this.waitForBufferFill);
            this.waitForBufferKeyFrame = wMSProperties.getPropertyBoolean("waitForBufferKeyFrame", this.waitForBufferKeyFrame);
            this.behindDropDFrames = wMSProperties.getPropertyInt("behindDropDFrames", this.behindDropDFrames);
            this.behindDropPFrames = wMSProperties.getPropertyInt("behindDropPFrames", this.behindDropPFrames);
            this.behindDropAudio = this.behindDropKFrames = wMSProperties.getPropertyInt("behindDropKFrames", this.behindDropKFrames);
            this.behindDropAudio = wMSProperties.getPropertyInt("behindDropAudio", this.behindDropAudio);
            this.maximumLiveLatency = wMSProperties.getPropertyInt("maxliveaudiolatency", this.maximumLiveLatency);
            this.sendOriginalTimecodes = wMSProperties.getPropertyBoolean("sendOriginalTimecodes", this.sendOriginalTimecodes);
            this.referenceWritePacketSizeThreshold = wMSProperties.getPropertyInt("referenceWritePacketSizeThreshold", this.referenceWritePacketSizeThreshold);
            this.referenceWrite = wMSProperties.getPropertyBoolean("referenceWrite", this.referenceWrite);
            this.enableDynamicStreamMarkers = wMSProperties.getPropertyBoolean("enableDynamicStreamMarkers", this.enableDynamicStreamMarkers);
        }
        this.isDebugLog = WMSLoggerFactory.getLogger(LiveReceiver.class).isDebugEnabled();
    }

    protected boolean testVideoFrame(int n, int n2) {
        return (n & 1 << ((n2 & 0x30) >> 4) - 1) != 0;
    }

    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.workBuffer == null) {
            bl = true;
        } else if (this.workBuffer.length < n) {
            bl = true;
        }
        if (bl) {
            this.workBuffer = new byte[n];
        }
    }

    protected AMFPacket getEnhanceSeekPacket(IMediaStream iMediaStream, int n, boolean bl) {
        AMFPacket aMFPacket = new AMFPacket(9, iMediaStream.getSrc(), 2);
        byte[] byArray = new byte[]{(byte)(0x50 | (byte)(n & 0xF)), (byte)(!bl ? 1 : 0)};
        aMFPacket.addData(byArray, 0, byArray.length);
        return aMFPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int playKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        this.startPacketsSent = this.packetsSent;
        Object object = this.lock;
        synchronized (object) {
            Client client = (Client)this.stream.getParent().getClient();
            int n2 = client.getSendChunkSize();
            this.checkWorkBuffer(n2);
            this.isEnhancedSeekCapable = this.isEnhancedSeekCapable(this.stream.getParent());
            if (this.enableDynamicStreamMarkers) {
                this.isBurstCapable = this.isBurstCapable(this.stream.getParent());
            }
            int n3 = -1;
            AMFPacket aMFPacket = this.getLastKeyFrame(iMediaStream);
            if (aMFPacket != null) {
                long l = 0L;
                int n4 = aMFPacket.getFirstByte();
                n3 = FLVUtils.getVideoCodec((int)n4);
                if (!this.sentPlayStart) {
                    if (this.sendPlayStop) {
                        n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                        this.sendPlayStop = false;
                    }
                    n += this.stream.getParent().sendLivePlayStart(outputStream, this.stream.getParent().getName(), l, this.firstPacketTC);
                    this.sentPlayStart = true;
                    this.sendPlayStop = true;
                    this.stream.getParent().setSendPlayStopLogEvent(true);
                    WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(0L));
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), "stream", "play", 200, this.stream.getParent().getName());
                    this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                    aMFObj3.setNew(true);
                    aMFObj.setNew(true);
                    aMFObj2.setNew(true);
                }
                if (this.sendFirstKeyFrame) {
                    AMFPacket aMFPacket2;
                    AMFPacket aMFPacket3;
                    Object object2;
                    IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                    if (iMediaStreamMetaDataProvider != null) {
                        ArrayList arrayList = new ArrayList();
                        long l2 = 0L;
                        iMediaStreamMetaDataProvider.onStreamStart(arrayList, l2);
                        if (arrayList.size() > 0) {
                            object2 = null;
                            AMFDataObj aMFDataObj = null;
                            object2 = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                            object2.createSeekMessage("onStatus");
                            object2.setSrc(this.stream.getParent().getSrc());
                            object2.setType(18);
                            object2.setTimecode(l);
                            aMFDataObj = new AMFDataObj();
                            aMFDataObj.put("code", (AMFData)new AMFDataItem("NetStream.Data.Start"));
                            object2.addBody((AMFData)aMFDataObj);
                            n += object2.write(outputStream, true, n2);
                            for (AMFPacket aMFPacket4 : arrayList) {
                                n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket4, l, aMFObj3, this.workBuffer, n2);
                            }
                        }
                    }
                    boolean bl = false;
                    if (this.sendFirstVideoFrame) {
                        AMFPacket aMFPacket5 = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                        if (aMFPacket5 != null) {
                            n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket5, l, aMFObj2, this.workBuffer, n2);
                        }
                        this.sendFirstVideoFrame = false;
                        bl = true;
                    }
                    if (bl && this.isEnhancedSeekCapable) {
                        n += this.packetOutput(outputStream, this.stream.getParent(), this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket.getFirstByte(), true), l, aMFObj2, this.workBuffer, n2);
                    }
                    lArray[2] = lArray[2] + (long)aMFPacket.getSize();
                    lArray[3] = lArray[3] + 1L;
                    n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket, l, aMFObj2, this.workBuffer, n2);
                    if (bl && this.isEnhancedSeekCapable) {
                        n += this.packetOutput(outputStream, this.stream.getParent(), this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket.getFirstByte(), false), l, aMFObj2, this.workBuffer, n2);
                    }
                    if ((aMFPacket3 = new AMFPacket(8, iMediaStream.getSrc(), 0)) != null) {
                        lArray[0] = lArray[0] + 0L;
                        lArray[1] = lArray[1] + 1L;
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket3, l, aMFObj, this.workBuffer, n2);
                        aMFObj.setNew(true);
                    }
                    if (n3 == 7 && (aMFPacket2 = new AMFPacket(9, iMediaStream.getSrc(), 5)) != null) {
                        lArray[2] = lArray[2] + 5L;
                        lArray[3] = lArray[3] + 1L;
                        object2 = new byte[5];
                        object2[0] = (ResponseFunction)23;
                        object2[1] = (ResponseFunction)2;
                        object2[2] = (ResponseFunction)false;
                        object2[3] = (ResponseFunction)false;
                        object2[4] = (ResponseFunction)false;
                        aMFPacket2.addData((byte[])object2, 0, ((ResponseFunction)object2).length);
                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket2, l, aMFObj2, this.workBuffer, n2);
                    }
                    if (this.stream.getParent().isSendPlayStopLogEvent()) {
                        this.stream.getParent().setSendPlayStopLogEvent(false);
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), "stream", "stop", 200, this.stream.getParent().getName());
                        this.stream.getParent().notifyActionStop();
                    }
                    n += this.stream.getParent().sendPlayStatus(outputStream, l, 2, 0.0, 0.0);
                    n += this.stream.getParent().sendPlayStop(outputStream, l, this.stream.getParent().getName());
                    this.sendPlayStop = false;
                    this.sendFirstKeyFrame = false;
                }
                this.playlistEnd = true;
            }
        }
        if (this.startPacketsSent != this.packetsSent) {
            this.sendBurstEnd(outputStream, this.stream.getParent());
        }
        return n;
    }

    protected List getPlayPackets(IMediaStream iMediaStream) {
        return iMediaStream.getPlayPackets();
    }

    protected AMFPacket getLastKeyFrame(IMediaStream iMediaStream) {
        return iMediaStream.getLastKeyFrame();
    }

    protected AMFPacket getLastPacket(IMediaStream iMediaStream) {
        return iMediaStream.getLastPacket();
    }

    protected long[] getLastPacketTimecodes(List<AMFPacket> list) {
        long[] lArray = new long[]{-1L, -1L};
        for (int i = list.size() - 1; i >= 0; --i) {
            AMFPacket aMFPacket = list.get(i);
            int n = aMFPacket.getType();
            long l = aMFPacket.getAbsTimecode();
            if (n == 8) {
                if (lArray[0] == -1L) {
                    lArray[0] = l;
                }
            } else if (n == 9 && lArray[1] == -1L) {
                lArray[1] = l;
            }
            if (lArray[0] >= 0L && lArray[1] >= 0L) break;
        }
        return lArray;
    }

    protected int playAll(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        this.startPacketsSent = this.packetsSent;
        n += this.playAllInternal(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        IMediaStream iMediaStream2 = null;
        LivePlayerSwitch livePlayerSwitch = this.liveSwitch.get();
        if (livePlayerSwitch != null && livePlayerSwitch.switchTimecodeFound) {
            this.sendPlaySwitch = true;
            this.sendFirstAudioFrame = true;
            this.sendFirstVideoFrame = true;
            this.lastSeq = livePlayerSwitch.switchVideoKeyFrameSeq;
            ((MediaStream)this.stream.getParent()).setJustName(livePlayerSwitch.getName());
            iMediaStream2 = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
            this.liveSwitch.set(null);
        }
        if (iMediaStream2 != null) {
            n += this.playAllInternal(iMediaStream2, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        if (this.startPacketsSent != this.packetsSent) {
            this.sendBurstEnd(outputStream, this.stream.getParent());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int playAllInternal(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        if (this.playlistEnd) {
            return 0;
        }
        boolean bl = true;
        boolean bl2 = true;
        int n2 = -1;
        Object object = this.stream.getParent();
        synchronized (object) {
            bl = this.stream.getParent().isReceiveAudio();
            bl2 = this.stream.getParent().isReceiveVideo();
            n2 = this.stream.getParent().getReceiveVideoFPS();
        }
        object = this.lock;
        synchronized (object) {
            String string;
            ClientWriteListener clientWriteListener;
            LiveTracker liveTracker;
            long l;
            int n3;
            block141: {
                int n4;
                List list;
                int n5;
                long l2;
                AMFPacket aMFPacket;
                int n6;
                AMFPacket aMFPacket2;
                boolean bl3;
                int n7;
                List list2;
                LivePlayerSwitch livePlayerSwitch;
                block142: {
                    AMFPacket aMFPacket3;
                    block140: {
                        livePlayerSwitch = this.liveSwitch.get();
                        list2 = this.getPlayPackets(iMediaStream);
                        aMFPacket3 = iMediaStream.getLastKeyFrame();
                        if (this.checkStreamProperties) {
                            this.isEnhancedSeekCapable = this.isEnhancedSeekCapable(this.stream.getParent());
                            if (this.enableDynamicStreamMarkers) {
                                this.isBurstCapable = this.isBurstCapable(this.stream.getParent());
                            }
                            if (this.isBurstCapable) {
                                WMSLoggerFactory.getLogger(null).info("LivePlayer.play[" + iMediaStream.getContextStr() + "]: Dynamic Stream Markers are on.");
                            }
                            this.checkStreamProperties = false;
                        }
                        Client client = (Client)this.stream.getParent().getClient();
                        n7 = client.getSendChunkSize();
                        n3 = 7;
                        bl3 = false;
                        l = 0L;
                        aMFPacket2 = null;
                        liveTracker = null;
                        clientWriteListener = client.getWriteListener();
                        string = "stream" + this.stream.getParent().getSrc();
                        n6 = list2.size();
                        if (n6 != 0) break block140;
                        this.bufferEmptyOnce = true;
                        break block141;
                    }
                    aMFPacket = (AMFPacket)list2.get(0);
                    if (!this.waitForBufferFill || !this.sendFirstKeyFrame) break block142;
                    boolean bl4 = true;
                    long l3 = System.currentTimeMillis();
                    l2 = Math.min((long)this.stream.getParent().getBufferTime(), (long)this.maximumLiveLatency);
                    if (this.waitForBufferFillStarTime == -1L) {
                        this.waitForBufferFillStarTime = l3;
                    } else if (l3 - this.waitForBufferFillStarTime > l2 && !this.waitForBufferKeyFrame) {
                        bl4 = false;
                    }
                    if (!bl4 || l2 <= 0L) break block142;
                    AMFPacket aMFPacket4 = (AMFPacket)list2.get(n6 - 1);
                    if (aMFPacket4.getAbsTimecode() - aMFPacket.getAbsTimecode() < l2) break block141;
                    if (!this.waitForBufferKeyFrame || aMFPacket3 != null) break block142;
                    n5 = 0;
                    for (int i = 0; i < n6 && ((list = (AMFPacket)list2.get(i)).getType() != 9 || ++n5 <= 2); ++i) {
                    }
                    if (n5 > 2) break block141;
                }
                long l4 = aMFPacket.getSeq();
                int n8 = n4 = this.lastSeq == -1L ? 0 : (int)(this.lastSeq - l4 + 1L);
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 < n6) {
                    int n9;
                    int n10;
                    ClientResponseTracker clientResponseTracker;
                    LiveTracker liveTracker2;
                    int n11;
                    long l5;
                    int n12;
                    if ((!this.bufferEmptyOnce || this.waitForBufferFill) && this.instantOn && this.sendFirstKeyFrame) {
                        l2 = -1L;
                        n5 = -1;
                        this.trackerBufferTime = 0L;
                        long l6 = this.stream.getParent().getBufferTime();
                        for (int i = n6 - 1; i >= 0; --i) {
                            aMFPacket = (AMFPacket)list2.get(i);
                            n12 = aMFPacket.getType();
                            if (n12 != 9 && n12 != 8) continue;
                            l5 = aMFPacket.getAbsTimecode();
                            if (l2 == -1L) {
                                l2 = l5;
                            } else {
                                if (n5 == -1) {
                                    this.trackerBufferTime = l2 - l5;
                                }
                                if (n5 == -1 && l2 - l5 > l6) {
                                    n5 = i;
                                }
                            }
                            if (n12 == 9) {
                                n11 = FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket);
                                if (this.isEnhancedSeekCapable) {
                                    if (n5 != -1 && n11 != 0) {
                                        aMFPacket2 = aMFPacket;
                                        if (this.instantOnBufferTime <= 0 || l2 - l5 >= (long)this.instantOnBufferTime) {
                                            break;
                                        }
                                    }
                                } else if (n11 != 0) {
                                    aMFPacket2 = aMFPacket;
                                }
                            }
                            if (!this.isEnhancedSeekCapable && n5 != -1) break;
                        }
                        int n13 = n4 = n5 < 0 ? 0 : n5;
                    }
                    if (n4 == 0 && this.lastSeq != -1L && (aMFPacket = (AMFPacket)list2.get(n4)).getSeq() != this.lastSeq + 1L) {
                        this.waitForKeyFrame = true;
                    }
                    LiveTracker liveTracker3 = liveTracker2 = (clientResponseTracker = clientWriteListener.getLastTracker()) == null ? null : (LiveTracker)clientResponseTracker.getInfo(string);
                    if (liveTracker2 != null && this.lastSentLiveTracker != null && liveTracker2.trackerSeq >= this.trackerStartSeq) {
                        long l7 = clientResponseTracker.getSent();
                        long l8 = clientResponseTracker.getSize();
                        long l9 = liveTracker2.firstTC + (liveTracker2.lastTC - liveTracker2.firstTC) * l7 / l8;
                        l = this.lastSentLiveTracker.lastTC - l9 - this.trackerBufferTime;
                        if (!this.disableLowBandwidthThrottling) {
                            if (l > (long)this.behindDropAudio) {
                                bl3 = true;
                            }
                            if (l > (long)this.behindDropKFrames) {
                                n3 = 0;
                            } else if (l > (long)this.behindDropPFrames) {
                                n3 = 1;
                            } else if (l > (long)this.behindDropDFrames) {
                                n3 = 3;
                            }
                        }
                        if (this.lastTCFilter != n3) {
                            WMSLoggerFactory.getLogger(LivePlayer.class).debug("Filter[" + string + "]: filter:(" + this.lastTCFilter + "-" + n3 + ") offset:" + l + " sentTC:" + this.lastSentLiveTracker.lastTC + " receivedTC:" + liveTracker2.lastTC + " bufferTime:" + this.trackerBufferTime + " tc:" + this.lastTC);
                        }
                        this.lastTCFilter = n3;
                    }
                    this.lastTCOffset = l;
                    int n14 = n2;
                    if (n14 < -1) {
                        if (n14 == -2 && n3 == 7) {
                            n3 = 3;
                        } else if (n14 == -3 && (n3 == 7 || n3 == 3)) {
                            n3 = 1;
                            this.waitForKeyFrame = true;
                        }
                    }
                    n5 = 300;
                    if (livePlayerSwitch != null) {
                        long l10;
                        long l11;
                        IMediaStream iMediaStream2 = this.stream.getParent().getStreams().getStream(livePlayerSwitch.getName());
                        list = null;
                        if (iMediaStream2 != null) {
                            list = iMediaStream2.getPlayPackets();
                        }
                        if (livePlayerSwitch.switchMode == -1) {
                            if (livePlayerSwitch.getPlayerTransition() == 12) {
                                livePlayerSwitch.switchMode = 1;
                            }
                            long l12 = 0L;
                            if (livePlayerSwitch.switchMode == -1) {
                                int n15 = 1;
                                if (list != null && list.size() > 0) {
                                    long[] lArray2 = this.getLastPacketTimecodes(list2);
                                    long[] lArray3 = this.getLastPacketTimecodes(list);
                                    l11 = -1L;
                                    boolean bl5 = false;
                                    long l13 = -1L;
                                    n10 = 0;
                                    if (lArray2[0] >= 0L && lArray3[0] >= 0L) {
                                        l11 = lArray3[0] - lArray2[0];
                                        bl5 = true;
                                    }
                                    if (lArray2[1] >= 0L && lArray3[1] >= 0L) {
                                        l13 = lArray3[1] - lArray2[1];
                                        n10 = 1;
                                    }
                                    l12 = bl5 && n10 != 0 ? (Math.abs(l13) < Math.abs(l11) ? l13 : l11) : (n10 != 0 ? l13 : l11);
                                    if (Math.abs(l12) <= (long)n5) {
                                        n15 = 0;
                                    }
                                }
                                livePlayerSwitch.switchMode = n15;
                            }
                            switch (livePlayerSwitch.switchMode) {
                                case 1: {
                                    livePlayerSwitch.switchTimecodeOffset = l12;
                                    break;
                                }
                                case 0: {
                                    livePlayerSwitch.switchTimecodeOffset = 0L;
                                }
                            }
                        }
                        if (livePlayerSwitch.lastSeq == -1L && list != null && (n12 = list.size()) > 0) {
                            long l14;
                            l5 = -1L;
                            long l15 = -1L;
                            l11 = -1L;
                            long l16 = -1L;
                            for (int i = n4; i < n6; ++i) {
                                aMFPacket = (AMFPacket)list2.get(i);
                                n10 = aMFPacket.getType();
                                l14 = aMFPacket.getAbsTimecode();
                                if (n10 == 8) {
                                    if (l5 == -1L) {
                                        l5 = l14;
                                    }
                                    l15 = l14;
                                    continue;
                                }
                                if (n10 != 9) continue;
                                if (l11 == -1L) {
                                    l11 = l14;
                                }
                                l16 = l14;
                            }
                            l10 = l16 - l11;
                            l14 = l15 - l5;
                            long l17 = Math.max(l10, l14);
                            l5 = -1L;
                            l15 = -1L;
                            l11 = -1L;
                            l16 = -1L;
                            int n16 = -1;
                            for (int i = n12 - 1; i >= 0; --i) {
                                aMFPacket = (AMFPacket)list.get(i);
                                n9 = aMFPacket.getType();
                                long l18 = aMFPacket.getAbsTimecode();
                                if (n9 == 8) {
                                    if (l15 == -1L) {
                                        l15 = l18;
                                        continue;
                                    }
                                    if (l15 - l18 < l17) continue;
                                    n16 = i;
                                    break;
                                }
                                if (n9 != 9) continue;
                                if (l16 == -1L) {
                                    l16 = l18;
                                    continue;
                                }
                                if (l16 - l18 < l17) continue;
                                n16 = i;
                                break;
                            }
                            if (n16 < 0) {
                                n16 = 0;
                            }
                            aMFPacket = (AMFPacket)list.get(n16);
                            livePlayerSwitch.lastSeq = aMFPacket.getSeq();
                        }
                        if (livePlayerSwitch.lastSeq >= 0L && livePlayerSwitch.switchVideoKeyFrameSeq < 0L && list != null && (n12 = list.size()) > 0) {
                            aMFPacket = (AMFPacket)list.get(0);
                            l5 = aMFPacket.getSeq();
                            int n17 = n11 = livePlayerSwitch.lastSeq == -1L ? 0 : (int)(livePlayerSwitch.lastSeq - l5 + 1L);
                            if (n11 < 0) {
                                n11 = 0;
                            }
                            if (n11 < n12) {
                                for (int i = n11; i < n12; ++i) {
                                    aMFPacket = (AMFPacket)list.get(i);
                                    l11 = aMFPacket.getSeq();
                                    int n18 = aMFPacket.getType();
                                    livePlayerSwitch.lastSeq = l11;
                                    if (n18 != 9 || !FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket)) continue;
                                    int n19 = aMFPacket.getFirstByte();
                                    l10 = aMFPacket.getAbsTimecode();
                                    livePlayerSwitch.switchVideoKeyFrameSeq = l11 - 1L;
                                    livePlayerSwitch.switchTimecodeTarget = l10 + livePlayerSwitch.switchTimecodeOffset;
                                }
                            }
                        }
                    }
                    if (!this.sendFirstKeyFrame && this.lastReceiveVideo != bl2) {
                        if (bl2) {
                            this.waitForKeyFrame = true;
                        }
                        this.lastReceiveVideo = bl2;
                    }
                    this.checkWorkBuffer(n7);
                    long l19 = -1L;
                    for (n12 = n4; n12 < n6; ++n12) {
                        aMFPacket = (AMFPacket)list2.get(n12);
                        AMFObj aMFObj4 = null;
                        long l20 = aMFPacket.getAbsTimecode();
                        long l21 = 0L;
                        int n20 = aMFPacket.getType();
                        int n21 = 0;
                        if (livePlayerSwitch != null) {
                            if (n20 == 9 && livePlayerSwitch.switchVideoKeyFrameSeq >= 0L && l20 >= livePlayerSwitch.switchTimecodeTarget && !livePlayerSwitch.switchTimecodeFound) {
                                livePlayerSwitch.switchTimecodeFound = true;
                            }
                            if (livePlayerSwitch.switchTimecodeFound) break;
                        }
                        switch (n20) {
                            case 8: {
                                if (!bl || bl3) break;
                                if (this.firstPacketTC == -1L) {
                                    l21 = 0L;
                                    this.firstPacketTC = l20;
                                    if (this.sendOriginalTimecodes) {
                                        this.firstPacketTC = 0L;
                                    }
                                } else {
                                    l21 = l20 - this.firstPacketTC;
                                }
                                if (l21 < 0L) break;
                                aMFObj4 = aMFObj;
                                this.lastTC = l21;
                                this.lastAudioTC = l21;
                                n21 = aMFPacket.getSize();
                                lArray[0] = lArray[0] + (long)n21;
                                lArray[1] = lArray[1] + 1L;
                                break;
                            }
                            case 9: {
                                int n22 = aMFPacket.getFirstByte();
                                int n23 = FLVUtils.getVideoCodec((int)n22);
                                if (!bl2 && n23 != 7) break;
                                int n24 = n10 = n3 == 7 ? 1 : 0;
                                if (n10 == 0) {
                                    n10 = this.testVideoFrame(n3, n22) ? 1 : 0;
                                }
                                if (n10 != 0) {
                                    if (this.waitForKeyFrame) {
                                        if (!FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket)) break;
                                        WMSLoggerFactory.getLogger(LivePlayer.class).debug("waitForKeyFrame: found");
                                        this.waitForKeyFrame = false;
                                    }
                                    if (this.firstPacketTC == -1L) {
                                        l21 = 0L;
                                        this.firstPacketTC = l20;
                                        if (this.sendOriginalTimecodes) {
                                            this.firstPacketTC = 0L;
                                        }
                                    } else {
                                        l21 = l20 - this.firstPacketTC;
                                    }
                                    if (l21 < 0L) break;
                                    aMFObj4 = aMFObj2;
                                    this.lastTC = l21;
                                    this.lastVideoTC = l21;
                                    if (!bl2 && n23 == 7) {
                                        int n25 = Math.min(aMFPacket.getSize(), 5);
                                        aMFPacket = aMFPacket.clone();
                                        aMFPacket.truncatePacket(n25);
                                    }
                                    n21 = aMFPacket.getSize();
                                    lArray[2] = lArray[2] + (long)n21;
                                    lArray[3] = lArray[3] + 1L;
                                    break;
                                }
                                n21 = aMFPacket.getSize();
                                lArray[6] = lArray[6] + (long)n21;
                                lArray[7] = lArray[7] + 1L;
                                break;
                            }
                            case 15: 
                            case 18: {
                                if (this.firstPacketTC == -1L) {
                                    l21 = 0L;
                                    this.firstPacketTC = l20;
                                    if (this.sendOriginalTimecodes) {
                                        this.firstPacketTC = 0L;
                                    }
                                } else {
                                    l21 = l20 - this.firstPacketTC;
                                    if (l21 < 0L) {
                                        l21 = 0L;
                                    }
                                }
                                aMFObj4 = aMFObj3;
                                this.lastTC = l21;
                                this.lastDataTC = l21;
                                lArray[4] = lArray[4] + (long)aMFPacket.getSize();
                                lArray[5] = lArray[5] + 1L;
                                break;
                            }
                            default: {
                                WMSLoggerFactory.getLogger(MediaStreamLivePlay.class).info("Info: WMSRespStreams: outputSingle: unkown packet type: " + aMFPacket.getType());
                            }
                        }
                        if (n21 > 0) {
                            this.avgPacketSizeTotal -= (long)this.avgPacketSizes[(int)(this.avgPacketSizeCount % (long)this.avgPacketSizes.length)];
                            this.avgPacketSizeTotal += (long)n21;
                            this.avgPacketSizes[(int)(this.avgPacketSizeCount % (long)this.avgPacketSizes.length)] = n21;
                            ++this.avgPacketSizeCount;
                        }
                        if (aMFObj4 != null) {
                            if (!this.sentPlayStart) {
                                if (this.sendPlayStop) {
                                    n += this.stream.getParent().sendPlayStop(outputStream, l21, this.stream.getParent().getName());
                                    this.sendPlayStop = false;
                                }
                                n += this.stream.getParent().sendLivePlayStart(outputStream, this.stream.getParent().getName(), l21, this.firstPacketTC);
                                this.sentPlayStart = true;
                                this.sendPlayStop = true;
                                this.stream.getParent().setSendPlayStopLogEvent(true);
                                WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(0L));
                                WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), "stream", "play", 200, this.stream.getParent().getName());
                                this.stream.getParent().notifyActionPlay(this.stream.getParent().getName(), this.playStart, this.playLen, this.playTransition);
                                aMFObj3.setNew(true);
                                aMFObj.setNew(true);
                                aMFObj2.setNew(true);
                            }
                            if (this.sendPlaySwitch) {
                                this.sendPlaySwitch = false;
                                n += this.stream.getParent().sendLivePlaySwitch(outputStream, iMediaStream.getName(), l21);
                                IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                                ArrayList arrayList = new ArrayList();
                                long l22 = aMFPacket.getAbsTimecode();
                                iMediaStreamMetaDataProvider.onStreamStart(arrayList, l22);
                                if (arrayList.size() > 0) {
                                    for (AMFPacket aMFPacket5 : arrayList) {
                                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket5, l21, aMFObj3, this.workBuffer, n7);
                                    }
                                }
                            }
                            if (liveTracker == null) {
                                liveTracker = new LiveTracker();
                                liveTracker.firstTC = l20;
                            }
                            liveTracker.lastTC = l20;
                            boolean bl6 = false;
                            if (this.sendFirstKeyFrame) {
                                IMediaStreamMetaDataProvider iMediaStreamMetaDataProvider = iMediaStream.getMetaDataProvider();
                                if (iMediaStreamMetaDataProvider != null) {
                                    ArrayList arrayList = new ArrayList();
                                    long l23 = aMFPacket.getAbsTimecode();
                                    iMediaStreamMetaDataProvider.onStreamStart(arrayList, l23);
                                    if (arrayList.size() > 0) {
                                        ResponseFunction responseFunction = null;
                                        AMFDataObj aMFDataObj = null;
                                        responseFunction = new ResponseFunction(this.stream.getParent().getClient(), this.stream.getParent().getRespAMFDataObj());
                                        responseFunction.createSeekMessage("onStatus");
                                        responseFunction.setSrc(this.stream.getParent().getSrc());
                                        responseFunction.setType(18);
                                        responseFunction.setTimecode(l21);
                                        aMFDataObj = new AMFDataObj();
                                        aMFDataObj.put("code", (AMFData)new AMFDataItem("NetStream.Data.Start"));
                                        responseFunction.addBody((AMFData)aMFDataObj);
                                        n += responseFunction.write(outputStream, true, n7);
                                        for (AMFPacket aMFPacket6 : arrayList) {
                                            n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket6, l21, aMFObj3, this.workBuffer, n7);
                                        }
                                    }
                                }
                                boolean bl7 = true;
                                if (aMFPacket2 == null) {
                                    aMFPacket2 = this.getLastKeyFrame(iMediaStream);
                                    bl7 = false;
                                }
                                if (!bl2) {
                                    aMFPacket2 = null;
                                }
                                if (aMFPacket2 != null) {
                                    if (this.sendFirstVideoFrame) {
                                        AMFPacket aMFPacket7 = iMediaStream.getVideoCodecConfigPacket(aMFPacket2.getAbsTimecode());
                                        if (aMFPacket7 != null) {
                                            n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket7, l21, aMFObj4, this.workBuffer, n7);
                                        }
                                        this.sendFirstVideoFrame = false;
                                        bl6 = true;
                                    }
                                    if (bl6 && this.isEnhancedSeekCapable) {
                                        n += this.packetOutput(outputStream, this.stream.getParent(), this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket2.getFirstByte(), true), l21, aMFObj4, this.workBuffer, n7);
                                    }
                                    lArray[2] = lArray[2] + (long)aMFPacket2.getSize();
                                    lArray[3] = lArray[3] + 1L;
                                    n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket2, l21, aMFObj2, this.workBuffer, n7);
                                    aMFObj2.setNew(true);
                                    if (this.isEnhancedSeekCapable) {
                                        long l24 = aMFPacket2.getSeq();
                                        int n26 = (int)(l24 - l4 + 1L);
                                        if (bl7) {
                                            this.waitForKeyFrame = false;
                                        }
                                        if (bl7 && n26 >= 0 && n26 < n6) {
                                            int n27 = 0;
                                            for (int i = n26; i < n12; ++i) {
                                                AMFPacket aMFPacket8 = (AMFPacket)list2.get(i);
                                                if (aMFPacket8.getType() != 9 || FLVUtils.getFrameType((int)(n9 = aMFPacket8.getFirstByte())) == 3) continue;
                                                lArray[2] = lArray[2] + (long)aMFPacket8.getSize();
                                                lArray[3] = lArray[3] + 1L;
                                                n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket8, l21, aMFObj2, this.workBuffer, n7);
                                                ++n27;
                                            }
                                        }
                                    }
                                    if (bl6 && this.isEnhancedSeekCapable) {
                                        n += this.packetOutput(outputStream, this.stream.getParent(), this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket2.getFirstByte(), false), l21, aMFObj4, this.workBuffer, n7);
                                    }
                                    bl6 = false;
                                }
                                this.trackerStartSeq = liveTracker.trackerSeq;
                                this.sendFirstKeyFrame = false;
                                this.lastReceiveAudio = bl;
                                this.lastReceiveVideo = bl2;
                                this.lastReceiveVideoFPS = n2;
                            } else if (this.lastReceiveAudio != bl) {
                                AMFPacket aMFPacket9;
                                if (bl) {
                                    n += this.stream.getParent().sendLivePlaySeek(outputStream, this.stream.getParent().getName(), l21);
                                }
                                if ((aMFPacket9 = new AMFPacket(8, iMediaStream.getSrc(), 0)) != null) {
                                    lArray[0] = lArray[0] + 0L;
                                    lArray[1] = lArray[1] + 1L;
                                    n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket9, l21, aMFObj, this.workBuffer, n7);
                                }
                                this.lastReceiveAudio = bl;
                            }
                            if (this.sendFirstAudioFrame || this.sendFirstVideoFrame) {
                                if (n20 == 8 && this.sendFirstAudioFrame) {
                                    AMFPacket aMFPacket10;
                                    AMFPacket aMFPacket11 = new AMFPacket(8, iMediaStream.getSrc(), 0);
                                    if (aMFPacket11 != null) {
                                        lArray[0] = lArray[0] + 0L;
                                        lArray[1] = lArray[1] + 1L;
                                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket11, l21, aMFObj, this.workBuffer, n7);
                                        aMFObj.setNew(true);
                                    }
                                    if ((aMFPacket10 = iMediaStream.getAudioCodecConfigPacket(aMFPacket.getAbsTimecode())) != null) {
                                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket10, l21, aMFObj4, this.workBuffer, n7);
                                    }
                                    this.sendFirstAudioFrame = false;
                                } else if (n20 == 9 && this.sendFirstVideoFrame) {
                                    AMFPacket aMFPacket12 = iMediaStream.getVideoCodecConfigPacket(aMFPacket.getAbsTimecode());
                                    if (aMFPacket12 != null) {
                                        n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket12, l21, aMFObj4, this.workBuffer, n7);
                                    }
                                    this.sendFirstVideoFrame = false;
                                    bl6 = true;
                                }
                            }
                            if (bl6 && this.isEnhancedSeekCapable) {
                                n += this.packetOutput(outputStream, this.stream.getParent(), this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket.getFirstByte(), true), l21, aMFObj4, this.workBuffer, n7);
                            }
                            n += this.packetOutput(outputStream, this.stream.getParent(), aMFPacket, l21, aMFObj4, this.workBuffer, n7);
                            if (bl6 && this.isEnhancedSeekCapable) {
                                n += this.packetOutput(outputStream, this.stream.getParent(), this.getEnhanceSeekPacket(this.stream.getParent(), aMFPacket.getFirstByte(), false), l21, aMFObj4, this.workBuffer, n7);
                            }
                            bl6 = false;
                        }
                        l19 = aMFPacket.getSeq();
                        if (!(this.playLen > 0.0) || l21 < Math.round(this.playLen)) continue;
                        if (this.stream.getParent().isSendPlayStopLogEvent()) {
                            this.stream.getParent().setSendPlayStopLogEvent(false);
                            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), "stream", "stop", 200, this.stream.getParent().getName());
                            this.stream.getParent().notifyActionStop();
                        }
                        n += this.stream.getParent().sendPlayStatus(outputStream, l21, 2, 0.0, 0.0);
                        n += this.stream.getParent().sendPlayStop(outputStream, l21, this.stream.getParent().getName());
                        this.playlistEnd = true;
                        break;
                    }
                    if (n3 == 0 || n3 == 1) {
                        this.waitForKeyFrame = true;
                    }
                    if (l19 != -1L) {
                        this.lastSeq = l19;
                    }
                }
            }
            long l25 = 0L;
            if (this.avgPacketSizeCount > (long)(this.avgPacketSizes.length * 2)) {
                l25 = this.avgPacketSizeTotal / (long)this.avgPacketSizes.length;
                if (this.referenceWritePacketSizeThreshold > 0) {
                    boolean bl8 = this.referenceWrite = l25 >= (long)this.referenceWritePacketSizeThreshold;
                }
            }
            if (this.isDebugLog) {
                long l26 = System.currentTimeMillis();
                long l27 = this.lastSendTime == -1L ? 0L : l26 - this.lastSendTime;
                this.lastSendTime = l26;
                WMSLoggerFactory.getLogger(LivePlayer.class).debug("send[" + this.stream.getParent().getClientId() + "]: size:" + n + ":" + l25 + " filter:" + n3 + " time:" + l27 + " tOffset:" + l + " rwrt:" + this.referenceWrite);
            }
            if (liveTracker != null) {
                liveTracker.totalLen = n;
                this.lastSentLiveTracker = liveTracker;
                clientWriteListener.getPendingTracker().putInfo(string, liveTracker);
            }
        }
        return n;
    }

    @Override
    public int play(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        if (this.playLen == 0.0) {
            return this.playKeyFrame(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return this.playAll(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
    }

    @Override
    public int play(OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, long[] lArray) {
        int n = 0;
        if (!this.stream.getParent().isOpen()) {
            return 0;
        }
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream != null) {
            n += this.play(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, lArray);
        }
        return n;
    }

    @Override
    public boolean play(IMediaStream iMediaStream) {
        return this.stream.getParent().isOpen();
    }

    @Override
    public boolean play() {
        IMediaStream iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName());
        if (iMediaStream == null && this.sendStreamNotFound) {
            this.stream.getParent().sendStreamNotFound(this.stream.getParent().getName());
        }
        this.sendStreamNotFound = false;
        return iMediaStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.lastSeq = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetInternal(boolean bl, boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            AMFPacket aMFPacket;
            IMediaStream iMediaStream;
            this.lastSeq = -1L;
            this.lastAudioTC = -1L;
            this.lastVideoTC = -1L;
            this.lastDataTC = -1L;
            this.lastTC = -1L;
            this.firstPacketTC = -1L;
            this.sendFirstKeyFrame = true;
            this.checkStreamProperties = true;
            this.sendFirstVideoFrame = true;
            this.sendFirstAudioFrame = true;
            this.sentPlayStart = false;
            this.lastSendTime = -1L;
            this.waitForKeyFrame = true;
            this.lastTCOffset = 0L;
            this.lastSentLiveTracker = null;
            this.trackerStartSeq = -1L;
            this.trackerBufferTime = 0L;
            this.lastReceiveAudio = true;
            this.lastReceiveVideo = true;
            this.lastReceiveVideoFPS = -1;
            this.playlistEnd = false;
            this.bufferEmptyOnce = false;
            this.sendStreamNotFound = true;
            this.waitForBufferFillStarTime = -1L;
            this.liveSwitch.set(null);
            this.sendPlaySwitch = false;
            if (bl2 && (iMediaStream = this.stream.getParent().getStreams().getStream(this.stream.getParent().getName())) != null && (aMFPacket = this.getLastPacket(iMediaStream)) != null) {
                this.lastSeq = aMFPacket.getSeq();
            }
        }
    }

    @Override
    public void resetNoLookup() {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), "stream", "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(true, false);
    }

    @Override
    public void reset(boolean bl) {
        if (this.stream.getParent().isSendPlayStopLogEvent()) {
            this.stream.getParent().setSendPlayStopLogEvent(false);
            WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(this.lastTC));
            WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream.getParent(), "stream", "stop", 200, this.stream.getParent().getName());
            this.stream.getParent().notifyActionStop();
        }
        this.resetInternal(bl, true);
    }

    @Override
    public void pause(int n, long l) {
    }

    @Override
    public void pauseRaw(int n, long l) {
    }

    @Override
    public void seek(int n) {
    }

    @Override
    public void setBufferTime(int n) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void stopName(String string, String string2, String string3, String string4, double d, double d2, int n) {
    }

    @Override
    public void switchName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        IMediaStream iMediaStream = this.stream.getParent();
        IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
        String string5 = this.stream.getParent().getStreamType();
        boolean bl = false;
        StreamList streamList = iApplicationInstance.getVHost().getStreamTypes();
        StreamItem streamItem = streamList.getStreamDef(string5);
        if (streamItem != null) {
            bl = streamItem.getProperties().getPropertyBoolean("isLiveRepeaterEdge", bl);
        }
        if (bl) {
            string = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, (IClient)iMediaStream.getClient(), (String)string);
        }
        this.liveSwitch.set(new LivePlayerSwitch(string, string2, n));
    }

    @Override
    public void setName(String string, String string2, String string3, String string4, double d, double d2, int n) {
        this.playStart = d;
        this.playLen = d2;
        this.playTransition = n;
    }

    @Override
    public void interruptPlay() {
    }

    @Override
    public void startPlay() {
    }

    @Override
    public void updateLoggingValues() {
        long l = this.lastTC;
        if (l < 0L) {
            l = 0L;
        }
        if (!WMSLoggerFactory.isGlobalLogValueSet((String)"x-spos")) {
            WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(l));
        }
    }

    @Override
    public double length() {
        return 0.0;
    }

    @Override
    public long size() {
        return 0L;
    }

    @Override
    public long getLastTimecodeOffset() {
        return this.lastTCOffset;
    }

    @Override
    public long getLastSentVideoTC() {
        return this.lastVideoTC;
    }

    @Override
    public long getLastSentAudioTC() {
        return this.lastAudioTC;
    }

    @Override
    public long getLastSentDataTC() {
        return this.lastDataTC;
    }

    @Override
    public int getLastVideoFilter() {
        return this.lastTCFilter;
    }

    protected class LiveTracker {
        public long totalLen = 0L;
        public long firstTC = -1L;
        public long lastTC = -1L;
        public long trackerSeq = 0L;

        public LiveTracker() {
            this.trackerSeq = ++LivePlayer.this.trackerSeqSource;
        }
    }
}

