/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer;

import com.wowza.util.HTTPUtils;
import com.wowza.util.IFasterByteArrayWriteReference;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.CupertinoStreamingURL;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerApplicationContextCupertinoStreamer;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.model.HTTPStreamerAdapterBase;
import com.wowza.wms.httpstreamer.model.HTTPStreamerContext;
import com.wowza.wms.httpstreamer.model.HTTPStreamerRequest;
import com.wowza.wms.httpstreamer.model.HTTPStreamerResponse;
import com.wowza.wms.httpstreamer.model.HTTPStreamerStreamNameParts;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IoSession;

public class HTTPStreamerAdapterCupertinoStreamer
extends HTTPStreamerAdapterBase {
    protected boolean debugLog = false;
    protected int requestTimeout = 8000;
    protected int tcpTimeToLive = 500;
    protected int tcpKeepAliveTimeout = 5000;
    protected String playlistMimeType = "application/vnd.apple.mpegurl";
    protected String videoMimeType = "video/MP2T";
    protected String audioAACMimeType = "audio/x-aac";
    protected String audioMP3MimeType = "audio/mpeg";
    protected String keyMimeType = "binary/octet-stream";
    protected String audioOnlyQueryParameter = "wowzaaudioonly";

    public HTTPStreamerAdapterCupertinoStreamer() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
    }

    public void init() {
        super.init();
        this.playlistMimeType = this.getProperties().getPropertyStr("playlistMimeType", this.playlistMimeType);
        this.videoMimeType = this.getProperties().getPropertyStr("videoMimeType", this.videoMimeType);
        this.audioAACMimeType = this.getProperties().getPropertyStr("videoAACMimeType", this.audioAACMimeType);
        this.audioMP3MimeType = this.getProperties().getPropertyStr("videoMP3MimeType", this.audioMP3MimeType);
        this.keyMimeType = this.getProperties().getPropertyStr("keyMimeType", this.keyMimeType);
        this.requestTimeout = this.getProperties().getPropertyInt("requestTimeout", this.requestTimeout);
        this.tcpTimeToLive = this.getProperties().getPropertyInt("tcpTimeToLive", this.tcpTimeToLive);
        this.tcpKeepAliveTimeout = this.getProperties().getPropertyInt("tcpKeepAliveTimeout", this.tcpKeepAliveTimeout);
        this.audioOnlyQueryParameter = this.getProperties().getPropertyStr("audioOnlyQueryParameter", this.audioOnlyQueryParameter);
        if (WMSLoggerFactory.getLogger(null).isDebugEnabled()) {
            this.debugLog = true;
        }
    }

    public boolean canHandle(String string) {
        int n = string.indexOf("?");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        boolean bl = super.canHandle(string);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).debug("HTTPStreamerAdapterCupertinoStreaming.canHandle[" + string + "]: " + bl);
        }
        return bl;
    }

    public void service(IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        long l = System.currentTimeMillis();
        if (rtmpRequestMessage.getType() == 3) {
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            RtmpRequestMessage rtmpRequestMessage2 = rtmpSessionInfo.getAndClearPendingRequest();
            if (rtmpRequestMessage2 != null) {
                this.serviceMsg(l, ioSession, rtmpRequestMessage2, rtmpResponseMessage);
                if (rtmpSessionInfo.isPendingRequest() && l - rtmpRequestMessage2.getCreateTime() > (long)this.requestTimeout) {
                    WMSLoggerFactory.getLogger(null).warn("HTTPStreamerAdapterCupertinoStreaming.service: Request timeout: " + this.requestTimeout);
                    rtmpSessionInfo.getAndClearPendingRequest();
                    rtmpResponseMessage.setResponseCode(404);
                }
            } else {
                long l2 = l - ioSession.getLastIoTime();
                long l3 = ioSession.getScheduledWriteBytes();
                boolean bl = false;
                if (l3 <= 0L) {
                    rtmpSessionInfo.setLastBytesToWriteBytes(-1L);
                    if (rtmpSessionInfo.isCloseOnIdle()) {
                        if (l2 >= (long)this.tcpTimeToLive) {
                            ioSession.close();
                        }
                    } else if (l2 >= (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                } else {
                    long l4 = rtmpSessionInfo.getLastBytesToWriteBytes();
                    long l5 = rtmpSessionInfo.getLastBytesToWriteTimecode();
                    if (l4 == -1L || l4 != l3) {
                        rtmpSessionInfo.setLastBytesToWriteBytes(l3);
                        rtmpSessionInfo.setLastBytesToWriteTimecode(l);
                    } else if (l - l5 > (long)this.tcpKeepAliveTimeout) {
                        ioSession.close();
                        bl = true;
                    }
                }
                if (!bl) {
                    Set set = rtmpSessionInfo.getHTTPSession();
                    for (IHTTPStreamerSession iHTTPStreamerSession : set) {
                        iHTTPStreamerSession.touch(l);
                    }
                }
            }
        } else {
            this.serviceMsg(l, ioSession, rtmpRequestMessage, rtmpResponseMessage);
        }
    }

    public void serviceMsg(long l, IoSession ioSession, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        try {
            int n;
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            String string = rtmpRequestMessage.getPath();
            if (this.debugLog) {
                WMSLoggerFactory.getLogger(null).debug("HTTPStreamerAdapterCupertinoStreaming.service: " + string);
            }
            HTTPStreamerRequest hTTPStreamerRequest = new HTTPStreamerRequest(rtmpRequestMessage);
            HTTPStreamerResponse hTTPStreamerResponse = new HTTPStreamerResponse(rtmpResponseMessage);
            IVHost iVHost = rtmpRequestMessage.getVHost();
            String string2 = hTTPStreamerRequest.getHeader("range");
            String string3 = hTTPStreamerRequest.getHeader("connection");
            boolean bl = false;
            if (string3 != null && string3.equalsIgnoreCase("close")) {
                bl = true;
            }
            rtmpSessionInfo.setCloseOnIdle(bl);
            boolean bl2 = false;
            if (string2 != null && (string2 = string2.trim()).length() > 0 && (n = string2.indexOf("=")) >= 0 && (string2 = string2.substring(n + 1)).equals("0-1")) {
                bl2 = true;
            }
            if ((n = string.indexOf("?")) >= 0) {
                string = string.substring(0, n);
            }
            if (bl2) {
                this.onCheckAvailibility(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".m3u") || string.endsWith(".m3u8")) {
                this.onPlaylist(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".m3u8key")) {
                this.onEncKey(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            } else if (string.endsWith(".ts") || string.endsWith(".aac") || string.endsWith(".mp3")) {
                this.onMediaFile(l, ioSession, iVHost, (IHTTPRequest)hTTPStreamerRequest, (IHTTPResponse)hTTPStreamerResponse);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).error("HTTPStreamerAdapterCupertinoStreaming.service: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void onCheckAvailibility(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block16: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block16;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).info("onCheckAvailibility: " + string);
                }
                if ((cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block16;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName(), true);
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onCheckAvailibility: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block16;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                boolean bl3 = this.isLive(iApplicationInstance);
                boolean bl4 = this.isRepeater(iApplicationInstance);
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(null, iApplicationInstance, bl4, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block16;
                String string5 = "";
                if (hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                    boolean bl5 = HTTPStreamerSessionCupertino.doesFileExist(iHTTPStreamerApplicationContext, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (!bl5) break block16;
                    string5 = "#E";
                } else if (bl3) {
                    ILiveStreamPacketizer iLiveStreamPacketizer;
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    if (bl4) {
                        this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                    }
                    if ((iLiveStreamPacketizer = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                        if (bl4) {
                            bl = true;
                        } else {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                        }
                        break block16;
                    }
                    string5 = "#E";
                } else {
                    boolean bl6 = HTTPStreamerSessionCupertino.doesFileExist(iHTTPStreamerApplicationContext, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (!bl6) break block16;
                    string5 = "#E";
                }
                iHTTPResponse.setHeader("Content-Type", "application/x-mpegURL");
                iHTTPResponse.setHeader("Cache-Control", "no-cache");
                iHTTPResponse.setHeader("Date", this.getHTTPDate());
                OutputStream outputStream = iHTTPResponse.getOutputStream();
                outputStream.write(string5.getBytes());
                bl2 = true;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).error("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    protected IHTTPStreamerSession createSession(IHTTPRequest iHTTPRequest, IApplicationInstance iApplicationInstance, String string, String string2) {
        int n;
        int n2;
        HTTPStreamerSessionCupertino hTTPStreamerSessionCupertino = new HTTPStreamerSessionCupertino();
        String string3 = iHTTPRequest.getHeader("referrer");
        hTTPStreamerSessionCupertino.setReferrer(string3);
        String string4 = iHTTPRequest.getHeader("host");
        int n3 = 80;
        if (string4 != null && (n2 = string4.indexOf(":")) >= 0) {
            try {
                n3 = Integer.parseInt(string4.substring(n2 + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string4 = string4.substring(0, n2);
        }
        hTTPStreamerSessionCupertino.setServerIp(string4);
        hTTPStreamerSessionCupertino.setServerPort(n3);
        String string5 = iHTTPRequest.getHeader("context");
        String string6 = null;
        if (string5 != null && (n = (string5 = HTTPStreamerUtils.urlDecode((String)string5)).indexOf("?")) > 0) {
            string6 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        hTTPStreamerSessionCupertino.setUri(string5);
        hTTPStreamerSessionCupertino.setQueryStr(string6);
        hTTPStreamerSessionCupertino.setUserAgent(iHTTPRequest.getHeader("user-agent"));
        hTTPStreamerSessionCupertino.setCookieStr(iHTTPRequest.getHeader("cookie"));
        hTTPStreamerSessionCupertino.addStreamDomainStr(string2);
        this.createSession((IHTTPStreamerSession)hTTPStreamerSessionCupertino, iApplicationInstance, string);
        return hTTPStreamerSessionCupertino;
    }

    public void onPlaylist(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block83: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                Object object;
                Object object2;
                Object object3;
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block83;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).info("onPlaylist: " + string);
                }
                if ((cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block83;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                String string5 = cupertinoStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                boolean bl3 = map.containsKey(this.audioOnlyQueryParameter);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName(), true);
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block83;
                }
                HTTPStreamerApplicationContextCupertinoStreamer hTTPStreamerApplicationContextCupertinoStreamer = (HTTPStreamerApplicationContextCupertinoStreamer)iHTTPStreamerApplicationContext;
                String string6 = hTTPStreamerApplicationContextCupertinoStreamer.getPlaylistHostDomain();
                String string7 = iHTTPRequest.getHeader("host");
                string7 = string6 != null ? hTTPStreamerApplicationContextCupertinoStreamer.getPlaylistHostProtocol() + string6 : (string7 != null ? hTTPStreamerApplicationContextCupertinoStreamer.getPlaylistHostProtocol() + string7 : "");
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string8 = this.getStreamDomainStr(iApplicationInstance, string4);
                String string9 = this.parseSessionId(string5);
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (string9 != null) {
                    iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string9);
                }
                boolean bl4 = false;
                boolean bl5 = false;
                if (iHTTPStreamerSession == null) {
                    bl4 = true;
                    bl5 = true;
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, string9, string8);
                    if (string9 != null && string9.equals(iHTTPStreamerSession.getSessionId())) {
                        bl4 = false;
                    }
                }
                boolean bl6 = this.isLive(iApplicationInstance);
                boolean bl7 = this.isRepeater(iApplicationInstance);
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl7, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block83;
                if (iHTTPStreamerSession == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: Should not get here [" + string + "]: " + string2 + "/" + string3);
                    break block83;
                }
                if (bl5) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                map.put("wowzasessionid", iHTTPStreamerSession.getSessionId());
                String string10 = HTTPUtils.assembleQueryStr((Map)map);
                rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                if (bl6 && bl7 && !hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                    ILiveStreamPacketizer iLiveStreamPacketizer;
                    object3 = iApplicationInstance.getStreams();
                    if (bl7) {
                        this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                    }
                    if ((iLiveStreamPacketizer = object3.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                        if (bl7) {
                            bl = true;
                        } else {
                            WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                        }
                        break block83;
                    }
                }
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        iHTTPStreamerSession.setLiveStreamingPacketizer(this.liveStreamPacketizer);
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "cupertino", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                        iHTTPStreamerSession.setSessionType(bl6 ? 1 : 2);
                    }
                    iHTTPStreamerSession.touch(l);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block83;
                }
                if (bl5) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block83;
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string8)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block83;
                }
                object3 = "";
                boolean bl8 = false;
                boolean bl9 = false;
                if (hTTPStreamerStreamNameParts.streamExt.equals("smil")) {
                    object2 = iHTTPStreamerSession.getUserQueryStr();
                    if (object2 != null) {
                        if (string10.length() > 0) {
                            string10 = string10 + "&";
                        }
                        string10 = string10 + (String)object2;
                    }
                    if ((object = ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName)) == null) break block83;
                    object3 = object.getPlaylistStr(bl3);
                    bl4 = false;
                    bl8 = true;
                    if (iHTTPStreamerSession != null) {
                        iHTTPStreamerSession.addStreamDomainStrs(object.getStreamNamesRaw());
                        if (bl7) {
                            iHTTPStreamerSession.lockRepeaterStreams(object.getStreamNames(), this.liveStreamPacketizer, this.liveStreamRepeater, iHTTPStreamerApplicationContext.getStreamTypeStr());
                        }
                    }
                } else if (bl4) {
                    int n;
                    object2 = iHTTPStreamerSession.getUserQueryStr();
                    if (object2 != null) {
                        if (string10.length() > 0) {
                            string10 = string10 + "&";
                        }
                        string10 = string10 + (String)object2;
                    }
                    if ((n = ((String)(object = string)).indexOf("?")) > 0) {
                        object = ((String)object).substring(0, n);
                    }
                    boolean bl10 = hTTPStreamerApplicationContextCupertinoStreamer.isAutoCreateMultibitratePlaylist();
                    boolean bl11 = hTTPStreamerApplicationContextCupertinoStreamer.isUseCalculatedVideoBitrate();
                    boolean bl12 = hTTPStreamerApplicationContextCupertinoStreamer.isUseCalculatedAudioBitrate();
                    boolean bl13 = hTTPStreamerApplicationContextCupertinoStreamer.isCalculatePlaylistBitrates();
                    boolean bl14 = hTTPStreamerApplicationContextCupertinoStreamer.isCalculateCodecs();
                    boolean bl15 = hTTPStreamerApplicationContextCupertinoStreamer.isCalculateResolution();
                    boolean bl16 = hTTPStreamerApplicationContextCupertinoStreamer.isRelativePlaylistPlaylists();
                    int n2 = hTTPStreamerApplicationContextCupertinoStreamer.getDefaultVideoBitrate();
                    int n3 = hTTPStreamerApplicationContextCupertinoStreamer.getDefaultAudioBitrate();
                    int n4 = hTTPStreamerApplicationContextCupertinoStreamer.getMaxCalulatedAudioBitrate();
                    int n5 = hTTPStreamerApplicationContextCupertinoStreamer.getMaxCalulatedVideoBitrate();
                    int n6 = hTTPStreamerApplicationContextCupertinoStreamer.getBitrateAdjustmentFactor();
                    String string11 = "";
                    String string12 = "";
                    String string13 = "";
                    LiveStreamPacketizerCupertino liveStreamPacketizerCupertino = null;
                    boolean bl17 = false;
                    IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex = null;
                    if (bl10 || bl13) {
                        Object object4;
                        if (bl6) {
                            ILiveStreamPacketizer iLiveStreamPacketizer;
                            object4 = iApplicationInstance.getStreams();
                            if (bl7) {
                                this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                            }
                            if ((iLiveStreamPacketizer = object4.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                                if (bl7) {
                                    bl = true;
                                } else {
                                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                                }
                            } else {
                                String string14;
                                String string15;
                                liveStreamPacketizerCupertino = (LiveStreamPacketizerCupertino)iLiveStreamPacketizer;
                                bl17 = liveStreamPacketizerCupertino.isAudioOnlyRendition();
                                String string16 = liveStreamPacketizerCupertino.getCodecsStr();
                                if (string16 != null) {
                                    string12 = ",CODECS=\"" + string16 + "\"";
                                }
                                if ((string15 = liveStreamPacketizerCupertino.getCodecsAudioStr()) != null) {
                                    string13 = ",CODECS=\"" + string15 + "\"";
                                }
                                if ((string14 = liveStreamPacketizerCupertino.getResolutionStr()) != null) {
                                    string11 = ",RESOLUTION=" + string14;
                                }
                            }
                        } else {
                            iHTTPStreamerCupertinoIndex = ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                            if (iHTTPStreamerCupertinoIndex != null) {
                                String string17;
                                String string18;
                                bl17 = iHTTPStreamerCupertinoIndex.getAudioBitrate() > 0 && iHTTPStreamerCupertinoIndex.getVideoBitrate() > 0;
                                object4 = iHTTPStreamerCupertinoIndex.getCodecsStr();
                                if (object4 != null) {
                                    string12 = ",CODECS=\"" + (String)object4 + "\"";
                                }
                                if ((string18 = iHTTPStreamerCupertinoIndex.getCodecsAudioStr()) != null) {
                                    string13 = ",CODECS=\"" + string18 + "\"";
                                }
                                if ((string17 = iHTTPStreamerCupertinoIndex.getResolutionStr()) != null) {
                                    string11 = ",RESOLUTION=" + string17;
                                }
                            }
                        }
                    }
                    if (bl) break block83;
                    if (bl11) {
                        long l2 = 0L;
                        if (liveStreamPacketizerCupertino != null) {
                            l2 = liveStreamPacketizerCupertino.getCalculatedBitrate();
                        } else if (iHTTPStreamerCupertinoIndex != null) {
                            l2 = iHTTPStreamerCupertinoIndex.getAudioBitrate() + iHTTPStreamerCupertinoIndex.getVideoBitrate() + iHTTPStreamerCupertinoIndex.getID3Bitrate(false);
                        }
                        if (l2 > 0L) {
                            l2 = l2 * (long)n6 / 100L;
                        }
                        if (l2 > 0L) {
                            n2 = (int)l2;
                            if (n5 > 0 && n2 > n5) {
                                n2 = n5;
                            }
                        }
                    }
                    if (bl12) {
                        long l3 = 0L;
                        if (liveStreamPacketizerCupertino != null) {
                            l3 = liveStreamPacketizerCupertino.getCalculatedAudioBitrate();
                        } else if (iHTTPStreamerCupertinoIndex != null) {
                            l3 = iHTTPStreamerCupertinoIndex.getAudioBitrate() + iHTTPStreamerCupertinoIndex.getID3Bitrate(true);
                        }
                        if (l3 > 0L) {
                            l3 = l3 * (long)n6 / 100L;
                        }
                        if (l3 > 0L) {
                            n3 = (int)l3;
                            if (n4 > 0 && n3 > n4) {
                                n3 = n4;
                            }
                        }
                    }
                    if (!bl14) {
                        string12 = "";
                        string13 = "";
                    }
                    if (!bl15) {
                        string11 = "";
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("#EXTM3U\n");
                    stringBuffer.append("#EXT-X-STREAM-INF:PROGRAM-ID=1,BANDWIDTH=" + n2 + string12 + string11 + "\n");
                    stringBuffer.append((bl16 ? "playlist.m3u8" : string7 + "/" + HTTPStreamerUtils.urlEncode((String)object)) + "?" + string10 + "\n");
                    if (bl10 && bl17) {
                        stringBuffer.append("#EXT-X-STREAM-INF:PROGRAM-ID=1,BANDWIDTH=" + n3 + string13 + "\n");
                        stringBuffer.append((bl16 ? "playlist.m3u8" : string7 + "/" + HTTPStreamerUtils.urlEncode((String)object)) + "?" + this.audioOnlyQueryParameter + "&" + string10 + "\n");
                    }
                    object3 = stringBuffer.toString();
                } else {
                    if (bl6) {
                        object2 = iApplicationInstance.getStreams();
                        if (bl7) {
                            this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                        }
                        if ((object = object2.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                            if (bl7) {
                                bl = true;
                            } else {
                                WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                            }
                            break block83;
                        }
                        object3 = bl3 ? ((LiveStreamPacketizerCupertino)object).getPlaylistAudioStr() : ((LiveStreamPacketizerCupertino)object).getPlaylistStr();
                        bl9 = ((LiveStreamPacketizerCupertino)object).isEmptyPlaylist();
                        if (bl9) {
                            bl = true;
                            break block83;
                        }
                    } else {
                        object2 = ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                        if (object2 == null) break block83;
                        object3 = object2.getPlaylistStr(bl3);
                    }
                    bl8 = true;
                }
                if (object3 == null) {
                    if (bl7) {
                        bl = true;
                    }
                } else if (((String)object3).length() <= 0) {
                    if (bl7) {
                        bl = true;
                    }
                } else {
                    if (bl8) {
                        object3 = ((String)object3).replace("{domain}", string7);
                        object3 = ((String)object3).replace("{application}", HTTPStreamerUtils.urlEncode((String)string2));
                        object3 = ((String)object3).replace("{appInstance}", HTTPStreamerUtils.urlEncode((String)string3));
                        object3 = ((String)object3).replace("{stream}", HTTPStreamerUtils.urlEncode((String)string4));
                        object3 = ((String)object3).replace("{query}", string10);
                        object3 = ((String)object3).replace("{audioOnly}", "&" + this.audioOnlyQueryParameter);
                    }
                    if (this.debugLog) {
                        System.out.println(this.playlistMimeType + ":\n" + (String)object3);
                    }
                    iHTTPResponse.setHeader("Content-Type", this.playlistMimeType);
                    iHTTPResponse.setHeader("Cache-Control", "no-cache");
                    iHTTPResponse.setHeader("Date", this.getHTTPDate());
                    object2 = ((String)object3).getBytes();
                    object = iHTTPResponse.getOutputStream();
                    ((OutputStream)object).write((byte[])object2);
                    bl2 = true;
                    if (object2 != null && iHTTPStreamerSession != null) {
                        iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(((Object)object2).length + iHTTPResponse.getHeaderSize()), 1L);
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).error("HTTPStreamerAdapterCupertinoStreaming.onPlaylist: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    public void onEncKey(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block20: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            try {
                Object object;
                Object object2;
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block20;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).info("onEncKey: " + string);
                }
                if ((cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block20;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                String string5 = cupertinoStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                boolean bl3 = map.containsKey(this.audioOnlyQueryParameter);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName());
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onEncKey: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block20;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string6 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl4 = this.isLive(iApplicationInstance);
                boolean bl5 = this.isRepeater(iApplicationInstance);
                String string7 = this.parseSessionId(string5);
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (string7 != null) {
                    iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string7);
                }
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl5, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block20;
                boolean bl6 = true;
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "cupertino", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                    }
                    iHTTPStreamerSession.touch(l);
                    bl6 = iHTTPStreamerSession.isActive();
                    rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onEncKey: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block20;
                }
                if (!bl6 || iHTTPStreamerSession == null) break block20;
                map.put("wowzasessionid", iHTTPStreamerSession.getSessionId());
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string6)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block20;
                }
                CupertinoEncInfo cupertinoEncInfo = null;
                if (bl4) {
                    object2 = iApplicationInstance.getStreams();
                    object = object2.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false);
                    if (object == null) {
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: LiveStreamPacketizer not found [" + string + "]: " + this.liveStreamPacketizer);
                        break block20;
                    }
                    cupertinoEncInfo = ((LiveStreamPacketizerCupertino)object).getEncryptionInfo();
                } else {
                    IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex = object2 = iHTTPStreamerSession == null ? null : ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (object2 == null) break block20;
                    cupertinoEncInfo = object2.getEncInfo();
                }
                if (cupertinoEncInfo != null && cupertinoEncInfo.isInternal() && (object2 = (Object)cupertinoEncInfo.getEncKeyBytes()) != null) {
                    iApplicationInstance.getModFunctions().onHTTPCupertinoEncryptionKeyRequest((HTTPStreamerSessionCupertino)iHTTPStreamerSession, iHTTPRequest, iHTTPResponse);
                    if (!iHTTPStreamerSession.isAcceptSession()) {
                        iHTTPResponse.setResponseCode(403);
                        bl2 = true;
                    } else {
                        iHTTPResponse.setHeader("Content-Type", this.keyMimeType);
                        iHTTPResponse.setHeader("Cache-Control", "no-cache");
                        iHTTPResponse.setHeader("Date", this.getHTTPDate());
                        object = iHTTPResponse.getOutputStream();
                        ((OutputStream)object).write((byte[])object2);
                        if (object2 != null && iHTTPStreamerSession != null) {
                            iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(((MediaStreamMap)object2).length + iHTTPResponse.getHeaderSize()), 1L);
                        }
                        bl2 = true;
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).error("HTTPStreamerAdapterCupertinoStreaming.onEncKey: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (!bl2) {
            if (bl) {
                rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            } else {
                iHTTPResponse.setResponseCode(404);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMediaFile(long l, IoSession ioSession, IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        RtmpSessionInfo rtmpSessionInfo;
        boolean bl;
        boolean bl2;
        block33: {
            bl2 = false;
            bl = false;
            rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            int n = 0;
            try {
                Object object;
                CupertinoStreamingURL cupertinoStreamingURL;
                String string = iHTTPRequest.getHeader("context");
                if (string == null) break block33;
                string = HTTPStreamerUtils.urlDecode((String)string);
                if (this.debugLog) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).info("onMediaFile: " + string);
                }
                if ((cupertinoStreamingURL = new CupertinoStreamingURL(string, true)) == null) break block33;
                String string2 = cupertinoStreamingURL.getAppName();
                String string3 = cupertinoStreamingURL.getAppInstanceName();
                String string4 = cupertinoStreamingURL.getStreamName();
                String string5 = cupertinoStreamingURL.getQueryStr();
                Map map = HTTPUtils.splitQueryStr((String)string5);
                boolean bl3 = map.containsKey(this.audioOnlyQueryParameter);
                IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = this.getHTTPStreamerAppContext(iVHost, string2, string3, this.getAdapterName());
                if (iHTTPStreamerApplicationContext == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onMediaFile: Application context not loaded [" + string + "]: " + string2 + "/" + string3);
                    break block33;
                }
                IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
                this.setThreadContext(iApplicationInstance);
                String string6 = this.getStreamDomainStr(iApplicationInstance, string4);
                boolean bl4 = this.isLive(iApplicationInstance);
                boolean bl5 = this.isRepeater(iApplicationInstance);
                String string7 = this.parseSessionId(string5);
                HTTPStreamerContext hTTPStreamerContext = iVHost.getHTTPStreamerContext();
                IHTTPStreamerSession iHTTPStreamerSession = null;
                if (string7 != null) {
                    iHTTPStreamerSession = hTTPStreamerContext.getSessions().getSession(string7);
                }
                boolean bl6 = false;
                if (iHTTPStreamerSession == null) {
                    iHTTPStreamerSession = this.createSession(iHTTPRequest, iApplicationInstance, string7, string6);
                    bl6 = true;
                }
                HTTPStreamerStreamNameParts hTTPStreamerStreamNameParts = this.resolveStreamName(iHTTPStreamerSession, iApplicationInstance, bl5, string4);
                if (hTTPStreamerStreamNameParts.resolvedName == null) break block33;
                if (bl6) {
                    iHTTPStreamerSession.setStreamExt(hTTPStreamerStreamNameParts.streamExt);
                    iHTTPStreamerSession.setStreamName(hTTPStreamerStreamNameParts.resolvedName);
                }
                boolean bl7 = true;
                int n2 = 0;
                if (iHTTPStreamerSession != null) {
                    if (!iHTTPStreamerSession.isValidated()) {
                        this.markSessionValid(iApplicationInstance, hTTPStreamerStreamNameParts.resolvedName, hTTPStreamerStreamNameParts.streamExt, string5, "cupertino", iHTTPStreamerSession, iHTTPRequest.getRemoteAddr());
                    }
                    iHTTPStreamerSession.touch(l);
                    bl7 = iHTTPStreamerSession.isActive();
                    n2 = iHTTPStreamerSession.getSessionType();
                    rtmpSessionInfo.addHTTPSession(iHTTPStreamerSession);
                }
                if (!iHTTPStreamerSession.isValidated()) {
                    WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.onMediaFile: Over license limit");
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block33;
                }
                if (bl6) {
                    this.notifySessionCreate(iHTTPStreamerSession, iApplicationInstance);
                }
                if (!iHTTPStreamerSession.isValidStreamDomainStr(string6)) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block33;
                }
                if (!bl7) break block33;
                if (iHTTPStreamerSession != null && !iHTTPStreamerSession.isAcceptSession()) {
                    iHTTPResponse.setResponseCode(403);
                    bl2 = true;
                    break block33;
                }
                int n3 = string.lastIndexOf("/");
                if (n3 < 0) break block33;
                String string8 = string.substring(n3 + 1);
                int n4 = string8.indexOf("?");
                if (n4 >= 0) {
                    string8 = string8.substring(0, n4);
                }
                if (n2 == 0) {
                    n2 = bl4 ? 1 : 2;
                }
                LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk = null;
                if (n2 == 2) {
                    IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex;
                    IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex2 = iHTTPStreamerCupertinoIndex = iHTTPStreamerSession == null ? null : ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).getIndex(iHTTPStreamerApplicationContext, iHTTPStreamerSession, string4, hTTPStreamerStreamNameParts.streamExt, hTTPStreamerStreamNameParts.resolvedName);
                    if (iHTTPStreamerCupertinoIndex == null) break block33;
                    liveStreamPacketizerCupertinoChunk = iHTTPStreamerCupertinoIndex.getChunk(string8, bl3);
                    ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).logVODChunk(liveStreamPacketizerCupertinoChunk);
                } else {
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    if (bl5) {
                        this.startLiveStreamRepeat(iHTTPStreamerApplicationContext, hTTPStreamerStreamNameParts.repeaterName);
                    }
                    if ((object = mediaStreamMap.getLiveStreamPacketizer(hTTPStreamerStreamNameParts.resolvedName, this.liveStreamPacketizer, false)) == null) {
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).warn("HTTPStreamerAdapterCupertinoStreaming.getAppInstance: Stream not found [" + string + "]: " + hTTPStreamerStreamNameParts.resolvedName);
                        break block33;
                    }
                    liveStreamPacketizerCupertinoChunk = bl3 ? ((LiveStreamPacketizerCupertino)object).getChunkAudioByFilename(string8) : ((LiveStreamPacketizerCupertino)object).getChunkByFilename(string8);
                    ((HTTPStreamerSessionCupertino)iHTTPStreamerSession).logLiveChunk(liveStreamPacketizerCupertinoChunk);
                }
                if (liveStreamPacketizerCupertinoChunk != null) {
                    void var35_41;
                    if (!iHTTPStreamerSession.checkAndSetPlayLogged()) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iHTTPStreamerSession.getStream(), "stream", "play", 200, iHTTPStreamerSession.getStreamName());
                    }
                    String string9 = this.videoMimeType;
                    switch (liveStreamPacketizerCupertinoChunk.getStreamMode()) {
                        case 3: {
                            String string10 = this.audioAACMimeType;
                            break;
                        }
                        case 2: {
                            String string11 = this.audioMP3MimeType;
                            break;
                        }
                    }
                    iHTTPResponse.setHeader("Content-Type", (String)var35_41);
                    iHTTPResponse.setHeader("Cache-Control", liveStreamPacketizerCupertinoChunk.isCacheable() ? "public" : "no-cache");
                    iHTTPResponse.setHeader("Date", this.getHTTPDate());
                    object = iHTTPResponse.getOutputStream();
                    IFasterByteArrayWriteReference iFasterByteArrayWriteReference = null;
                    if (object instanceof IFasterByteArrayWriteReference) {
                        iFasterByteArrayWriteReference = (IFasterByteArrayWriteReference)object;
                    }
                    List<LiveStreamingCupertinoBlock> list = liveStreamPacketizerCupertinoChunk.getBlockList();
                    for (LiveStreamingCupertinoBlock liveStreamingCupertinoBlock : list) {
                        if (iFasterByteArrayWriteReference != null) {
                            iFasterByteArrayWriteReference.write(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen(), true);
                        } else {
                            ((OutputStream)object).write(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen());
                        }
                        n += liveStreamingCupertinoBlock.getLen();
                    }
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).info("onMediaFile: contentLength:" + n);
                    }
                    if (iHTTPStreamerSession != null) {
                        LiveStreamingCupertinoBlock liveStreamingCupertinoBlock;
                        liveStreamingCupertinoBlock = iHTTPStreamerSession.getStream();
                        if (liveStreamingCupertinoBlock != null) {
                            liveStreamingCupertinoBlock.getMediaIOPerformance().incrementMessagesOut((long)n, 1L);
                        }
                        iHTTPStreamerSession.getIOPerformanceCounter().incrementMessagesOut((long)(n + iHTTPResponse.getHeaderSize()), 1L);
                    }
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerAdapterCupertinoStreamer.class).error("HTTPStreamerAdapterCupertinoStreaming.onMediaFile: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (bl2) return;
        if (bl) {
            rtmpSessionInfo.setPendingRequest(((HTTPStreamerRequest)iHTTPRequest).getRTMPRequest());
            return;
        }
        iHTTPResponse.setResponseCode(404);
    }
}

