/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndexItem;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.IHTTPStreamerCupertinoVODActionNotify;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.model.HTTPStreamerApplicationContextBase;
import com.wowza.wms.httpstreamer.model.HTTPStreamerItem;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPStreamerApplicationContextCupertinoStreamer
extends HTTPStreamerApplicationContextBase {
    private boolean autoCreateMultibitratePlaylist = false;
    private boolean useCalculatedVideoBitrate = true;
    private boolean useCalculatedAudioBitrate = true;
    private boolean calculatePlaylistBitrates = true;
    private boolean calculateCodecs = false;
    private boolean calculateResolution = false;
    private boolean relativePlaylistPlaylists = false;
    private int defaultVideoBitrate = 250000;
    private int defaultAudioBitrate = 64000;
    private int maxCalulatedAudioBitrate = 0;
    private int maxCalulatedVideoBitrate = 0;
    private int bitrateAdjustmentFactor = 110;
    private String playlistHostDomain = null;
    private String playlistHostProtocol = "http://";
    private Set<IHTTPStreamerCupertinoVODActionNotify> vodActionListeners = new HashSet<IHTTPStreamerCupertinoVODActionNotify>();

    public void init(IApplicationInstance iApplicationInstance, HTTPStreamerItem hTTPStreamerItem) {
        super.init(iApplicationInstance, hTTPStreamerItem);
        WMSProperties wMSProperties = this.getProperties();
        this.defaultVideoBitrate = wMSProperties.getPropertyInt("cupertinoDefaultVideoBitrate", this.defaultVideoBitrate);
        this.maxCalulatedVideoBitrate = wMSProperties.getPropertyInt("cupertinoMaxCalulatedVideoBitrate", this.maxCalulatedVideoBitrate);
        this.defaultAudioBitrate = wMSProperties.getPropertyInt("cupertinoDefaultAudioBitrate", this.defaultAudioBitrate);
        this.maxCalulatedAudioBitrate = wMSProperties.getPropertyInt("cupertinoMaxCalulatedAudioBitrate", this.maxCalulatedAudioBitrate);
        this.bitrateAdjustmentFactor = wMSProperties.getPropertyInt("cupertinoBitrateAdjustmentFactor", this.bitrateAdjustmentFactor);
        this.autoCreateMultibitratePlaylist = wMSProperties.getPropertyBoolean("cupertinoAutoCreateMultibitratePlaylist", this.autoCreateMultibitratePlaylist);
        this.useCalculatedVideoBitrate = wMSProperties.getPropertyBoolean("cupertinoUseCalculatedVideoBitrate", this.useCalculatedVideoBitrate);
        this.useCalculatedAudioBitrate = wMSProperties.getPropertyBoolean("cupertinoUseCalculatedAudioBitrate", this.useCalculatedAudioBitrate);
        this.relativePlaylistPlaylists = wMSProperties.getPropertyBoolean("cupertinoRelativePlaylistPlaylists", this.relativePlaylistPlaylists);
        this.calculateCodecs = wMSProperties.getPropertyBoolean("cupertinoCalculateCodecs", this.calculateCodecs);
        this.calculateResolution = wMSProperties.getPropertyBoolean("cupertinoCalculateResolution", this.calculateResolution);
        this.playlistHostDomain = wMSProperties.getPropertyStr("cupertinoPlaylistHostDomain", this.playlistHostDomain);
        this.playlistHostProtocol = wMSProperties.getPropertyStr("cupertinoPlaylistHostProtocol", this.playlistHostProtocol);
        this.calculatePlaylistBitrates = this.useCalculatedVideoBitrate || this.useCalculatedAudioBitrate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVODActionListener(IHTTPStreamerCupertinoVODActionNotify iHTTPStreamerCupertinoVODActionNotify) {
        Set<IHTTPStreamerCupertinoVODActionNotify> set = this.vodActionListeners;
        synchronized (set) {
            this.vodActionListeners.add(iHTTPStreamerCupertinoVODActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeVODActionListener(IHTTPStreamerCupertinoVODActionNotify iHTTPStreamerCupertinoVODActionNotify) {
        Set<IHTTPStreamerCupertinoVODActionNotify> set = this.vodActionListeners;
        synchronized (set) {
            return this.vodActionListeners.remove(iHTTPStreamerCupertinoVODActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IHTTPStreamerCupertinoVODActionNotify> getVODListeners() {
        ArrayList<IHTTPStreamerCupertinoVODActionNotify> arrayList = null;
        Set<IHTTPStreamerCupertinoVODActionNotify> set = this.vodActionListeners;
        synchronized (set) {
            if (this.vodActionListeners.size() > 0) {
                arrayList = new ArrayList<IHTTPStreamerCupertinoVODActionNotify>(this.vodActionListeners);
            }
        }
        return arrayList;
    }

    public void notifyVODListenerOnCreate(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex, IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, IHTTPStreamerSession iHTTPStreamerSession, String string, String string2, String string3) {
        List<IHTTPStreamerCupertinoVODActionNotify> list = this.getVODListeners();
        if (list != null) {
            for (IHTTPStreamerCupertinoVODActionNotify iHTTPStreamerCupertinoVODActionNotify : list) {
                try {
                    iHTTPStreamerCupertinoVODActionNotify.onCreate(iHTTPStreamerCupertinoIndex, iHTTPStreamerApplicationContext, iHTTPStreamerSession, string, string2, string3);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerApplicationContextCupertinoStreamer.class).error("HTTPStreamerApplicationContextCupertinoStreamer.notifyVODListenerOnCreate: " + exception.toString());
                }
            }
        }
    }

    public void notifyVODListenerOnInit(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex, IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, IHTTPStreamerSession iHTTPStreamerSession, String string, String string2, String string3) {
        List<IHTTPStreamerCupertinoVODActionNotify> list = this.getVODListeners();
        if (list != null) {
            for (IHTTPStreamerCupertinoVODActionNotify iHTTPStreamerCupertinoVODActionNotify : list) {
                try {
                    iHTTPStreamerCupertinoVODActionNotify.onInit(iHTTPStreamerCupertinoIndex, iHTTPStreamerApplicationContext, iHTTPStreamerSession, string, string2, string3);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerApplicationContextCupertinoStreamer.class).error("HTTPStreamerApplicationContextCupertinoStreamer.notifyVODListenerOnInit: " + exception.toString());
                }
            }
        }
    }

    public void notifyVODListenerOnOpen(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex, IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, IHTTPStreamerSession iHTTPStreamerSession, String string, String string2, String string3) {
        List<IHTTPStreamerCupertinoVODActionNotify> list = this.getVODListeners();
        if (list != null) {
            for (IHTTPStreamerCupertinoVODActionNotify iHTTPStreamerCupertinoVODActionNotify : list) {
                try {
                    iHTTPStreamerCupertinoVODActionNotify.onOpen(iHTTPStreamerCupertinoIndex, iHTTPStreamerApplicationContext, iHTTPStreamerSession, string, string2, string3);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerApplicationContextCupertinoStreamer.class).error("HTTPStreamerApplicationContextCupertinoStreamer.notifyVODListenerOnOpen: " + exception.toString());
                }
            }
        }
    }

    public void notifyVODListenerOnIndex(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex, IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, IHTTPStreamerSession iHTTPStreamerSession, String string, String string2, String string3) {
        List<IHTTPStreamerCupertinoVODActionNotify> list = this.getVODListeners();
        if (list != null) {
            for (IHTTPStreamerCupertinoVODActionNotify iHTTPStreamerCupertinoVODActionNotify : list) {
                try {
                    iHTTPStreamerCupertinoVODActionNotify.onIndex(iHTTPStreamerCupertinoIndex, iHTTPStreamerApplicationContext, iHTTPStreamerSession, string, string2, string3);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerApplicationContextCupertinoStreamer.class).error("HTTPStreamerApplicationContextCupertinoStreamer.notifyVODListenerOnIndex: " + exception.toString());
                }
            }
        }
    }

    public void notifyVODListenerOnFillChunkStart(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex, IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem, LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, boolean bl) {
        List<IHTTPStreamerCupertinoVODActionNotify> list = this.getVODListeners();
        if (list != null) {
            for (IHTTPStreamerCupertinoVODActionNotify iHTTPStreamerCupertinoVODActionNotify : list) {
                try {
                    iHTTPStreamerCupertinoVODActionNotify.onFillChunkStart(iHTTPStreamerCupertinoIndex, iHTTPStreamerCupertinoIndexItem, liveStreamPacketizerCupertinoChunk, bl);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerApplicationContextCupertinoStreamer.class).error("HTTPStreamerApplicationContextCupertinoStreamer.notifyVODListenerOnFillChunkStart: " + exception.toString());
                }
            }
        }
    }

    public void notifyVODListenerOnFillChunkEnd(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex, IHTTPStreamerCupertinoIndexItem iHTTPStreamerCupertinoIndexItem, LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, boolean bl) {
        List<IHTTPStreamerCupertinoVODActionNotify> list = this.getVODListeners();
        if (list != null) {
            for (IHTTPStreamerCupertinoVODActionNotify iHTTPStreamerCupertinoVODActionNotify : list) {
                try {
                    iHTTPStreamerCupertinoVODActionNotify.onFillChunkEnd(iHTTPStreamerCupertinoIndex, iHTTPStreamerCupertinoIndexItem, liveStreamPacketizerCupertinoChunk, bl);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerApplicationContextCupertinoStreamer.class).error("HTTPStreamerApplicationContextCupertinoStreamer.notifyVODListenerOnFillChunkEnd: " + exception.toString());
                }
            }
        }
    }

    public void notifyVODListenerOnDestroy(IHTTPStreamerCupertinoIndex iHTTPStreamerCupertinoIndex) {
        List<IHTTPStreamerCupertinoVODActionNotify> list = this.getVODListeners();
        if (list != null) {
            for (IHTTPStreamerCupertinoVODActionNotify iHTTPStreamerCupertinoVODActionNotify : list) {
                try {
                    iHTTPStreamerCupertinoVODActionNotify.onDestroy(iHTTPStreamerCupertinoIndex);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerApplicationContextCupertinoStreamer.class).error("HTTPStreamerApplicationContextCupertinoStreamer.notifyVODListenerOnDestroy: " + exception.toString());
                }
            }
        }
    }

    public boolean isAutoCreateMultibitratePlaylist() {
        return this.autoCreateMultibitratePlaylist;
    }

    public void setAutoCreateMultibitratePlaylist(boolean bl) {
        this.autoCreateMultibitratePlaylist = bl;
    }

    public boolean isUseCalculatedVideoBitrate() {
        return this.useCalculatedVideoBitrate;
    }

    public void setUseCalculatedVideoBitrate(boolean bl) {
        this.useCalculatedVideoBitrate = bl;
    }

    public boolean isUseCalculatedAudioBitrate() {
        return this.useCalculatedAudioBitrate;
    }

    public void setUseCalculatedAudioBitrate(boolean bl) {
        this.useCalculatedAudioBitrate = bl;
    }

    public boolean isCalculatePlaylistBitrates() {
        return this.calculatePlaylistBitrates;
    }

    public void setCalculatePlaylistBitrates(boolean bl) {
        this.calculatePlaylistBitrates = bl;
    }

    public int getDefaultVideoBitrate() {
        return this.defaultVideoBitrate;
    }

    public void setDefaultVideoBitrate(int n) {
        this.defaultVideoBitrate = n;
    }

    public int getDefaultAudioBitrate() {
        return this.defaultAudioBitrate;
    }

    public void setDefaultAudioBitrate(int n) {
        this.defaultAudioBitrate = n;
    }

    public int getMaxCalulatedAudioBitrate() {
        return this.maxCalulatedAudioBitrate;
    }

    public void setMaxCalulatedAudioBitrate(int n) {
        this.maxCalulatedAudioBitrate = n;
    }

    public int getMaxCalulatedVideoBitrate() {
        return this.maxCalulatedVideoBitrate;
    }

    public void setMaxCalulatedVideoBitrate(int n) {
        this.maxCalulatedVideoBitrate = n;
    }

    public int getBitrateAdjustmentFactor() {
        return this.bitrateAdjustmentFactor;
    }

    public void setBitrateAdjustmentFactor(int n) {
        this.bitrateAdjustmentFactor = n;
    }

    public String getPlaylistHostDomain() {
        return this.playlistHostDomain;
    }

    public void setPlaylistHostDomain(String string) {
        this.playlistHostDomain = string;
    }

    public boolean isCalculateCodecs() {
        return this.calculateCodecs;
    }

    public void setCalculateCodecs(boolean bl) {
        this.calculateCodecs = bl;
    }

    public boolean isCalculateResolution() {
        return this.calculateResolution;
    }

    public void setCalculateResolution(boolean bl) {
        this.calculateResolution = bl;
    }

    public boolean isRelativePlaylistPlaylists() {
        return this.relativePlaylistPlaylists;
    }

    public void setRelativePlaylistPlaylists(boolean bl) {
        this.relativePlaylistPlaylists = bl;
    }

    public String getPlaylistHostProtocol() {
        return this.playlistHostProtocol;
    }

    public void setPlaylistHostProtocol(String string) {
        this.playlistHostProtocol = string;
    }
}

