/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.ICupertinoChunkWriter;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.model.IMediaCodecInfo;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaReaderFactory;
import com.wowza.wms.stream.MediaReaderList;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.util.ArrayList;
import java.util.List;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

public class CupertinoPacketHandler {
    private boolean didStreamReset = false;
    private boolean waitForKeyFrame = true;
    private long lastAudioTimecode = -1L;
    private long lastVideoTimecode = -1L;
    private long lastDataTimecode = -1L;
    private boolean reportVideoCodecInfo = true;
    private boolean reportAudioCodecInfo = true;
    private AACFrame aacFrame = null;
    private int lastAACSampleRate = -1;
    private long lastAACTimecode = -1L;
    private int lastMP3SampleRate = -1;
    private long lastMP3Timecode = -1L;
    private CupertinoPacketHolder audioGroupPacket = null;
    private int videoCodec = -1;
    private int audioCodec = -1;
    private boolean codecIsLocked = false;
    private long codecLockStartTimecode = -1L;
    private int streamMode = 1;
    private List<CupertinoPacketHolder> savedHolders = new ArrayList<CupertinoPacketHolder>();
    private int audioGroupCount = 3;
    private int waitForCodecTime = 9000;
    private int chunkDurationTarget = 10000;
    private int chunkDurationTolerance = 500;
    private int maxSaveHolderSize = 500;
    private int maxChunkKeyCount = 50;
    private boolean debugAACTimecodes = false;
    private boolean debugMP3Timecodes = false;
    private byte[] mp3HeaderBuf = null;
    private MP3HeaderData mp3HeaderData = null;
    private MediaCodecInfoAudio chunkCodecInfoAudio = null;
    private boolean chunkCodecInfoAudioSent = false;
    private MediaCodecInfoVideo chunkCodecInfoVideo = null;
    private boolean chunkCodecInfoVideoSent = false;
    private long chunkLastAudioTimecode = -1L;
    private long chunkHitEndKeyTimecode = -1L;
    private boolean chunkHitEndKey = false;
    private long chunkStartTimecode = -1L;
    private long chunkStartKeyTimecode = -1L;
    private long chunkStopKeyTimecode = -1L;
    private long chunkKeyCount = 0L;
    private boolean isChunkOpen = false;
    private boolean sendEndChunk = false;
    private ICupertinoChunkWriter chunkWriter = null;
    private AMFPacket saveVideoCodecConfig = null;
    private boolean isFirstFrame = true;
    private String contextStr = null;
    private int lastAdjAudioTimecodeBackwardsCount = 0;
    private int lastAdjVideoTimecodeBackwardsCount = 0;
    private boolean lastAdjAudioTimecodeWarning = true;
    private boolean lastAdjVideoTimecodeWarning = true;
    private MediaCodecInfoAudio codecInfoAudio = null;
    private MediaCodecInfoVideo codecInfoVideo = null;
    private long audioSampleCount = -1L;
    private long audioSampleTimecode = -1L;
    private long audioSampleLast = -1L;

    private IMediaReader getMediaReader(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2) {
        String string3 = string.toLowerCase();
        IMediaReader iMediaReader = MediaReaderFactory.getInstance((IApplicationInstance)iApplicationInstance, (MediaReaderList)iApplicationInstance.getVHost().getMediaReaders(), (String)string3);
        if (iMediaReader != null) {
            String string4 = iApplicationInstance.getStreamStoragePath();
            iMediaReader.init(iApplicationInstance, iMediaStream, string, string4, string2);
            iMediaReader.open(string4, string2);
        }
        return iMediaReader;
    }

    private void doPreroll(IMediaStream iMediaStream) {
        try {
            IMediaReader iMediaReader = null;
            PlaylistCursor playlistCursor = null;
            IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
            String string = "mp4";
            String string2 = "preroll.mov";
            iMediaReader = this.getMediaReader(iApplicationInstance, iMediaStream, string, string2);
            playlistCursor = new PlaylistCursor();
            long[] lArray = new long[8];
            PlaylistWriteControl playlistWriteControl = playlistCursor.getWriteControl();
            PlaylistReaderWriteResults playlistReaderWriteResults = playlistCursor.getWriteResults();
            playlistWriteControl.setMaxTC(10000L);
            iMediaReader.seek(0L, 3);
            ArrayList arrayList = new ArrayList();
            iMediaReader.writePackets(arrayList, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, null);
            long l = 0L;
            int n = 5;
            for (int i = 0; i < n; ++i) {
                long l2 = 0L;
                System.out.println("****START: " + i);
                int n2 = arrayList.size();
                for (int j = 0; j < n2; ++j) {
                    AMFPacket aMFPacket = (AMFPacket)arrayList.get(j);
                    l2 = aMFPacket.getAbsTimecode();
                    long l3 = l2 + l;
                    aMFPacket.setAbsTimecode(l3);
                    switch (aMFPacket.getType()) {
                        case 8: {
                            break;
                        }
                        case 9: {
                            this.handlePacket(iMediaStream, aMFPacket, false);
                            break;
                        }
                    }
                    aMFPacket.setAbsTimecode(l2);
                }
                l += l2;
            }
            iMediaReader.close();
            this.waitForKeyFrame = true;
            this.reportVideoCodecInfo = true;
            this.reportAudioCodecInfo = true;
            System.out.println("****DONE: ");
        }
        catch (Exception exception) {
            System.out.println("doPreroll: " + exception.toString());
        }
    }

    public void startStream(IMediaStream iMediaStream) {
        this.doStreamReset();
        WMSLoggerFactory.getLogger(CupertinoPacketHandler.class).info("CupertinoPacketHandler.startStream[" + this.getContextStr(iMediaStream) + "]");
    }

    public void resetStream(IMediaStream iMediaStream) {
        this.lastAdjAudioTimecodeBackwardsCount = 0;
        this.lastAdjVideoTimecodeBackwardsCount = 0;
        this.lastAdjAudioTimecodeWarning = true;
        this.lastAdjVideoTimecodeWarning = true;
        this.lastAudioTimecode = -1L;
        this.lastVideoTimecode = -1L;
        this.waitForKeyFrame = true;
        this.didStreamReset = true;
    }

    private void doStreamReset() {
        this.lastAdjAudioTimecodeBackwardsCount = 0;
        this.lastAdjVideoTimecodeBackwardsCount = 0;
        this.lastAdjAudioTimecodeWarning = true;
        this.lastAdjVideoTimecodeWarning = true;
        this.lastAudioTimecode = -1L;
        this.lastVideoTimecode = -1L;
        this.waitForKeyFrame = true;
    }

    private String getContextStr(IMediaStream iMediaStream) {
        String string = iMediaStream.getStreams().getAppInstance().getApplication().getName() + "/" + iMediaStream.getStreams().getAppInstance().getName() + "/" + iMediaStream.getName();
        return string;
    }

    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        this.contextStr = this.getContextStr(iMediaStream);
        this.handlePacket(iMediaStream, aMFPacket, false);
    }

    public void handlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket, boolean bl) {
        try {
            long l = aMFPacket.getAbsTimecode();
            int n = aMFPacket.getType();
            int n2 = aMFPacket.getSize();
            if (n2 > 0) {
                int n3;
                Object object;
                int n4;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = true;
                if (!this.codecIsLocked) {
                    if (this.videoCodec == -1 && (n4 = iMediaStream.getPublishVideoCodecId()) != -1) {
                        this.videoCodec = n4;
                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket[" + this.getContextStr(iMediaStream) + "]: Video codec:" + FLVUtils.videoCodecToString((int)n4) + " isCompatible:" + this.isValidVideoCodec(n4));
                    }
                    if (this.audioCodec == -1 && (n4 = iMediaStream.getPublishAudioCodecId()) != -1) {
                        this.audioCodec = n4;
                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket[" + this.getContextStr(iMediaStream) + "]: Audio codec:" + FLVUtils.audioCodecToString((int)n4) + " isCompatible:" + this.isValidAudioCodec(n4));
                    }
                }
                n4 = -1;
                int n5 = -1;
                if (n == 9) {
                    bl3 = FLVUtils.isVideoCodecConfig((AMFPacket)aMFPacket);
                    bl2 = FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket);
                    n4 = FLVUtils.getVideoCodec((int)aMFPacket.getFirstByte());
                    if (bl3) {
                        Object object2 = object = aMFPacket.getSize() > 5 ? H264Utils.decodeAVCC((byte[])aMFPacket.getData(), (int)5) : null;
                        if (object != null) {
                            byte[] byArray = new byte[aMFPacket.getSize() - 5];
                            System.arraycopy(aMFPacket.getData(), 5, byArray, 0, byArray.length);
                            this.codecInfoVideo = new MediaCodecInfoVideo();
                            this.codecInfoVideo.setCodecId(7);
                            this.codecInfoVideo.setVideoLevel(((H264CodecConfigInfo)object).levelIDC);
                            this.codecInfoVideo.setVideoProfile(((H264CodecConfigInfo)object).profileIDC);
                            this.codecInfoVideo.setVideoWidth(((H264CodecConfigInfo)object).width);
                            this.codecInfoVideo.setVideoHeight(((H264CodecConfigInfo)object).height);
                            this.codecInfoVideo.setDisplayWidth(((H264CodecConfigInfo)object).displayWidth);
                            this.codecInfoVideo.setDisplayHeight(((H264CodecConfigInfo)object).displayHeight);
                            this.codecInfoVideo.setCodecConfig(byArray);
                            if (this.reportVideoCodecInfo) {
                                String string = "avc1." + ((H264CodecConfigInfo)object).profileIDC + "." + ((H264CodecConfigInfo)object).levelIDC;
                                if (((H264CodecConfigInfo)object).profileIDC != 66 || ((H264CodecConfigInfo)object).levelIDC > 30) {
                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket[" + this.getContextStr(iMediaStream) + "][" + string + "]: H.264 (Video may not be playable on older iPhone and iPod touch devices where Baseline/Level 3.0 or lower is required) Video info: " + object.toString());
                                } else {
                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket[" + this.getContextStr(iMediaStream) + "][" + string + "]: H.264 Video info: " + object.toString());
                                }
                                this.reportVideoCodecInfo = false;
                            }
                        }
                    }
                    if (this.waitForKeyFrame) {
                        if (bl2) {
                            this.waitForKeyFrame = false;
                        } else {
                            bl4 = false;
                            if (bl3) {
                                this.saveVideoCodecConfig = aMFPacket;
                            }
                        }
                    }
                } else if (n == 8) {
                    bl3 = FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket);
                    n5 = FLVUtils.getAudioCodec((int)aMFPacket.getFirstByte());
                    if (bl3) {
                        if (n5 == 10) {
                            AACFrame aACFrame = this.aacFrame = aMFPacket.getSize() >= 4 ? AACUtils.decodeAACCodecConfig((byte[])aMFPacket.getData(), (int)2) : null;
                            if (this.aacFrame != null) {
                                object = new byte[aMFPacket.getSize() - 2];
                                System.arraycopy(aMFPacket.getData(), 2, object, 0, ((H264CodecConfigInfo)object).length);
                                this.codecInfoAudio = new MediaCodecInfoAudio();
                                this.codecInfoAudio.setCodecId(10);
                                this.codecInfoAudio.setAudioObjectType(this.aacFrame.getProfileObjectType());
                                this.codecInfoAudio.setAudioSamplesPerFrame(this.aacFrame.getSampleCount());
                                this.codecInfoAudio.setAudioChannels(this.aacFrame.getChannels());
                                this.codecInfoAudio.setAudioSampleFrequency(this.aacFrame.getSampleRate());
                                this.codecInfoAudio.setCodecConfig((byte[])object);
                                if (this.reportAudioCodecInfo) {
                                    String string = "mp4a.40." + this.aacFrame.getProfileObjectType();
                                    if (this.aacFrame.getChannels() > 2 || this.aacFrame.getSampleRate() > 48000) {
                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket[" + this.getContextStr(iMediaStream) + "][" + string + "]: AAC (Audio may not be playable on older iPhone and iPod touch devices where 48KHz/stereo or lower is required) Audio info: " + this.aacFrame.toString());
                                    } else {
                                        WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket[" + this.getContextStr(iMediaStream) + "][" + string + "]: AAC Audio info: " + this.aacFrame.toString());
                                    }
                                    this.reportAudioCodecInfo = false;
                                }
                            }
                        } else if (n5 == 2) {
                            if (this.codecInfoAudio == null && aMFPacket.getSize() >= 5) {
                                object = new byte[4];
                                MP3HeaderData mP3HeaderData = new MP3HeaderData();
                                System.arraycopy(aMFPacket.getData(), 1, object, 0, 4);
                                int n6 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])object, (MP3HeaderData)mP3HeaderData);
                                if (n6 != 0) {
                                    MP3BufferedDecoder.decodeHeader((int)n6, (int)0, (MP3HeaderData)mP3HeaderData);
                                    n3 = 2;
                                    switch (mP3HeaderData.h_mode) {
                                        case 0: {
                                            n3 = 2;
                                            break;
                                        }
                                        case 1: {
                                            n3 = 2;
                                            break;
                                        }
                                        case 2: {
                                            n3 = 2;
                                            break;
                                        }
                                        case 3: {
                                            n3 = 1;
                                        }
                                    }
                                    this.codecInfoAudio = new MediaCodecInfoAudio();
                                    this.codecInfoAudio.setCodecId(2);
                                    this.codecInfoAudio.setAudioObjectType(34);
                                    this.codecInfoAudio.setAudioSamplesPerFrame(MP3BufferedDecoder.samples_per_frame((MP3HeaderData)mP3HeaderData));
                                    this.codecInfoAudio.setAudioChannels(n3);
                                    this.codecInfoAudio.setAudioSampleFrequency(MP3BufferedDecoder.frequency((MP3HeaderData)mP3HeaderData));
                                }
                            }
                            if (this.reportAudioCodecInfo) {
                                object = "mp4a.40.34";
                                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info("LiveStreamPacketizerCupertino.handlePacket[" + this.getContextStr(iMediaStream) + "][" + (String)object + "]: MP3 Audio info");
                                this.reportAudioCodecInfo = false;
                            }
                        }
                    }
                } else if (n != 18) {
                    bl4 = false;
                }
                if (bl4) {
                    if (n == 9) {
                        if (this.lastVideoTimecode >= 0L && l < this.lastVideoTimecode) {
                            if (this.lastAdjVideoTimecodeWarning) {
                                WMSLoggerFactory.getLogger(CupertinoPacketHandler.class).warn("CupertinoPacketHandler.handlePacket[" + this.getContextStr(iMediaStream) + "]: Timecode out of order [video]: " + l + ":" + this.lastVideoTimecode);
                                this.lastAdjVideoTimecodeWarning = false;
                            }
                            ++this.lastAdjVideoTimecodeBackwardsCount;
                        } else {
                            this.lastVideoTimecode = l;
                            this.lastAdjVideoTimecodeBackwardsCount = 0;
                            if (bl4) {
                                if (this.saveVideoCodecConfig != null) {
                                    object = new CupertinoPacketHolder(this.saveVideoCodecConfig, 9, n4, true, l, l * 90L);
                                    this.saveVideoCodecConfig = null;
                                    this.handleHolder((CupertinoPacketHolder)object);
                                }
                                object = new CupertinoPacketHolder(aMFPacket, 9, n4, bl3, l, l * 90L);
                                ((CupertinoPacketHolder)object).setKey(bl2);
                                ((CupertinoPacketHolder)object).setCodecInfo((IMediaCodecInfo)this.codecInfoVideo);
                                this.handleHolder((CupertinoPacketHolder)object);
                            }
                        }
                    } else if (n == 8) {
                        if (this.lastAudioTimecode >= 0L && l < this.lastAudioTimecode) {
                            if (this.lastAdjAudioTimecodeWarning) {
                                WMSLoggerFactory.getLogger(CupertinoPacketHandler.class).warn("CupertinoPacketHandler.handlePacket[" + this.getContextStr(iMediaStream) + "]: Timecode out of order [audio]: " + l + ":" + this.lastAudioTimecode);
                                this.lastAdjAudioTimecodeWarning = false;
                            }
                            ++this.lastAdjAudioTimecodeBackwardsCount;
                        } else {
                            this.lastAudioTimecode = l;
                            this.lastAdjAudioTimecodeBackwardsCount = 0;
                            long l2 = l * 90L;
                            if (n2 >= 5 && n5 == 2) {
                                if (this.mp3HeaderBuf == null) {
                                    this.mp3HeaderBuf = new byte[4];
                                    this.mp3HeaderData = new MP3HeaderData();
                                }
                                System.arraycopy(aMFPacket.getData(), 1, this.mp3HeaderBuf, 0, 4);
                                int n7 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])this.mp3HeaderBuf, (MP3HeaderData)this.mp3HeaderData);
                                if (n7 != 0) {
                                    MP3BufferedDecoder.decodeHeader((int)n7, (int)0, (MP3HeaderData)this.mp3HeaderData);
                                    n3 = MP3BufferedDecoder.samples_per_frame((MP3HeaderData)this.mp3HeaderData);
                                    int n8 = MP3BufferedDecoder.frequency((MP3HeaderData)this.mp3HeaderData);
                                    if (this.lastMP3SampleRate == -1 || this.lastMP3SampleRate != n8) {
                                        this.lastMP3SampleRate = n8;
                                        this.lastMP3Timecode = Math.round((double)(l * (long)this.lastMP3SampleRate) / 1000.0);
                                    } else {
                                        long l3 = this.lastMP3Timecode + (long)n3;
                                        long l4 = Math.round((double)l3 * 1000.0 / (double)this.lastMP3SampleRate);
                                        int n9 = (int)Math.abs(l4 - l);
                                        if (this.debugMP3Timecodes) {
                                            System.out.println("tc[" + n9 + "]: " + l4 + ":" + l + ":" + this.lastMP3SampleRate);
                                        }
                                        if (n9 <= 1) {
                                            l2 = Math.round((double)(l3 * 90000L) / (double)this.lastMP3SampleRate);
                                            this.lastMP3Timecode = l3;
                                        } else {
                                            this.lastMP3Timecode = Math.round((double)(l * (long)this.lastMP3SampleRate) / 1000.0);
                                            if (this.debugMP3Timecodes) {
                                                System.out.println("reset: " + this.lastMP3Timecode);
                                            }
                                        }
                                    }
                                }
                            } else if (!bl3 && n5 == 10 && this.aacFrame != null) {
                                if (this.lastAACSampleRate == -1 || this.lastAACSampleRate != this.aacFrame.getSampleRate()) {
                                    this.lastAACSampleRate = this.aacFrame.getSampleRate();
                                    this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                                } else {
                                    long l5 = this.lastAACTimecode + (long)this.aacFrame.getSampleCount();
                                    long l6 = Math.round((double)l5 * 1000.0 / (double)this.lastAACSampleRate);
                                    int n10 = (int)Math.abs(l6 - l);
                                    if (this.debugAACTimecodes) {
                                        System.out.println("tc[" + n10 + "]: " + l6 + ":" + l + ":" + this.lastAACSampleRate);
                                    }
                                    if (n10 <= 1) {
                                        l2 = Math.round((double)(l5 * 90000L) / (double)this.lastAACSampleRate);
                                        this.lastAACTimecode = l5;
                                    } else {
                                        this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                                        if (this.debugAACTimecodes) {
                                            System.out.println("reset: " + this.lastAACTimecode);
                                        }
                                    }
                                }
                            }
                            if (bl4) {
                                CupertinoPacketHolder cupertinoPacketHolder = new CupertinoPacketHolder(aMFPacket, 8, n5, bl3, l, l2);
                                cupertinoPacketHolder.setCodecInfo((IMediaCodecInfo)this.codecInfoAudio);
                                if (this.audioGroupPacket == null) {
                                    this.audioGroupPacket = new CupertinoPacketHolder(null, 8, n5, false, l, l2);
                                    this.audioGroupPacket.setCodecInfo((IMediaCodecInfo)this.codecInfoAudio);
                                }
                                this.audioGroupPacket.addHolder(cupertinoPacketHolder);
                                if (this.audioGroupPacket.getPacketCount() >= this.audioGroupCount) {
                                    this.handleHolder(this.audioGroupPacket);
                                    this.audioGroupPacket = null;
                                }
                            }
                        }
                    } else if (n == 18 && (this.lastDataTimecode < 0L || l >= this.lastDataTimecode)) {
                        this.lastDataTimecode = l;
                        if (bl4) {
                            object = new CupertinoPacketHolder(aMFPacket, 18, -1, bl3, l, l * 90L);
                            ((CupertinoPacketHolder)object).setKey(bl2);
                            this.handleHolder((CupertinoPacketHolder)object);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.handlePacket: " + exception.toString());
            exception.printStackTrace();
        }
        if (this.lastAdjAudioTimecodeBackwardsCount > 10 || this.lastAdjVideoTimecodeBackwardsCount > 10) {
            WMSLoggerFactory.getLogger(CupertinoPacketHandler.class).warn("CupertinoPacketHandler.resetStream[" + this.getContextStr(iMediaStream) + "][" + this.lastAdjAudioTimecodeBackwardsCount + ":" + this.lastAdjVideoTimecodeBackwardsCount + "]: Timecodes jumped back in time.");
            this.lastAdjAudioTimecodeBackwardsCount = 0;
            this.lastAdjVideoTimecodeBackwardsCount = 0;
            this.resetStream(iMediaStream);
        }
    }

    public void handleHolder(CupertinoPacketHolder cupertinoPacketHolder) {
        try {
            int n = this.savedHolders.size();
            HandlerHolderResult handlerHolderResult = this.handleHolderInternal(cupertinoPacketHolder, false, n);
            if (handlerHolderResult.saveHolder) {
                this.savedHolders.add(cupertinoPacketHolder);
            }
            if (handlerHolderResult.flushSavedHolders) {
                ArrayList<CupertinoPacketHolder> arrayList = new ArrayList<CupertinoPacketHolder>();
                for (CupertinoPacketHolder cupertinoPacketHolder2 : this.savedHolders) {
                    HandlerHolderResult handlerHolderResult2 = this.handleHolderInternal(cupertinoPacketHolder2, true, 0);
                    if (!handlerHolderResult2.saveHolder) continue;
                    arrayList.add(cupertinoPacketHolder);
                }
                this.savedHolders.clear();
                this.savedHolders = arrayList;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error("LiveStreamPacketizerCupertino.handleHolder: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public boolean isValidVideoCodec(int n) {
        return n == 7;
    }

    public boolean isValidAudioCodec(int n) {
        return n == 10 || n == 2;
    }

    public HandlerHolderResult handleHolderInternal(CupertinoPacketHolder cupertinoPacketHolder, boolean bl, int n) {
        HandlerHolderResult handlerHolderResult;
        block53: {
            boolean bl2;
            boolean bl3;
            long l;
            int n2;
            long l2;
            long l3;
            block56: {
                block57: {
                    int n3;
                    block55: {
                        block52: {
                            block54: {
                                handlerHolderResult = new HandlerHolderResult();
                                l3 = cupertinoPacketHolder.getTimecode();
                                l2 = cupertinoPacketHolder.getTimecode();
                                n2 = cupertinoPacketHolder.getType();
                                long l4 = 0L;
                                if (n2 == 9 && cupertinoPacketHolder.getPacket() != null) {
                                    l4 = FLVUtils.getVideoTimecodeOffset((AMFPacket)cupertinoPacketHolder.getPacket());
                                }
                                l2 += l4;
                                l = l3 + (long)cupertinoPacketHolder.getDuration();
                                n3 = cupertinoPacketHolder.getCodec();
                                if (this.codecIsLocked) break block52;
                                bl3 = false;
                                if (this.codecLockStartTimecode == -1L) {
                                    this.codecLockStartTimecode = l3;
                                }
                                if (this.videoCodec != -1 && this.audioCodec != -1) {
                                    this.codecIsLocked = true;
                                    handlerHolderResult.saveHolder = true;
                                    handlerHolderResult.flushSavedHolders = true;
                                    bl3 = true;
                                } else if (n > this.maxSaveHolderSize || l3 - this.codecLockStartTimecode > (long)this.waitForCodecTime) {
                                    this.codecIsLocked = true;
                                    handlerHolderResult.saveHolder = true;
                                    handlerHolderResult.flushSavedHolders = true;
                                    bl3 = true;
                                } else {
                                    handlerHolderResult.saveHolder = true;
                                    bl3 = true;
                                }
                                if (!bl3) break block52;
                                if (!this.codecIsLocked) break block53;
                                if (this.videoCodec != -1 && this.videoCodec != 7) {
                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("LiveStreamPacketizerCupertino.handleHolder: Invalid video codec for iPhone/iPod: " + FLVUtils.videoCodecToString((int)this.videoCodec));
                                }
                                if (this.videoCodec == 7 && this.audioCodec != -1 && this.audioCodec != 10 && this.audioCodec != 2) {
                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("LiveStreamPacketizerCupertino.handleHolder: Invalid video/audio codec combination for iPhone/iPod: video:" + FLVUtils.videoCodecToString((int)this.videoCodec) + " audio:" + FLVUtils.audioCodecToString((int)this.audioCodec));
                                }
                                if (this.audioCodec != -1 && this.audioCodec != 10 && this.audioCodec != 2) {
                                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn("LiveStreamPacketizerCupertino.handleHolder: Invalid audio codec for iPhone/iPod: " + FLVUtils.audioCodecToString((int)this.audioCodec));
                                }
                                if (this.audioCodec != 2 || this.videoCodec != -1 && this.chunkWriter.isPacketizeVideo()) break block54;
                                this.streamMode = 2;
                                break block53;
                            }
                            if (this.audioCodec != 10 || this.videoCodec != -1 && this.chunkWriter.isPacketizeVideo()) break block53;
                            this.streamMode = 3;
                            break block53;
                        }
                        if (n2 != 8) break block55;
                        if (this.isValidAudioCodec(n3)) break block56;
                        break block53;
                    }
                    if (n2 != 9) break block57;
                    if (this.isValidVideoCodec(n3) && this.streamMode != 2) break block56;
                    break block53;
                }
                if (n2 == 18) {
                    // empty if block
                }
            }
            if (this.sendEndChunk) {
                this.endChunk(l3);
                this.chunkLastAudioTimecode = -1L;
                this.chunkHitEndKeyTimecode = -1L;
                this.chunkStartTimecode = -1L;
                this.chunkStartKeyTimecode = -1L;
                this.chunkStopKeyTimecode = -1L;
                this.chunkHitEndKey = false;
                this.chunkCodecInfoAudio = null;
                this.chunkCodecInfoAudioSent = false;
                this.chunkCodecInfoVideo = null;
                this.chunkCodecInfoVideoSent = false;
                this.chunkKeyCount = 0L;
                this.sendEndChunk = false;
            }
            if (this.chunkStartTimecode == -1L) {
                this.chunkStartTimecode = l3;
            }
            bl3 = false;
            if (this.isValidVideoCodec(this.videoCodec) && this.isValidAudioCodec(this.audioCodec)) {
                bl2 = false;
                if (n2 == 9) {
                    if (this.chunkHitEndKey) {
                        handlerHolderResult.saveHolder = true;
                        bl2 = cupertinoPacketHolder.isKey();
                    } else if (cupertinoPacketHolder.isKey()) {
                        boolean bl4 = false;
                        MediaCodecInfoVideo mediaCodecInfoVideo = (MediaCodecInfoVideo)cupertinoPacketHolder.getCodecInfo();
                        if (mediaCodecInfoVideo != null) {
                            if (this.chunkCodecInfoVideo != null && !this.chunkCodecInfoVideo.equals(mediaCodecInfoVideo)) {
                                bl4 = true;
                            }
                            if (this.chunkCodecInfoVideo == null) {
                                this.chunkCodecInfoVideo = mediaCodecInfoVideo;
                            }
                        }
                        if (this.didStreamReset) {
                            bl4 = true;
                            this.didStreamReset = false;
                        }
                        ++this.chunkKeyCount;
                        if (this.chunkStartKeyTimecode < 0L) {
                            this.chunkStartKeyTimecode = l2;
                            this.chunkStopKeyTimecode = (l2 / (long)this.chunkDurationTarget + 1L) * (long)this.chunkDurationTarget;
                        }
                        if (bl4 || this.chunkKeyCount > (long)this.maxChunkKeyCount || l3 < this.chunkStartTimecode || l2 >= this.chunkStopKeyTimecode) {
                            this.chunkHitEndKeyTimecode = l3;
                            this.chunkHitEndKey = true;
                            handlerHolderResult.saveHolder = true;
                        }
                    }
                } else if (n2 == 8) {
                    if (this.chunkCodecInfoAudio == null) {
                        this.chunkCodecInfoAudio = (MediaCodecInfoAudio)cupertinoPacketHolder.getCodecInfo();
                    }
                    this.chunkLastAudioTimecode = l;
                }
                if (this.chunkHitEndKey && (n > this.maxSaveHolderSize || bl2 || this.chunkLastAudioTimecode >= this.chunkHitEndKeyTimecode)) {
                    bl3 = true;
                    if (n2 == 8) {
                        handlerHolderResult.saveHolder = true;
                    }
                }
            } else if (this.isValidVideoCodec(this.videoCodec)) {
                if (cupertinoPacketHolder.isKey()) {
                    bl2 = false;
                    MediaCodecInfoVideo mediaCodecInfoVideo = (MediaCodecInfoVideo)cupertinoPacketHolder.getCodecInfo();
                    if (mediaCodecInfoVideo != null) {
                        if (this.chunkCodecInfoVideo != null && !this.chunkCodecInfoVideo.equals(mediaCodecInfoVideo)) {
                            bl2 = true;
                        }
                        if (this.chunkCodecInfoVideo == null) {
                            this.chunkCodecInfoVideo = mediaCodecInfoVideo;
                        }
                    }
                    if (this.didStreamReset) {
                        bl2 = true;
                        this.didStreamReset = false;
                    }
                    ++this.chunkKeyCount;
                    if (this.chunkStartKeyTimecode < 0L) {
                        this.chunkStartKeyTimecode = l2;
                        this.chunkStopKeyTimecode = (l2 / (long)this.chunkDurationTarget + 1L) * (long)this.chunkDurationTarget;
                    }
                    if (bl2 || this.chunkKeyCount > (long)this.maxChunkKeyCount || l3 < this.chunkStartTimecode || l2 >= this.chunkStopKeyTimecode) {
                        this.chunkHitEndKeyTimecode = l3;
                        this.chunkHitEndKey = true;
                        bl3 = true;
                        handlerHolderResult.saveHolder = true;
                    }
                }
            } else {
                bl2 = false;
                if (this.didStreamReset) {
                    bl2 = true;
                    this.didStreamReset = false;
                }
                if (bl2 || n > this.maxSaveHolderSize || l < this.chunkStartTimecode || l - this.chunkStartTimecode >= (long)this.chunkDurationTarget) {
                    bl3 = true;
                }
            }
            if (!handlerHolderResult.saveHolder) {
                if (!this.isChunkOpen) {
                    this.startChunk(this.chunkStartTimecode);
                    this.isChunkOpen = true;
                }
                if (cupertinoPacketHolder.getType() == 8 && this.chunkCodecInfoAudio == null) {
                    this.chunkCodecInfoAudio = (MediaCodecInfoAudio)cupertinoPacketHolder.getCodecInfo();
                }
                if (this.chunkCodecInfoAudio != null && !this.chunkCodecInfoAudioSent) {
                    this.chunkWriter.setCodecInfoAudio(this.chunkCodecInfoAudio);
                    this.chunkCodecInfoAudioSent = true;
                }
                if (this.chunkCodecInfoVideo != null && !this.chunkCodecInfoVideoSent) {
                    this.chunkWriter.setCodecInfoVideo(this.chunkCodecInfoVideo);
                    this.chunkCodecInfoVideoSent = true;
                }
                bl2 = true;
                switch (cupertinoPacketHolder.getType()) {
                    case 8: {
                        if (this.chunkWriter.isPacketizeAudio()) break;
                        bl2 = false;
                        break;
                    }
                    case 9: {
                        if (this.chunkWriter.isPacketizeVideo()) break;
                        bl2 = false;
                        break;
                    }
                    case 18: {
                        if (this.chunkWriter.isPacketizeData()) break;
                        bl2 = false;
                    }
                }
                if (bl2) {
                    this.addToChunk(cupertinoPacketHolder);
                }
            }
            if (!bl3) break block53;
            if (this.isChunkOpen) {
                this.sendEndChunk = true;
                this.isChunkOpen = false;
            }
            handlerHolderResult.flushSavedHolders = true;
        }
        return handlerHolderResult;
    }

    private void startChunk(long l) {
        this.chunkWriter.startChunk(this.streamMode, this.videoCodec, this.audioCodec, l);
    }

    private void endChunk(long l) {
        this.chunkWriter.endChunk(l);
    }

    private void addToChunk(CupertinoPacketHolder cupertinoPacketHolder) {
        this.chunkWriter.addToChunk(cupertinoPacketHolder);
    }

    public int getAudioGroupCount() {
        return this.audioGroupCount;
    }

    public void setAudioGroupCount(int n) {
        this.audioGroupCount = n;
    }

    public int getWaitForCodecTime() {
        return this.waitForCodecTime;
    }

    public void setWaitForCodecTime(int n) {
        this.waitForCodecTime = n;
    }

    public int getChunkDurationTarget() {
        return this.chunkDurationTarget;
    }

    public void setChunkDurationTarget(int n) {
        this.chunkDurationTarget = n;
    }

    public int getChunkDurationTolerance() {
        return this.chunkDurationTolerance;
    }

    public void setChunkDurationTolerance(int n) {
        this.chunkDurationTolerance = n;
    }

    public void setChunkWriter(ICupertinoChunkWriter iCupertinoChunkWriter) {
        this.chunkWriter = iCupertinoChunkWriter;
    }

    public boolean isDebugAACTimecodes() {
        return this.debugAACTimecodes;
    }

    public void setDebugAACTimecodes(boolean bl) {
        this.debugAACTimecodes = bl;
    }

    public int getMaxSaveHolderSize() {
        return this.maxSaveHolderSize;
    }

    public void setMaxSaveHolderSize(int n) {
        this.maxSaveHolderSize = n;
    }

    public boolean isDebugMP3Timecodes() {
        return this.debugMP3Timecodes;
    }

    public void setDebugMP3Timecodes(boolean bl) {
        this.debugMP3Timecodes = bl;
    }

    public int getMaxChunkKeyCount() {
        return this.maxChunkKeyCount;
    }

    public void setMaxChunkKeyCount(int n) {
        this.maxChunkKeyCount = n;
    }

    class HandlerHolderResult {
        boolean saveHolder = false;
        boolean flushSavedHolders = false;

        HandlerHolderResult() {
        }
    }
}

