/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamMetaDataProvider;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.ILiveReceiver;
import com.wowza.wms.stream.live.LiveReceiverPacketSorter;
import com.wowza.wms.stream.live.LiveStreamPacketizerRunner;
import com.wowza.wms.stream.live.LiveStreamTranscoderRunner;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerItem;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerList;
import com.wowza.wms.stream.livetranscoder.ILiveStreamTranscoder;
import com.wowza.wms.stream.livetranscoder.LiveStreamTranscoderFactory;
import com.wowza.wms.stream.livetranscoder.LiveStreamTranscoderItem;
import com.wowza.wms.stream.livetranscoder.LiveStreamTranscoderList;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.ThreadPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveReceiver
implements IMediaStreamMetaDataProvider,
ILiveReceiver {
    private IMediaStream stream = null;
    private List tmpObjs = new ArrayList();
    private AMFPacket tmpKeyFrame = null;
    private AMFPacket videoObj = null;
    private AMFPacket audioObj = null;
    private AMFPacket dataObj = null;
    private long packetSeq = 0L;
    private long sortedSeq = 0L;
    private int maximumLiveLatency = 8000;
    private int src = 0;
    private int audioLag = 0;
    private int videoLag = 0;
    private long lastReceivedAudioTC = -1L;
    private long lastReceivedVideoTC = -1L;
    private long lastReceivedDataTC = -1L;
    private long lastSentAudioTC = -1L;
    private long lastSentVideoTC = -1L;
    private long lastSentDataTC = -1L;
    private long lastFlushAudioTC = -1L;
    private long lastFlushVideoTC = -1L;
    private long lastFlushDataTC = -1L;
    private ThreadPool threadPool = null;
    private boolean onFlushNotifyClients = false;
    private boolean sortPackets = false;
    private int sortBufferSize = 250;
    private LiveReceiverPacketSorter sortSorter = null;
    private int flushInterval = 50;
    private long maxFlushTimecode = -1L;
    private long lastFlushTimecode = -1L;
    private long maxFlushRTTimecode = -1L;
    private long lastFlushRTTimecode = -1L;
    private boolean isDebugLog = false;
    private long timecodeSource = -1L;
    private long timecodeRealtime = -1L;
    private long lastFlushTime = -1L;
    private long lastNotifyTime = -1L;
    private boolean verboseDebug = false;
    private long lastTCOffset = 0L;
    private int nothingTrimmedCount = 0;
    private boolean somethingTrimmed = false;
    private AtomicLong maxTC = new AtomicLong(-1L);
    private AtomicLong maxTCSeq = new AtomicLong(-1L);
    private AtomicReference<List> dataObjsRef = new AtomicReference(new ArrayList());
    private AtomicReference<List> startupObjsRef = new AtomicReference(new ArrayList());
    private AtomicReference<AMFPacket> lastKeyFrame = new AtomicReference<Object>(null);
    private AtomicReference<AMFPacket> metaDataPacket = new AtomicReference<Object>(null);
    private boolean inEnhancedSeek = false;
    private boolean hitEnhancedSeekEnd = false;
    private SortedMap<Long, AMFPacket> audioCodecConfigPackets = new TreeMap<Long, AMFPacket>();
    private int audioCodecConfigPacketCount = 0;
    private AtomicReference<AMFPacket> audioCodecConfigPacketLastAdded = new AtomicReference<Object>(null);
    private SortedMap<Long, AMFPacket> videoCodecConfigPackets = new TreeMap<Long, AMFPacket>();
    private int videoCodecConfigPacketCount = 0;
    private AtomicReference<AMFPacket> videoCodecConfigPacketLastAdded = new AtomicReference<Object>(null);
    private LiveStreamPacketizerRunner liveStreamPacketizerRunner = null;
    private LiveStreamTranscoderRunner liveStreamTranscoderRunner = null;
    private boolean initLiveStreamPacketizers = true;
    private boolean initLiveStreamTranscoders = true;
    private int videoCodecId = -1;
    private int audioCodecId = -1;
    private boolean debugKeyFrameTimecodes = false;
    private ThreadedNotify threadedNotify = null;
    private boolean extractH264VideoFrameType = false;
    private boolean fixH264VideoNALLenStartcodeMix = false;
    private int h264VideoNALLenStartcodeLen = 3;

    private void initLiveStreamTranscoders() {
        IApplicationInstance iApplicationInstance;
        int n = 0;
        IVHost iVHost = null;
        HashMap<String, ILiveStreamTranscoder> hashMap = new HashMap<String, ILiveStreamTranscoder>();
        String string = this.stream.getLiveStreamTranscoderList();
        if (string != null && string.length() > 0 && (iApplicationInstance = this.stream.getStreams().getAppInstance()) != null) {
            MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
            String string2 = this.stream.getName();
            iVHost = iApplicationInstance.getVHost();
            LiveStreamTranscoderList liveStreamTranscoderList = iVHost.getLiveStreamTranscoderList();
            string = string.replace(",", "|");
            string = string.replace(";", "|");
            String[] stringArray = string.split("[|]");
            for (int i = 0; i < stringArray.length; ++i) {
                ILiveStreamTranscoder iLiveStreamTranscoder;
                LiveStreamTranscoderItem liveStreamTranscoderItem;
                String string3 = stringArray[i].trim();
                if (string3.length() <= 0 || !iApplicationInstance.getLiveStreamTranscoderControl().isLiveStreamTranscode(string3, this.stream) || (liveStreamTranscoderItem = liveStreamTranscoderList.getLiveStreamTranscoderDef(string3)) == null || (iLiveStreamTranscoder = LiveStreamTranscoderFactory.createInstance((IMediaStream)this.stream, (LiveStreamTranscoderItem)liveStreamTranscoderItem)) == null) continue;
                this.stream.putLiveStreamTranscoder(string3, iLiveStreamTranscoder);
                hashMap.put(string3, iLiveStreamTranscoder);
                ++n;
            }
        }
        if (n > 0) {
            this.liveStreamTranscoderRunner = new LiveStreamTranscoderRunner(this.stream, iVHost.getHandlerThreadPool());
            this.liveStreamTranscoderRunner.setLiveStreamTranscoders(hashMap);
        }
    }

    private void initLiveStreamPacketizers() {
        IApplicationInstance iApplicationInstance;
        int n = 0;
        IVHost iVHost = null;
        HashMap<String, ILiveStreamPacketizer> hashMap = new HashMap<String, ILiveStreamPacketizer>();
        String string = this.stream.getLiveStreamPacketizerList();
        if (string != null && string.length() > 0 && (iApplicationInstance = this.stream.getStreams().getAppInstance()) != null) {
            MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
            String string2 = this.stream.getName();
            iVHost = iApplicationInstance.getVHost();
            LiveStreamPacketizerList liveStreamPacketizerList = iVHost.getLiveStreamPacketizerList();
            string = string.replace(",", "|");
            string = string.replace(";", "|");
            String[] stringArray = string.split("[|]");
            for (int i = 0; i < stringArray.length; ++i) {
                LiveStreamPacketizerItem liveStreamPacketizerItem;
                String string3 = stringArray[i].trim();
                if (string3.length() <= 0 || !iApplicationInstance.getLiveStreamPacketizerControl().isLiveStreamPacketize(string3, this.stream) || (liveStreamPacketizerItem = liveStreamPacketizerList.getLiveStreamPacketizerDef(string3)) == null || liveStreamPacketizerItem.isRepeater()) continue;
                hashMap.put(string3, null);
                ++n;
            }
        }
        if (n > 0) {
            this.liveStreamPacketizerRunner = new LiveStreamPacketizerRunner(this.stream, iVHost.getHandlerThreadPool());
            this.liveStreamPacketizerRunner.setLiveStreamPacketizers(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClients() {
        boolean bl = false;
        List list = this.threadedNotify.notifyQueue;
        synchronized (list) {
            this.threadedNotify.notifyQueue.add(null);
            if (this.threadedNotify.processingCompleted) {
                this.threadedNotify.processingCompleted = false;
                bl = true;
            }
        }
        if (bl) {
            this.threadPool.execute((Runnable)this.threadedNotify);
        }
        if (this.isDebugLog) {
            long l = System.currentTimeMillis();
            long l2 = this.lastNotifyTime == -1L ? 0L : l - this.lastNotifyTime;
            this.lastNotifyTime = l;
            WMSLoggerFactory.getLogger(null).debug("notify: dataObjs:" + this.dataObjsRef.get().size() + " time:" + l2);
        }
    }

    @Override
    public void init(IMediaStream iMediaStream) {
        this.stream = iMediaStream;
        this.threadedNotify = new ThreadedNotify(this.stream);
        this.threadPool = this.stream.getStreams().getVHost().getThreadPool();
        WMSProperties wMSProperties = this.stream.getProperties();
        if (wMSProperties != null) {
            this.onFlushNotifyClients = wMSProperties.getPropertyBoolean("onFlushNotifyClients", this.onFlushNotifyClients);
            this.flushInterval = wMSProperties.getPropertyInt("flushInterval", this.flushInterval);
            this.verboseDebug = wMSProperties.getPropertyBoolean("verboseDebug", this.verboseDebug);
            this.sortPackets = wMSProperties.getPropertyBoolean("sortPackets", this.sortPackets);
            this.sortBufferSize = wMSProperties.getPropertyInt("sortBufferSize", this.sortBufferSize);
            this.audioLag = wMSProperties.getPropertyInt("audioLag", this.audioLag);
            this.videoLag = wMSProperties.getPropertyInt("videoLag", this.videoLag);
            this.debugKeyFrameTimecodes = wMSProperties.getPropertyBoolean("debugKeyFrameTimecodes", this.debugKeyFrameTimecodes);
            this.extractH264VideoFrameType = wMSProperties.getPropertyBoolean("extractH264VideoFrameType", this.extractH264VideoFrameType);
            this.fixH264VideoNALLenStartcodeMix = wMSProperties.getPropertyBoolean("fixH264VideoNALLenStartcodeMix", this.fixH264VideoNALLenStartcodeMix);
            this.h264VideoNALLenStartcodeLen = wMSProperties.getPropertyInt("h264VideoNALLenStartcodeLen", this.h264VideoNALLenStartcodeLen);
            if (this.audioLag != 0) {
                WMSLoggerFactory.getLogger(LiveReceiver.class).info("audioLag[" + this.stream.getSrc() + "]: " + this.audioLag);
            }
            if (this.videoLag != 0) {
                WMSLoggerFactory.getLogger(LiveReceiver.class).info("videoLag[" + this.stream.getSrc() + "]: " + this.videoLag);
            }
            if (this.sortPackets) {
                this.sortSorter = new LiveReceiverPacketSorter();
                WMSLoggerFactory.getLogger(LiveReceiver.class).info("sortPackets[" + this.stream.getSrc() + "]: sortBufferSize:" + this.sortBufferSize);
            }
        }
        this.isDebugLog = WMSLoggerFactory.getLogger(LiveReceiver.class).isDebugEnabled();
        if (this.isDebugLog) {
            WMSLoggerFactory.getLogger(LiveReceiver.class).debug("onFlushNotifyClients: " + this.onFlushNotifyClients);
            WMSLoggerFactory.getLogger(LiveReceiver.class).debug("flushInterval: " + this.flushInterval);
            WMSLoggerFactory.getLogger(LiveReceiver.class).debug("verboseDebug: " + this.verboseDebug);
        }
    }

    protected void newPacket(AMFPacket aMFPacket) {
        if (this.initLiveStreamPacketizers) {
            this.initLiveStreamPacketizers();
            this.initLiveStreamPacketizers = false;
        }
        if (this.initLiveStreamTranscoders) {
            this.initLiveStreamTranscoders();
            this.initLiveStreamTranscoders = false;
        }
        if (this.liveStreamPacketizerRunner != null) {
            this.liveStreamPacketizerRunner.handlePacket(aMFPacket);
        }
        if (this.liveStreamTranscoderRunner != null) {
            this.liveStreamTranscoderRunner.handlePacket(aMFPacket);
        }
    }

    protected void resetTimecodePacketizer() {
        if (this.initLiveStreamPacketizers) {
            this.initLiveStreamPacketizers();
            this.initLiveStreamPacketizers = false;
        }
        if (this.initLiveStreamTranscoders) {
            this.initLiveStreamTranscoders();
            this.initLiveStreamTranscoders = false;
        }
        if (this.liveStreamPacketizerRunner != null) {
            this.liveStreamPacketizerRunner.resetTimecodes();
        }
        if (this.liveStreamTranscoderRunner != null) {
            this.liveStreamTranscoderRunner.resetTimecodes();
        }
    }

    @Override
    public void resetTimecodes() {
        WMSLoggerFactory.getLogger(null).debug("LiveReceiver2: resetTimecodes");
        this.checkFlush(0L, true);
        this.tmpObjs.clear();
        this.sortSorter = new LiveReceiverPacketSorter();
        this.tmpKeyFrame = null;
        this.maxFlushTimecode = -1L;
        this.lastFlushTimecode = -1L;
        this.maxFlushRTTimecode = -1L;
        this.lastFlushRTTimecode = -1L;
        this.lastFlushTime = -1L;
        this.lastNotifyTime = -1L;
        this.lastReceivedAudioTC = -1L;
        this.lastReceivedVideoTC = -1L;
        this.lastReceivedDataTC = -1L;
        this.lastSentAudioTC = -1L;
        this.lastSentVideoTC = -1L;
        this.lastSentDataTC = -1L;
        this.lastFlushAudioTC = -1L;
        this.lastFlushVideoTC = -1L;
        this.lastFlushDataTC = -1L;
        this.lastTCOffset = 0L;
        this.maxTC.set(-1L);
        this.maxTCSeq.set(-1L);
        this.nothingTrimmedCount = 0;
        this.somethingTrimmed = false;
        this.inEnhancedSeek = false;
        this.hitEnhancedSeekEnd = false;
        this.videoCodecId = -1;
        this.audioCodecId = -1;
        this.timecodeSource = -1L;
        this.timecodeRealtime = -1L;
        this.dataObjsRef.set(new ArrayList());
        this.lastKeyFrame.set(null);
        this.metaDataPacket.set(null);
        this.videoCodecConfigPackets.clear();
        this.videoCodecConfigPacketCount = 0;
        this.videoCodecConfigPacketLastAdded.set(null);
        this.audioCodecConfigPackets.clear();
        this.audioCodecConfigPacketCount = 0;
        this.audioCodecConfigPacketLastAdded.set(null);
        this.resetTimecodePacketizer();
    }

    @Override
    public int getVideoMissing(int n) {
        if (this.videoObj != null) {
            return this.videoObj.getMissing();
        }
        return n;
    }

    @Override
    public int getDataMissing(int n) {
        if (this.dataObj != null) {
            return this.dataObj.getMissing();
        }
        return n;
    }

    @Override
    public int getAudioMissing(int n) {
        if (this.audioObj != null) {
            return this.audioObj.getMissing();
        }
        return n;
    }

    private void initAudioObj(int n) {
        if (this.audioObj == null) {
            this.audioObj = new AMFPacket(8, this.src, n);
        }
    }

    private void initVideoObj(int n) {
        if (this.videoObj == null) {
            this.videoObj = new AMFPacket(9, this.src, n);
        }
    }

    private void initDataObj(int n) {
        if (this.dataObj == null) {
            this.dataObj = new AMFPacket(this.stream.getDataType(), this.src, n);
        }
    }

    @Override
    public void startVideoPacket() {
        if (this.videoObj != null) {
            WMSLoggerFactory.getLogger(null).warn("LiveReceiver.startVideoPacket: Video packet sync issue.");
            this.videoObj = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVideoData(byte[] byArray, int n, int n2, int n3, long l) {
        this.initVideoObj(n3);
        int n4 = this.videoObj.addData(byArray, n, n2);
        if (n4 == 0) {
            try {
                long l2;
                SortedMap<Long, AMFPacket> sortedMap;
                l += (long)this.videoLag;
                int n5 = -1;
                boolean bl = true;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                int n6 = 0;
                int n7 = 0;
                if (n3 >= 1) {
                    n6 = this.videoObj.getFirstByte();
                    n5 = n6 & 0xF;
                }
                if (n3 >= 2) {
                    n7 = this.videoObj.getSecondByte();
                }
                if (n3 == 2 && (n6 & 0x50) == 80 && (n7 == 0 || n7 == 1)) {
                    bl2 = true;
                    bl3 = n7 == 0;
                    boolean bl6 = bl4 = n7 == 1;
                    if (bl3) {
                        this.inEnhancedSeek = true;
                        this.hitEnhancedSeekEnd = false;
                    } else if (bl4) {
                        this.hitEnhancedSeekEnd = true;
                    }
                }
                if (this.inEnhancedSeek) {
                    bl = false;
                }
                if (this.hitEnhancedSeekEnd) {
                    this.inEnhancedSeek = false;
                }
                if (n5 != -1) {
                    sortedMap = this.videoCodecConfigPackets;
                    synchronized (sortedMap) {
                        this.videoCodecId = n5;
                    }
                }
                if (n3 >= 2 && n5 != -1) {
                    if (n5 == 7) {
                        if (!bl2 && n7 == 1 && n3 > 13) {
                            int n8;
                            int n9;
                            sortedMap = (SortedMap<Long, AMFPacket>)this.videoObj.getData();
                            int n10 = 5;
                            int n11 = BufferUtils.byteArrayToInt(sortedMap, (int)n10, (int)4);
                            if (n11 == n3 - (n10 += 4) && sortedMap[n10 + 0] == false && sortedMap[n10 + 1] == false && sortedMap[n10 + 2] == false && sortedMap[n10 + 3] == true) {
                                int n12;
                                byte[] byArray2 = new byte[n3 - 4];
                                System.arraycopy(sortedMap, 0, byArray2, 0, 5);
                                System.arraycopy(sortedMap, 9, byArray2, 5, n3 - 9);
                                this.videoObj.setDataBuffer(byArray2);
                                n9 = 5;
                                for (n8 = 9; n8 < byArray2.length - 4; ++n8) {
                                    if (byArray2[n8 + 0] != 0 || byArray2[n8 + 1] != 0 || byArray2[n8 + 2] != 0 || byArray2[n8 + 3] != 1) continue;
                                    n12 = n8 - n9 - 4;
                                    BufferUtils.intToByteArray((int)n12, (byte[])byArray2, (int)n9, (int)4);
                                    n9 = n8;
                                }
                                n12 = byArray2.length - n9 - 4;
                                BufferUtils.intToByteArray((int)n12, (byte[])byArray2, (int)n9, (int)4);
                            }
                            int n13 = this.videoObj.getSize();
                            if (this.fixH264VideoNALLenStartcodeMix && n13 > 5) {
                                try {
                                    byte[] byArray3 = H264Utils.fixH264VideoNALLenStartcodeMix((byte[])this.videoObj.getData(), (int)5, (int)(this.videoObj.getSize() - 5), (int)this.h264VideoNALLenStartcodeLen);
                                    this.videoObj.setDataBuffer(byArray3);
                                }
                                catch (Exception exception) {
                                    WMSLoggerFactory.getLogger(null).error("LiveReceiver.addVideoData[H264Utils.fixH264VideoNALLenStartcodeMix]: " + exception.toString());
                                }
                                n13 = this.videoObj.getSize();
                            }
                            if (this.extractH264VideoFrameType && n13 > 5) {
                                n9 = -1;
                                try {
                                    n9 = H264Utils.extractFrameType((byte[])this.videoObj.getData(), (int)5, (int)(this.videoObj.getSize() - 5));
                                }
                                catch (Exception exception) {
                                    WMSLoggerFactory.getLogger(null).error("LiveReceiver.addVideoData[H264Utils.extractFrameType]: " + exception.toString());
                                }
                                n8 = FLVUtils.getFrameType((int)n6);
                                if (n8 != n9 && n8 >= 1 && n8 <= 3 && n9 >= 1 && n9 <= 3) {
                                    byte[] byArray4 = this.videoObj.getData();
                                    byArray4[0] = (byte)(byArray4[0] & 0xF | n9 << 4);
                                    n6 = byArray4[0];
                                }
                            }
                        }
                        if (!bl2 && n7 == 0) {
                            bl5 = true;
                            sortedMap = this.videoCodecConfigPackets;
                            synchronized (sortedMap) {
                                this.videoCodecConfigPackets.put(new Long(l), this.videoObj);
                                this.videoCodecConfigPacketLastAdded.set(this.videoObj);
                                this.videoCodecConfigPacketCount = this.videoCodecConfigPackets.size();
                            }
                        }
                    } else if (this.videoCodecConfigPacketLastAdded.get() != null) {
                        sortedMap = this.videoCodecConfigPackets;
                        synchronized (sortedMap) {
                            this.videoCodecConfigPackets.put(new Long(l), null);
                            this.videoCodecConfigPacketLastAdded.set(null);
                            this.videoCodecConfigPacketCount = this.videoCodecConfigPackets.size();
                        }
                    }
                }
                long l3 = l2 = this.lastReceivedVideoTC == -1L ? 0L : l - this.lastReceivedVideoTC;
                if (this.isDebugLog && this.verboseDebug) {
                    String string = "" + n3;
                    while (string.length() < 5) {
                        string = "0" + string;
                    }
                    String string2 = ",fbyte:" + this.videoObj.getFirstByte();
                    WMSLoggerFactory.getLogger(null).debug("MS: VID: mediadat[tp:vid,si:" + this.getSrc() + ",sz:" + string + ",tc:" + this.lastReceivedVideoTC + string2 + "]");
                }
                if (bl) {
                    ++this.packetSeq;
                    this.lastReceivedVideoTC = l;
                    if (this.packetSeq - this.maxTCSeq.get() > 10L || l > this.maxTC.get()) {
                        this.maxTC.set(l);
                        this.maxTCSeq.set(this.packetSeq);
                    }
                    this.videoObj.setTimecodes(l2, l);
                    if (this.sortPackets) {
                        this.sortSorter.addVideo(this.videoObj, System.currentTimeMillis());
                    } else {
                        this.videoObj.setSeq(this.packetSeq);
                        this.tmpObjs.add(this.videoObj);
                    }
                    if (FLVUtils.isVideoKeyFrame((AMFPacket)this.videoObj)) {
                        this.tmpKeyFrame = this.videoObj;
                        if (this.debugKeyFrameTimecodes) {
                            long l4;
                            long l5 = l4 = this.videoObj.getAbsTimecode();
                            if (n5 == 7 && n3 >= 5) {
                                l4 += BufferUtils.byteArrayToLong((byte[])this.videoObj.getData(), (int)2, (int)3);
                            }
                            WMSLoggerFactory.getLogger(null).info("Key frame[" + this.stream.getStreams().getAppInstance().getContextStr() + "/" + this.stream.getName() + "]: dts:" + l5 + " pts:" + l4);
                        }
                    }
                    this.newPacket(this.videoObj);
                    this.checkFlush(l, false);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).debug("LiveReceiver.addDataData2: " + exception.toString());
            }
            this.videoObj = null;
        }
    }

    @Override
    public void startDataPacket() {
        if (this.dataObj != null) {
            WMSLoggerFactory.getLogger(null).warn("LiveReceiver.startDataPacket: Data packet sync issue.");
            this.dataObj = null;
        }
    }

    @Override
    public void addDataData(byte[] byArray, int n, int n2, int n3, long l) {
        this.initDataObj(n3);
        int n4 = this.dataObj.addData(byArray, n, n2);
        if (n4 == 0) {
            boolean bl;
            block24: {
                bl = true;
                try {
                    AMFPacket aMFPacket;
                    Object object;
                    String string;
                    Object object2;
                    AMFPacket aMFPacket2;
                    int n5;
                    AMFDataList aMFDataList;
                    byte[] byArray2 = this.dataObj.getData();
                    if (byArray2 == null || byArray2.length <= 0) break block24;
                    int n6 = 0;
                    if (byArray2[0] == 0) {
                        ++n6;
                    }
                    if ((aMFDataList = new AMFDataList(byArray2, n6, byArray2.length - n6)).size() <= 1 || aMFDataList.get(0).getType() != 2) break block24;
                    String string2 = aMFDataList.getString(0);
                    boolean bl2 = this.stream.isMergeOnMetadata();
                    if (string2.equals("@setDataFrame")) {
                        bl = false;
                        bl2 = true;
                        aMFDataList.remove(0);
                    }
                    if (aMFDataList.size() <= 1 || aMFDataList.get(0).getType() != 2 || !(string2 = aMFDataList.getString(0)).equalsIgnoreCase("onMetaData") || (n5 = aMFDataList.get(1).getType()) != 3 && n5 != 8) break block24;
                    AMFDataObj aMFDataObj = new AMFDataObj();
                    if (bl2 && (aMFPacket2 = this.metaDataPacket.get()) != null) {
                        object2 = null;
                        try {
                            object2 = new AMFDataList(aMFPacket2.getData());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (object2 != null && object2.size() > 1) {
                            AMFData aMFData;
                            String string3;
                            Iterator iterator;
                            int n7 = object2.get(1).getType();
                            if (n7 == 3) {
                                string = (AMFDataObj)object2.get(1);
                                object = string.getKeys();
                                iterator = object.iterator();
                                while (iterator.hasNext()) {
                                    string3 = (String)iterator.next();
                                    aMFData = string.get(string3);
                                    aMFDataObj.put(string3, aMFData);
                                }
                            } else if (n7 == 8) {
                                string = (AMFDataMixedArray)object2.get(1);
                                object = string.getKeys();
                                iterator = object.iterator();
                                while (iterator.hasNext()) {
                                    string3 = (String)iterator.next();
                                    aMFData = string.get(string3);
                                    aMFDataObj.put(string3, aMFData);
                                }
                            }
                        }
                    }
                    if (n5 == 3) {
                        aMFPacket2 = (AMFDataObj)aMFDataList.get(1);
                        object2 = aMFPacket2.getKeys();
                        aMFPacket = object2.iterator();
                        while (aMFPacket.hasNext()) {
                            string = (String)aMFPacket.next();
                            object = aMFPacket2.get(string);
                            aMFDataObj.put(string, (AMFData)object);
                        }
                    } else if (n5 == 8) {
                        aMFPacket2 = (AMFDataMixedArray)aMFDataList.get(1);
                        object2 = aMFPacket2.getKeys();
                        aMFPacket = object2.iterator();
                        while (aMFPacket.hasNext()) {
                            string = (String)aMFPacket.next();
                            object = aMFPacket2.get(string);
                            aMFDataObj.put(string, (AMFData)object);
                        }
                    }
                    aMFPacket2 = new AMFDataList();
                    aMFPacket2.add((AMFData)new AMFDataItem("onMetaData"));
                    aMFPacket2.add((AMFData)aMFDataObj);
                    object2 = aMFPacket2.serialize();
                    aMFPacket = new AMFPacket(18, 0, ((Object)object2).length);
                    aMFPacket.addData((byte[])object2, 0, ((Object)object2).length);
                    this.stream.notifyActionOnMetaData(aMFPacket);
                    this.metaDataPacket.set(aMFPacket);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(LiveReceiver.class).warn("LiveReceiver2: addDataData: parse data frame: " + exception.toString());
                }
            }
            try {
                if (bl) {
                    long l2 = this.lastReceivedDataTC == -1L ? 0L : l - this.lastReceivedDataTC;
                    this.lastReceivedDataTC = l;
                    ++this.packetSeq;
                    this.dataObj.setTimecodes(l2, l);
                    if (this.sortPackets) {
                        this.sortSorter.addData(this.dataObj, System.currentTimeMillis());
                    } else {
                        this.dataObj.setSeq(this.packetSeq);
                        this.tmpObjs.add(this.dataObj);
                    }
                    this.newPacket(this.dataObj);
                    this.checkFlush(l, true);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).debug("LiveReceiver.addDataData2: " + exception.toString());
            }
            this.dataObj = null;
        }
    }

    public boolean isAAC(int n) {
        return (n & 0xF0) == 160;
    }

    public boolean isH264(int n) {
        return (n & 0xF) == 7;
    }

    @Override
    public void startAudioPacket() {
        if (this.audioObj != null) {
            WMSLoggerFactory.getLogger(null).warn("LiveReceiver.startAudioPacket: Audio packet sync issue.");
            this.audioObj = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAudioData(byte[] byArray, int n, int n2, int n3, long l) {
        this.initAudioObj(n3);
        int n4 = this.audioObj.addData(byArray, n, n2);
        if (n4 == 0) {
            try {
                long l2;
                SortedMap<Long, AMFPacket> sortedMap;
                l += (long)this.audioLag;
                int n5 = -1;
                boolean bl = true;
                boolean bl2 = false;
                int n6 = 0;
                int n7 = 0;
                if (n3 >= 1) {
                    n6 = this.audioObj.getFirstByte();
                    n5 = n6 >> 4 & 0xF;
                }
                if (n3 >= 2) {
                    n7 = this.audioObj.getSecondByte();
                }
                if (n5 != -1) {
                    sortedMap = this.audioCodecConfigPackets;
                    synchronized (sortedMap) {
                        this.audioCodecId = n5;
                    }
                }
                if (n3 >= 2 && n5 != -1) {
                    if (n5 == 10) {
                        if (n7 == 0) {
                            bl2 = true;
                            sortedMap = this.audioCodecConfigPackets;
                            synchronized (sortedMap) {
                                this.audioCodecConfigPackets.put(new Long(l), this.audioObj);
                                this.audioCodecConfigPacketLastAdded.set(this.audioObj);
                                this.audioCodecConfigPacketCount = this.audioCodecConfigPackets.size();
                            }
                        }
                    } else if (this.audioCodecConfigPacketLastAdded.get() != null) {
                        sortedMap = this.audioCodecConfigPackets;
                        synchronized (sortedMap) {
                            this.audioCodecConfigPackets.put(new Long(l), null);
                            this.audioCodecConfigPacketLastAdded.set(null);
                            this.audioCodecConfigPacketCount = this.audioCodecConfigPackets.size();
                        }
                    }
                }
                long l3 = l2 = this.lastReceivedAudioTC == -1L ? 0L : l - this.lastReceivedAudioTC;
                if (this.isDebugLog && this.verboseDebug) {
                    String string = "" + n3;
                    while (string.length() < 5) {
                        string = "0" + string;
                    }
                    String string2 = ",fbyte:" + this.audioObj.getFirstByte();
                    WMSLoggerFactory.getLogger(null).debug("MS: AUD: mediadat[tp:aud,si:" + this.getSrc() + ",sz:" + string + ",tc:" + this.lastReceivedAudioTC + string2 + "]");
                }
                if (bl) {
                    ++this.packetSeq;
                    this.lastReceivedAudioTC = l;
                    if (this.packetSeq - this.maxTCSeq.get() > 10L || l > this.maxTC.get()) {
                        this.maxTC.set(l);
                        this.maxTCSeq.set(this.packetSeq);
                    }
                    this.audioObj.setTimecodes(l2, l);
                    if (this.sortPackets) {
                        this.sortSorter.addAudio(this.audioObj, System.currentTimeMillis());
                    } else {
                        this.audioObj.setSeq(this.packetSeq);
                        this.tmpObjs.add(this.audioObj);
                    }
                    this.newPacket(this.audioObj);
                    this.checkFlush(l, false);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).debug("LiveReceiver.addAudioData: " + exception.toString());
            }
            this.audioObj = null;
        }
    }

    @Override
    public int getPacketCount() {
        return this.dataObjsRef.get().size();
    }

    @Override
    public long getLastPacketTC() {
        long l = -1L;
        List list = this.dataObjsRef.get();
        int n = list.size();
        if (n > 0) {
            AMFPacket aMFPacket = (AMFPacket)list.get(n - 1);
            l = aMFPacket.getAbsTimecode();
        }
        return l;
    }

    @Override
    public long getFirstPacketTC() {
        long l = -1L;
        List list = this.dataObjsRef.get();
        int n = list.size();
        if (n > 0) {
            AMFPacket aMFPacket = (AMFPacket)list.get(0);
            l = aMFPacket.getAbsTimecode();
        }
        return l;
    }

    @Override
    public AMFPacket getLastPacket() {
        List list = this.dataObjsRef.get();
        int n = list.size();
        return n > 0 ? (AMFPacket)list.get(n - 1) : null;
    }

    @Override
    public List<AMFPacket> getPlayPackets() {
        this.lastSentAudioTC = this.lastFlushAudioTC;
        this.lastSentVideoTC = this.lastFlushVideoTC;
        this.lastSentDataTC = this.lastFlushDataTC;
        return this.dataObjsRef.get();
    }

    private void checkFlush(long l, boolean bl) {
        boolean bl2 = bl;
        long l2 = System.currentTimeMillis();
        if (!bl2) {
            this.maxFlushTimecode = l > this.maxFlushTimecode ? l : this.maxFlushTimecode;
            this.lastFlushTimecode = this.lastFlushTimecode == -1L ? this.maxFlushTimecode : this.lastFlushTimecode;
            this.maxFlushRTTimecode = l2;
            this.lastFlushRTTimecode = this.lastFlushRTTimecode == -1L ? this.maxFlushRTTimecode : this.lastFlushRTTimecode;
            boolean bl3 = bl2 = this.maxFlushTimecode >= this.lastFlushTimecode + (long)this.flushInterval || this.maxFlushRTTimecode >= this.lastFlushRTTimecode + (long)this.flushInterval;
            if (this.isDebugLog) {
                WMSLoggerFactory.getLogger(null).debug("checkFlush[" + bl2 + "," + this.onFlushNotifyClients + "," + this.flushInterval + "]: tc:" + this.maxFlushTimecode + ">" + (this.lastFlushTimecode + (long)this.flushInterval) + " || rt:" + this.maxFlushRTTimecode + ">" + (this.lastFlushRTTimecode + (long)this.flushInterval));
            }
            if (bl2) {
                this.lastFlushTimecode = this.maxFlushTimecode;
                this.lastFlushRTTimecode = this.maxFlushRTTimecode;
            }
        }
        if (bl2) {
            long l3;
            ArrayList<AMFPacket> arrayList = new ArrayList<AMFPacket>();
            arrayList.addAll(this.dataObjsRef.get());
            int n = 0;
            if (this.sortPackets) {
                List<AMFPacket> list = this.sortSorter.getPackets(l2, this.sortBufferSize);
                AMFPacket aMFPacket = null;
                for (AMFPacket aMFPacket2 : list) {
                    ++this.sortedSeq;
                    aMFPacket2.setSeq(this.sortedSeq);
                    if (FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket2)) {
                        aMFPacket = aMFPacket2;
                    }
                    arrayList.add(aMFPacket2);
                    ++n;
                }
                if (aMFPacket != null) {
                    this.lastKeyFrame.set(aMFPacket);
                }
            } else {
                arrayList.addAll(this.tmpObjs);
                n = this.tmpObjs.size();
                this.tmpObjs.clear();
                if (this.tmpKeyFrame != null) {
                    this.lastKeyFrame.set(this.tmpKeyFrame);
                    this.tmpKeyFrame = null;
                }
            }
            this.trim(arrayList);
            int n2 = arrayList.size();
            this.lastFlushAudioTC = this.lastReceivedAudioTC;
            this.lastFlushVideoTC = this.lastReceivedVideoTC;
            this.lastFlushDataTC = this.lastReceivedDataTC;
            this.dataObjsRef.set(arrayList);
            if (this.onFlushNotifyClients) {
                this.notifyClients();
            }
            long l4 = 0L;
            if (this.timecodeRealtime == -1L) {
                this.timecodeRealtime = l2;
                this.timecodeSource = this.maxFlushTimecode;
            } else {
                long l5 = l2 - this.timecodeRealtime;
                l3 = this.maxFlushTimecode - this.timecodeSource;
                l4 = l5 - l3;
            }
            this.lastTCOffset = l4;
            if (this.isDebugLog) {
                long l6 = l2;
                l3 = this.lastFlushTime == -1L ? 0L : l6 - this.lastFlushTime;
                this.lastFlushTime = l6;
                WMSLoggerFactory.getLogger(null).debug("flush: notify:" + this.onFlushNotifyClients + " tSize:" + n + " dataObjs:" + n2 + " time:" + l3 + " tOffset:" + l4);
            }
        }
    }

    @Override
    public AMFPacket getLastKeyFrame() {
        return this.lastKeyFrame.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trim(List<AMFPacket> list) {
        block23: {
            long l;
            Iterator<Long> iterator;
            SortedMap<Long, AMFPacket> sortedMap;
            int n;
            block22: {
                AMFPacket aMFPacket;
                long l2;
                int n2 = 0;
                n2 = list.size();
                if (n2 == 0) break block23;
                int n3 = 0;
                AMFPacket aMFPacket2 = list.get(n2 - 1);
                long l3 = aMFPacket2.getAbsTimecode() - (long)this.maximumLiveLatency;
                while (n2 > 0 && (l2 = (aMFPacket = list.get(0)).getAbsTimecode()) < l3) {
                    list.remove(0);
                    --n2;
                    ++n3;
                }
                if (n3 == 0) {
                    ++this.nothingTrimmedCount;
                } else {
                    this.nothingTrimmedCount = 0;
                    this.somethingTrimmed = true;
                }
                if (this.nothingTrimmedCount >= 3 && n2 > 0) {
                    AMFPacket aMFPacket3;
                    long l4;
                    int n4;
                    for (n4 = n2 - 1; n4 >= 0 && (l4 = (aMFPacket3 = list.get(n4)).getAbsTimecode()) >= l3; --n4) {
                    }
                    int n5 = 0;
                    for (n = 0; n <= n4; ++n) {
                        list.remove(0);
                        --n2;
                        ++n5;
                    }
                    this.nothingTrimmedCount = 0;
                }
                if (this.audioCodecConfigPacketCount > 10) {
                    try {
                        if (list.size() <= 0) break block22;
                        long l5 = list.get(0).getAbsTimecode();
                        n = 0;
                        sortedMap = this.audioCodecConfigPackets;
                        synchronized (sortedMap) {
                            Long l6;
                            iterator = this.audioCodecConfigPackets.keySet().iterator();
                            while (iterator.hasNext() && (l = (l6 = iterator.next()).longValue()) < l5) {
                                ++n;
                            }
                            n -= 2;
                            for (int i = 0; i < n; ++i) {
                                Long l7 = this.audioCodecConfigPackets.firstKey();
                                this.audioCodecConfigPackets.remove(l7);
                                if (this.audioCodecConfigPackets.size() <= 0) break;
                            }
                            this.audioCodecConfigPacketCount = this.audioCodecConfigPackets.size();
                        }
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(null).error("LiveReceiver.trim[audioCodecConfig]: " + exception.toString());
                    }
                }
            }
            if (this.videoCodecConfigPacketCount > 10) {
                try {
                    if (list.size() <= 0) break block23;
                    long l8 = list.get(0).getAbsTimecode();
                    n = 0;
                    sortedMap = this.videoCodecConfigPackets;
                    synchronized (sortedMap) {
                        Long l9;
                        iterator = this.videoCodecConfigPackets.keySet().iterator();
                        while (iterator.hasNext() && (l = (l9 = iterator.next()).longValue()) < l8) {
                            ++n;
                        }
                        n -= 2;
                        for (int i = 0; i < n; ++i) {
                            Long l10 = this.videoCodecConfigPackets.firstKey();
                            this.videoCodecConfigPackets.remove(l10);
                            if (this.videoCodecConfigPackets.size() <= 0) break;
                        }
                        this.videoCodecConfigPacketCount = this.videoCodecConfigPackets.size();
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error("LiveReceiver.trim[videoCodecConfig]: " + exception.toString());
                }
            }
        }
    }

    @Override
    public void trim() {
    }

    @Override
    public int getMaximumLiveLatency() {
        return this.maximumLiveLatency;
    }

    @Override
    public void setMaximumLiveLatency(int n) {
        this.maximumLiveLatency = n;
    }

    @Override
    public int getSrc() {
        return this.src;
    }

    @Override
    public void setSrc(int n) {
        this.src = n;
    }

    @Override
    public void close() {
        if (this.liveStreamTranscoderRunner != null) {
            this.liveStreamTranscoderRunner.close();
        }
        this.checkFlush(0L, true);
        this.dataObjsRef.set(new ArrayList());
        this.startupObjsRef.set(new ArrayList());
        this.lastKeyFrame.set(null);
        this.metaDataPacket.set(null);
        this.videoCodecConfigPackets.clear();
        this.videoCodecConfigPacketCount = 0;
        this.videoCodecConfigPacketLastAdded.set(null);
        this.audioCodecConfigPackets.clear();
        this.audioCodecConfigPacketCount = 0;
        this.audioCodecConfigPacketLastAdded.set(null);
        this.tmpKeyFrame = null;
        this.tmpObjs.clear();
        this.packetSeq = 0L;
        this.sortedSeq = 0L;
        this.lastReceivedAudioTC = -1L;
        this.lastReceivedVideoTC = -1L;
        this.lastReceivedDataTC = -1L;
        this.lastSentAudioTC = -1L;
        this.lastSentVideoTC = -1L;
        this.lastSentDataTC = -1L;
        this.lastFlushAudioTC = -1L;
        this.lastFlushVideoTC = -1L;
        this.lastFlushDataTC = -1L;
        this.inEnhancedSeek = false;
        this.hitEnhancedSeekEnd = false;
        this.timecodeSource = -1L;
        this.timecodeRealtime = -1L;
        this.lastFlushTime = -1L;
        this.lastNotifyTime = -1L;
        this.maxFlushTimecode = -1L;
        this.lastFlushTimecode = -1L;
        this.lastTCOffset = 0L;
        this.maxTC.set(-1L);
        this.maxTCSeq.set(-1L);
        this.nothingTrimmedCount = 0;
        this.somethingTrimmed = false;
    }

    @Override
    public long getMaxTimecode() {
        return this.maxTC.get();
    }

    @Override
    public long getTimecodeOffset() {
        return this.lastTCOffset;
    }

    @Override
    public void updateLoggingValues() {
        long l = Math.max(this.lastReceivedAudioTC, Math.max(this.lastReceivedVideoTC, this.lastReceivedDataTC));
        if (l < 0L) {
            l = 0L;
        }
        if (!WMSLoggerFactory.isGlobalLogValueSet((String)"x-spos")) {
            WMSLoggerFactory.putGlobalLogValue((String)"x-spos", (Object)new Long(l));
        }
    }

    @Override
    public long getLastReceivedAudioTC() {
        return this.lastReceivedAudioTC;
    }

    @Override
    public long getLastReceivedVideoTC() {
        return this.lastReceivedVideoTC;
    }

    @Override
    public long getLastReceivedDataTC() {
        return this.lastReceivedDataTC;
    }

    @Override
    public long getLastSentAudioTC() {
        return this.lastSentAudioTC;
    }

    @Override
    public long getLastSentVideoTC() {
        return this.lastSentVideoTC;
    }

    @Override
    public long getLastSentDataTC() {
        return this.lastSentDataTC;
    }

    @Override
    public long getLastFlushAudioTC() {
        return this.lastFlushAudioTC;
    }

    @Override
    public long getLastFlushVideoTC() {
        return this.lastFlushVideoTC;
    }

    @Override
    public long getLastFlushDataTC() {
        return this.lastFlushDataTC;
    }

    @Override
    public long getLastFlushTimecode() {
        return this.lastFlushTimecode;
    }

    @Override
    public long getLastFlushRTTimecode() {
        return this.lastFlushRTTimecode;
    }

    @Override
    public long getLastFlushTime() {
        return this.lastFlushTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMFPacket getAudioCodecConfigPacket(long l) {
        AMFPacket aMFPacket = null;
        Long l2 = new Long(l);
        SortedMap<Long, AMFPacket> sortedMap = this.audioCodecConfigPackets;
        synchronized (sortedMap) {
            if (this.audioCodecConfigPackets.size() > 0) {
                Object object;
                SortedMap<Long, AMFPacket> sortedMap2 = this.audioCodecConfigPackets.tailMap(l2);
                aMFPacket = sortedMap2.size() > 0 && (Long)(object = sortedMap2.firstKey()) == l ? (AMFPacket)sortedMap2.get(object) : ((object = this.audioCodecConfigPackets.headMap(l2)).size() > 0 ? (AMFPacket)object.get(object.lastKey()) : (AMFPacket)this.audioCodecConfigPackets.get(this.audioCodecConfigPackets.firstKey()));
            }
        }
        return aMFPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAudioCodecConfigPacket(long l, AMFPacket aMFPacket) {
        SortedMap<Long, AMFPacket> sortedMap = this.audioCodecConfigPackets;
        synchronized (sortedMap) {
            this.audioCodecConfigPackets.put(new Long(l), aMFPacket);
            this.audioCodecConfigPacketLastAdded.set(aMFPacket);
            this.audioCodecConfigPacketCount = this.audioCodecConfigPackets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMFPacket getVideoCodecConfigPacket(long l) {
        AMFPacket aMFPacket = null;
        Long l2 = new Long(l);
        SortedMap<Long, AMFPacket> sortedMap = this.videoCodecConfigPackets;
        synchronized (sortedMap) {
            if (this.videoCodecConfigPackets.size() > 0) {
                Object object;
                SortedMap<Long, AMFPacket> sortedMap2 = this.videoCodecConfigPackets.tailMap(l2);
                aMFPacket = sortedMap2.size() > 0 && (Long)(object = sortedMap2.firstKey()) == l ? (AMFPacket)sortedMap2.get(object) : ((object = this.videoCodecConfigPackets.headMap(l2)).size() > 0 ? (AMFPacket)object.get(object.lastKey()) : (AMFPacket)this.videoCodecConfigPackets.get(this.videoCodecConfigPackets.firstKey()));
            }
        }
        return aMFPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVideoCodecConfigPacket(long l, AMFPacket aMFPacket) {
        SortedMap<Long, AMFPacket> sortedMap = this.videoCodecConfigPackets;
        synchronized (sortedMap) {
            this.videoCodecConfigPackets.put(new Long(l), aMFPacket);
            this.videoCodecConfigPacketLastAdded.set(aMFPacket);
            this.videoCodecConfigPacketCount = this.videoCodecConfigPackets.size();
        }
    }

    @Override
    public void onStreamStart(List list, long l) {
        AMFPacket aMFPacket = this.metaDataPacket.get();
        if (aMFPacket != null) {
            list.add(aMFPacket);
        }
    }

    @Override
    public void flush() {
        int n = this.tmpObjs.size();
        if (n > 0) {
            this.checkFlush(0L, true);
        }
    }

    @Override
    public ILiveStreamPacketizer getLiveStreamPacketizer(String string) {
        return this.stream.getStreams().getLiveStreamPacketizer(this.stream.getName(), string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getVideoCodecId() {
        SortedMap<Long, AMFPacket> sortedMap = this.videoCodecConfigPackets;
        synchronized (sortedMap) {
            return this.videoCodecId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAudioCodecId() {
        SortedMap<Long, AMFPacket> sortedMap = this.audioCodecConfigPackets;
        synchronized (sortedMap) {
            return this.audioCodecId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVideoCodecId(int n) {
        SortedMap<Long, AMFPacket> sortedMap = this.audioCodecConfigPackets;
        synchronized (sortedMap) {
            this.videoCodecId = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAudioCodecId(int n) {
        SortedMap<Long, AMFPacket> sortedMap = this.audioCodecConfigPackets;
        synchronized (sortedMap) {
            this.audioCodecId = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPublishStreamReady(boolean bl, boolean bl2) {
        SortedMap<Long, AMFPacket> sortedMap;
        int n;
        int n2;
        boolean bl3 = true;
        if (bl) {
            n2 = this.getAudioCodecId();
            if (n2 != -1) {
                if (n2 == 10) {
                    n = 0;
                    sortedMap = this.audioCodecConfigPackets;
                    synchronized (sortedMap) {
                        n = this.audioCodecConfigPackets.size();
                    }
                    if (n <= 0) {
                        bl3 = false;
                    }
                }
            } else {
                bl3 = false;
            }
        }
        if (bl2) {
            n2 = this.getVideoCodecId();
            if (n2 != -1) {
                if (n2 == 7) {
                    n = 0;
                    sortedMap = this.videoCodecConfigPackets;
                    synchronized (sortedMap) {
                        n = this.videoCodecConfigPackets.size();
                    }
                    if (n <= 0) {
                        bl3 = false;
                    }
                }
            } else {
                bl3 = false;
            }
        }
        return bl3;
    }

    class ThreadedNotify
    implements Runnable {
        private IMediaStream stream = null;
        private IApplicationInstance appInstance = null;
        public List notifyQueue = new ArrayList();
        public boolean processingCompleted = true;

        ThreadedNotify(IMediaStream iMediaStream) {
            this.stream = iMediaStream;
            this.appInstance = this.stream.getStreams().getAppInstance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block3: while (true) {
                var1_1 = this.notifyQueue;
                synchronized (var1_1) {
                    if (this.notifyQueue.size() == 0) {
                        this.processingCompleted = true;
                        break;
                    }
                    this.notifyQueue.remove(0);
                }
                var1_1 = this.appInstance.getPlayStreamsByName(this.stream.getName());
                if (var1_1 == null) continue;
                var2_2 = var1_1.iterator();
                while (true) {
                    if (var2_2.hasNext()) ** break;
                    continue block3;
                    var3_4 = (IMediaStream)var2_2.next();
                    var4_5 = (Client)var3_4.getClient();
                    var4_5.doIdle();
                }
                break;
            }
        }
    }
}

