/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.util.Iterator;
import org.farng.mp3.MP3File;
import org.farng.mp3.TagException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.filename.FilenameDelimiter;
import org.farng.mp3.filename.FilenameEndWordDelimiter;
import org.farng.mp3.filename.FilenameParenthesis;
import org.farng.mp3.filename.FilenameStartWordDelimiter;
import org.farng.mp3.filename.FilenameTag;
import org.farng.mp3.filename.FilenameToken;
import org.farng.mp3.id3.ID3v2_4;

public class FilenameTagBuilder {
    private FilenameTagBuilder() {
    }

    public static AbstractFilenameComposite createCompositeFromToken(String string) throws TagException {
        AbstractFilenameComposite abstractFilenameComposite = null;
        String[] stringArray = FilenameTagBuilder.parseParenthesis(string);
        if (stringArray != null) {
            abstractFilenameComposite = new FilenameParenthesis();
            ((FilenameParenthesis)abstractFilenameComposite).setOpenDelimiter(stringArray[0]);
            AbstractFilenameComposite abstractFilenameComposite2 = FilenameTagBuilder.createCompositeFromToken(stringArray[2]);
            ((FilenameDelimiter)abstractFilenameComposite).setBeforeComposite(abstractFilenameComposite2);
            AbstractFilenameComposite abstractFilenameComposite3 = FilenameTagBuilder.createCompositeFromToken(stringArray[3]);
            ((FilenameParenthesis)abstractFilenameComposite).setMiddleComposite(abstractFilenameComposite3);
            AbstractFilenameComposite abstractFilenameComposite4 = FilenameTagBuilder.createCompositeFromToken(stringArray[4]);
            ((FilenameParenthesis)abstractFilenameComposite).setAfterComposite(abstractFilenameComposite4);
            abstractFilenameComposite.setOriginalToken(string);
            return abstractFilenameComposite;
        }
        stringArray = FilenameTagBuilder.parseDelimiter(string);
        if (stringArray != null) {
            abstractFilenameComposite = new FilenameDelimiter();
            ((FilenameDelimiter)abstractFilenameComposite).setDelimiter(stringArray[0]);
            AbstractFilenameComposite abstractFilenameComposite5 = FilenameTagBuilder.createCompositeFromToken(stringArray[1]);
            ((FilenameDelimiter)abstractFilenameComposite).setBeforeComposite(abstractFilenameComposite5);
            AbstractFilenameComposite abstractFilenameComposite6 = FilenameTagBuilder.createCompositeFromToken(stringArray[2]);
            ((FilenameDelimiter)abstractFilenameComposite).setAfterComposite(abstractFilenameComposite6);
            abstractFilenameComposite.setOriginalToken(string);
            return abstractFilenameComposite;
        }
        stringArray = FilenameTagBuilder.parseStartWordDelimiter(string);
        if (stringArray != null) {
            abstractFilenameComposite = new FilenameStartWordDelimiter();
            ((FilenameDelimiter)abstractFilenameComposite).setDelimiter(stringArray[0]);
            AbstractFilenameComposite abstractFilenameComposite7 = FilenameTagBuilder.createCompositeFromToken(stringArray[1]);
            ((FilenameStartWordDelimiter)abstractFilenameComposite).setBeforeComposite(abstractFilenameComposite7);
            AbstractFilenameComposite abstractFilenameComposite8 = FilenameTagBuilder.createCompositeFromToken(stringArray[2]);
            ((FilenameStartWordDelimiter)abstractFilenameComposite).setAfterComposite(abstractFilenameComposite8);
            abstractFilenameComposite.setOriginalToken(string);
            return abstractFilenameComposite;
        }
        stringArray = FilenameTagBuilder.parseEndWordDelimiter(string);
        if (stringArray != null) {
            abstractFilenameComposite = new FilenameEndWordDelimiter();
            ((FilenameDelimiter)abstractFilenameComposite).setDelimiter(stringArray[0]);
            AbstractFilenameComposite abstractFilenameComposite9 = FilenameTagBuilder.createCompositeFromToken(stringArray[1]);
            ((FilenameEndWordDelimiter)abstractFilenameComposite).setBeforeComposite(abstractFilenameComposite9);
            AbstractFilenameComposite abstractFilenameComposite10 = FilenameTagBuilder.createCompositeFromToken(stringArray[2]);
            ((FilenameEndWordDelimiter)abstractFilenameComposite).setAfterComposite(abstractFilenameComposite10);
            abstractFilenameComposite.setOriginalToken(string);
            return abstractFilenameComposite;
        }
        if (string != null && string.trim().length() > 0) {
            abstractFilenameComposite = new FilenameToken();
            ((FilenameToken)abstractFilenameComposite).setToken(string.trim());
            abstractFilenameComposite.setOriginalToken(string);
            return abstractFilenameComposite;
        }
        return abstractFilenameComposite;
    }

    public static FilenameTag createEmptyFilenameTag() {
        FilenameTag filenameTag = new FilenameTag();
        filenameTag.setId3tag(new ID3v2_4());
        return filenameTag;
    }

    public static FilenameTag createFilenameTagFromMP3File(MP3File mP3File) throws Exception {
        FilenameTag filenameTag = null;
        if (mP3File.getMp3file() != null) {
            filenameTag = new FilenameTag();
            String string = mP3File.getMp3file().getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                filenameTag.setExtension(string.substring(n + 1));
                string = string.substring(0, n);
            }
            AbstractFilenameComposite abstractFilenameComposite = FilenameTagBuilder.createCompositeFromToken(string);
            FilenameTagBuilder.updateCompositeFromAllTag(abstractFilenameComposite, mP3File);
            FilenameTagBuilder.updateCompositeFromAllOption(abstractFilenameComposite);
            ID3v2_4 iD3v2_4 = abstractFilenameComposite.createId3Tag();
            filenameTag.setMp3file(mP3File);
            filenameTag.setComposite(abstractFilenameComposite);
            filenameTag.setId3tag(iD3v2_4);
        }
        return filenameTag;
    }

    public static void updateCompositeFromAllOption(AbstractFilenameComposite abstractFilenameComposite) {
        Iterator iterator = TagOptionSingleton.getInstance().getKeywordIterator();
        while (iterator.hasNext()) {
            abstractFilenameComposite.matchAgainstKeyword((Class)iterator.next());
        }
    }

    public static void updateCompositeFromAllTag(AbstractFilenameComposite abstractFilenameComposite, MP3File mP3File) {
        abstractFilenameComposite.matchAgainstTag(mP3File.getID3v1Tag());
        abstractFilenameComposite.matchAgainstTag(mP3File.getID3v2Tag());
        abstractFilenameComposite.matchAgainstTag(mP3File.getLyrics3Tag());
    }

    private static String[] parseDelimiter(String string) {
        String[] stringArray = null;
        if (string != null && string.length() > 0) {
            Iterator iterator = TagOptionSingleton.getInstance().getFilenameDelimiterIterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                int n = string.indexOf(string2);
                if (n < 0) continue;
                stringArray = new String[]{string2, string.substring(0, n), string.substring(n + string2.length())};
            }
        }
        return stringArray;
    }

    private static String[] parseEndWordDelimiter(String string) {
        String[] stringArray = null;
        if (string != null && string.length() > 0) {
            Iterator iterator = TagOptionSingleton.getInstance().getEndWordDelimiterIterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                int n = string.endsWith(string2) ? string.substring(0, string.length() - string2.length()).indexOf(string2) : string.indexOf(string2);
                if (n <= 0) continue;
                stringArray = new String[]{string2, string.substring(0, n), string.substring(n)};
            }
        }
        return stringArray;
    }

    private static String[] parseParenthesis(String string) throws TagException {
        String[] stringArray = null;
        if (string != null && string.length() > 0) {
            TagOptionSingleton tagOptionSingleton = TagOptionSingleton.getInstance();
            String string2 = "";
            int n = string.length();
            Iterator iterator = tagOptionSingleton.getOpenParenthesisIterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                int n2 = string.indexOf(string3);
                if (n2 < 0 || n2 >= n) continue;
                n = n2;
                string2 = string3;
            }
            if (n >= 0 && n < string.length()) {
                String string4 = tagOptionSingleton.getCloseParenthesis(string2);
                int n3 = TagUtility.findMatchingParenthesis(string, n);
                if (n3 < 0) {
                    throw new TagException("Unmatched parenthesis in \"" + string + "\" at position : " + n);
                }
                stringArray = new String[]{string2, string4, string.substring(0, n), string.substring(n + string2.length(), n3), string.substring(n3 + string4.length())};
            }
        }
        return stringArray;
    }

    private static String[] parseStartWordDelimiter(String string) {
        String[] stringArray = null;
        if (string != null && string.length() > 0) {
            Iterator iterator = TagOptionSingleton.getInstance().getStartWordDelimiterIterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                int n = string.startsWith(string2) ? string.indexOf(string2, string2.length()) : string.indexOf(string2);
                if (n <= 0) continue;
                stringArray = new String[]{string2, string.substring(0, n), string.substring(n)};
            }
        }
        return stringArray;
    }
}

