/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.publish;

import com.wowza.wms.application.Application;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamTimecodeControl;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.IVHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;

public class Publisher {
    private String fileExtension = "flv";
    private IMediaStream stream = null;
    private String streamType = "live";
    private IApplicationInstance appInstance = null;
    private Object lock = new Object();
    private long maxTimecode = 0L;

    public static Publisher createInstance(IVHost iVHost, String string) {
        return Publisher.createInstance(iVHost, string, "_definst_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Publisher createInstance(IVHost iVHost, String string, String string2) {
        Publisher publisher = null;
        IApplication iApplication = null;
        IApplicationInstance iApplicationInstance = null;
        WMSReadWriteLock wMSReadWriteLock = iVHost.getApplicationLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            iApplication = iVHost.getApplication(string);
            if (iApplication != null) {
                iApplicationInstance = iApplication.getAppInstance(string2);
            } else {
                WMSLoggerFactory.getLogger(ModuleCore.class).warn("Application folder ([install-location]/applications/" + string + ") is missing");
            }
            if (iApplicationInstance != null) {
                publisher = new Publisher();
                publisher.appInstance = iApplicationInstance;
                iApplicationInstance.addPublisher(publisher);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Publisher.createInstance: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
        return publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Publisher createInstance(IApplicationInstance iApplicationInstance) {
        Publisher publisher = null;
        WMSReadWriteLock wMSReadWriteLock = iApplicationInstance.getVHost().getApplicationLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            if (iApplicationInstance != null) {
                publisher = new Publisher();
                publisher.appInstance = iApplicationInstance;
                iApplicationInstance.addPublisher(publisher);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Publisher.createInstance: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
        return publisher;
    }

    private Publisher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaStream getStream() {
        Object object = this.lock;
        synchronized (object) {
            return this.stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStream(IMediaStream iMediaStream) {
        Object object = this.lock;
        synchronized (object) {
            this.stream = iMediaStream;
        }
    }

    public String getStreamType() {
        return this.streamType;
    }

    public void setStreamType(String string) {
        this.streamType = string;
    }

    public void publish(String string) {
        this.publish(string, "live");
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String string) {
        this.fileExtension = string;
    }

    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    private void resetStreamTimecodes() {
        if (this.stream instanceof IMediaStreamTimecodeControl) {
            WMSLoggerFactory.getLogger(Publisher.class).debug("Publisher.resetStreamTimecodes: ");
            ((IMediaStreamTimecodeControl)this.stream).resetTimecodes();
        }
    }

    public void unpublish() {
        this.publish(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            IApplicationInstance iApplicationInstance = this.getAppInstance();
            if (iApplicationInstance == null) {
                WMSLoggerFactory.getLogger(Publisher.class).error("Publisher.publish: Application instance not defined");
            } else {
                MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                if (this.stream == null) {
                    int bl = mediaStreamMap.getNextStreamIndex();
                    this.stream = mediaStreamMap.getStreamClientless(bl, this.streamType);
                    this.stream.setMergeOnMetadata(false);
                    WMSLoggerFactory.getLogger(null).info(null, this.stream, "stream", "create", 200, null);
                }
                if (string == null) {
                    this.stream.close();
                    this.stream.publish();
                    this.stream.stopPublishing();
                    this.stream.notifyActionUnPublish(this.stream.getName(), this.stream.isRecord(), this.stream.isAppend());
                    if (this.stream.isRecord()) {
                        WMSLoggerFactory.getLogger(Publisher.class).info(null, this.stream, "stream", "recordstop", 200, this.stream.getName());
                    }
                    WMSLoggerFactory.getLogger(Publisher.class).info(null, this.stream, "stream", "unpublish", 200, this.stream.getName());
                    mediaStreamMap.notifyPlayUnpublish(this.stream);
                    this.resetStreamTimecodes();
                } else {
                    IMediaStream iMediaStream;
                    boolean bl;
                    boolean bl2 = false;
                    boolean bl3 = this.stream.isAppend();
                    if (string2 != null) {
                        if (string2.compareToIgnoreCase("record") == 0 || string2.compareToIgnoreCase("append") == 0) {
                            bl = true;
                        }
                        if (string2.compareToIgnoreCase("append") == 0) {
                            bl3 = true;
                        }
                    }
                    if ((iMediaStream = mediaStreamMap.getStream(string)) != null) {
                        WMSLoggerFactory.getLogger(Publisher.class).warn("Publisher.publish: Stream name already in use: " + string);
                    }
                    this.stream.setOpen(true);
                    this.stream.setPlay(false);
                    this.stream.setRecord(bl);
                    this.stream.setAppend(bl3);
                    this.stream.setName(string);
                    this.stream.setExt(this.fileExtension);
                    this.stream.setQueryStr("");
                    this.stream.startPublishing();
                    mediaStreamMap.notifyPlayPublish(this.stream);
                    this.stream.notifyActionPublish(string, bl, bl3);
                    WMSLoggerFactory.getLogger(Publisher.class).info(null, this.stream, "stream", "publish", 200, string);
                    if (bl) {
                        WMSLoggerFactory.getLogger(Publisher.class).info(null, this.stream, "stream", "record", 200, string);
                    }
                }
            }
        }
    }

    public void addVideoData(byte[] byArray, long l) {
        this.addVideoData(byArray, 0, byArray.length, l);
    }

    public void addVideoData(byte[] byArray, int n, long l) {
        this.addVideoData(byArray, 0, n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoData(byte[] byArray, int n, int n2, long l) {
        if (this.stream == null) {
            WMSLoggerFactory.getLogger(Publisher.class).error("Publisher.addVideoData: Stream is null (missing call to publish)");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.stream.setVideoTC(l, true);
            this.stream.setVideoSize(n2);
            this.stream.startVideoPacket();
            this.stream.addVideoData(byArray, n, n2);
            this.maxTimecode = Math.max(this.maxTimecode, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startVideoData(int n, long l) {
        if (this.stream == null) {
            WMSLoggerFactory.getLogger(Publisher.class).error("startVideoData: Stream is null (missing call to publish)");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.stream.setVideoTC(l, true);
            this.stream.setVideoSize(n);
            this.stream.startVideoPacket();
            this.maxTimecode = Math.max(this.maxTimecode, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoDataInc(byte[] byArray, int n, int n2) {
        if (this.stream == null) {
            WMSLoggerFactory.getLogger(Publisher.class).error("Publisher.addVideoData: Stream is null (missing call to publish)");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.stream.addVideoData(byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAudioData(int n, long l) {
        if (this.stream == null) {
            WMSLoggerFactory.getLogger(Publisher.class).error("Publisher.startAudioData: Stream is null (missing call to publish)");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.stream.setAudioTC(l, true);
            this.stream.setAudioSize(n);
            this.stream.startAudioPacket();
            this.maxTimecode = Math.max(this.maxTimecode, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioDataInc(byte[] byArray, int n, int n2) {
        if (this.stream == null) {
            WMSLoggerFactory.getLogger(Publisher.class).error("Publisher.addAudioData: Stream is null (missing call to publish)");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.stream.addAudioData(byArray, n, n2);
        }
    }

    public void addAudioData(byte[] byArray, long l) {
        this.addAudioData(byArray, 0, byArray.length, l);
    }

    public void addAudioData(byte[] byArray, int n, long l) {
        this.addAudioData(byArray, 0, n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioData(byte[] byArray, int n, int n2, long l) {
        if (this.stream == null) {
            WMSLoggerFactory.getLogger(Publisher.class).error("Publisher.addAudioData: Stream is null (missing call to publish)");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.stream.setAudioTC(l, true);
            this.stream.setAudioSize(n2);
            this.stream.startAudioPacket();
            this.stream.addAudioData(byArray, n, n2);
            this.maxTimecode = Math.max(this.maxTimecode, l);
        }
    }

    public void addDataData(byte[] byArray, long l) {
        this.addDataData(byArray, 0, byArray.length, l);
    }

    public void addDataData(byte[] byArray, int n, long l) {
        this.addDataData(byArray, 0, n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataData(byte[] byArray, int n, int n2, long l) {
        if (this.stream == null) {
            WMSLoggerFactory.getLogger(Publisher.class).error("Publisher.addDataData: Stream is null (missing call to publish)");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.stream.setDataType(18);
            this.stream.setDataTC(l, true);
            this.stream.setDataSize(n2);
            this.stream.startDataPacket();
            this.stream.addDataData(byArray, n, n2);
            this.maxTimecode = Math.max(this.maxTimecode, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stream != null) {
                this.stream.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stream != null) {
                IApplicationInstance iApplicationInstance = this.getAppInstance();
                if (iApplicationInstance != null) {
                    iApplicationInstance.getStreams().removeStream(this.stream.getSrc());
                }
                this.stream = null;
            }
        }
        object = this.appInstance.getVHost().getApplicationLock();
        object.writeLock().lock();
        try {
            this.appInstance.removePublisher(this);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Publisher.createInstance: " + exception.toString());
        }
        finally {
            object.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxTimecode() {
        Object object = this.lock;
        synchronized (object) {
            return this.maxTimecode;
        }
    }
}

