/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transport.security;

import com.wowza.util.BufferUtils;
import com.wowza.wms.client.Client;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.IRTMPEncrypt;
import com.wowza.wms.request.IRTMPTransportSecureHandshakeProvider;
import com.wowza.wms.request.RC4;
import com.wowza.wms.request.RequestConnectHandshake;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.KeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class RTMPTransportSecureHandshakeProvider
implements IRTMPTransportSecureHandshakeProvider {
    private static int getMagicDHOffset1(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 1532; i <= 1535; ++i) {
            n2 += byArray[n + i] & 0xFF;
        }
        n2 %= 632;
        return n2 += 772;
    }

    private static int getMagicDHOffset2(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 768; i <= 771; ++i) {
            n2 += byArray[n + i] & 0xFF;
        }
        n2 %= 632;
        return n2 += 8;
    }

    private static byte[] calculateEncryptionKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "HmacSHA256");
            mac.init(secretKeySpec);
            mac.update(byArray);
            byArray3 = mac.doFinal();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.calculateEncryptionKey: " + exception.toString());
        }
        return byArray3;
    }

    private static void calculateEncryptionKeys(Client client, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            byte[] byArray4 = RTMPTransportSecureHandshakeProvider.calculateEncryptionKey(byArray2, byArray3);
            RC4 rC4 = new RC4();
            rC4.setKey(byArray4, 0, 16);
            client.setRTMPEncryptHandlerIn((IRTMPEncrypt)rC4);
            byte[] byArray5 = RTMPTransportSecureHandshakeProvider.calculateEncryptionKey(byArray, byArray3);
            RC4 rC42 = new RC4();
            rC42.setKey(byArray5, 0, 16);
            byte[] byArray6 = new byte[1536];
            rC42.encrypt(byArray6, 0, byArray6.length);
            client.setRTMPEncryptHandlerOut((IRTMPEncrypt)rC42);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.calculateEncryptionKeys: " + exception.toString());
        }
    }

    public byte getServerHandshakeType(byte by) {
        return by;
    }

    public void generateServerHandshake(byte[] byArray, Client client, byte[] byArray2, int n, int n2) {
        try {
            int n3 = RTMPTransportSecureHandshakeProvider.getMagicDHOffset1(byArray, 0);
            int n4 = n2 <= 0 ? RTMPTransportSecureHandshakeProvider.getMagicDHOffset2(byArray2, n) : RTMPTransportSecureHandshakeProvider.getMagicDHOffset1(byArray2, n);
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            KeyPairGenerator keyPairGenerator = null;
            KeyPair keyPair = null;
            DHParameterSpec dHParameterSpec = new DHParameterSpec(RequestConnectHandshake.pHandshake, RequestConnectHandshake.gHandshake, 1023);
            keyPairGenerator = KeyPairGenerator.getInstance("DH");
            keyPairGenerator.initialize(dHParameterSpec);
            keyPair = keyPairGenerator.genKeyPair();
            Object object = (DHPublicKey)keyPair.getPublic();
            Object object2 = BufferUtils.decodeHexString((String)object.getY().toString(16));
            if (object2 != null) {
                if (((byte[])object2).length < 128) {
                    byArray3 = new byte[128];
                    System.arraycopy(object2, 0, byArray3, 128 - ((byte[])object2).length, ((byte[])object2).length);
                } else {
                    byArray3 = object2;
                }
                System.arraycopy(byArray3, 0, byArray, n3, byArray3.length);
                int n5 = 0;
                while (byArray2[n + n4 + n5] == 0) {
                    ++n5;
                }
                byArray4 = new byte[128 - n5];
                System.arraycopy(byArray2, n + n4 + n5, byArray4, 0, byArray4.length);
                object = KeyFactory.getInstance("DH");
                object2 = new DHPublicKeySpec(new BigInteger(BufferUtils.encodeHexString((byte[])byArray4), 16), RequestConnectHandshake.pHandshake, RequestConnectHandshake.gHandshake);
                DHPublicKey dHPublicKey = (DHPublicKey)((KeyFactory)object).generatePublic((KeySpec)object2);
                KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
                keyAgreement.init(keyPair.getPrivate());
                keyAgreement.doPhase(dHPublicKey, true);
                byte[] byArray5 = keyAgreement.generateSecret();
                if (byArray4.length != 128) {
                    byArray4 = new byte[128];
                    System.arraycopy(byArray2, n + n4, byArray4, 0, byArray4.length);
                }
                RTMPTransportSecureHandshakeProvider.calculateEncryptionKeys(client, byArray4, byArray3, byArray5);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.generateServerHandshake: " + exception.toString());
        }
    }
}

