/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.io;

import com.wowza.io.HTTPByteReader;
import com.wowza.io.HTTPByteReaderResult;
import com.wowza.io.RandomAccessReaderBase;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import java.io.IOException;
import java.net.URL;

public class HTTPDirectRandomAccessReader
extends RandomAccessReaderBase {
    private String baseHTTPURL = null;
    private String urlStr = null;
    private HTTPByteReader httpReader = null;
    private int port = 80;
    private String host = null;
    private String path = null;
    private boolean isOpen = false;
    private long status = 200L;
    private long length = -1L;
    private long lastModified = -1L;

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        super.init(iApplicationInstance, iMediaStream, string, string2, string3);
        WMSProperties wMSProperties = iApplicationInstance.getMediaReaderProperties();
        if (wMSProperties != null) {
            this.baseHTTPURL = wMSProperties.getPropertyStr("baseHTTPURL", this.baseHTTPURL);
            if (this.baseHTTPURL != null && this.baseHTTPURL.length() <= 0) {
                this.baseHTTPURL = null;
            }
        }
        int n = string2.lastIndexOf("/");
        int n2 = string2.lastIndexOf(".");
        boolean bl = false;
        if (n2 < 0) {
            bl = true;
        } else if (n >= 0 && n2 < n) {
            bl = true;
        }
        if (bl) {
            string2 = string2 + "." + string3;
        }
        this.urlStr = string2;
        if (this.baseHTTPURL != null) {
            this.urlStr = this.baseHTTPURL + "/" + string2;
        }
        try {
            URL uRL = new URL(this.urlStr);
            if (uRL != null) {
                long[] lArray;
                this.host = uRL.getHost();
                if (uRL.getPort() != -1) {
                    this.port = uRL.getPort();
                }
                this.path = uRL.getPath();
                if (uRL.getQuery() != null) {
                    this.path = this.path + "?" + uRL.getQuery();
                }
                this.httpReader = new HTTPByteReader(this.host, this.port);
                if (this.httpReader != null && (lArray = this.httpReader.head(this.path)) != null) {
                    this.status = lArray[0];
                    this.length = lArray[1];
                    this.lastModified = lArray[2];
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPDirectRandomAccessReader.class).error("HTTPDirectRandomAccessReader.init: " + exception.toString());
        }
    }

    public void open() throws IOException {
        if (this.httpReader == null) {
            throw new IOException("HTTPDirectRandomAccessReader.open: Invalid HTTP URL: " + this.urlStr);
        }
        if (this.status == 404L) {
            throw new IOException("HTTPDirectRandomAccessReader.open: HTTP URL not found: " + this.urlStr);
        }
        if (this.status < 200L || this.status >= 300L) {
            throw new IOException("HTTPDirectRandomAccessReader.open: Invalid HTTP status[" + this.status + "]: " + this.urlStr);
        }
        if (this.length <= 0L) {
            throw new IOException("HTTPDirectRandomAccessReader.open: Invalid HTTP length[" + this.length + "]: " + this.urlStr);
        }
        this.isOpen = true;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() throws IOException {
        this.isOpen = false;
        if (this.httpReader != null) {
            this.httpReader.close();
        }
    }

    public boolean exists() {
        return this.status >= 200L && this.status < 300L;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long length() {
        return this.length;
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3;
        block2: {
            HTTPByteReaderResult hTTPByteReaderResult;
            n3 = 0;
            if (!this.isOpen || this.httpReader == null) break block2;
            if (this.pos + (long)n2 > this.length) {
                n2 = (int)(this.length - this.pos);
            }
            if (n2 > 0 && (hTTPByteReaderResult = this.httpReader.read(this.path, this.pos, n2)) != null && hTTPByteReaderResult.buffer != null && hTTPByteReaderResult.contentLength > 0L) {
                System.arraycopy(hTTPByteReaderResult.buffer, (int)hTTPByteReaderResult.headerLength, byArray, n, (int)hTTPByteReaderResult.contentLength);
                this.pos += (long)((int)hTTPByteReaderResult.contentLength);
                n3 += (int)hTTPByteReaderResult.contentLength;
            }
        }
        return n3;
    }
}

