/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.admin;

import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.server.ServerHandler;
import com.wowza.wms.server.ServerHandlerThreaded;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IAcceptorNotify;
import com.wowza.wms.vhost.IVHost;
import java.util.Map;
import org.apache.commons.modeler.Registry;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandlerAdapter;

public class AdminAcceptorListener
implements IAcceptorNotify {
    public static final String ACCEPTOR_OBJECTNAME = "acceptors=Acceptors,hostPort=";
    public static final String ACCEPTOR_FILTERNAME = "Acceptor";
    private AdminAgent adminAgent = null;
    private IVHost vhost = null;
    private boolean isActive = true;

    public AdminAcceptorListener(AdminAgent adminAgent, IVHost iVHost) {
        this.adminAgent = adminAgent;
        this.vhost = iVHost;
        this.isActive = Server.getInstance().getAdminInterfaceObjectList().contains(ACCEPTOR_FILTERNAME.toLowerCase());
    }

    private String getObjectName(HostPort hostPort) {
        return "WowzaMediaServerPro:vHosts=VHosts,vHostName=" + this.vhost.getName() + "," + ACCEPTOR_OBJECTNAME + hostPort.toString(true);
    }

    private ServerHandler getServerHandler(IoHandlerAdapter ioHandlerAdapter) {
        ServerHandler serverHandler = null;
        if (ioHandlerAdapter instanceof ServerHandler) {
            serverHandler = (ServerHandler)ioHandlerAdapter;
        } else if (ioHandlerAdapter instanceof ServerHandlerThreaded) {
            serverHandler = ((ServerHandlerThreaded)ioHandlerAdapter).getServerHandler();
        }
        return serverHandler;
    }

    public void onAcceptorCreate(HostPort hostPort, Map map) {
        try {
            if (this.isActive) {
                IoAcceptor ioAcceptor = (IoAcceptor)map.get("acceptor");
                IoHandlerAdapter ioHandlerAdapter = (IoHandlerAdapter)map.get("handlerAdapter");
                String string = this.getObjectName(hostPort);
                ServerHandler serverHandler = this.getServerHandler(ioHandlerAdapter);
                if (serverHandler != null) {
                    Registry.getRegistry(null, null).registerComponent((Object)serverHandler.getIoPerformanceCounter(), string + ",name=IOPerformance", serverHandler.getIoPerformanceCounter().getClass().getName());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminAcceptorListener.class).error("onAcceptorCreate: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void onAcceptorDestroy(HostPort hostPort, Map map) {
        try {
            if (this.isActive) {
                IoAcceptor ioAcceptor = (IoAcceptor)map.get("acceptor");
                IoHandlerAdapter ioHandlerAdapter = (IoHandlerAdapter)map.get("handlerAdapter");
                String string = this.getObjectName(hostPort);
                ServerHandler serverHandler = this.getServerHandler(ioHandlerAdapter);
                if (serverHandler != null) {
                    Registry.getRegistry(null, null).unregisterComponent(string + ",name=IOPerformance");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminAcceptorListener.class).error("onAcceptorDestroy: " + exception.toString());
        }
    }
}

