/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.wms.amf.AMFDataTrait;
import java.util.ArrayList;
import java.util.List;

public class AMFDataContextDeserialize {
    private int objectEncoding = 0;
    private List<String> refStrings;
    private List<Object> refObjects;
    private List<AMFDataTrait> refTraits;
    private int intData = 0;
    private boolean isIntData = false;

    public AMFDataContextDeserialize() {
    }

    public AMFDataContextDeserialize(int n) {
        this.objectEncoding = n;
    }

    public boolean isIntData() {
        return this.isIntData;
    }

    public void setIntData(int n) {
        this.intData = n;
        this.isIntData = true;
    }

    public int getIntData() {
        return this.intData;
    }

    public int clearIntData() {
        int n = this.intData;
        this.intData = 0;
        this.isIntData = false;
        return n;
    }

    public int getObjectEncoding() {
        return this.objectEncoding;
    }

    public void setObjectEncoding(int n) {
        this.objectEncoding = n;
    }

    public boolean isAMF3() {
        return this.objectEncoding != 0;
    }

    public boolean isAMF0() {
        return this.objectEncoding == 0;
    }

    public void addString(String string) {
        if (this.refStrings == null) {
            this.refStrings = new ArrayList<String>();
        }
        this.refStrings.add(string);
    }

    public String getString(int n) throws IndexOutOfBoundsException {
        if (this.refStrings == null) {
            this.refStrings = new ArrayList<String>();
        }
        return this.refStrings.get(n);
    }

    public void addObject(Object object) {
        if (this.refObjects == null) {
            this.refObjects = new ArrayList<Object>();
        }
        this.refObjects.add(object);
    }

    public Object getObject(int n) throws IndexOutOfBoundsException {
        if (this.refObjects == null) {
            this.refObjects = new ArrayList<Object>();
        }
        return this.refObjects.get(n);
    }

    public void addTrait(AMFDataTrait aMFDataTrait) {
        if (this.refTraits == null) {
            this.refTraits = new ArrayList<AMFDataTrait>();
        }
        this.refTraits.add(aMFDataTrait);
    }

    public AMFDataTrait getTrait(int n) throws IndexOutOfBoundsException {
        if (this.refTraits == null) {
            this.refTraits = new ArrayList<AMFDataTrait>();
        }
        return this.refTraits.get(n);
    }
}

