/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.application;

import com.wowza.util.AMFUtils;
import com.wowza.util.ElapsedTimer;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.SystemUtils;
import com.wowza.util.URLUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.application.Application;
import com.wowza.wms.application.DatagramPortRange;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.ConnectionCounterSimple;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.client.IClient;
import com.wowza.wms.client.IClientNotify;
import com.wowza.wms.client.IConnectionNotify;
import com.wowza.wms.client.IConnectionValidator;
import com.wowza.wms.http.streammanager.HTTPStreamManager;
import com.wowza.wms.httpstreamer.model.HTTPStreamerItem;
import com.wowza.wms.httpstreamer.model.HTTPStreamerList;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.smil.SmilMediaList;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterNotify;
import com.wowza.wms.mediacaster.IMediaCasterNotify2;
import com.wowza.wms.mediacaster.IMediaCasterValidateMediaCaster;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamManager;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.module.IModuleNotify;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.module.ModuleItem;
import com.wowza.wms.module.ModuleList;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.server.Server;
import com.wowza.wms.sharedobject.ISharedObjectNotify;
import com.wowza.wms.sharedobject.ISharedObjects;
import com.wowza.wms.sharedobject.SharedObjects;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderActionNotify;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamFileMapper;
import com.wowza.wms.stream.IMediaStreamNameAliasProvider;
import com.wowza.wms.stream.IMediaStreamNameAliasProvider2;
import com.wowza.wms.stream.IMediaStreamNotify;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.IMediaWriterActionNotify;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamFileMapperBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamMapGroup;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizerActionNotify;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizerControl;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerList;
import com.wowza.wms.stream.livetranscoder.ILiveStreamTranscoder;
import com.wowza.wms.stream.livetranscoder.ILiveStreamTranscoderActionNotify;
import com.wowza.wms.stream.livetranscoder.ILiveStreamTranscoderControl;
import com.wowza.wms.stream.livetranscoder.LiveStreamTranscoderApplicationContext;
import com.wowza.wms.stream.livetranscoder.LiveStreamTranscoderList;
import com.wowza.wms.stream.publish.Publisher;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.util.MediaCasterUtils;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.util.SmilUtils;
import com.wowza.wms.vhost.IVHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationInstance
implements IApplicationInstance,
IMediaStreamNameAliasProvider,
ILiveStreamPacketizerControl,
ILiveStreamTranscoderControl {
    private String name = "";
    private MediaStreamMap streams = null;
    private IApplication application = null;
    private String streamType = "default";
    protected WMSProperties properties = new WMSProperties();
    protected WMSProperties streamProperties = new WMSProperties();
    protected WMSProperties mediaCasterProperties = new WMSProperties();
    protected WMSProperties mediaReaderProperties = new WMSProperties();
    protected WMSProperties mediaWriterProperties = new WMSProperties();
    protected WMSProperties rtpProperties = new WMSProperties();
    protected WMSProperties liveStreamPacketizerProperties = new WMSProperties();
    protected WMSProperties transcoderProperties = new WMSProperties();
    protected WMSProperties httpStreamerProperties = new WMSProperties();
    private boolean acceptConnection = true;
    private String streamStorageDir = "";
    private String rsoStorageDir = "";
    private String keyStorageDir = "";
    private List<IClient> clients = new ArrayList<IClient>();
    private int clientsTotal = 0;
    private WMSReadWriteLock clientsLock = new WMSReentrantReadWriteLock();
    private ISharedObjects sharedObjects = new SharedObjects(false);
    private ISharedObjects sharedObjectsPersist = new SharedObjects(true);
    private List<IClientNotify> clientListeners = new ArrayList<IClientNotify>();
    private List<IModuleNotify> moduleListeners = new ArrayList<IModuleNotify>();
    private List<IMediaWriterActionNotify> mediaWriterListeners = new ArrayList<IMediaWriterActionNotify>();
    private IOPerformanceCounter ioPerformanceCounter = new IOPerformanceCounter();
    private IOPerformanceCounter[] ioPerformanceCounters = new IOPerformanceCounter[6];
    private IOPerformanceCounter ioPerformanceCounterLast = null;
    private IOPerformanceCounter[] ioPerformanceCountersLast = new IOPerformanceCounter[6];
    private ConnectionCounter connectionCounter = new ConnectionCounter();
    private ConnectionCounterSimple[] connectionCounters = new ConnectionCounterSimple[6];
    private ConnectionValidator connectionValidator = new ConnectionValidator(this);
    private ElapsedTimer elapsedTime = new ElapsedTimer();
    private long clientRemoveTime = 0L;
    private Map<String, List<IMediaStream>> playNameToStream = new HashMap<String, List<IMediaStream>>();
    private Map<IMediaStream, String> streamToPlayName = new HashMap<IMediaStream, String>();
    private MediaCasterStreamMap mediaCasterStreams = null;
    private List<IMediaCasterNotify> mediaCasterListeners = new ArrayList<IMediaCasterNotify>();
    private List<IMediaReaderActionNotify> mediaReaderListeners = new ArrayList<IMediaReaderActionNotify>();
    private List<ILiveStreamPacketizerActionNotify> liveStreamPacketizerListeners = new ArrayList<ILiveStreamPacketizerActionNotify>();
    private List<ILiveStreamTranscoderActionNotify> liveStreamTranscoderListeners = new ArrayList<ILiveStreamTranscoderActionNotify>();
    private ModuleFunctions modFunctions = new ModuleFunctions();
    private ModuleList moduleList = new ModuleList();
    private int applicationTimeout = 6000;
    private int pingTimeout = 12000;
    private int validationFrequency = 8000;
    private int maximumPendingWriteBytes = 0;
    private int maximumSetBufferTime = 0;
    private String repeaterOriginUrl = null;
    private String repeaterQueryString = null;
    private String[] allowDomains = null;
    private int clientIdleFrequency = -1;
    private int rtpIdleFrequency = -1;
    private String streamVideoSampleAccess = "";
    private String streamAudioSampleAccess = "";
    private String streamReadAccess = "*";
    private String streamWriteAccess = "*";
    private String sharedObjectReadAccess = "*";
    private String sharedObjectWriteAccess = "*";
    private String rtpAuthenticationMethod = "digest";
    private String rtpPublishAuthenticationMethod = null;
    private String rtpPlayAuthenticationMethod = null;
    private int rtpAVSyncMethod = 1;
    private int rtpMaxRTCPWaitTime = 10000;
    private int rtspSessionTimeout = 90000;
    private int rtspMaximumPendingWriteBytes = 0;
    private List<RTPSession> rtpSessions = new ArrayList<RTPSession>();
    private Map<String, List<RTPSession>> rtpNameToSessions = new HashMap<String, List<RTPSession>>();
    private List<IHTTPStreamerSession> httpStreamerSessions = new ArrayList<IHTTPStreamerSession>();
    private List<IHTTPStreamerSession>[] httpStreamerSessionsByProtocol = new ArrayList[4];
    private Map<String, List<IHTTPStreamerSession>>[] httpStreamerNameToSessions = new HashMap[4];
    private List<Publisher> publishers = new ArrayList<Publisher>();
    private int maxStorageDirDepth = 25;
    private IMediaStreamFileMapper streamFileMapper = new MediaStreamFileMapperBase();
    private String liveStreamPacketizerList = null;
    private String liveStreamTranscoderList = null;
    private List<String> liveStreamPacketizerSet = new ArrayList<String>();
    private List<String> liveStreamTranscoderSet = new ArrayList<String>();
    private String httpStreamerList = null;
    private List<String> httpStreamerSet = new ArrayList<String>();
    private IMediaStreamNameAliasProvider streamNameAliasProvider = this;
    private Map<String, IHTTPStreamerApplicationContext> httpStreamerApplicationContexts = new HashMap<String, IHTTPStreamerApplicationContext>();
    private LiveStreamTranscoderApplicationContext transcoderApplicationContext = null;
    private List<DatagramPortRange> rtpIncomingDatagramPortRanges = null;
    private ILiveStreamPacketizerControl liveStreamPacketizerControl = this;
    private ILiveStreamTranscoderControl liveStreamTranscoderControl = this;
    private IMediaCasterValidateMediaCaster mediaCasterValidator = null;
    private long lastTouchTime = -1L;
    private int applicationInstanceTouchTimeout = 5000;
    private String rtspBindIpAddress = null;
    private String rtspConnectionIpAddress = "0.0.0.0";
    private String rtspConnectionAddressType = "IP4";
    private String rtspOriginIpAddress = "127.0.0.1";
    private String rtspOriginAddressType = "IP4";
    private boolean validateFMLEConnections = false;

    ApplicationInstance(String string, IApplication iApplication) {
        int n;
        this.name = ApplicationInstance.fixName(string);
        this.application = iApplication;
        this.streams = new MediaStreamMap(this);
        this.mediaCasterStreams = new MediaCasterStreamMap(this);
        this.transcoderApplicationContext = new LiveStreamTranscoderApplicationContext(this);
        ConnectionNotifier connectionNotifier = new ConnectionNotifier(this);
        this.connectionCounter.addConnectionListener(connectionNotifier);
        for (n = 0; n < this.httpStreamerNameToSessions.length; ++n) {
            this.httpStreamerNameToSessions[n] = new HashMap<String, List<IHTTPStreamerSession>>();
        }
        for (n = 0; n < this.httpStreamerSessionsByProtocol.length; ++n) {
            this.httpStreamerSessionsByProtocol[n] = new ArrayList<IHTTPStreamerSession>();
        }
        for (n = 0; n < this.ioPerformanceCounters.length; ++n) {
            this.ioPerformanceCounters[n] = new IOPerformanceCounter();
            this.connectionCounters[n] = new ConnectionCounterSimple();
        }
        IVHost iVHost = iApplication.getVHost();
        if (iVHost != null) {
            this.applicationTimeout = iVHost.getApplicationTimeout();
            this.pingTimeout = iVHost.getPingTimeout();
            this.validationFrequency = iVHost.getValidationFrequency();
            this.maximumPendingWriteBytes = iVHost.getMaximumPendingWriteBytes();
            this.maximumSetBufferTime = iVHost.getMaximumSetBufferTime();
            this.rtpIdleFrequency = iVHost.getRTPIdleFrequency();
        }
        this.loadConfig();
        this.connectionCounter.setConnectionValidator(this.connectionValidator);
    }

    public void init() {
        this.sharedObjectsPersist.setStorageDir(this.getRsoStoragePath());
        this.sharedObjectsPersist.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initClient(IClient iClient) {
        iClient.setStreamType(this.streamType);
        iClient.setAcceptConnection(this.acceptConnection);
        iClient.setStreamVideoSampleAccess(this.streamVideoSampleAccess);
        iClient.setStreamAudioSampleAccess(this.streamAudioSampleAccess);
        iClient.setStreamReadAccess(this.streamReadAccess);
        iClient.setStreamWriteAccess(this.streamWriteAccess);
        iClient.setSharedObjectReadAccess(this.sharedObjectReadAccess);
        iClient.setSharedObjectWriteAccess(this.sharedObjectWriteAccess);
        iClient.setLiveStreamPacketizerList(this.liveStreamPacketizerList);
        iClient.setLiveStreamTranscoderList(this.liveStreamTranscoderList);
        iClient.setValidateFMLEConnections(this.validateFMLEConnections);
        if (this.getClientIdleFrequency() > 0) {
            iClient.setIdleFrequency(this.getClientIdleFrequency());
        }
        this.clientsLock.writeLock().lock();
        try {
            this.clients.add(iClient);
            ++this.clientsTotal;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.initClient: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
        this.notifyClientConnect(iClient);
    }

    private static void checkLicense(byte[] byArray) {
        byte[] byArray2 = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray2, 0, ModuleConnect.lc.length);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
        BigInteger bigInteger2 = (BigInteger)MediaStreamBase.sinfo.get("r2");
        byte[] byArray3 = bigInteger.toByteArray();
        byte[] byArray4 = bigInteger2.toByteArray();
        for (int i = 0; i < ModuleConnect.lc.length; ++i) {
            int n = i;
            byArray2[n] = (byte)(byArray2[n] ^ byArray3[(i + 11) % byArray3.length]);
            int n2 = i;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray4[(i + 8) % byArray4.length]);
            if (byArray[i] == byArray2[i]) continue;
            WMSLoggerFactory.getLogger(null).error("bail1:" + byArray[i] + ":" + byArray2[i]);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownClient(IClient iClient) {
        ModuleFunctions moduleFunctions = this.getModFunctions();
        moduleFunctions.onDisconnect(iClient);
        this.notifyClientDisconnect(iClient);
        this.sharedObjects.removeClient(iClient);
        this.sharedObjectsPersist.removeClient(iClient);
        this.clientsLock.writeLock().lock();
        try {
            this.clients.remove(iClient);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.shutdownClient: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
        ((Client)iClient).addIOPerformance(this.ioPerformanceCounter);
        ((Client)iClient).addIOPerformance2(this.ioPerformanceCounters[0]);
        byte[] byArray = null;
        byArray = new byte[ModuleConnect.lc.length];
        System.arraycopy(ModuleConnect.lc, 0, byArray, 0, ModuleConnect.lc.length);
        BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r1");
        byte[] byArray2 = bigInteger.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 11) % byArray2.length]);
        }
        this.connectionCounter.disconnect(((Client)iClient).getConnectionHolder(), byArray);
        ApplicationInstance.checkLicense(byArray);
        this.clientRemoveTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectAllClients() {
        IVHost iVHost = this.application.getVHost();
        WMSReadWriteLock wMSReadWriteLock = iVHost.getApplicationLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            ArrayList<IClient> arrayList = new ArrayList<IClient>();
            this.clientsLock.readLock().lock();
            try {
                arrayList.addAll(this.clients);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.disconnectAllClients: " + exception.toString());
            }
            finally {
                this.clientsLock.readLock().unlock();
            }
            for (IClient iClient : arrayList) {
                if (iClient == null) continue;
                try {
                    int n = iClient.getClientId();
                    iVHost.killClient(n);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.disconnectAllClients[" + iClient.getClientId() + "]: " + exception.toString());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Application.class).error("Application.disconnectAllClients: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void shutdown(boolean bl, boolean bl2) {
        this.mediaCasterStreams.shutdown(true);
        ModuleFunctions moduleFunctions = this.getModFunctions();
        moduleFunctions.onAppStop(this);
        this.notifyModuleUnloadAll();
    }

    public static String fixName(String string) {
        if (string.length() == 0) {
            return "_definst_";
        }
        return string;
    }

    private void loadConfig() {
        String string = this.application.getConfigPath();
        if (new File(string).exists()) {
            ApplicationUtils.loadConfigFile(this, URLUtils.pathToFileURL(string));
        } else if (Bootstrap.getConfigURL() != null) {
            ApplicationUtils.loadConfigFile(this, URLUtils.appendParamsToUrl(Bootstrap.getConfigURL(), "context=vhost&vhostName=" + URLUtils.encodeValue(this.getVHost().getName()) + "&filename=" + URLUtils.encodeValue("conf/Application.xml") + "&applicationName=" + this.getApplication().getName()));
        } else {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("loadConfig: Application.xml file missing: " + string);
        }
    }

    public void notifyModuleLoadAll() {
        Map map = this.moduleList.getModuleItems();
        for (String string : map.keySet()) {
            ModuleItem moduleItem = this.moduleList.getModuleItem(string);
            this.notifyModuleLoad(moduleItem);
        }
    }

    public void notifyModuleUnloadAll() {
        Map map = this.moduleList.getModuleItems();
        for (String string : map.keySet()) {
            ModuleItem moduleItem = this.moduleList.getModuleItem(string);
            this.notifyModuleUnload(moduleItem);
        }
    }

    @Override
    public IApplication getApplication() {
        return this.application;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public MediaStreamMap getStreams() {
        return this.streams;
    }

    @Override
    public IVHost getVHost() {
        return this.application.getVHost();
    }

    @Override
    public String getStreamStoragePath() {
        String string = this.streamStorageDir;
        if (string.length() == 0) {
            string = this.application.getApplicationPath() + File.separatorChar + "streams";
            File file = null;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("getStreamStoragePath: mkdir1: " + exception.toString());
            }
            string = string + File.separatorChar + this.name;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("getStreamStoragePath: mkdir2: " + exception.toString());
            }
        }
        return string;
    }

    @Override
    public String getStreamKeyPath() {
        String string = this.keyStorageDir;
        if (string.length() == 0) {
            string = this.application.getApplicationPath() + File.separatorChar + "keys";
            File file = null;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("getStreamKeyPath: mkdir1: " + exception.toString());
            }
            string = string + File.separatorChar + this.name;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("getStreamKeyPath: mkdir2: " + exception.toString());
            }
        }
        return string;
    }

    @Override
    public String getRsoStoragePath() {
        String string = this.rsoStorageDir;
        if (string.length() == 0) {
            string = this.application.getApplicationPath() + File.separatorChar + "sharedobjects";
            File file = null;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("getRsoStoragePath: mkdir1: " + exception.toString());
            }
            string = string + File.separatorChar + this.name;
            try {
                file = new File(string);
                if (!file.exists()) {
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("getRsoStoragePath: mkdir2: " + exception.toString());
            }
        }
        return string;
    }

    @Override
    public WMSProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getStreamType() {
        return this.streamType;
    }

    @Override
    public void setStreamType(String string) {
        this.streamType = string;
    }

    @Override
    public boolean isAcceptConnection() {
        return this.acceptConnection;
    }

    @Override
    public void setAcceptConnection(boolean bl) {
        this.acceptConnection = bl;
    }

    @Override
    public WMSReadWriteLock getClientsLockObj() {
        return this.clientsLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClientCount() {
        int n = 0;
        this.clientsLock.readLock().lock();
        try {
            n = this.clients.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getClientCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClientCountTotal() {
        int n = 0;
        this.clientsLock.readLock().lock();
        try {
            n = this.clientsTotal;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getClientCountTotal: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incClientCountTotal() {
        this.clientsLock.readLock().lock();
        try {
            ++this.clientsTotal;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getClientCountTotal: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IClient> getClients() {
        ArrayList<IClient> arrayList = new ArrayList<IClient>();
        this.clientsLock.readLock().lock();
        try {
            arrayList.addAll(this.clients);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return arrayList;
    }

    @Override
    public IClient getClient(int n) {
        IClient iClient = null;
        WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.getClient: This method is deprecated. Use List<IClient> getClients().");
        return iClient;
    }

    @Override
    public IClient getClientById(int n) {
        return this.getVHost().getClient(n);
    }

    @Override
    public ISharedObjects getSharedObjects() {
        return this.getSharedObjects(false);
    }

    @Override
    public ISharedObjects getSharedObjects(boolean bl) {
        return bl ? this.sharedObjectsPersist : this.sharedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLiveStreamPacketizerListener(ILiveStreamPacketizerActionNotify iLiveStreamPacketizerActionNotify) {
        List<ILiveStreamPacketizerActionNotify> list = this.liveStreamPacketizerListeners;
        synchronized (list) {
            this.liveStreamPacketizerListeners.add(iLiveStreamPacketizerActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLiveStreamPacketizerListener(ILiveStreamPacketizerActionNotify iLiveStreamPacketizerActionNotify) {
        List<ILiveStreamPacketizerActionNotify> list = this.liveStreamPacketizerListeners;
        synchronized (list) {
            this.liveStreamPacketizerListeners.remove(iLiveStreamPacketizerActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLiveStreamPacketizerCreate(ILiveStreamPacketizer iLiveStreamPacketizer, String string) {
        ArrayList<ILiveStreamPacketizerActionNotify> arrayList = null;
        List<ILiveStreamPacketizerActionNotify> list = this.liveStreamPacketizerListeners;
        synchronized (list) {
            arrayList = new ArrayList<ILiveStreamPacketizerActionNotify>(this.liveStreamPacketizerListeners);
        }
        for (ILiveStreamPacketizerActionNotify iLiveStreamPacketizerActionNotify : arrayList) {
            iLiveStreamPacketizerActionNotify.onLiveStreamPacketizerCreate(iLiveStreamPacketizer, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLiveStreamPacketizerDestroy(ILiveStreamPacketizer iLiveStreamPacketizer) {
        ArrayList<ILiveStreamPacketizerActionNotify> arrayList = null;
        List<ILiveStreamPacketizerActionNotify> list = this.liveStreamPacketizerListeners;
        synchronized (list) {
            arrayList = new ArrayList<ILiveStreamPacketizerActionNotify>(this.liveStreamPacketizerListeners);
        }
        for (ILiveStreamPacketizerActionNotify iLiveStreamPacketizerActionNotify : arrayList) {
            iLiveStreamPacketizerActionNotify.onLiveStreamPacketizerDestroy(iLiveStreamPacketizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLiveStreamPacketizerInit(ILiveStreamPacketizer iLiveStreamPacketizer, String string) {
        ArrayList<ILiveStreamPacketizerActionNotify> arrayList = null;
        List<ILiveStreamPacketizerActionNotify> list = this.liveStreamPacketizerListeners;
        synchronized (list) {
            arrayList = new ArrayList<ILiveStreamPacketizerActionNotify>(this.liveStreamPacketizerListeners);
        }
        for (ILiveStreamPacketizerActionNotify iLiveStreamPacketizerActionNotify : arrayList) {
            iLiveStreamPacketizerActionNotify.onLiveStreamPacketizerInit(iLiveStreamPacketizer, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLiveStreamTranscoderListener(ILiveStreamTranscoderActionNotify iLiveStreamTranscoderActionNotify) {
        List<ILiveStreamTranscoderActionNotify> list = this.liveStreamTranscoderListeners;
        synchronized (list) {
            this.liveStreamTranscoderListeners.add(iLiveStreamTranscoderActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLiveStreamTranscoderListener(ILiveStreamTranscoderActionNotify iLiveStreamTranscoderActionNotify) {
        List<ILiveStreamTranscoderActionNotify> list = this.liveStreamTranscoderListeners;
        synchronized (list) {
            this.liveStreamTranscoderListeners.remove(iLiveStreamTranscoderActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLiveStreamTranscoderCreate(ILiveStreamTranscoder iLiveStreamTranscoder, IMediaStream iMediaStream) {
        ArrayList<ILiveStreamTranscoderActionNotify> arrayList = null;
        List<ILiveStreamTranscoderActionNotify> list = this.liveStreamTranscoderListeners;
        synchronized (list) {
            arrayList = new ArrayList<ILiveStreamTranscoderActionNotify>(this.liveStreamTranscoderListeners);
        }
        for (ILiveStreamTranscoderActionNotify iLiveStreamTranscoderActionNotify : arrayList) {
            iLiveStreamTranscoderActionNotify.onLiveStreamTranscoderCreate(iLiveStreamTranscoder, iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLiveStreamTranscoderDestroy(ILiveStreamTranscoder iLiveStreamTranscoder, IMediaStream iMediaStream) {
        ArrayList<ILiveStreamTranscoderActionNotify> arrayList = null;
        List<ILiveStreamTranscoderActionNotify> list = this.liveStreamTranscoderListeners;
        synchronized (list) {
            arrayList = new ArrayList<ILiveStreamTranscoderActionNotify>(this.liveStreamTranscoderListeners);
        }
        for (ILiveStreamTranscoderActionNotify iLiveStreamTranscoderActionNotify : arrayList) {
            iLiveStreamTranscoderActionNotify.onLiveStreamTranscoderDestroy(iLiveStreamTranscoder, iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLiveStreamTranscoderInit(ILiveStreamTranscoder iLiveStreamTranscoder, IMediaStream iMediaStream) {
        ArrayList<ILiveStreamTranscoderActionNotify> arrayList = null;
        List<ILiveStreamTranscoderActionNotify> list = this.liveStreamTranscoderListeners;
        synchronized (list) {
            arrayList = new ArrayList<ILiveStreamTranscoderActionNotify>(this.liveStreamTranscoderListeners);
        }
        for (ILiveStreamTranscoderActionNotify iLiveStreamTranscoderActionNotify : arrayList) {
            iLiveStreamTranscoderActionNotify.onLiveStreamTranscoderInit(iLiveStreamTranscoder, iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaReaderListener(IMediaReaderActionNotify iMediaReaderActionNotify) {
        List<IMediaReaderActionNotify> list = this.mediaReaderListeners;
        synchronized (list) {
            this.mediaReaderListeners.add(iMediaReaderActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaReaderListener(IMediaReaderActionNotify iMediaReaderActionNotify) {
        List<IMediaReaderActionNotify> list = this.mediaReaderListeners;
        synchronized (list) {
            this.mediaReaderListeners.remove(iMediaReaderActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMediaReaderCreate(IMediaReader iMediaReader) {
        ArrayList<IMediaReaderActionNotify> arrayList = null;
        List<IMediaReaderActionNotify> list = this.mediaReaderListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaReaderActionNotify>(this.mediaReaderListeners);
        }
        for (IMediaReaderActionNotify iMediaReaderActionNotify : arrayList) {
            iMediaReaderActionNotify.onMediaReaderCreate(iMediaReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMediaReaderInit(IMediaReader iMediaReader, IMediaStream iMediaStream) {
        ArrayList<IMediaReaderActionNotify> arrayList = null;
        List<IMediaReaderActionNotify> list = this.mediaReaderListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaReaderActionNotify>(this.mediaReaderListeners);
        }
        for (IMediaReaderActionNotify iMediaReaderActionNotify : arrayList) {
            iMediaReaderActionNotify.onMediaReaderInit(iMediaReader, iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMediaReaderOpen(IMediaReader iMediaReader, IMediaStream iMediaStream) {
        ArrayList<IMediaReaderActionNotify> arrayList = null;
        List<IMediaReaderActionNotify> list = this.mediaReaderListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaReaderActionNotify>(this.mediaReaderListeners);
        }
        for (IMediaReaderActionNotify iMediaReaderActionNotify : arrayList) {
            iMediaReaderActionNotify.onMediaReaderOpen(iMediaReader, iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMediaReaderExtractMetaData(IMediaReader iMediaReader, IMediaStream iMediaStream) {
        ArrayList<IMediaReaderActionNotify> arrayList = null;
        List<IMediaReaderActionNotify> list = this.mediaReaderListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaReaderActionNotify>(this.mediaReaderListeners);
        }
        for (IMediaReaderActionNotify iMediaReaderActionNotify : arrayList) {
            iMediaReaderActionNotify.onMediaReaderExtractMetaData(iMediaReader, iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMediaReaderClose(IMediaReader iMediaReader, IMediaStream iMediaStream) {
        ArrayList<IMediaReaderActionNotify> arrayList = null;
        List<IMediaReaderActionNotify> list = this.mediaReaderListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaReaderActionNotify>(this.mediaReaderListeners);
        }
        for (IMediaReaderActionNotify iMediaReaderActionNotify : arrayList) {
            iMediaReaderActionNotify.onMediaReaderClose(iMediaReader, iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaCasterListener(IMediaCasterNotify iMediaCasterNotify) {
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            this.mediaCasterListeners.add(iMediaCasterNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaCasterListener(IMediaCasterNotify2 iMediaCasterNotify2) {
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            this.mediaCasterListeners.add(iMediaCasterNotify2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaCasterListener(IMediaCasterNotify iMediaCasterNotify) {
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            this.mediaCasterListeners.remove(iMediaCasterNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterCreate(IMediaCaster iMediaCaster) {
        ArrayList<IMediaCasterNotify> arrayList = null;
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaCasterNotify>(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            iMediaCasterNotify.onMediaCasterCreate(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterDestroy(IMediaCaster iMediaCaster) {
        ArrayList<IMediaCasterNotify> arrayList = null;
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaCasterNotify>(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            iMediaCasterNotify.onMediaCasterDestroy(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
        ArrayList<IMediaCasterNotify> arrayList = null;
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaCasterNotify>(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            iMediaCasterNotify.onRegisterPlayer(iMediaCaster, iMediaStreamPlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterUnRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
        ArrayList<IMediaCasterNotify> arrayList = null;
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaCasterNotify>(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            iMediaCasterNotify.onUnRegisterPlayer(iMediaCaster, iMediaStreamPlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterSetSourceStream(IMediaCaster iMediaCaster, IMediaStream iMediaStream) {
        ArrayList<IMediaCasterNotify> arrayList = null;
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaCasterNotify>(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            iMediaCasterNotify.onSetSourceStream(iMediaCaster, iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterConnectStart(IMediaCaster iMediaCaster) {
        ArrayList<IMediaCasterNotify> arrayList = null;
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaCasterNotify>(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            if (!(iMediaCasterNotify instanceof IMediaCasterNotify2)) continue;
            ((IMediaCasterNotify2)iMediaCasterNotify).onConnectStart(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterConnectSuccess(IMediaCaster iMediaCaster) {
        ArrayList<IMediaCasterNotify> arrayList = null;
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaCasterNotify>(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            if (!(iMediaCasterNotify instanceof IMediaCasterNotify2)) continue;
            ((IMediaCasterNotify2)iMediaCasterNotify).onConnectSuccess(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterConnectFailure(IMediaCaster iMediaCaster) {
        ArrayList<IMediaCasterNotify> arrayList = null;
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaCasterNotify>(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            if (!(iMediaCasterNotify instanceof IMediaCasterNotify2)) continue;
            ((IMediaCasterNotify2)iMediaCasterNotify).onConnectFailure(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterStreamStart(IMediaCaster iMediaCaster) {
        ArrayList<IMediaCasterNotify> arrayList = null;
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaCasterNotify>(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            if (!(iMediaCasterNotify instanceof IMediaCasterNotify2)) continue;
            ((IMediaCasterNotify2)iMediaCasterNotify).onStreamStart(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaCasterStreamStop(IMediaCaster iMediaCaster) {
        ArrayList<IMediaCasterNotify> arrayList = null;
        List<IMediaCasterNotify> list = this.mediaCasterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaCasterNotify>(this.mediaCasterListeners);
        }
        for (IMediaCasterNotify iMediaCasterNotify : arrayList) {
            if (!(iMediaCasterNotify instanceof IMediaCasterNotify2)) continue;
            ((IMediaCasterNotify2)iMediaCasterNotify).onStreamStop(iMediaCaster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientListener(IClientNotify iClientNotify) {
        List<IClientNotify> list = this.clientListeners;
        synchronized (list) {
            this.clientListeners.add(iClientNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClientListener(IClientNotify iClientNotify) {
        List<IClientNotify> list = this.clientListeners;
        synchronized (list) {
            this.clientListeners.remove(iClientNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediaWriterListener(IMediaWriterActionNotify iMediaWriterActionNotify) {
        List<IMediaWriterActionNotify> list = this.mediaWriterListeners;
        synchronized (list) {
            this.mediaWriterListeners.add(iMediaWriterActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaWriterListener(IMediaWriterActionNotify iMediaWriterActionNotify) {
        List<IMediaWriterActionNotify> list = this.mediaWriterListeners;
        synchronized (list) {
            this.mediaWriterListeners.remove(iMediaWriterActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMediaWriterOnWriteComplete(IMediaStream iMediaStream, File file) {
        ArrayList<IMediaWriterActionNotify> arrayList = null;
        List<IMediaWriterActionNotify> list = this.mediaWriterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaWriterActionNotify>(this.mediaWriterListeners);
        }
        for (IMediaWriterActionNotify iMediaWriterActionNotify : arrayList) {
            iMediaWriterActionNotify.onWriteComplete(iMediaStream, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMediaWriterOnFLVAddMetadata(IMediaStream iMediaStream, Map<String, Object> map) {
        ArrayList<IMediaWriterActionNotify> arrayList = null;
        List<IMediaWriterActionNotify> list = this.mediaWriterListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaWriterActionNotify>(this.mediaWriterListeners);
        }
        for (IMediaWriterActionNotify iMediaWriterActionNotify : arrayList) {
            iMediaWriterActionNotify.onFLVAddMetadata(iMediaStream, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModuleListener(IModuleNotify iModuleNotify) {
        List<IModuleNotify> list = this.moduleListeners;
        synchronized (list) {
            this.moduleListeners.add(iModuleNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModuleListener(IModuleNotify iModuleNotify) {
        List<IModuleNotify> list = this.moduleListeners;
        synchronized (list) {
            this.moduleListeners.remove(iModuleNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyModuleLoad(ModuleItem moduleItem) {
        ArrayList<IModuleNotify> arrayList = null;
        List<IModuleNotify> list = this.moduleListeners;
        synchronized (list) {
            arrayList = new ArrayList<IModuleNotify>(this.moduleListeners);
        }
        for (IModuleNotify iModuleNotify : arrayList) {
            iModuleNotify.onModuleLoad(moduleItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyModuleUnload(ModuleItem moduleItem) {
        ArrayList<IModuleNotify> arrayList = null;
        List<IModuleNotify> list = this.moduleListeners;
        synchronized (list) {
            arrayList = new ArrayList<IModuleNotify>(this.moduleListeners);
        }
        for (IModuleNotify iModuleNotify : arrayList) {
            iModuleNotify.onModuleUnload(moduleItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientConnect(IClient iClient) {
        ArrayList<IClientNotify> arrayList = null;
        List<IClientNotify> list = this.clientListeners;
        synchronized (list) {
            arrayList = new ArrayList<IClientNotify>(this.clientListeners);
        }
        for (IClientNotify iClientNotify : arrayList) {
            iClientNotify.onClientConnect(iClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientDisconnect(IClient iClient) {
        ArrayList<IClientNotify> arrayList = null;
        List<IClientNotify> list = this.clientListeners;
        synchronized (list) {
            arrayList = new ArrayList<IClientNotify>(this.clientListeners);
        }
        for (IClientNotify iClientNotify : arrayList) {
            iClientNotify.onClientDisconnect(iClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientAccept(IClient iClient) {
        ArrayList<IClientNotify> arrayList = null;
        List<IClientNotify> list = this.clientListeners;
        synchronized (list) {
            arrayList = new ArrayList<IClientNotify>(this.clientListeners);
        }
        for (IClientNotify iClientNotify : arrayList) {
            iClientNotify.onClientAccept(iClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientReject(IClient iClient) {
        ArrayList<IClientNotify> arrayList = null;
        List<IClientNotify> list = this.clientListeners;
        synchronized (list) {
            arrayList = new ArrayList<IClientNotify>(this.clientListeners);
        }
        for (IClientNotify iClientNotify : arrayList) {
            iClientNotify.onClientReject(iClient);
        }
    }

    @Override
    public void addMediaStreamListener(IMediaStreamNotify iMediaStreamNotify) {
        this.streams.addMediaStreamListener(iMediaStreamNotify);
    }

    @Override
    public void removeMediaStreamListener(IMediaStreamNotify iMediaStreamNotify) {
        this.streams.removeMediaStreamListener(iMediaStreamNotify);
    }

    @Override
    public void addSharedObjectListener(ISharedObjectNotify iSharedObjectNotify, boolean bl) {
        (bl ? this.sharedObjectsPersist : this.sharedObjects).addSharedObjectListener(iSharedObjectNotify);
    }

    @Override
    public void removeSharedObjectListener(ISharedObjectNotify iSharedObjectNotify, boolean bl) {
        (bl ? this.sharedObjectsPersist : this.sharedObjects).removeSharedObjectListener(iSharedObjectNotify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOPerformanceCounter updateIOPerformance() {
        ArrayList<IClient> arrayList = null;
        ArrayList<RTPSession> arrayList2 = null;
        ArrayList<IHTTPStreamerSession> arrayList3 = null;
        this.clientsLock.readLock().lock();
        try {
            if (this.clients.size() > 0) {
                arrayList = new ArrayList<IClient>();
                arrayList.addAll(this.clients);
            }
            if (this.rtpSessions.size() > 0) {
                arrayList2 = new ArrayList<RTPSession>();
                arrayList2.addAll(this.rtpSessions);
            }
            if (this.httpStreamerSessions.size() > 0) {
                arrayList3 = new ArrayList<IHTTPStreamerSession>();
                arrayList3.addAll(this.httpStreamerSessions);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.updateIOPerformance: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        if (arrayList != null) {
            for (IClient object : arrayList) {
                ((Client)object).addIOPerformance(this.ioPerformanceCounter);
            }
        }
        if (arrayList3 != null) {
            for (IHTTPStreamerSession iHTTPStreamerSession : arrayList3) {
                iHTTPStreamerSession.addIOPerformance(this.ioPerformanceCounter);
            }
        }
        if (arrayList2 != null) {
            for (RTPSession rTPSession : arrayList2) {
                rTPSession.addIOPerformance(this.ioPerformanceCounter);
            }
        }
        return this.ioPerformanceCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOPerformanceCounter updateIOPerformance(int n) {
        ArrayList<IClient> arrayList = null;
        ArrayList<RTPSession> arrayList2 = null;
        ArrayList<IHTTPStreamerSession> arrayList3 = null;
        IOPerformanceCounter iOPerformanceCounter = this.ioPerformanceCounters[n];
        this.clientsLock.readLock().lock();
        try {
            if (n == 0 && this.clients.size() > 0) {
                arrayList = new ArrayList<IClient>();
                arrayList.addAll(this.clients);
            }
            if (n == 1 && this.rtpSessions.size() > 0) {
                arrayList2 = new ArrayList<RTPSession>();
                arrayList2.addAll(this.rtpSessions);
            }
            if (n == 2 || n == 3 || n == 4) {
                int n2 = -1;
                switch (n) {
                    case 2: {
                        n2 = 1;
                        break;
                    }
                    case 3: {
                        n2 = 0;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                    }
                }
                if (n2 >= 0 && n2 < this.httpStreamerSessionsByProtocol.length && this.httpStreamerSessionsByProtocol[n2].size() > 0) {
                    arrayList3 = new ArrayList<IHTTPStreamerSession>();
                    arrayList3.addAll(this.httpStreamerSessionsByProtocol[n2]);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.updateIOPerformance: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        if (arrayList != null) {
            for (IClient object : arrayList) {
                ((Client)object).addIOPerformance2(iOPerformanceCounter);
            }
        }
        if (arrayList3 != null) {
            for (IHTTPStreamerSession iHTTPStreamerSession : arrayList3) {
                iHTTPStreamerSession.addIOPerformance2(iOPerformanceCounter);
            }
        }
        if (arrayList2 != null) {
            for (RTPSession rTPSession : arrayList2) {
                rTPSession.addIOPerformance2(iOPerformanceCounter);
            }
        }
        return iOPerformanceCounter;
    }

    public IOPerformanceCounter addIOPerformance(int n, IOPerformanceCounter iOPerformanceCounter) {
        this.updateIOPerformance(n);
        IOPerformanceCounter iOPerformanceCounter2 = this.ioPerformanceCounters[n].clone();
        iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.ioPerformanceCountersLast[n]);
        this.ioPerformanceCountersLast[n] = iOPerformanceCounter2;
        return this.ioPerformanceCounters[n];
    }

    public IOPerformanceCounter addIOPerformance(IOPerformanceCounter iOPerformanceCounter) {
        this.updateIOPerformance();
        IOPerformanceCounter iOPerformanceCounter2 = this.ioPerformanceCounter.clone();
        iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.ioPerformanceCounterLast);
        this.ioPerformanceCounterLast = iOPerformanceCounter2;
        return this.ioPerformanceCounter;
    }

    @Override
    public IOPerformanceCounter getIOPerformanceCounter() {
        return this.ioPerformanceCounter;
    }

    @Override
    public IOPerformanceCounter getIOPerformanceCounter(int n) {
        return this.ioPerformanceCounters[n];
    }

    public long getMessagesInCount() {
        return this.ioPerformanceCounter.getMessagesInCount();
    }

    public long getMessagesInCountRate() {
        return this.ioPerformanceCounter.getMessagesInCountRate();
    }

    public long getMessagesOutCount() {
        return this.ioPerformanceCounter.getMessagesOutCount();
    }

    public long getMessagesOutCountRate() {
        return this.ioPerformanceCounter.getMessagesOutCountRate();
    }

    public long getMessagesInBytes() {
        return this.ioPerformanceCounter.getMessagesInBytes();
    }

    public double getMessagesInBytesRate() {
        return this.ioPerformanceCounter.getMessagesInBytesRate();
    }

    public long getMessagesOutBytes() {
        return this.ioPerformanceCounter.getMessagesOutBytes();
    }

    public double getMessagesOutBytesRate() {
        return this.ioPerformanceCounter.getMessagesOutBytesRate();
    }

    @Override
    public ConnectionCounter getConnectionCounter() {
        return this.connectionCounter;
    }

    @Override
    public ConnectionCounterSimple getConnectionCounter(int n) {
        return this.connectionCounters[n];
    }

    public IConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    @Override
    public String getDateStarted() {
        return this.elapsedTime.getDateString();
    }

    @Override
    public String getTimeRunning() {
        return this.elapsedTime.getTimeString();
    }

    @Override
    public double getTimeRunningSeconds() {
        return this.elapsedTime.getTimeSeconds();
    }

    public void updateLoggingDuration() {
        WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
    }

    public long getClientRemoveTime() {
        return this.clientRemoveTime;
    }

    public void setClientRemoveTime(long l) {
        this.clientRemoveTime = l;
    }

    @Override
    public void broadcastMsg(List<IClient> list, String string) {
        this.broadcastMsg(list, string, null);
    }

    @Override
    public void broadcastMsg(List<IClient> list, String string, Object ... objectArray) {
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        for (Client client : list) {
            if (client == null) continue;
            client.callInternal(string, null, aMFDataArray);
        }
    }

    public void broadcastMsg(String string) {
        this.broadcastMsg(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcastMsg(String string, Object ... objectArray) {
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        ArrayList<IClient> arrayList = null;
        this.clientsLock.readLock().lock();
        try {
            arrayList = new ArrayList<IClient>(this.clients);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.broadcastMsg: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        for (Client client : arrayList) {
            client.callInternal(string, null, aMFDataArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlayStreamByName(IMediaStream iMediaStream, String string) {
        Map<String, List<IMediaStream>> map = this.playNameToStream;
        synchronized (map) {
            this.removePlayStreamByName(iMediaStream);
            this.streamToPlayName.put(iMediaStream, string);
            List<IMediaStream> list = this.playNameToStream.get(string);
            if (list != null) {
                list.add(iMediaStream);
            } else {
                list = new ArrayList<IMediaStream>();
                list.add(iMediaStream);
                this.playNameToStream.put(string, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlayStreamByName(IMediaStream iMediaStream) {
        Map<String, List<IMediaStream>> map = this.playNameToStream;
        synchronized (map) {
            String string = this.streamToPlayName.get(iMediaStream);
            if (string != null) {
                this.streamToPlayName.remove(iMediaStream);
                List<IMediaStream> list = this.playNameToStream.get(string);
                if (list != null) {
                    list.remove(iMediaStream);
                    if (list.size() == 0) {
                        this.playNameToStream.remove(string);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getPlayStreamCountsByName() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Map<String, List<IMediaStream>> map = this.playNameToStream;
        synchronized (map) {
            for (String string : this.playNameToStream.keySet()) {
                hashMap.put(string, new Integer(this.playNameToStream.get(string).size()));
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPlayStreamCount(String string) {
        int n = 0;
        Map<String, List<IMediaStream>> map = this.playNameToStream;
        synchronized (map) {
            List<IMediaStream> list = this.playNameToStream.get(string);
            if (list != null) {
                n = list.size();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMediaStream> getPlayStreamsByName(String string) {
        Map<String, List<IMediaStream>> map = this.playNameToStream;
        synchronized (map) {
            List<IMediaStream> list = this.playNameToStream.get(string);
            if (list == null) {
                return null;
            }
            return new ArrayList<IMediaStream>(list);
        }
    }

    @Override
    public MediaCasterStreamMap getMediaCasterStreams() {
        return this.mediaCasterStreams;
    }

    public void doWatchdog() {
        this.mediaCasterStreams.doWatchdog();
    }

    @Override
    public int getStreamCount() {
        return this.streams.getCount();
    }

    @Override
    public ModuleFunctions getModFunctions() {
        return this.modFunctions;
    }

    @Override
    public ModuleList getModuleList() {
        return this.moduleList;
    }

    @Override
    public Object getModuleInstance(String string) {
        Object object = null;
        ModuleItem moduleItem = this.moduleList.getModuleItem(string);
        if (moduleItem != null) {
            object = moduleItem.getInstance();
        }
        return object;
    }

    public int getPublishStreamIdByName(String string) {
        IMediaStream iMediaStream = this.streams.getStream(string);
        return iMediaStream == null ? -1 : iMediaStream.getSrc();
    }

    @Override
    public int getApplicationTimeout() {
        return this.applicationTimeout;
    }

    @Override
    public void setApplicationTimeout(int n) {
        this.applicationTimeout = n;
    }

    @Override
    public int getPingTimeout() {
        return this.pingTimeout;
    }

    @Override
    public void setPingTimeout(int n) {
        this.pingTimeout = n;
    }

    @Override
    public int getValidationFrequency() {
        return this.validationFrequency;
    }

    @Override
    public void setValidationFrequency(int n) {
        this.validationFrequency = n;
    }

    @Override
    public int getMaximumPendingWriteBytes() {
        return this.maximumPendingWriteBytes;
    }

    @Override
    public void setMaximumPendingWriteBytes(int n) {
        this.maximumPendingWriteBytes = n;
    }

    @Override
    public int getMaximumSetBufferTime() {
        return this.maximumSetBufferTime;
    }

    @Override
    public void setMaximumSetBufferTime(int n) {
        this.maximumSetBufferTime = n;
    }

    @Override
    public String getRepeaterOriginUrl() {
        return this.repeaterOriginUrl;
    }

    @Override
    public void setRepeaterOriginUrl(String string) {
        this.repeaterOriginUrl = string;
    }

    @Override
    public String getRepeaterQueryString() {
        return this.repeaterQueryString;
    }

    @Override
    public void setRepeaterQueryString(String string) {
        this.repeaterQueryString = string;
    }

    @Override
    public String[] getAllowDomains() {
        return this.allowDomains;
    }

    @Override
    public void setAllowDomains(String[] stringArray) {
        this.allowDomains = stringArray;
    }

    @Override
    public void parseAllowDomains(String string) {
        if (string == null) {
            this.allowDomains = null;
            return;
        }
        this.allowDomains = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split("[,]");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        if (arrayList.size() > 0) {
            this.allowDomains = arrayList.toArray(new String[0]);
        }
    }

    @Override
    public int getClientIdleFrequency() {
        return this.clientIdleFrequency;
    }

    @Override
    public void setClientIdleFrequency(int n) {
        this.clientIdleFrequency = n;
    }

    @Override
    public String decodeStorageDir(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.getVHost() != null) {
            hashMap.put("com.wowza.wms.context.VHost", this.getVHost().getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", this.getVHost().getHomePath());
        }
        hashMap.put("com.wowza.wms.context.Application", this.getApplication().getName());
        if (this != null) {
            hashMap.put("com.wowza.wms.context.ApplicationInstance", this.getName());
        }
        String string2 = SystemUtils.expandEnvironmentVariables(string, hashMap);
        WMSLoggerFactory.getLogger(null).debug("explodeStorageDir: " + string + "=" + string2);
        return string2;
    }

    private void validateStoragePath(String string) {
        String string2;
        if (this.maxStorageDirDepth <= 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        File file = new File(string.replace("\\", "/"));
        WMSLoggerFactory.getLogger(null).debug("validateStoragePath: start: " + file);
        int n = 0;
        while (!file.exists()) {
            string2 = file.getParent();
            WMSLoggerFactory.getLogger(null).debug("  parent: " + string2);
            if (string2 == null) break;
            String string3 = file.toString().substring(string2.length(), file.toString().length());
            WMSLoggerFactory.getLogger(null).debug("  add: " + (String)string3);
            arrayList.add(0, string3);
            file = new File(string2);
            if (++n < this.maxStorageDirDepth) continue;
            WMSLoggerFactory.getLogger(null).warn("ApplicationInstance.validateStoragePath: maxStorageDirDepth has been exceeded[" + this.maxStorageDirDepth + "]: " + string);
            break;
        }
        if (n >= this.maxStorageDirDepth) {
            return;
        }
        string2 = file.getAbsolutePath();
        for (String string4 : arrayList) {
            string2 = string2 + string4;
            File file2 = new File(string2);
            try {
                WMSLoggerFactory.getLogger(null).debug("  mkdir: " + file2);
                file2.mkdir();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).error("Application.validateStoragePath: Invalid path (" + string2 + "): " + exception.toString());
                break;
            }
        }
    }

    @Override
    public String getStreamStorageDir() {
        return this.streamStorageDir;
    }

    @Override
    public void setStreamStorageDir(String string) {
        this.streamStorageDir = this.decodeStorageDir(string);
        this.validateStoragePath(this.streamStorageDir);
    }

    @Override
    public String getStreamKeyDir() {
        return this.keyStorageDir;
    }

    @Override
    public void setStreamKeyDir(String string) {
        this.keyStorageDir = this.decodeStorageDir(string);
        this.validateStoragePath(this.keyStorageDir);
    }

    @Override
    public String getRsoStorageDir() {
        return this.rsoStorageDir;
    }

    @Override
    public void setRsoStorageDir(String string) {
        this.rsoStorageDir = this.decodeStorageDir(string);
        this.validateStoragePath(this.rsoStorageDir);
    }

    @Override
    public String getStreamVideoSampleAccess() {
        return this.streamVideoSampleAccess;
    }

    @Override
    public void setStreamVideoSampleAccess(String string) {
        this.streamVideoSampleAccess = string;
    }

    @Override
    public String getStreamAudioSampleAccess() {
        return this.streamAudioSampleAccess;
    }

    @Override
    public void setStreamAudioSampleAccess(String string) {
        this.streamAudioSampleAccess = string;
    }

    @Override
    public String getStreamReadAccess() {
        return this.streamReadAccess;
    }

    @Override
    public void setStreamReadAccess(String string) {
        this.streamReadAccess = string;
    }

    @Override
    public String getStreamWriteAccess() {
        return this.streamWriteAccess;
    }

    @Override
    public void setStreamWriteAccess(String string) {
        this.streamWriteAccess = string;
    }

    @Override
    public String getSharedObjectReadAccess() {
        return this.sharedObjectReadAccess;
    }

    @Override
    public void setSharedObjectReadAccess(String string) {
        this.sharedObjectReadAccess = string;
    }

    @Override
    public String getSharedObjectWriteAccess() {
        return this.sharedObjectWriteAccess;
    }

    @Override
    public void setSharedObjectWriteAccess(String string) {
        this.sharedObjectWriteAccess = string;
    }

    @Override
    public String getRTPPublishAuthenticationMethod() {
        return this.rtpPublishAuthenticationMethod != null ? this.rtpPublishAuthenticationMethod : this.rtpAuthenticationMethod;
    }

    @Override
    public void setRTPPublishAuthenticationMethod(String string) {
        this.rtpPublishAuthenticationMethod = string;
    }

    @Override
    public String getRTPPlayAuthenticationMethod() {
        return this.rtpPlayAuthenticationMethod != null ? this.rtpPlayAuthenticationMethod : this.rtpAuthenticationMethod;
    }

    @Override
    public void setRTPPlayAuthenticationMethod(String string) {
        this.rtpPlayAuthenticationMethod = string;
    }

    @Override
    public int getRTPMaxRTCPWaitTime() {
        return this.rtpMaxRTCPWaitTime;
    }

    @Override
    public void setRTPMaxRTCPWaitTime(int n) {
        this.rtpMaxRTCPWaitTime = n;
    }

    @Override
    public int getRTPAVSyncMethod() {
        return this.rtpAVSyncMethod;
    }

    @Override
    public void setRTPAVSyncMethod(int n) {
        this.rtpAVSyncMethod = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RTPSession> getRTPSessions(String string) {
        ArrayList<RTPSession> arrayList = new ArrayList<RTPSession>();
        this.clientsLock.readLock().lock();
        try {
            List<RTPSession> list = this.rtpNameToSessions.get(string);
            if (list != null) {
                arrayList.addAll(list);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getRTPSessions: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RTPSession> getRTPSessions() {
        ArrayList<RTPSession> arrayList = new ArrayList<RTPSession>();
        this.clientsLock.readLock().lock();
        try {
            arrayList.addAll(this.rtpSessions);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getRTPSessions: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getRTPSessionCountsByName() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.clientsLock.readLock().lock();
        try {
            for (String string : this.rtpNameToSessions.keySet()) {
                hashMap.put(string, new Integer(this.rtpNameToSessions.get(string).size()));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getRTPSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRTPSessionCount(String string) {
        int n = 0;
        this.clientsLock.readLock().lock();
        try {
            List<RTPSession> list = this.rtpNameToSessions.get(string);
            if (list != null) {
                n = list.size();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getRTPSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRTPSessionCount() {
        int n = 0;
        this.clientsLock.readLock().lock();
        try {
            n = this.rtpSessions.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getRTPSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRTPSession(RTPSession rTPSession) {
        this.clientsLock.writeLock().lock();
        try {
            ++this.clientsTotal;
            this.rtpSessions.add(rTPSession);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.addRTPSession: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPlayRTPSession(RTPSession rTPSession) {
        this.clientsLock.writeLock().lock();
        try {
            String string;
            RTPStream rTPStream = rTPSession.getRTSPStream();
            if (rTPStream != null && (string = rTPStream.getStreamName()) != null) {
                List<RTPSession> list = this.rtpNameToSessions.get(string);
                if (list == null) {
                    list = new ArrayList<RTPSession>();
                    this.rtpNameToSessions.put(string, list);
                }
                if (!list.contains(rTPSession)) {
                    list.add(rTPSession);
                }
            }
            if (!this.rtpSessions.contains(rTPSession)) {
                ++this.clientsTotal;
                this.rtpSessions.add(rTPSession);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.removeRTPSession: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRTPSession(RTPSession rTPSession) {
        rTPSession.addIOPerformance(this.ioPerformanceCounter);
        rTPSession.addIOPerformance2(this.ioPerformanceCounters[1]);
        this.clientsLock.writeLock().lock();
        try {
            List<RTPSession> list;
            String string;
            RTPStream rTPStream = rTPSession.getRTSPStream();
            if (rTPStream != null && (string = rTPStream.getStreamName()) != null && (list = this.rtpNameToSessions.get(string)) != null) {
                list.remove(rTPSession);
                if (list.size() <= 0) {
                    this.rtpNameToSessions.remove(string);
                }
            }
            this.clientRemoveTime = System.currentTimeMillis();
            this.rtpSessions.remove(rTPSession);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.removeRTPSession: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IHTTPStreamerSession> getHTTPStreamerSessions(int n) {
        ArrayList<IHTTPStreamerSession> arrayList = new ArrayList<IHTTPStreamerSession>();
        this.clientsLock.readLock().lock();
        try {
            if (n >= 0 && n < this.httpStreamerSessionsByProtocol.length) {
                arrayList.addAll(this.httpStreamerSessionsByProtocol[n]);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getHTTPStreamerSessions: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IHTTPStreamerSession> getHTTPStreamerSessions() {
        ArrayList<IHTTPStreamerSession> arrayList = new ArrayList<IHTTPStreamerSession>();
        this.clientsLock.readLock().lock();
        try {
            arrayList.addAll(this.httpStreamerSessions);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getHTTPStreamerSessions: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IHTTPStreamerSession> getHTTPStreamerSessions(int n, String string) {
        ArrayList<IHTTPStreamerSession> arrayList = new ArrayList<IHTTPStreamerSession>();
        this.clientsLock.readLock().lock();
        try {
            List<IHTTPStreamerSession> list;
            if (n >= 0 && n < this.httpStreamerSessionsByProtocol.length && (list = this.httpStreamerNameToSessions[n].get(string)) != null) {
                arrayList.addAll(list);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getHTTPStreamerSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IHTTPStreamerSession> getHTTPStreamerSessions(String string) {
        ArrayList<IHTTPStreamerSession> arrayList = new ArrayList<IHTTPStreamerSession>();
        this.clientsLock.readLock().lock();
        try {
            for (int i = 0; i < this.httpStreamerSessionsByProtocol.length; ++i) {
                List<IHTTPStreamerSession> list = this.httpStreamerNameToSessions[i].get(string);
                if (list == null) continue;
                arrayList.addAll(list);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getHTTPStreamerSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getHTTPStreamerSessionCountsByName(int n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        this.clientsLock.readLock().lock();
        try {
            if (n >= 0 && n < this.httpStreamerNameToSessions.length) {
                for (String string : this.httpStreamerNameToSessions[n].keySet()) {
                    hashMap.put(string, new Integer(this.httpStreamerNameToSessions[n].get(string).size()));
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getHTTPStreamerSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHTTPStreamerSessionCount(String string) {
        int n = 0;
        this.clientsLock.readLock().lock();
        try {
            for (int i = 0; i < this.httpStreamerNameToSessions.length; ++i) {
                List<IHTTPStreamerSession> list = this.httpStreamerNameToSessions[i].get(string);
                if (list == null) continue;
                n += list.size();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getHTTPStreamerSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHTTPStreamerSessionCount(int n, String string) {
        int n2 = 0;
        this.clientsLock.readLock().lock();
        try {
            List<IHTTPStreamerSession> list;
            if (n >= 0 && n < this.httpStreamerNameToSessions.length && (list = this.httpStreamerNameToSessions[n].get(string)) != null) {
                n2 = list.size();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getHTTPStreamerSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHTTPStreamerSessionCount(int n) {
        int n2 = 0;
        this.clientsLock.readLock().lock();
        try {
            if (n >= 0 && n < this.httpStreamerNameToSessions.length) {
                n2 = this.httpStreamerSessionsByProtocol[n].size();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getHTTPStreamerSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHTTPStreamerSessionCount() {
        int n = 0;
        this.clientsLock.readLock().lock();
        try {
            n = this.httpStreamerSessions.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getHTTPStreamerSessionCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHTTPStreamerSession(IHTTPStreamerSession iHTTPStreamerSession) {
        this.clientsLock.writeLock().lock();
        try {
            ++this.clientsTotal;
            this.httpStreamerSessions.add(iHTTPStreamerSession);
            int n = iHTTPStreamerSession.getSessionProtocol();
            if (n >= 0 && n < this.httpStreamerSessionsByProtocol.length) {
                this.httpStreamerSessionsByProtocol[n].add(iHTTPStreamerSession);
                String string = iHTTPStreamerSession.getStreamName();
                if (string != null) {
                    List<IHTTPStreamerSession> list = this.httpStreamerNameToSessions[n].get(string);
                    if (list == null) {
                        list = new ArrayList<IHTTPStreamerSession>();
                        this.httpStreamerNameToSessions[n].put(string, list);
                    }
                    if (!list.contains(iHTTPStreamerSession)) {
                        list.add(iHTTPStreamerSession);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.addHTTPStreamerSession: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHTTPStreamerSession(IHTTPStreamerSession iHTTPStreamerSession) {
        iHTTPStreamerSession.addIOPerformance(this.ioPerformanceCounter);
        int n = iHTTPStreamerSession.getSessionProtocol();
        if (n == 0) {
            iHTTPStreamerSession.addIOPerformance2(this.ioPerformanceCounters[3]);
        } else if (n == 1) {
            iHTTPStreamerSession.addIOPerformance2(this.ioPerformanceCounters[2]);
        } else if (n == 2) {
            iHTTPStreamerSession.addIOPerformance2(this.ioPerformanceCounters[4]);
        }
        this.clientsLock.writeLock().lock();
        try {
            this.clientRemoveTime = System.currentTimeMillis();
            this.httpStreamerSessions.remove(iHTTPStreamerSession);
            int n2 = iHTTPStreamerSession.getSessionProtocol();
            if (n2 >= 0 && n2 < this.httpStreamerSessionsByProtocol.length) {
                List<IHTTPStreamerSession> list;
                this.httpStreamerSessionsByProtocol[n2].remove(iHTTPStreamerSession);
                String string = iHTTPStreamerSession.getStreamName();
                if (string != null && (list = this.httpStreamerNameToSessions[n2].get(string)) != null) {
                    list.remove(iHTTPStreamerSession);
                    if (list.size() <= 0) {
                        this.httpStreamerNameToSessions[n2].remove(string);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.removeHTTPStreamerSession: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Publisher> getPublishers() {
        ArrayList<Publisher> arrayList = new ArrayList<Publisher>();
        this.clientsLock.readLock().lock();
        try {
            arrayList.addAll(this.publishers);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getPublishers: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPublisherCount() {
        int n = 0;
        this.clientsLock.readLock().lock();
        try {
            n = this.publishers.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.getPublisherCount: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPublisher(Publisher publisher) {
        this.clientsLock.writeLock().lock();
        try {
            this.publishers.add(publisher);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.addPublisher: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePublisher(Publisher publisher) {
        this.clientsLock.writeLock().lock();
        try {
            this.publishers.remove(publisher);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.removeHTTPStreamerSession: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    @Override
    public WMSProperties getStreamProperties() {
        return this.streamProperties;
    }

    @Override
    public WMSProperties getMediaCasterProperties() {
        return this.mediaCasterProperties;
    }

    @Override
    public WMSProperties getMediaReaderProperties() {
        return this.mediaReaderProperties;
    }

    @Override
    public WMSProperties getMediaWriterProperties() {
        return this.mediaWriterProperties;
    }

    @Override
    public WMSProperties getRTPProperties() {
        return this.rtpProperties;
    }

    @Override
    public WMSProperties getLiveStreamPacketizerProperties() {
        return this.liveStreamPacketizerProperties;
    }

    @Override
    public WMSProperties getTranscoderProperties() {
        return this.transcoderProperties;
    }

    @Override
    public WMSProperties getHTTPStreamerProperties() {
        return this.httpStreamerProperties;
    }

    @Override
    public int getMaxStorageDirDepth() {
        return this.maxStorageDirDepth;
    }

    @Override
    public void setMaxStorageDirDepth(int n) {
        this.maxStorageDirDepth = n;
    }

    @Override
    public IMediaStreamFileMapper getStreamFileMapper() {
        return this.streamFileMapper;
    }

    @Override
    public void setStreamFileMapper(IMediaStreamFileMapper iMediaStreamFileMapper) {
        this.streamFileMapper = iMediaStreamFileMapper;
    }

    @Override
    public String getLiveStreamPacketizerList() {
        return this.liveStreamPacketizerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLiveStreamPacketizerList(String string) {
        Object object;
        this.liveStreamPacketizerList = string;
        String[] stringArray = null;
        if (string != null) {
            object = string;
            object = ((String)object).replace(",", "|");
            object = ((String)object).replace(";", "|");
            stringArray = ((String)object).split("[|]");
        }
        object = this.getVHost();
        LiveStreamPacketizerList liveStreamPacketizerList = null;
        if (object != null) {
            liveStreamPacketizerList = object.getLiveStreamPacketizerList();
        }
        List<String> list = this.liveStreamPacketizerSet;
        synchronized (list) {
            this.liveStreamPacketizerSet.clear();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].trim();
                    if (string2.length() <= 0) continue;
                    if (liveStreamPacketizerList != null && !liveStreamPacketizerList.containsLiveStreamPacketizerDef(string2)) {
                        WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.setLiveStreamPacketizerList[" + this.getApplication().getName() + "/" + this.getName() + "]: LiveStreamPacketizer is not valid: " + string2);
                    }
                    this.liveStreamPacketizerSet.add(string2);
                }
            }
        }
    }

    @Override
    public String getLiveStreamTranscoderList() {
        return this.liveStreamTranscoderList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLiveStreamTranscoderList(String string) {
        Object object;
        this.liveStreamTranscoderList = string;
        String[] stringArray = null;
        if (string != null) {
            object = string;
            object = ((String)object).replace(",", "|");
            object = ((String)object).replace(";", "|");
            stringArray = ((String)object).split("[|]");
        }
        object = this.getVHost();
        LiveStreamTranscoderList liveStreamTranscoderList = null;
        if (object != null) {
            liveStreamTranscoderList = object.getLiveStreamTranscoderList();
        }
        List<String> list = this.liveStreamTranscoderSet;
        synchronized (list) {
            this.liveStreamTranscoderSet.clear();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].trim();
                    if (string2.length() <= 0) continue;
                    if (liveStreamTranscoderList != null && !liveStreamTranscoderList.containsLiveStreamTranscoderDef(string2)) {
                        WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.setLiveStreamTranscoderList[" + this.getApplication().getName() + "/" + this.getName() + "]: LiveStreamTranscoder is not valid: " + string2);
                    }
                    this.liveStreamTranscoderSet.add(string2);
                }
            }
        }
    }

    @Override
    public String getHTTPStreamerList() {
        return this.httpStreamerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHTTPStreamerList(String string) {
        Object object;
        this.httpStreamerList = string;
        String[] stringArray = null;
        if (string != null) {
            object = string;
            object = ((String)object).replace(",", "|");
            object = ((String)object).replace(";", "|");
            stringArray = ((String)object).split("[|]");
        }
        object = this.getVHost();
        HTTPStreamerList hTTPStreamerList = null;
        if (object != null) {
            hTTPStreamerList = object.getHTTPStreamerList();
        }
        List<String> list = this.httpStreamerSet;
        synchronized (list) {
            this.httpStreamerSet.clear();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].trim();
                    if (string2.length() <= 0) continue;
                    if (hTTPStreamerList != null && !hTTPStreamerList.containsHTTPStreamerDef(string2)) {
                        WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.setHTTPStreamerList[" + this.getApplication().getName() + "/" + this.getName() + "]: HTTPStreamer is not valid: " + string2);
                    }
                    this.httpStreamerSet.add(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsHTTPStreamer(String string) {
        List<String> list = this.httpStreamerSet;
        synchronized (list) {
            return this.httpStreamerSet.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsLiveStreamPacketizer(String string) {
        List<String> list = this.liveStreamPacketizerSet;
        synchronized (list) {
            return this.liveStreamPacketizerSet.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsLiveStreamTranscoder(String string) {
        List<String> list = this.liveStreamTranscoderSet;
        synchronized (list) {
            return this.liveStreamTranscoderSet.contains(string);
        }
    }

    @Override
    public IMediaStreamNameAliasProvider getStreamNameAliasProvider() {
        return this.streamNameAliasProvider;
    }

    @Override
    public void setStreamNameAliasProvider(IMediaStreamNameAliasProvider iMediaStreamNameAliasProvider) {
        this.streamNameAliasProvider = iMediaStreamNameAliasProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHTTPStreamerApplicationContext getHTTPStreamerApplicationContext(String string, boolean bl) {
        IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext = null;
        Map<String, IHTTPStreamerApplicationContext> map = this.httpStreamerApplicationContexts;
        synchronized (map) {
            iHTTPStreamerApplicationContext = this.httpStreamerApplicationContexts.get(string);
            if (iHTTPStreamerApplicationContext == null && bl) {
                IVHost iVHost = this.getVHost();
                if (iVHost == null) {
                    WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.getHTTPStreamerApplicationContext: Can't get vhost.");
                } else {
                    HTTPStreamerList hTTPStreamerList = iVHost.getHTTPStreamerList();
                    if (hTTPStreamerList == null) {
                        WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.getHTTPStreamerApplicationContext: HTTPStreamerList is missing.");
                    } else {
                        HTTPStreamerItem hTTPStreamerItem = hTTPStreamerList.getHTTPStreamerDef(string);
                        if (hTTPStreamerItem == null) {
                            WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.getHTTPStreamerApplicationContext: HTTPStreamerItem not found: " + string);
                        } else {
                            String string2 = hTTPStreamerItem.getApplicationContextClass();
                            if (string2 == null) {
                                WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.getHTTPStreamerApplicationContext: HTTPStreamerItem ApplicationContextClass class not set: " + string);
                            } else {
                                try {
                                    Class<?> clazz = Class.forName(string2);
                                    if (clazz != null) {
                                        iHTTPStreamerApplicationContext = (IHTTPStreamerApplicationContext)clazz.newInstance();
                                        iHTTPStreamerApplicationContext.init(this, hTTPStreamerItem);
                                    } else {
                                        WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.getHTTPStreamerApplicationContext: Error creating ApplicationContextClass: " + string + ": Error newInstance.");
                                    }
                                }
                                catch (Exception exception) {
                                    WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.getHTTPStreamerApplicationContext: Error creating ApplicationContextClass: " + string + ": " + exception.toString());
                                }
                                if (iHTTPStreamerApplicationContext != null) {
                                    this.httpStreamerApplicationContexts.put(string, iHTTPStreamerApplicationContext);
                                }
                            }
                        }
                    }
                }
            }
        }
        return iHTTPStreamerApplicationContext;
    }

    @Override
    public void addRTPIncomingDatagramPortRange(int n, int n2) {
        if (this.rtpIncomingDatagramPortRanges == null) {
            this.rtpIncomingDatagramPortRanges = new ArrayList<DatagramPortRange>();
        }
        this.rtpIncomingDatagramPortRanges.add(new DatagramPortRange(n, n2));
    }

    @Override
    public void addRTPIncomingDatagramPortAll() {
        if (this.rtpIncomingDatagramPortRanges == null) {
            this.rtpIncomingDatagramPortRanges = new ArrayList<DatagramPortRange>();
        }
        this.rtpIncomingDatagramPortRanges.add(DatagramPortRange.createAllPorts());
    }

    @Override
    public boolean isRTPIncomingDatagramPortValid(int n) {
        if (this.rtpIncomingDatagramPortRanges == null) {
            return false;
        }
        if (this.rtpIncomingDatagramPortRanges.size() == 1) {
            return this.rtpIncomingDatagramPortRanges.get(0).isValid(n);
        }
        boolean bl = false;
        for (DatagramPortRange datagramPortRange : this.rtpIncomingDatagramPortRanges) {
            if (!datagramPortRange.isValid(n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public String readAppInstConfig(String string) {
        String string2 = this.getStreamStoragePath() + "/" + string;
        return Server.readXMLConfig(string2);
    }

    @Override
    public boolean writeAppInstConfig(String string, String string2) {
        String string3 = this.getStreamStoragePath() + "/" + string;
        return Server.writeXMLConfig(string3, string2);
    }

    @Override
    public boolean isLiveStreamPacketize(String string, IMediaStream iMediaStream) {
        return true;
    }

    @Override
    public boolean isLiveStreamTranscode(String string, IMediaStream iMediaStream) {
        return !iMediaStream.isTranscodeResult();
    }

    @Override
    public ILiveStreamPacketizerControl getLiveStreamPacketizerControl() {
        return this.liveStreamPacketizerControl;
    }

    @Override
    public void setLiveStreamPacketizerControl(ILiveStreamPacketizerControl iLiveStreamPacketizerControl) {
        this.liveStreamPacketizerControl = iLiveStreamPacketizerControl;
    }

    @Override
    public ILiveStreamTranscoderControl getLiveStreamTranscoderControl() {
        return this.liveStreamTranscoderControl;
    }

    @Override
    public void setLiveStreamTranscoderControl(ILiveStreamTranscoderControl iLiveStreamTranscoderControl) {
        this.liveStreamTranscoderControl = iLiveStreamTranscoderControl;
    }

    @Override
    public boolean resetMediaCasterStream(String string) {
        return this.resetMediaCasterStream(string, "flv");
    }

    @Override
    public boolean resetMediaCasterStream(String string, String string2) {
        boolean bl = true;
        ApplicationInstance applicationInstance = this;
        try {
            Object object;
            ArrayList<String> arrayList;
            block10: {
                arrayList = new ArrayList<String>();
                if (string2.equals("smil")) {
                    try {
                        object = SmilUtils.parseSmilFile(applicationInstance, string, string2);
                        if (object == null) {
                            WMSLoggerFactory.getLogger(HTTPStreamManager.class).warn("ApplicationInstance.resetMediaCasterStream[" + applicationInstance.getContextStr() + "]: SMIL file: Error parsing file.");
                            break block10;
                        }
                        if (((SmilMediaList)object).size() <= 0) {
                            WMSLoggerFactory.getLogger(HTTPStreamManager.class).warn("ApplicationInstance.resetMediaCasterStream[" + applicationInstance.getContextStr() + "]: SMIL file: File is empty.");
                            break block10;
                        }
                        List<String> list = ((SmilMediaList)object).getStreamNames();
                        arrayList.addAll(list);
                        MediaStreamMapGroup object2 = new MediaStreamMapGroup();
                        object2.setName(string);
                        object2.addAll((Collection<String>)list);
                        MediaStreamMapGroup mediaStreamMapGroup = this.streams.addNameGroup(object2);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(HTTPStreamManager.class).error("ApplicationInstance.resetMediaCasterStream[" + applicationInstance.getContextStr() + "]: SMIL file: " + exception.toString());
                    }
                } else {
                    arrayList.add(string2 + ":" + string);
                }
            }
            object = applicationInstance.getMediaCasterStreams();
            bl = true;
            for (String string3 : arrayList) {
                MediaCasterStreamItem mediaCasterStreamItem = ((MediaCasterStreamMap)object).getMediaCaster(string3);
                if (mediaCasterStreamItem != null) {
                    mediaCasterStreamItem.getMediaCaster().forceReset();
                    WMSLoggerFactory.getLogger(ApplicationInstance.class).info("ApplicationInstance.resetMediaCasterStream[" + applicationInstance.getContextStr() + "]: Stream restarted: " + string3);
                    continue;
                }
                WMSLoggerFactory.getLogger(ApplicationInstance.class).info("ApplicationInstance.resetMediaCasterStream[" + applicationInstance.getContextStr() + "]: Stream not found: " + string3);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.resetMediaCasterStream[" + applicationInstance.getContextStr() + "]: " + exception.toString());
        }
        return bl;
    }

    @Override
    public boolean startMediaCasterStream(String string, String string2) {
        String string3 = "flv";
        String string4 = "";
        String[] stringArray = ModuleUtils.decodeStreamExtension(string, string3);
        string = stringArray[0];
        string3 = stringArray[1];
        boolean bl = string.indexOf("://") >= 0;
        int n = string.indexOf("?");
        if (!bl && n >= 0) {
            string4 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        return this.startMediaCasterStream(string, string3, string2);
    }

    @Override
    public boolean startMediaCasterStream(String string, String string2, String string3) {
        boolean bl;
        block14: {
            bl = false;
            ApplicationInstance applicationInstance = this;
            try {
                Object object;
                Object object2;
                Object object3;
                ArrayList<String> arrayList;
                block13: {
                    arrayList = new ArrayList<String>();
                    if (string2.equals("smil")) {
                        try {
                            object3 = SmilUtils.parseSmilFile(applicationInstance, string, string2);
                            if (object3 == null) {
                                WMSLoggerFactory.getLogger(HTTPStreamManager.class).warn("ApplicationInstance.startMediaCasterStream[" + applicationInstance.getContextStr() + "]: SMIL file: Error parsing file.");
                                break block13;
                            }
                            if (((SmilMediaList)object3).size() <= 0) {
                                WMSLoggerFactory.getLogger(HTTPStreamManager.class).warn("ApplicationInstance.startMediaCasterStream[" + applicationInstance.getContextStr() + "]: SMIL file: File is empty.");
                                break block13;
                            }
                            object2 = ((SmilMediaList)object3).getStreamNames();
                            arrayList.addAll((Collection<String>)object2);
                            object = new MediaStreamMapGroup();
                            ((MediaStreamMapGroup)object).setName(string);
                            ((MediaStreamMapGroup)object).addAll((Collection<String>)object2);
                            object = this.streams.addNameGroup((MediaStreamMapGroup)object);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(HTTPStreamManager.class).error("ApplicationInstance.startMediaCasterStream[" + applicationInstance.getContextStr() + "]: SMIL file: " + exception.toString());
                        }
                    } else {
                        arrayList.add(string2 + ":" + string);
                    }
                }
                object3 = applicationInstance.getMediaCasterStreams();
                object2 = applicationInstance.getVHost();
                object = ((MediaCasterStreamMap)object3).getStreamManager();
                MediaCasterList mediaCasterList = object2.getMediaCasterList();
                MediaCasterItem mediaCasterItem = mediaCasterList.getMediaCasterDef(string3);
                if (mediaCasterItem == null) {
                    WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.startMediaCasterStream[" + applicationInstance.getContextStr() + "]: MediaCaster type not found: " + string3);
                    break block14;
                }
                bl = true;
                try {
                    for (String string4 : arrayList) {
                        boolean bl2 = ((MediaCasterStreamManager)object).startStream(string4, string3);
                        if (bl2) {
                            WMSLoggerFactory.getLogger(ApplicationInstance.class).info("ApplicationInstance.startMediaCasterStream[" + applicationInstance.getContextStr() + "]: Stream started: " + string4);
                            continue;
                        }
                        WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.startMediaCasterStream[" + applicationInstance.getContextStr() + "]: Stream already started: " + string4);
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamManager.class).error("HTTPStreamManager.onHTTPRequest[" + applicationInstance.getContextStr() + "]: " + exception.toString());
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.startMediaCasterStream[" + applicationInstance.getContextStr() + "]: " + exception.toString());
            }
        }
        return bl;
    }

    @Override
    public void stopMediaCasterStream(String string) {
        try {
            ApplicationInstance applicationInstance = this;
            MediaCasterStreamMap mediaCasterStreamMap = applicationInstance.getMediaCasterStreams();
            MediaCasterStreamManager mediaCasterStreamManager = mediaCasterStreamMap.getStreamManager();
            boolean bl = mediaCasterStreamManager.stopStream(string);
            if (bl) {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).info("ApplicationInstance.stopMediaCasterStream: Stream stopped: " + string);
            } else {
                WMSLoggerFactory.getLogger(ApplicationInstance.class).warn("ApplicationInstance.stopMediaCasterStream: Stream not found: " + string);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.startMediaCasterStream: " + exception.toString());
        }
    }

    @Override
    public String getContextStr() {
        return this.application.getName() + "/" + this.getName();
    }

    @Override
    public List<String> getPublishStreamNames() {
        return this.streams.getPublishStreamNames();
    }

    @Override
    public int getRTPIdleFrequency() {
        return this.rtpIdleFrequency;
    }

    @Override
    public void setRTPIdleFrequency(int n) {
        this.rtpIdleFrequency = n;
    }

    @Override
    public IMediaCasterValidateMediaCaster getMediaCasterValidator() {
        return this.mediaCasterValidator;
    }

    @Override
    public void setMediaCasterValidator(IMediaCasterValidateMediaCaster iMediaCasterValidateMediaCaster) {
        this.mediaCasterValidator = iMediaCasterValidateMediaCaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void touch() {
        this.clientsLock.writeLock().lock();
        try {
            this.lastTouchTime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.touch: " + exception.toString());
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastTouchTime() {
        long l = 0L;
        this.clientsLock.readLock().lock();
        try {
            l = this.lastTouchTime;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ApplicationInstance.class).error("ApplicationInstance.touch: " + exception.toString());
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return l;
    }

    @Override
    public int getApplicationInstanceTouchTimeout() {
        return this.applicationInstanceTouchTimeout;
    }

    @Override
    public void setApplicationInstanceTouchTimeout(int n) {
        this.applicationInstanceTouchTimeout = n;
    }

    @Override
    public int getRTSPSessionTimeout() {
        return this.rtspSessionTimeout;
    }

    @Override
    public void setRTSPSessionTimeout(int n) {
        this.rtspSessionTimeout = n;
    }

    @Override
    public int getRTSPMaximumPendingWriteBytes() {
        return this.rtspMaximumPendingWriteBytes;
    }

    @Override
    public void setRTSPMaximumPendingWriteBytes(int n) {
        this.rtspMaximumPendingWriteBytes = n;
    }

    @Override
    public String getRTSPBindIpAddress() {
        return this.rtspBindIpAddress;
    }

    @Override
    public void setRTSPBindIpAddress(String string) {
        this.rtspBindIpAddress = string;
    }

    @Override
    public String getRTSPConnectionIpAddress() {
        return this.rtspConnectionIpAddress;
    }

    @Override
    public void setRTSPConnectionIpAddress(String string) {
        this.rtspConnectionIpAddress = string;
    }

    @Override
    public String getRTSPConnectionAddressType() {
        return this.rtspConnectionAddressType;
    }

    @Override
    public void setRTSPConnectionAddressType(String string) {
        this.rtspConnectionAddressType = string;
    }

    @Override
    public String getRTSPOriginIpAddress() {
        return this.rtspOriginIpAddress;
    }

    @Override
    public void setRTSPOriginIpAddress(String string) {
        this.rtspOriginIpAddress = string;
    }

    @Override
    public String getRTSPOriginAddressType() {
        return this.rtspOriginAddressType;
    }

    @Override
    public void setRTSPOriginAddressType(String string) {
        this.rtspOriginAddressType = string;
    }

    @Override
    public String resolvePlayAlias(IApplicationInstance iApplicationInstance, String string) {
        return MediaCasterUtils.handlePlayAliasFile(iApplicationInstance, string);
    }

    @Override
    public String resolveStreamAlias(IApplicationInstance iApplicationInstance, String string) {
        return MediaCasterUtils.handleStreamAliasFile(iApplicationInstance, string);
    }

    public String internalResolvePlayAlias(String string) {
        return this.streamNameAliasProvider.resolvePlayAlias(this, string);
    }

    public String internalResolvePlayAlias(String string, IClient iClient) {
        if (this.streamNameAliasProvider instanceof IMediaStreamNameAliasProvider2) {
            return ((IMediaStreamNameAliasProvider2)this.streamNameAliasProvider).resolvePlayAlias((IApplicationInstance)this, string, iClient);
        }
        return this.streamNameAliasProvider.resolvePlayAlias(this, string);
    }

    public String internalResolvePlayAlias(String string, IHTTPStreamerSession iHTTPStreamerSession) {
        if (this.streamNameAliasProvider instanceof IMediaStreamNameAliasProvider2) {
            return ((IMediaStreamNameAliasProvider2)this.streamNameAliasProvider).resolvePlayAlias((IApplicationInstance)this, string, iHTTPStreamerSession);
        }
        return this.streamNameAliasProvider.resolvePlayAlias(this, string);
    }

    public String internalResolvePlayAlias(String string, RTPSession rTPSession) {
        if (this.streamNameAliasProvider instanceof IMediaStreamNameAliasProvider2) {
            return ((IMediaStreamNameAliasProvider2)this.streamNameAliasProvider).resolvePlayAlias((IApplicationInstance)this, string, rTPSession);
        }
        return this.streamNameAliasProvider.resolvePlayAlias(this, string);
    }

    public String internalResolvePlayAlias(String string, ILiveStreamPacketizer iLiveStreamPacketizer) {
        if (this.streamNameAliasProvider instanceof IMediaStreamNameAliasProvider2) {
            return ((IMediaStreamNameAliasProvider2)this.streamNameAliasProvider).resolvePlayAlias((IApplicationInstance)this, string, iLiveStreamPacketizer);
        }
        return this.streamNameAliasProvider.resolvePlayAlias(this, string);
    }

    public String internalResolveStreamAlias(String string) {
        return this.streamNameAliasProvider.resolveStreamAlias(this, string);
    }

    public String internalResolveStreamAlias(String string, IMediaCaster iMediaCaster) {
        if (this.streamNameAliasProvider instanceof IMediaStreamNameAliasProvider2) {
            return ((IMediaStreamNameAliasProvider2)this.streamNameAliasProvider).resolveStreamAlias(this, string, iMediaCaster);
        }
        return this.streamNameAliasProvider.resolveStreamAlias(this, string);
    }

    @Override
    public boolean isValidateFMLEConnections() {
        return this.validateFMLEConnections;
    }

    @Override
    public void setValidateFMLEConnections(boolean bl) {
        this.validateFMLEConnections = bl;
    }

    @Override
    public LiveStreamTranscoderApplicationContext getTranscoderApplicationContext() {
        return this.transcoderApplicationContext;
    }

    class ConnectionNotifier
    implements IConnectionNotify {
        private ApplicationInstance appInstance = null;

        public ConnectionNotifier(ApplicationInstance applicationInstance2) {
            this.appInstance = applicationInstance2;
        }

        public void onAcceptConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, Date date, long l) {
            ApplicationInstance.this.connectionCounters[connectionHolder.getConnectionType()].incrementAccept(connectionHolder, date, l);
        }

        public void onRejectConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, int n, Date date, long l) {
            ApplicationInstance.this.connectionCounters[connectionHolder.getConnectionType()].incrementReject(connectionHolder, n, date, l);
        }

        public void onDisconnect(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, boolean bl, Date date, long l) {
            ApplicationInstance.this.connectionCounters[connectionHolder.getConnectionType()].decrement(connectionHolder, bl, date, l);
        }
    }

    class ConnectionValidator
    implements IConnectionValidator {
        private ApplicationInstance applicationInstance = null;

        public ConnectionValidator(ApplicationInstance applicationInstance2) {
            this.applicationInstance = applicationInstance2;
        }

        public boolean validateConnection(ConnectionCounter connectionCounter, ConnectionHolder connectionHolder, byte[] byArray) {
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("r2");
            byte[] byArray2 = bigInteger.toByteArray();
            for (int i = 0; i < byArray.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] ^ byArray2[(i + 3) % byArray2.length]);
            }
            return ((Application)this.applicationInstance.application).getConnectionValidator().validateConnection(connectionCounter, connectionHolder, byArray);
        }
    }
}

