/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.client;

import com.wowza.util.AMFUtils;
import com.wowza.util.ElapsedTimer;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.NoMBean;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.application.Application;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.ClientCallResults;
import com.wowza.wms.client.ClientPingResults;
import com.wowza.wms.client.ClientWorker;
import com.wowza.wms.client.ClientWriteListener;
import com.wowza.wms.client.ConnectionHolder;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.module.IModuleCallResult;
import com.wowza.wms.module.IModulePingResult;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.request.IRTMPEncrypt;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.request.RequestData;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.response.ResponseFunctions;
import com.wowza.wms.response.ResponseStreams;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.server.ServerHandler;
import com.wowza.wms.sharedobject.ISharedObject;
import com.wowza.wms.sharedobject.SharedObject;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import com.wowza.wms.vhost.ThreadPool;
import com.wowza.wms.vhost.VHostWorkerThread;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.BaseIoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
implements IClient {
    public static final int CONFIRM_BYTESRECEIVED = 625500;
    public static final int VALIDATIONFREQUENCY = 8000;
    public static final int MAXIMUMPENDINGWRITEBYTES = 0;
    public static final int MAXIMUMSETBUFFERTIME = 0;
    public static final int SMALLCHUNKSIZE = 512;
    public static final int LARGECHUNKSIZE = 4096;
    private String flashVer = "unknown";
    private int responseIndex = 0;
    private int lastRequestType = 0;
    private List<IMediaStream> playStreams = new ArrayList<IMediaStream>();
    private List<IMediaStream> publishStreams = new ArrayList<IMediaStream>();
    private Object isSendingData = new Object();
    private boolean isSendingFlag = false;
    private IVHost vhost = null;
    private boolean acceptConnection = true;
    private AMFData acceptConnectionObj = null;
    private AMFDataObj acceptConnectionExObj = null;
    private boolean acceptConnectionExIsRedirect = false;
    private String acceptConnectionDescription = null;
    private Map<String, AMFData> acceptConnectionAttributes = new HashMap<String, AMFData>();
    private String streamType = "default";
    private String ip = "127.0.0.1";
    private long connectTime = 0L;
    private long pingRoundTripTime = 0L;
    private int isFlashVerH264 = 0;
    private int isFlashVer90115 = 0;
    private int isFlashVer10 = 0;
    private int isFMLE = 0;
    private int isLiveRepeater = 0;
    private int handshake;
    private int debugDumpData = 0;
    private byte[] leftOverData = null;
    private int leftOverMissing = 0;
    private List<AMFObj> reqAMFObjs = new ArrayList<AMFObj>();
    private int receiveChunkSize = 128;
    private int sendChunkSize = 512;
    private Map<Integer, RequestFunction> partialFunctions = new HashMap<Integer, RequestFunction>();
    private ResponseFunctions respFunctions = new ResponseFunctions();
    private ResponseStreams respStreams = new ResponseStreams();
    private List<AMFObj> respAMFObjs = new ArrayList<AMFObj>();
    private Map<IMediaStream, Integer> respAMFMap = new HashMap<IMediaStream, Integer>();
    private AMFObj statusAMFObj = new AMFObj(5, 0);
    private byte lastHandshakeByte = 0;
    private IOPerformanceCounter totalIOPerformance = new IOPerformanceCounter();
    private IOPerformanceCounter totalIOPerformanceLast = null;
    private IOPerformanceCounter totalIOPerformance2Last = null;
    private IOPerformanceCounter mediaIOPerformance = new IOPerformanceCounter();
    private long nextConfirmBytesReceived = 625500L;
    private IApplicationInstance appInstance = null;
    private long lastTouch = 0L;
    private Object lastTouchObj = new Object();
    private boolean isConnected = false;
    private List<RequestData> packetList = null;
    private ClientWorker asyncProcessor = null;
    private int clientId = -1;
    private WMSProperties properties = new WMSProperties();
    private int lastStreamId = 0;
    private ClientCallResults callResults = new ClientCallResults();
    private ClientPingResults pingResults = new ClientPingResults();
    private List<ISharedObject> sharedObjects = new ArrayList<ISharedObject>();
    private List<IMediaStream> streamList = new ArrayList<IMediaStream>();
    private FastPlaySettings fastPlaySettings = null;
    private boolean isValidatingConnection = false;
    private long lastValidateTime = 0L;
    private boolean shutdownClient = false;
    private ConnectionHolder connectionHolder = new ConnectionHolder(this);
    private ElapsedTimer elapsedTime = new ElapsedTimer();
    private int bufferTime = 0;
    private String queryStr = "";
    private String referrer = "";
    private String pageUrl = "";
    private String uri = "";
    private int protocol = 1;
    private boolean isSSL = false;
    private boolean isEncrypted = false;
    private HostPort serverHostPort = null;
    private boolean immediateIdle = false;
    private Object immediateIdleLock = new Object();
    private IoSession ioSession = null;
    private int idleFrequency = 500;
    private String streamVideoSampleAccess = "";
    private String streamAudioSampleAccess = "";
    private String streamReadAccess = "*";
    private String streamWriteAccess = "*";
    private String sharedObjectReadAccess = "*";
    private String sharedObjectWriteAccess = "*";
    private ClientWriteListener writeListener = new ClientWriteListener(this);
    private long timebase = 0L;
    private int waitingForIOCount = 0;
    private String repeaterOriginUrl = null;
    private int objectEncoding = 0;
    private AtomicReference<RTPStream> rtpStream = new AtomicReference<Object>(null);
    private IRTMPEncrypt rtmpEncryptHandlerIn = null;
    private IRTMPEncrypt rtmpEncryptHandlerOut = null;
    private long lastPingWriteId = -1L;
    private String liveStreamPacketizerList = null;
    private String liveStreamTranscoderList = null;
    private int liveRepeaterCapabilities = 0;
    private Object fcSubcripeLock = new Object();
    private Map<String, FCSubscribeHolder> fcSubcripes = null;
    private Map<Long, IMediaStream> streamCache = new HashMap<Long, IMediaStream>();
    private boolean validateFMLEConnections = false;

    @NoMBean
    public static boolean decodeSS(String string) {
        boolean bl = false;
        try {
            int n = 27;
            BigInteger bigInteger = ServerHandler.sDecode2(RTMPRequestAdapter.sDescramble2(RTMPRequestAdapter.sUnpretty(string), n), n);
            String[] stringArray = ModuleConnect.getK2();
            byte[] byArray = Application.getX();
            int n2 = 0;
            BigInteger bigInteger2 = null;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                BigInteger bigInteger3 = new BigInteger(stringArray[n2], 36);
                byte[] byArray2 = bigInteger3.toByteArray();
                for (int i = 0; i < byArray2.length; ++i) {
                    int n3 = i;
                    byArray2[n3] = (byte)(byArray2[n3] ^ byArray[i % byArray.length]);
                }
                bigInteger2 = new BigInteger(byArray2);
                if (bigInteger.mod(bigInteger2).intValue() == 0) break;
            }
            bl = n2 < stringArray.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @NoMBean
    public static void decodeS(String string) {
        Object object;
        Object object2;
        int n = 27;
        BigInteger bigInteger = ServerHandler.sDecode2(RTMPRequestAdapter.sDescramble2(RTMPRequestAdapter.sUnpretty(string), n), n);
        String[] stringArray = ModuleConnect.getK2();
        byte[] byArray = Application.getX();
        int n2 = 0;
        int n3 = 0;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = new BigInteger("0");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            object2 = new BigInteger(stringArray[n2], 36);
            object = ((BigInteger)object2).toByteArray();
            for (int i = 0; i < ((byte[])object).length; ++i) {
                int n4 = i;
                object[n4] = (byte)(object[n4] ^ byArray[i % byArray.length]);
            }
            bigInteger2 = new BigInteger((byte[])object);
            if (!bigInteger.mod(bigInteger2).equals(bigInteger3)) continue;
            n3 = bigInteger.divide(bigInteger2).intValue();
            break;
        }
        MediaStreamBase.s = string;
        if (n2 < stringArray.length && n3 >= 1 && n3 <= 500000) {
            object2 = RTMPRequestAdapter.sBaggage(string);
            if (object2 == null) {
                object2 = ModuleConnect.getP2(n2);
            }
            object = RTMPRequestAdapter.fS(bigInteger2.toByteArray(), (String)object2);
            MediaStreamBase.sinfo.put("s", object2);
            MediaStreamBase.sinfo.put("k", bigInteger2);
            String string2 = "";
            int n5 = 0;
            int n6 = 0;
            String string3 = "";
            String string4 = "";
            String string5 = "";
            ArrayList<int[]> arrayList = null;
            HashMap hashMap = null;
            ArrayList arrayList2 = null;
            HashMap<String, Integer> hashMap2 = null;
            String[] stringArray2 = ((String)object).split("[|]");
            for (int i = 0; i < stringArray2.length; ++i) {
                String[] stringArray3 = stringArray2[i].split("[=]");
                if (stringArray3.length != 2) continue;
                try {
                    String[] stringArray4;
                    int n7;
                    String[] stringArray5;
                    if (stringArray3[0].equals("n")) {
                        string2 = stringArray3[1];
                        continue;
                    }
                    if (stringArray3[0].equals("c")) {
                        n5 = Integer.parseInt(stringArray3[1]);
                        continue;
                    }
                    if (stringArray3[0].startsWith("c")) continue;
                    if (stringArray3[0].equals("b")) {
                        n6 = Integer.parseInt(stringArray3[1]);
                        continue;
                    }
                    if (stringArray3[0].startsWith("b")) continue;
                    if (stringArray3[0].equals("k")) {
                        string5 = stringArray3[1];
                        continue;
                    }
                    if (stringArray3[0].equals("d")) {
                        stringArray5 = stringArray3[1].split("[-]");
                        if (stringArray5.length != 2) continue;
                        string3 = stringArray5[0];
                        string4 = stringArray5[1];
                        continue;
                    }
                    if (stringArray3[0].equals("i")) {
                        arrayList = new ArrayList<int[]>();
                        stringArray5 = stringArray3[1].split("[,]");
                        for (n7 = 0; n7 < stringArray5.length; ++n7) {
                            int n8;
                            String[] stringArray6 = stringArray5[n7].split("[-]");
                            if (stringArray6.length != 2) continue;
                            stringArray4 = stringArray6[0].split("[.]");
                            String[] stringArray7 = stringArray6[1].split("[.]");
                            int[] nArray = new int[stringArray4.length + stringArray7.length];
                            int n9 = 0;
                            for (n8 = 0; n8 < stringArray4.length; ++n8) {
                                nArray[n9] = Integer.parseInt(stringArray4[n8]);
                                ++n9;
                            }
                            for (n8 = 0; n8 < stringArray7.length; ++n8) {
                                nArray[n9] = Integer.parseInt(stringArray7[n8]);
                                ++n9;
                            }
                            arrayList.add(nArray);
                        }
                        continue;
                    }
                    if (stringArray3[0].equals("s")) {
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        if ((stringArray5 = stringArray3[1].split(",")).length <= 0) continue;
                        ArrayList<String> arrayList3 = new ArrayList<String>();
                        for (int j = 1; j < stringArray5.length; ++j) {
                            arrayList3.add(stringArray5[j].trim());
                        }
                        hashMap.put(stringArray5[0].trim(), arrayList3);
                        continue;
                    }
                    if (stringArray3[0].startsWith("s")) continue;
                    if (stringArray3[0].equals("p")) {
                        stringArray5 = stringArray3[1].split("[,]");
                        for (n7 = 0; n7 < stringArray5.length; ++n7) {
                            String[] stringArray8 = stringArray5[n7].split(":");
                            if (hashMap2 == null) {
                                hashMap2 = new HashMap<String, Integer>();
                            }
                            hashMap2.put(stringArray8[0], new Integer(Integer.parseInt(stringArray8[1])));
                        }
                        continue;
                    }
                    if (stringArray3[0].startsWith("p")) continue;
                    if (stringArray3[0].equals("maf")) {
                        arrayList2 = new ArrayList();
                        stringArray5 = stringArray3[1].split("[,]");
                        for (n7 = 0; n7 < stringArray5.length; ++n7) {
                            ArrayList<String> arrayList4 = new ArrayList<String>();
                            stringArray4 = stringArray5[n7].trim().split("[:]");
                            for (int j = 0; j < stringArray4.length; ++j) {
                                arrayList4.add(stringArray4[j].trim());
                            }
                            arrayList2.add(arrayList4);
                        }
                        continue;
                    }
                    WMSLoggerFactory.getLogger(null).error(RTMPRequestAdapter.fN(ModuleConnect.getN(14)));
                    System.exit(1);
                    continue;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error(exception.toString());
                }
            }
            if (string5.equals("wowza") && n5 != 0 && n6 != 0) {
                Random random = new Random(System.currentTimeMillis());
                MediaStreamBase.p = string2;
                MediaStreamBase.sinfo.put("l", new Integer(n5));
                MediaStreamBase.sinfo.put("i", arrayList);
                MediaStreamBase.sinfo.put("maf", arrayList2);
                MediaStreamBase.sinfo.put("n", string2);
                MediaStreamBase.sinfo.put("b", new Integer(n6));
                MediaStreamBase.sinfo.put("sl", hashMap);
                MediaStreamBase.sinfo.put("slp", "");
                MediaStreamBase.sinfo.put("sta", string3);
                MediaStreamBase.sinfo.put("stp", string4);
                MediaStreamBase.sinfo.put("pp", hashMap2);
                MediaStreamBase.sinfo.put("r1", BigInteger.probablePrime(64, random));
                MediaStreamBase.sinfo.put("r2", BigInteger.probablePrime(64, random));
                MediaStreamBase.sinfo.put("ss", RTMPRequestAdapter.sUnpretty(string));
            }
        }
    }

    public Client(IVHost iVHost, int n) {
        this.vhost = iVHost;
        this.clientId = n;
        this.packetList = new ArrayList<RequestData>();
        this.connectTime = System.currentTimeMillis();
        this.idleFrequency = iVHost.getClientIdleFrequency();
        this.connectionHolder.setConnectionType(0);
        for (int i = 0; i <= 4; ++i) {
            this.respAMFObjs.add(null);
            this.reqAMFObjs.add(null);
        }
        this.respAMFObjs.set(3, new AMFObj(3, this.objectEncoding));
        this.respAMFObjs.set(4, new AMFObj(4, this.objectEncoding));
    }

    @Override
    public void reparentClient(IVHost iVHost) {
        this.vhost = iVHost;
        this.idleFrequency = iVHost.getClientIdleFrequency();
    }

    @NoMBean
    public void init(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        ((ApplicationInstance)iApplicationInstance).initClient(this);
    }

    @Override
    public int getClientId() {
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAsync() {
        StackTraceElement[] stackTraceElementArray;
        if (this.asyncProcessor == null) {
            return;
        }
        ClientWorker clientWorker = this.asyncProcessor;
        synchronized (clientWorker) {
            boolean bl = this.asyncProcessor.isRunning();
            stackTraceElementArray = this.asyncProcessor.getThread();
            if (bl && stackTraceElementArray == null) {
                WMSLoggerFactory.getLogger(Client.class).debug("waitForAsync: notrunning: " + this.getClientId());
                this.asyncProcessor.setRunning(false);
                return;
            }
        }
        int n = 0;
        while (this.asyncProcessor.isRunning()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(Client.class).error("destroyAsyncProcessor: " + exception.toString());
            }
            if (++n <= 100) continue;
            Thread thread = this.asyncProcessor.getThread();
            if (thread != null) {
                WMSLoggerFactory.getLogger(Client.class).debug("waitForAsync: stuck: " + this.getClientId());
                stackTraceElementArray = thread.getStackTrace();
                if (stackTraceElementArray != null) {
                    for (int i = 0; i < stackTraceElementArray.length; ++i) {
                        WMSLoggerFactory.getLogger(Client.class).debug("  " + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + " line:" + stackTraceElementArray[i].getLineNumber());
                    }
                }
                try {
                    thread.interrupt();
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(Client.class).error("waitForAsync: kill: " + exception.toString());
                }
                break;
            }
            WMSLoggerFactory.getLogger(Client.class).debug("waitForAsync: choked: " + this.getClientId());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public int getRequestDataSize() {
        int n = 0;
        ClientWorker clientWorker = this.asyncProcessor;
        synchronized (clientWorker) {
            n = this.packetList.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void addRequestData(ByteBuffer byteBuffer, int n, int n2, List list) {
        ClientWorker clientWorker = this.asyncProcessor;
        synchronized (clientWorker) {
            this.packetList.add(new RequestData(byteBuffer, n, n2, list));
            if (!this.asyncProcessor.isRunning()) {
                ThreadPool threadPool = this.vhost.getThreadPool();
                this.asyncProcessor.setRunning(true);
                threadPool.execute(this.asyncProcessor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public RequestData getNextRequestData() {
        RequestData requestData = null;
        ClientWorker clientWorker = this.asyncProcessor;
        synchronized (clientWorker) {
            if (this.packetList.size() > 0) {
                requestData = this.packetList.remove(0);
            }
        }
        return requestData;
    }

    @NoMBean
    public List getRespAMFObjs() {
        return this.respAMFObjs;
    }

    @NoMBean
    public int getRespAFMIndex(IMediaStream iMediaStream) {
        int n = -1;
        try {
            Integer n2 = this.respAMFMap.get(iMediaStream);
            if (n2 != null) {
                n = n2;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Client.class).error("unregisterPlayStream: " + exception.toString());
        }
        return n;
    }

    @Override
    @NoMBean
    public AMFObj getRespAMFAudioObj(IMediaStream iMediaStream) {
        AMFObj aMFObj = null;
        try {
            int n = this.getRespAFMIndex(iMediaStream);
            if (n >= 0) {
                aMFObj = this.respAMFObjs.get(n + 1);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Client.class).error("getRespAMFAudioObj: " + exception.toString());
        }
        return aMFObj;
    }

    @Override
    @NoMBean
    public AMFObj getRespAMFVideoObj(IMediaStream iMediaStream) {
        AMFObj aMFObj = null;
        try {
            int n = this.getRespAFMIndex(iMediaStream);
            if (n >= 0) {
                aMFObj = this.respAMFObjs.get(n + 2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Client.class).error("getRespAMFVideoObj: " + exception.toString());
        }
        return aMFObj;
    }

    @Override
    @NoMBean
    public AMFObj getRespAMFDataObj(IMediaStream iMediaStream) {
        AMFObj aMFObj = null;
        try {
            int n = this.getRespAFMIndex(iMediaStream);
            if (n >= 0) {
                aMFObj = this.respAMFObjs.get(n + 0);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Client.class).error("getRespAMFDataObj: " + exception.toString());
        }
        return aMFObj;
    }

    @Override
    public String getFlashVer() {
        return this.flashVer;
    }

    @Override
    public void setFlashVer(String string) {
        this.flashVer = string;
    }

    @NoMBean
    public int getHandshake() {
        return this.handshake;
    }

    @NoMBean
    public void setHandshake(int n) {
        this.handshake = n;
    }

    @Override
    @NoMBean
    public ResponseFunctions getRespFunctions() {
        return this.respFunctions;
    }

    @NoMBean
    public void setRespFunctions(ResponseFunctions responseFunctions) {
        this.respFunctions = responseFunctions;
    }

    @NoMBean
    public int getDebugDumpData() {
        return this.debugDumpData;
    }

    @NoMBean
    public void setDebugDumpData(int n) {
        this.debugDumpData = n;
    }

    @NoMBean
    public byte getLastHandshakeByte() {
        return this.lastHandshakeByte;
    }

    @NoMBean
    public void setLastHandshakeByte(byte by) {
        this.lastHandshakeByte = by;
    }

    @NoMBean
    public int getResponseIndex() {
        return this.responseIndex;
    }

    @NoMBean
    public int incResponseIndex() {
        int n = this.responseIndex++;
        return n;
    }

    @NoMBean
    public void resetResponseIndex() {
        this.responseIndex = 0;
    }

    @NoMBean
    public void setResponseIndex(int n) {
        this.responseIndex = n;
    }

    @NoMBean
    public int getLastRequestType() {
        return this.lastRequestType;
    }

    @NoMBean
    public void setLastRequestType(int n) {
        this.lastRequestType = n;
    }

    @NoMBean
    public IOPerformanceCounter addIOPerformance(IOPerformanceCounter iOPerformanceCounter) {
        IOPerformanceCounter iOPerformanceCounter2 = this.totalIOPerformance.clone();
        iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.totalIOPerformanceLast);
        this.totalIOPerformanceLast = iOPerformanceCounter2;
        return this.totalIOPerformance;
    }

    @NoMBean
    public IOPerformanceCounter addIOPerformance2(IOPerformanceCounter iOPerformanceCounter) {
        IOPerformanceCounter iOPerformanceCounter2 = this.totalIOPerformance.clone();
        iOPerformanceCounter.addDifference(iOPerformanceCounter2, this.totalIOPerformance2Last);
        this.totalIOPerformance2Last = iOPerformanceCounter2;
        return this.totalIOPerformance;
    }

    public long getTotalInBytes() {
        return this.totalIOPerformance.getMessagesInBytes();
    }

    @Override
    @NoMBean
    public IOPerformanceCounter getTotalIOPerformanceCounter() {
        return this.totalIOPerformance;
    }

    @Override
    @NoMBean
    public IOPerformanceCounter getMediaIOPerformanceCounter() {
        return this.mediaIOPerformance;
    }

    @NoMBean
    public long incrementTotalInBytes(long l) {
        long l2 = this.totalIOPerformance.incrementMessagesIn(l);
        return l2;
    }

    @NoMBean
    public long incrementTotalOutBytes(long l) {
        long l2 = this.totalIOPerformance.incrementMessagesOut(l);
        return l2;
    }

    @NoMBean
    public long incrementMediaOutBytes(long l, long l2) {
        return this.mediaIOPerformance.incrementMessagesOut(l, l2);
    }

    @NoMBean
    public long incrementMediaLossBytes(long l, long l2) {
        return this.mediaIOPerformance.incrementMessagesLoss(l, l2);
    }

    @NoMBean
    public long incrementTotalLossBytes(long l, long l2) {
        return this.totalIOPerformance.incrementMessagesLoss(l, l2);
    }

    @NoMBean
    public long incrementMediaInBytes(long l) {
        return this.mediaIOPerformance.incrementMessagesIn(l);
    }

    @NoMBean
    public long getNextConfirmBytesReceived() {
        return this.nextConfirmBytesReceived;
    }

    @NoMBean
    public void setNextConfirmBytesReceived(long l) {
        this.nextConfirmBytesReceived = l;
    }

    @NoMBean
    public long incrementNextConfirmBytesReceived() {
        this.nextConfirmBytesReceived += 625500L;
        return this.nextConfirmBytesReceived;
    }

    @Override
    @NoMBean
    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    @Override
    @NoMBean
    public IApplication getApplication() {
        return this.appInstance.getApplication();
    }

    @NoMBean
    public void setAppInstance(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
    }

    private void registerPlayStream(IMediaStream iMediaStream) {
        int n;
        if (this.respAMFMap.containsKey(iMediaStream)) {
            return;
        }
        boolean bl = false;
        for (n = 5; n <= this.respAMFObjs.size() - 3; n += 3) {
            if (this.respAMFObjs.get(n) != null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.respAMFObjs.add(null);
            this.respAMFObjs.add(null);
            this.respAMFObjs.add(null);
        }
        this.respAMFMap.put(iMediaStream, new Integer(n));
        this.respAMFObjs.set(n, new AMFObj(n, this.objectEncoding));
        this.respAMFObjs.set(n + 1, new AMFObj(n + 1, this.objectEncoding));
        this.respAMFObjs.set(n + 2, new AMFObj(n + 2, this.objectEncoding));
    }

    private void unregisterPlayStream(IMediaStream iMediaStream) {
        try {
            int n = this.getRespAFMIndex(iMediaStream);
            if (n >= 0) {
                this.respAMFObjs.set(n, null);
                this.respAMFObjs.set(n + 1, null);
                this.respAMFObjs.set(n + 2, null);
            }
            this.respAMFMap.remove(iMediaStream);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Client.class).error("unregisterPlayStream: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void addPlayStreams(IMediaStream iMediaStream) {
        List<IMediaStream> list = this.playStreams;
        synchronized (list) {
            this.playStreams.add(iMediaStream);
            this.registerPlayStream(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void getStreamSendDirectMessages() {
        List<IMediaStream> list = this.publishStreams;
        synchronized (list) {
            if (this.publishStreams.size() > 0) {
                for (IMediaStream iMediaStream : this.publishStreams) {
                    ((MediaStream)iMediaStream).processSendDirectMessages();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public int getPlayResponse() {
        int n = 0;
        List<IMediaStream> list = this.playStreams;
        synchronized (list) {
            if (this.playStreams.size() > 0) {
                for (IMediaStream iMediaStream : this.playStreams) {
                    IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
                    boolean bl = iMediaStreamPlay != null ? iMediaStreamPlay.play() : false;
                    if (!bl) continue;
                    this.respStreams.addStreamResponse(iMediaStream);
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void removePlayStreams(IMediaStream iMediaStream) {
        try {
            List<IMediaStream> list = this.playStreams;
            synchronized (list) {
                int n = this.playStreams.indexOf(iMediaStream);
                if (n >= 0) {
                    this.playStreams.remove(n);
                }
                this.unregisterPlayStream(iMediaStream);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Client.class).error("removePlayStreams: " + exception.toString());
        }
    }

    @Override
    @NoMBean
    public List getPlayStreams() {
        return this.playStreams;
    }

    @NoMBean
    public void addPublishStreams(IMediaStream iMediaStream) {
        this.publishStreams.add(iMediaStream);
    }

    @NoMBean
    public void removePublishStreams(IMediaStream iMediaStream) {
        try {
            this.publishStreams.remove(iMediaStream);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(Client.class).error("removeLiveStreams: " + exception.toString());
        }
    }

    @Override
    @NoMBean
    public List getPublishStreams() {
        return this.publishStreams;
    }

    @NoMBean
    public ResponseStreams getRespStreams() {
        return this.respStreams;
    }

    @NoMBean
    public void setRespStreams(ResponseStreams responseStreams) {
        this.respStreams = responseStreams;
    }

    @NoMBean
    public Map getPartialFunctions() {
        return this.partialFunctions;
    }

    @NoMBean
    public void setPartialFunctions(Map map) {
        this.partialFunctions.putAll(map);
    }

    @NoMBean
    public void clearPartialFunctions() {
        this.partialFunctions.clear();
    }

    @NoMBean
    public void addPartialFunction(Integer n, RequestFunction requestFunction) {
        this.partialFunctions.put(n, requestFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownRTPStream() {
        RTPStream rTPStream = this.getRTPStream();
        if (rTPStream != null) {
            Object object;
            Object object2 = object = rTPStream.getStreamLock();
            synchronized (object2) {
                RTPRequestStatus rTPRequestStatus = new RTPRequestStatus();
                rTPStream.shutdown(rTPRequestStatus);
            }
            this.setRTPStream(null);
        }
    }

    public void shutdownClientInternal() {
        this.waitForAsync();
        this.fcUnSubscribeAll();
        this.shutdownRTPStream();
        this.removeOpenStreams();
        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, null, "session", "disconnect", 200, this.getClientId() + "");
        this.releaseSharedObjects();
        if (this.appInstance != null) {
            this.appInstance.shutdownClient(this);
        }
        this.isConnected = false;
        this.respFunctions.clear();
        if (this.ioSession != null) {
            this.ioSession.clearWriteListeners();
        }
        this.ioSession = null;
    }

    @Override
    public void shutdownClient() {
        byte[] byArray = new byte[]{3, 0, 0, 0, 0, 0, 18, 20, 0, 0, 0, 0, 2, 0, 5, 99, 108, 111, 115, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5};
        ResponseFunction responseFunction = new ResponseFunction(this);
        responseFunction.addBytes(byArray);
        this.getRespFunctions().add(responseFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NoMBean
    public void touch() {
        Object object = this.lastTouchObj;
        synchronized (object) {
            this.lastTouch = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public long getTouch() {
        long l = 0L;
        Object object = this.lastTouchObj;
        synchronized (object) {
            l = this.lastTouch;
        }
        return l;
    }

    @NoMBean
    public void setIsConnected(boolean bl) {
        this.isConnected = bl;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneSendData() {
        Object object = this.isSendingData;
        synchronized (object) {
            this.isSendingFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSendData() {
        boolean bl = false;
        Object object = this.isSendingData;
        synchronized (object) {
            if (!this.isSendingFlag) {
                this.isSendingFlag = true;
                bl = true;
            }
        }
        return bl;
    }

    @NoMBean
    public byte[] getLeftOverData() {
        return this.leftOverData;
    }

    @NoMBean
    public int getLeftOverMissing() {
        return this.leftOverMissing;
    }

    @NoMBean
    public void setLeftOverData(byte[] byArray, int n, int n2) {
        this.setLeftOverData(byArray, n, n2, 0);
    }

    @NoMBean
    public void setLeftOverData(byte[] byArray, int n, int n2, int n3) {
        this.leftOverData = new byte[n2];
        this.leftOverMissing = n3;
        System.arraycopy(byArray, n, this.leftOverData, 0, n2);
    }

    @NoMBean
    public void clearLeftOverData() {
        this.leftOverData = null;
        this.leftOverMissing = 0;
    }

    @NoMBean
    public boolean isLeftOverData() {
        return this.leftOverData != null;
    }

    @NoMBean
    public List getReqAMFObjs() {
        return this.reqAMFObjs;
    }

    public int getReceiveChunkSize() {
        return this.receiveChunkSize;
    }

    @NoMBean
    public void setReceiveChunkSize(int n) {
        this.receiveChunkSize = n;
    }

    public int getSendChunkSize() {
        return this.sendChunkSize;
    }

    @NoMBean
    public void setSendChunkSize(int n) {
        this.sendChunkSize = n;
    }

    @Override
    @NoMBean
    public WMSProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getStreamType() {
        return this.streamType;
    }

    @Override
    public void setStreamType(String string) {
        this.streamType = string;
    }

    @Override
    public boolean isAcceptConnection() {
        return this.acceptConnection;
    }

    @Override
    @NoMBean
    public void setAcceptConnection(boolean bl) {
        this.acceptConnection = bl;
    }

    @Override
    @NoMBean
    public void acceptConnection() {
        this.acceptConnection((AMFData)null);
    }

    @Override
    @NoMBean
    public void acceptConnection(String string) {
        this.acceptConnection(new AMFDataItem(string));
    }

    @Override
    @NoMBean
    public void acceptConnection(AMFData aMFData) {
        this.acceptConnection = true;
        this.acceptConnectionObj = aMFData;
    }

    @Override
    @NoMBean
    public void rejectConnection() {
        this.rejectConnection(null, (AMFData)null);
    }

    @Override
    @NoMBean
    public void rejectConnection(String string) {
        this.rejectConnection(null, new AMFDataItem(string));
    }

    @Override
    @NoMBean
    public void rejectConnection(AMFData aMFData) {
        this.rejectConnection(null, aMFData);
    }

    @Override
    @NoMBean
    public void rejectConnection(String string, String string2) {
        this.rejectConnection(string, new AMFDataItem(string2));
    }

    @Override
    @NoMBean
    public void rejectConnection(String string, AMFData aMFData) {
        this.acceptConnection = false;
        if (aMFData != null) {
            this.acceptConnectionObj = aMFData;
        }
        if (string != null) {
            this.acceptConnectionDescription = string;
        }
    }

    @Override
    @NoMBean
    public void redirectConnection(String string) {
        this.redirectConnection(string, null, (AMFData)null);
    }

    @Override
    @NoMBean
    public void redirectConnection(String string, String string2) {
        this.redirectConnection(string, string2, (AMFData)null);
    }

    @Override
    @NoMBean
    public void redirectConnection(String string, String string2, String string3) {
        this.redirectConnection(string, string2, new AMFDataItem(string3));
    }

    @Override
    @NoMBean
    public void redirectConnection(String string, String string2, AMFData aMFData) {
        this.acceptConnection = false;
        if (aMFData != null) {
            this.acceptConnectionObj = aMFData;
        }
        if (string2 != null) {
            this.acceptConnectionDescription = string2;
        }
        if (this.acceptConnectionExObj == null) {
            this.acceptConnectionExObj = new AMFDataObj();
        }
        this.acceptConnectionExObj.put("redirect", new AMFDataItem(string));
        this.acceptConnectionExObj.put("code", new AMFDataItem(302));
        this.acceptConnectionExIsRedirect = true;
    }

    @NoMBean
    public boolean isAcceptConnectionExIsRedirect() {
        return this.acceptConnectionExIsRedirect;
    }

    @Override
    @NoMBean
    public IVHost getVHost() {
        return this.vhost;
    }

    public int getLastStreamId() {
        return this.lastStreamId;
    }

    @NoMBean
    public void setLastStreamId(int n) {
        this.lastStreamId = n;
    }

    @Override
    @NoMBean
    public void call(String string, IModuleCallResult iModuleCallResult, Object ... objectArray) {
        AMFData[] aMFDataArray = AMFUtils.convertParams(objectArray);
        this.callInternal(string, iModuleCallResult, aMFDataArray);
    }

    @Override
    public void call(String string) {
        this.callInternal(string, null, null);
    }

    @NoMBean
    public void callInternal(String string, IModuleCallResult iModuleCallResult, AMFData[] aMFDataArray) {
        double d = 0.0;
        if (iModuleCallResult != null) {
            d = this.callResults.add(iModuleCallResult);
        }
        ResponseFunction responseFunction = new ResponseFunction(this);
        responseFunction.createDefaultMessage(string, d);
        responseFunction.setRetAMFNumber(4);
        responseFunction.setSrc(0);
        responseFunction.setTimecode(0L);
        if (aMFDataArray != null) {
            for (int i = 0; i < aMFDataArray.length; ++i) {
                responseFunction.addBody(aMFDataArray[i]);
            }
        }
        this.getRespFunctions().add(responseFunction);
    }

    @NoMBean
    public ClientCallResults getCallResults() {
        return this.callResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void registerStream(IMediaStream iMediaStream) {
        List<IMediaStream> list = this.streamList;
        synchronized (list) {
            this.streamList.add(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void unregisterStream(IMediaStream iMediaStream) {
        List<IMediaStream> list = this.streamList;
        synchronized (list) {
            this.streamList.remove(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOpenStream(IMediaStream iMediaStream) {
        if (iMediaStream == null) {
            return;
        }
        MediaStreamMap mediaStreamMap = iMediaStream.getStreams();
        if (mediaStreamMap == null) {
            return;
        }
        IMediaStream iMediaStream2 = iMediaStream;
        synchronized (iMediaStream2) {
            if (iMediaStream.isOpen()) {
                iMediaStream.close();
                if (!iMediaStream.isPlay()) {
                    ResponseFunction responseFunction;
                    AMFDataObj aMFDataObj = null;
                    double d = this.getClientId();
                    ResponseFunctions responseFunctions = this.getRespFunctions();
                    if (iMediaStream.isSendRecordStopLogEvent()) {
                        responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
                        responseFunction.createDefaultMessage("onStatus", 0.0);
                        responseFunction.setSrc(iMediaStream.getSrc());
                        aMFDataObj = new AMFDataObj();
                        aMFDataObj.put("level", new AMFDataItem("status"));
                        aMFDataObj.put("code", new AMFDataItem("NetStream.Record.Stop"));
                        aMFDataObj.put("description", new AMFDataItem("Stopped recording " + iMediaStream.getName() + "."));
                        aMFDataObj.put("clientid", new AMFDataItem(d));
                        responseFunction.addBody(aMFDataObj);
                        responseFunctions.add(responseFunction);
                        iMediaStream.setSendRecordStopLogEvent(false);
                    }
                    if (iMediaStream.isSendPublishStopLogEvent()) {
                        responseFunction = new ResponseFunction(iMediaStream.getClient(), iMediaStream.getRespAMFDataObj());
                        responseFunction.createDefaultMessage("onStatus", 0.0);
                        responseFunction.setSrc(iMediaStream.getSrc());
                        aMFDataObj = new AMFDataObj();
                        aMFDataObj.put("level", new AMFDataItem("status"));
                        aMFDataObj.put("code", new AMFDataItem("NetStream.Unpublish.Success"));
                        aMFDataObj.put("description", new AMFDataItem(iMediaStream.getName() + " is now unpublished."));
                        aMFDataObj.put("clientid", new AMFDataItem(d));
                        responseFunction.addBody(aMFDataObj);
                        responseFunctions.add(responseFunction);
                        mediaStreamMap.notifyPlayUnpublish(iMediaStream);
                        iMediaStream.setSendPublishStopLogEvent(false);
                    }
                    iMediaStream.publish();
                    iMediaStream.stopPublishing();
                } else {
                    IApplicationInstance iApplicationInstance = this.getAppInstance();
                    if (iApplicationInstance != null) {
                        iApplicationInstance.removePlayStreamByName(iMediaStream);
                    }
                }
                if (iMediaStream.isPlay()) {
                    if (iMediaStream.isSendPlayStopLogEvent()) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "stop", 200, iMediaStream.getName());
                        iMediaStream.setSendPlayStopLogEvent(false);
                        iMediaStream.notifyActionStop();
                        iMediaStream.sendPlayStop(0L, iMediaStream.getName());
                    }
                } else {
                    mediaStreamMap.clearStreamName(iMediaStream.getName(), iMediaStream);
                    if (iMediaStream.isRecord()) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "recordstop", 200, iMediaStream.getName());
                    }
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, iMediaStream, "stream", "unpublish", 200, iMediaStream.getName());
                    iMediaStream.notifyActionUnPublish(iMediaStream.getName(), iMediaStream.isRecord(), iMediaStream.isAppend());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void removeOpenStreams() {
        ArrayList<IMediaStream> arrayList = new ArrayList<IMediaStream>();
        List<IMediaStream> list = this.streamList;
        synchronized (list) {
            arrayList.addAll(this.streamList);
        }
        for (IMediaStream iMediaStream : arrayList) {
            if (iMediaStream == null) continue;
            this.closeOpenStream(iMediaStream);
            if (this.appInstance == null) continue;
            this.appInstance.getStreams().removeStream(this, iMediaStream.getSrc());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void registerSharedObject(ISharedObject iSharedObject) {
        List<ISharedObject> list = this.sharedObjects;
        synchronized (list) {
            if (!this.sharedObjects.contains(iSharedObject)) {
                this.sharedObjects.add(iSharedObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void unregisterSharedObject(ISharedObject iSharedObject) {
        List<ISharedObject> list = this.sharedObjects;
        synchronized (list) {
            if (this.sharedObjects.contains(iSharedObject)) {
                this.sharedObjects.remove(iSharedObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSharedObjects() {
        ArrayList<ISharedObject> arrayList = new ArrayList<ISharedObject>();
        List<ISharedObject> list = this.sharedObjects;
        synchronized (list) {
            arrayList.addAll(this.sharedObjects);
        }
        for (ISharedObject iSharedObject : arrayList) {
            iSharedObject.removeClient(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void getSharedObjectUpdates() {
        List<ISharedObject> list = this.sharedObjects;
        synchronized (list) {
            for (SharedObject sharedObject : this.sharedObjects) {
                sharedObject.getClientUpdates(this);
            }
        }
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    @Override
    @NoMBean
    public FastPlaySettings getFastPlaySettings() {
        return this.fastPlaySettings;
    }

    @Override
    @NoMBean
    public void setFastPlaySettings(FastPlaySettings fastPlaySettings) {
        this.fastPlaySettings = fastPlaySettings;
    }

    @Override
    @NoMBean
    public void clearFastPlaySettings() {
        this.fastPlaySettings = null;
    }

    @NoMBean
    public void updateLoggingDuration() {
        WMSLoggerFactory.putGlobalLogValue("x-duration", new Double((double)this.elapsedTime.getTime() / 1000.0));
    }

    @NoMBean
    public void clearLoggingValues() {
        WMSLoggerFactory.removeGlobalLogValue("c-ip");
        WMSLoggerFactory.removeGlobalLogValue("c-proto");
        WMSLoggerFactory.removeGlobalLogValue("s-uri");
        WMSLoggerFactory.removeGlobalLogValue("cs-uri-stem");
        WMSLoggerFactory.removeGlobalLogValue("cs-uri-query");
        WMSLoggerFactory.removeGlobalLogValue("c-referrer");
        WMSLoggerFactory.removeGlobalLogValue("c-user-agent");
        WMSLoggerFactory.removeGlobalLogValue("c-client-id");
        WMSLoggerFactory.removeGlobalLogValue("s-ip");
        WMSLoggerFactory.removeGlobalLogValue("s-port");
        WMSLoggerFactory.removeGlobalLogValue("sc-bytes");
        WMSLoggerFactory.removeGlobalLogValue("cs-bytes");
    }

    @NoMBean
    public void updateLoggingValues() {
        String string;
        if (this.appInstance != null) {
            WMSLoggerFactory.putGlobalLogValue("x-app", this.appInstance.getApplication().getName());
            WMSLoggerFactory.putGlobalLogValue("x-appinst", this.appInstance.getName());
        }
        WMSLoggerFactory.putGlobalLogValue("x-vhost", this.getVHost().getName());
        WMSLoggerFactory.putGlobalLogValue("c-ip", this.getIp());
        if (this.protocol == 3) {
            WMSLoggerFactory.putGlobalLogValue("c-proto", this.isSSL ? "rtmpts (HTTP-1.1)" : (this.isEncrypted ? "rtmpte (HTTP-1.1)" : "rtmpt (HTTP-1.1)"));
        } else {
            WMSLoggerFactory.putGlobalLogValue("c-proto", this.isSSL ? "rtmps" : (this.isEncrypted ? "rtmpe" : "rtmp"));
        }
        String string2 = this.getUri();
        String string3 = this.getQueryStr();
        if (string3.length() > 0) {
            string2 = string2 + "?" + string3;
        }
        if ((string = this.getReferrer()) == null) {
            string = "";
        }
        string.replace("|", "%7c");
        WMSLoggerFactory.putGlobalLogValue("s-uri", string2);
        WMSLoggerFactory.putGlobalLogValue("cs-uri-stem", this.getUri());
        WMSLoggerFactory.putGlobalLogValue("cs-uri-query", string3);
        WMSLoggerFactory.putGlobalLogValue("c-referrer", string);
        WMSLoggerFactory.putGlobalLogValue("c-user-agent", this.getFlashVer());
        WMSLoggerFactory.putGlobalLogValue("c-client-id", new Integer(this.getClientId()));
        WMSLoggerFactory.putGlobalLogValue("s-ip", this.getServerHostPort() == null ? null : this.getServerHostPort().getAddressStr());
        WMSLoggerFactory.putGlobalLogValue("s-port", this.getServerHostPort() == null ? null : new Integer(this.getServerHostPort().getPort()));
        WMSLoggerFactory.putGlobalLogValue("sc-bytes", new Long(this.totalIOPerformance.getMessagesOutBytes()));
        WMSLoggerFactory.putGlobalLogValue("cs-bytes", new Long(this.totalIOPerformance.getMessagesInBytes()));
    }

    @NoMBean
    public void setThreadContext() {
        if (Thread.currentThread() instanceof VHostWorkerThread) {
            ((VHostWorkerThread)Thread.currentThread()).setClient(this);
        }
    }

    @Override
    @NoMBean
    public int ping(IModulePingResult iModulePingResult) {
        long l = System.currentTimeMillis() - this.connectTime;
        int n = (int)(l % 0x100000000L & 0xFFFFFFFFL);
        while (this.pingResults.exists(n)) {
            n = (int)(++l % 0x100000000L & 0xFFFFFFFFL);
        }
        ResponseFunction responseFunction = new ResponseFunction(this);
        byte[] byArray = new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 6, (byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 0)};
        responseFunction.addBytes(byArray);
        this.getRespFunctions().add(responseFunction);
        this.pingResults.add(l, n, iModulePingResult);
        return n;
    }

    @NoMBean
    public void handlePingResult(int n, boolean bl) {
        long l = this.pingResults.handleResult(this, n, bl);
    }

    @NoMBean
    public void checkPingTimeout() {
        long l;
        long l2 = l = this.ioSession == null ? 0L : this.ioSession.getMessageBytesWaiting();
        if (l == 0L) {
            long l3 = System.currentTimeMillis() - this.connectTime;
            this.pingResults.checkPingTimeout(this, l3);
        }
    }

    @Override
    public long getLastValidateTime() {
        return this.lastValidateTime;
    }

    @Override
    public void setLastValidateTime(long l) {
        this.lastValidateTime = l;
    }

    public boolean isValidatingConnection() {
        return this.isValidatingConnection;
    }

    @NoMBean
    public void setValidatingConnection(boolean bl) {
        this.isValidatingConnection = bl;
    }

    public boolean isShutdownClient() {
        return this.shutdownClient;
    }

    @Override
    public void setShutdownClient(boolean bl) {
        this.shutdownClient = bl;
        if (bl) {
            this.doIdle();
        }
    }

    @Override
    public long getConnectTime() {
        return this.connectTime;
    }

    @Override
    public long getPingRoundTripTime() {
        return this.pingRoundTripTime;
    }

    public void setPingRoundTripTime(long l) {
        this.pingRoundTripTime = l;
    }

    @NoMBean
    public void setCallResultsStartIndex(int n) {
        this.callResults.setResultIndex(n);
    }

    @NoMBean
    public ConnectionHolder getConnectionHolder() {
        return this.connectionHolder;
    }

    @Override
    public String getDateStarted() {
        return this.elapsedTime.getDateString();
    }

    @Override
    public String getTimeRunning() {
        return this.elapsedTime.getTimeString();
    }

    @Override
    public double getTimeRunningSeconds() {
        return this.elapsedTime.getTimeSeconds();
    }

    @Override
    public File getStreamFile(String string) {
        return this.getStreamFile(string, "flv", false);
    }

    @Override
    public File getStreamFile(String string, String string2) {
        return this.getStreamFile(string, string2, false);
    }

    @Override
    public File getStreamFile(String string, String string2, boolean bl) {
        String string3;
        String string4 = string.replace("\\", "/");
        String[] stringArray = string4.split("[/]");
        if (bl && stringArray.length > 1) {
            string3 = this.getAppInstance().getStreamStoragePath();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                File file = new File(string3 = string3 + File.separatorChar + stringArray[i]);
                if (file.exists()) continue;
                try {
                    file.mkdir();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        string3 = this.getAppInstance().getStreamStoragePath() + File.separatorChar + string4 + "." + string2;
        return new File(string3);
    }

    @Override
    public int getBufferTime() {
        return this.bufferTime;
    }

    @Override
    public void setBufferTime(int n) {
        this.bufferTime = n;
    }

    @Override
    @NoMBean
    public AMFObj getResponseAMFObj(int n) {
        return this.respAMFObjs.get(n);
    }

    @Override
    public String getQueryStr() {
        return this.queryStr;
    }

    public void setQueryStr(String string) {
        this.queryStr = string;
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String string) {
        this.referrer = string;
    }

    @Override
    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String string) {
        this.pageUrl = string;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    @Override
    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int n) {
        this.protocol = n;
    }

    @Override
    @NoMBean
    public HostPort getServerHostPort() {
        return this.serverHostPort;
    }

    @NoMBean
    public void setServerHostPort(HostPort hostPort) {
        this.serverHostPort = hostPort;
    }

    @Override
    public boolean isSecure() {
        return this.isSSL || this.isEncrypted;
    }

    @Override
    public boolean isSSL() {
        return this.isSSL;
    }

    public void setSSL(boolean bl) {
        this.isSSL = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImmediateIdle() {
        Object object = this.immediateIdleLock;
        synchronized (object) {
            return this.immediateIdle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImmediateIdle(boolean bl) {
        Object object = this.immediateIdleLock;
        synchronized (object) {
            this.immediateIdle = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public boolean clearImmediateIdle() {
        boolean bl = false;
        Object object = this.immediateIdleLock;
        synchronized (object) {
            bl = this.immediateIdle;
            this.immediateIdle = false;
        }
        return bl;
    }

    @NoMBean
    public IoSession getIoSession() {
        return this.ioSession;
    }

    @NoMBean
    public void setIoSession(IoSession ioSession) {
        this.ioSession = ioSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void doIdle() {
        IoSession ioSession = this.ioSession;
        if (ioSession != null) {
            this.touch();
            RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
            boolean bl = false;
            if (rtmpSessionInfo != null) {
                IoSession ioSession2 = ioSession;
                synchronized (ioSession2) {
                    if (rtmpSessionInfo.getInHandler() > 0) {
                        rtmpSessionInfo.addMessageQueue(null);
                    } else {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                ioSession.getFilterChain().fireSessionIdle(ioSession, IdleStatus.BOTH_IDLE);
            }
            ((BaseIoSession)ioSession).increaseIdleCount(IdleStatus.BOTH_IDLE);
            this.touch();
        }
    }

    @Override
    public int getIdleFrequency() {
        return this.idleFrequency;
    }

    @Override
    public void setIdleFrequency(int n) {
        this.idleFrequency = n;
    }

    @Override
    public String getSharedObjectReadAccess() {
        return this.sharedObjectReadAccess;
    }

    @Override
    public void setSharedObjectReadAccess(String string) {
        this.sharedObjectReadAccess = string;
    }

    @Override
    public String getSharedObjectWriteAccess() {
        return this.sharedObjectWriteAccess;
    }

    @Override
    public void setSharedObjectWriteAccess(String string) {
        this.sharedObjectWriteAccess = string;
    }

    @Override
    public String getStreamVideoSampleAccess() {
        return this.streamVideoSampleAccess;
    }

    @Override
    public void setStreamVideoSampleAccess(String string) {
        this.streamVideoSampleAccess = string;
    }

    @Override
    public String getStreamAudioSampleAccess() {
        return this.streamAudioSampleAccess;
    }

    @Override
    public void setStreamAudioSampleAccess(String string) {
        this.streamAudioSampleAccess = string;
    }

    @Override
    public String getStreamReadAccess() {
        return this.streamReadAccess;
    }

    @Override
    public void setStreamReadAccess(String string) {
        this.streamReadAccess = string;
    }

    @Override
    public String getStreamWriteAccess() {
        return this.streamWriteAccess;
    }

    @Override
    public void setStreamWriteAccess(String string) {
        this.streamWriteAccess = string;
    }

    @Override
    @NoMBean
    public ClientWriteListener getWriteListener() {
        return this.writeListener;
    }

    @Override
    @NoMBean
    public void addAcceptConnectionAttribute(String string, AMFDataObj aMFDataObj) {
        this.acceptConnectionAttributes.put(string, aMFDataObj);
    }

    @Override
    @NoMBean
    public void addAcceptConnectionAttribute(String string, String string2) {
        this.acceptConnectionAttributes.put(string, new AMFDataItem(string2));
    }

    public Map getAcceptConnectionAttributes() {
        return this.acceptConnectionAttributes;
    }

    public long getTimebase() {
        return this.timebase;
    }

    public void setTimebase(long l) {
        this.timebase = l;
    }

    public void incWaitingForIOCount() {
        ++this.waitingForIOCount;
    }

    public void decWaitingForIOCount() {
        --this.waitingForIOCount;
    }

    public boolean isWaitingForIO() {
        return this.waitingForIOCount != 0;
    }

    @Override
    public String getRepeaterOriginUrl() {
        String string = this.repeaterOriginUrl;
        if (string == null && this.appInstance != null) {
            string = this.appInstance.getRepeaterOriginUrl();
        }
        return string;
    }

    @Override
    public void setRepeaterOriginUrl(String string) {
        this.repeaterOriginUrl = string;
    }

    @Override
    public int getPingTimeout() {
        if (this.appInstance != null) {
            return this.appInstance.getPingTimeout();
        }
        if (this.vhost != null) {
            return this.vhost.getPingTimeout();
        }
        return 12000;
    }

    public int getValidationFrequency() {
        if (this.appInstance != null) {
            return this.appInstance.getValidationFrequency();
        }
        if (this.vhost != null) {
            return this.vhost.getValidationFrequency();
        }
        return 8000;
    }

    @Override
    public int getMaximumPendingWriteBytes() {
        if (this.appInstance != null) {
            return this.appInstance.getMaximumPendingWriteBytes();
        }
        if (this.vhost != null) {
            return this.vhost.getMaximumPendingWriteBytes();
        }
        return 0;
    }

    @Override
    public int getMaximumSetBufferTime() {
        if (this.appInstance != null) {
            return this.appInstance.getMaximumSetBufferTime();
        }
        if (this.vhost != null) {
            return this.vhost.getMaximumSetBufferTime();
        }
        return 0;
    }

    @Override
    public boolean isLiveRepeater() {
        if (this.isLiveRepeater == 0) {
            this.isLiveRepeater = this.referrer.equals("WowzaProLiveRepeater") ? 1 : -1;
        }
        return this.isLiveRepeater > 0;
    }

    @Override
    public boolean isFlashVersionH264Capable() {
        if (this.isFlashVerH264 == 0) {
            int[] nArray = new int[]{9, 0, 45, 0};
            this.isFlashVerH264 = this.testFlashVersion(nArray);
            if (this.isFlashVerH264 == 0) {
                this.isFlashVerH264 = 1;
            }
        }
        return this.isFlashVerH264 > 0;
    }

    @Override
    public boolean isFlashVersion90115() {
        if (this.isFlashVer90115 == 0) {
            int[] nArray = new int[]{9, 0, 115, 0};
            this.isFlashVer90115 = this.testFlashVersion(nArray);
            if (this.isFlashVer90115 == 0) {
                this.isFlashVer90115 = 1;
            }
        }
        return this.isFlashVer90115 > 0;
    }

    @Override
    public boolean isFlashVersion10() {
        if (this.isFlashVer10 == 0) {
            int[] nArray = new int[]{10, 0, 0, 0};
            this.isFlashVer10 = this.testFlashVersion(nArray);
            if (this.isFlashVer10 == 0) {
                this.isFlashVer10 = 1;
            }
        }
        return this.isFlashVer10 > 0;
    }

    @Override
    public boolean isFlashMediaLiveEncoder() {
        String string;
        if (this.isFMLE == 0 && (string = this.getFlashVer()) != null) {
            this.isFMLE = string.startsWith("FME/") || string.startsWith("FMLE/") ? 1 : -1;
        }
        return this.isFMLE > 0;
    }

    @Override
    public int testFlashVersion(int[] nArray) {
        String string;
        String[] stringArray;
        int n = -1;
        String string2 = this.getFlashVer();
        if (string2 != null && (string2 = string2.trim()).length() > 0 && (stringArray = string2.split(" ")).length >= 2 && (string = stringArray[1].trim()).length() > 0) {
            String[] stringArray2 = string.split("[,]");
            n = 0;
            for (int i = 0; i < Math.min(nArray.length, stringArray2.length); ++i) {
                try {
                    int n2 = Integer.parseInt(stringArray2[i]);
                    if (n2 < nArray[i]) {
                        n = -1;
                        break;
                    }
                    if (n2 <= nArray[i]) continue;
                    n = 1;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    @Override
    public boolean isObjectEncodingAMF3() {
        return this.objectEncoding != 0;
    }

    @Override
    public boolean isObjectEncodingAMF0() {
        return this.objectEncoding == 0;
    }

    @Override
    public void setObjectEncoding(int n) {
        this.objectEncoding = n;
        this.statusAMFObj.setObjectEncoding(n);
        for (AMFObj aMFObj : this.respAMFObjs) {
            if (aMFObj == null) continue;
            aMFObj.setObjectEncoding(n);
        }
    }

    @Override
    public int getObjectEncoding() {
        return this.objectEncoding;
    }

    @Override
    public RTPStream getRTPStream() {
        return this.rtpStream.get();
    }

    public void setRTPStream(RTPStream rTPStream) {
        this.rtpStream.set(rTPStream);
    }

    public IRTMPEncrypt getRTMPEncryptHandlerIn() {
        return this.rtmpEncryptHandlerIn;
    }

    public void setRTMPEncryptHandlerIn(IRTMPEncrypt iRTMPEncrypt) {
        this.rtmpEncryptHandlerIn = iRTMPEncrypt;
    }

    public IRTMPEncrypt getRTMPEncryptHandlerOut() {
        return this.rtmpEncryptHandlerOut;
    }

    public void setRTMPEncryptHandlerOut(IRTMPEncrypt iRTMPEncrypt) {
        this.rtmpEncryptHandlerOut = iRTMPEncrypt;
    }

    @Override
    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean bl) {
        this.isEncrypted = bl;
    }

    public long getLastPingWriteId() {
        return this.lastPingWriteId;
    }

    public void setLastPingWriteId(long l) {
        this.lastPingWriteId = l;
    }

    @NoMBean
    public AMFData getAcceptConnectionObj() {
        return this.acceptConnectionObj;
    }

    @Override
    @NoMBean
    public void setAcceptConnectionObj(AMFData aMFData) {
        this.acceptConnectionObj = aMFData;
    }

    @NoMBean
    public AMFDataObj getAcceptConnectionExObj() {
        return this.acceptConnectionExObj;
    }

    @Override
    @NoMBean
    public void setAcceptConnectionExObj(AMFDataObj aMFDataObj) {
        this.acceptConnectionExObj = aMFDataObj;
    }

    public String getAcceptConnectionDescription() {
        return this.acceptConnectionDescription;
    }

    @Override
    public void setAcceptConnectionDescription(String string) {
        this.acceptConnectionDescription = string;
    }

    @Override
    public String getLiveStreamPacketizerList() {
        return this.liveStreamPacketizerList;
    }

    @Override
    public void setLiveStreamPacketizerList(String string) {
        this.liveStreamPacketizerList = string;
    }

    @Override
    public String getLiveStreamTranscoderList() {
        return this.liveStreamTranscoderList;
    }

    @Override
    public void setLiveStreamTranscoderList(String string) {
        this.liveStreamTranscoderList = string;
    }

    @Override
    public ElapsedTimer getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public int getLiveRepeaterCapabilities() {
        return this.liveRepeaterCapabilities;
    }

    @Override
    public void setLiveRepeaterCapabilities(int n) {
        this.liveRepeaterCapabilities = n;
    }

    @Override
    public void fcSubscribe(String string) {
        this.fcSubscribe(string, null);
    }

    @Override
    public void fcSubscribe(String string, String string2) {
        String string3 = "default";
        String string4 = this.getStreamType();
        if (string4 != null) {
            string3 = string4;
        }
        boolean bl = false;
        StreamList streamList = this.appInstance.getVHost().getStreamTypes();
        StreamItem streamItem = streamList.getStreamDef(string3);
        if (streamItem != null) {
            if (string2 == null) {
                string2 = streamItem.getProperties().getPropertyStr("mediaCasterType", string2);
                string2 = this.appInstance.getStreamProperties().getPropertyStr("mediaCasterType", string2);
            }
            bl = streamItem.getProperties().getPropertyBoolean("isLiveRepeaterEdge", bl);
        }
        this.fcSubscribe(string, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fcSubscribe(String string, String string2, boolean bl) {
        Object object;
        Object object2;
        if (bl) {
            string = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)this.appInstance, (IClient)this, (String)string);
        }
        MediaCasterStreamItem mediaCasterStreamItem = null;
        if (string2 != null) {
            object2 = this.appInstance.getMediaCasterStreams();
            object = ((MediaCasterStreamMap)object2).getLock();
            object.writeLock().lock();
            try {
                MediaCasterList mediaCasterList = this.vhost.getMediaCasterList();
                MediaCasterItem mediaCasterItem = mediaCasterList.getMediaCasterDef(string2);
                if (mediaCasterItem == null) {
                } else {
                    mediaCasterStreamItem = ((MediaCasterStreamMap)object2).acquire(string, mediaCasterItem);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(Client.class).error("Client.fcSubscribe: " + exception.toString());
            }
            finally {
                object.writeLock().unlock();
            }
        }
        if (mediaCasterStreamItem != null) {
            object2 = this.fcSubcripeLock;
            synchronized (object2) {
                if (this.fcSubcripes == null) {
                    this.fcSubcripes = new HashMap<String, FCSubscribeHolder>();
                }
                if ((object = this.fcSubcripes.get(string)) == null) {
                    object = new FCSubscribeHolder();
                    ((FCSubscribeHolder)object).streamName = string;
                    ((FCSubscribeHolder)object).mediaCasterType = string2;
                    this.fcSubcripes.put(((FCSubscribeHolder)object).streamName, (FCSubscribeHolder)object);
                }
                ++((FCSubscribeHolder)object).count;
                ((FCSubscribeHolder)object).streamItems.add(mediaCasterStreamItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fcUnSubscribeAll() {
        ArrayList<MediaCasterStreamItem> arrayList = new ArrayList<MediaCasterStreamItem>();
        Object object = this.fcSubcripeLock;
        synchronized (object) {
            if (this.fcSubcripes != null) {
                for (FCSubscribeHolder object2 : this.fcSubcripes.values()) {
                    arrayList.addAll(object2.streamItems);
                    object2.streamItems.clear();
                }
                this.fcSubcripes.clear();
            }
        }
        if (arrayList.size() > 0) {
            object = this.appInstance.getMediaCasterStreams();
            WMSReadWriteLock wMSReadWriteLock = ((MediaCasterStreamMap)object).getLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                for (MediaCasterStreamItem mediaCasterStreamItem : arrayList) {
                    mediaCasterStreamItem.release();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(Client.class).error("Client.fcUnSubscribeAll: " + exception.toString());
                exception.printStackTrace();
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
        }
    }

    @Override
    public void fcUnSubscribe(String string) {
        String string2 = "default";
        String string3 = this.getStreamType();
        if (string3 != null) {
            string2 = string3;
        }
        boolean bl = false;
        StreamList streamList = this.appInstance.getVHost().getStreamTypes();
        StreamItem streamItem = streamList.getStreamDef(string2);
        if (streamItem != null) {
            bl = streamItem.getProperties().getPropertyBoolean("isLiveRepeaterEdge", bl);
        }
        this.fcUnSubscribe(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fcUnSubscribe(String string, boolean bl) {
        Object object;
        if (bl) {
            string = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)this.appInstance, (IClient)this, (String)string);
        }
        MediaCasterStreamItem mediaCasterStreamItem = null;
        Object object2 = this.fcSubcripeLock;
        synchronized (object2) {
            if (this.fcSubcripes != null && (object = this.fcSubcripes.get(string)) != null) {
                --((FCSubscribeHolder)object).count;
                if (((FCSubscribeHolder)object).streamItems.size() > 0) {
                    mediaCasterStreamItem = ((FCSubscribeHolder)object).streamItems.remove(0);
                }
            }
        }
        if (mediaCasterStreamItem != null) {
            object2 = this.appInstance.getMediaCasterStreams();
            object = ((MediaCasterStreamMap)object2).getLock();
            object.writeLock().lock();
            try {
                mediaCasterStreamItem.release();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(Client.class).error("Client.fcUnSubscribe: " + exception.toString());
            }
            finally {
                object.writeLock().unlock();
            }
        }
    }

    public Map<Long, IMediaStream> getStreamCache() {
        return this.streamCache;
    }

    @Override
    public boolean isValidateFMLEConnections() {
        return this.validateFMLEConnections;
    }

    @Override
    public void setValidateFMLEConnections(boolean bl) {
        this.validateFMLEConnections = bl;
    }

    class FCSubscribeHolder {
        String streamName = null;
        String mediaCasterType = null;
        int count = 0;
        List<MediaCasterStreamItem> streamItems = new ArrayList<MediaCasterStreamItem>();

        FCSubscribeHolder() {
        }
    }
}

