/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.util;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerAdapter;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPStreamerUtils {
    public static final String KEYFILEEXTENSION = ".key";

    public static byte[] keyFileStrToBytes(String string) {
        byte[] byArray = null;
        if (string != null && (string = string.trim()).length() > 0) {
            try {
                byArray = string.startsWith("0x") ? BufferUtils.decodeHexString(string.substring(2)) : Base64.decode(string);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerUtils.class).error("HTTPStreamerUtils.keyFileStrToBytes[" + string + "]: " + exception.toString());
            }
        }
        return byArray;
    }

    public static Map<String, String> parseEncryptionKeyFile(File file) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if ((string = string.trim()).startsWith("#") || (n = string.indexOf(":")) < 0) continue;
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1).trim();
                hashMap.put(string2.toLowerCase(), string3);
            }
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerUtils.class).error("HTTPStreamerUtils.parseEncryptionKeyFile: " + exception.toString());
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            bufferedReader = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    public static IHTTPStreamerAdapter pathToAdapter(IVHost iVHost, HostPort hostPort, String string) {
        List<String> list;
        IHTTPStreamerAdapter iHTTPStreamerAdapter = null;
        if (hostPort != null && (list = hostPort.getHTTPStreamerAdapterIDs()) != null && iVHost != null) {
            for (String string2 : list) {
                boolean bl;
                IHTTPStreamerAdapter iHTTPStreamerAdapter2 = iVHost.getHTTPStreamerAdapter(string2);
                if (iHTTPStreamerAdapter2 == null || !(bl = iHTTPStreamerAdapter2.canHandle(string))) continue;
                iHTTPStreamerAdapter = iHTTPStreamerAdapter2;
                break;
            }
        }
        return iHTTPStreamerAdapter;
    }

    public static String urlDecode(String string) {
        String string2 = string;
        try {
            String string3 = null;
            int n = string2.indexOf("?");
            if (n >= 0) {
                string3 = string2.substring(n);
                string2 = string2.substring(0, n);
            }
            string2 = URLDecoder.decode(string2, "UTF-8");
            if (string3 != null) {
                string2 = string2 + string3;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerUtils.class).error("HTTPStreamerUtils.urlDecode[" + string + "]: " + exception.toString());
        }
        return string2;
    }

    public static String urlEncode(String string) {
        String string2 = string;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
            string2 = string2.replace("%2f", "/").replace("%2F", "/");
            string2 = string2.replace("%3a", ":").replace("%3A", ":");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPStreamerUtils.class).error("HTTPStreamerUtils.urlEncode[" + string + "]: " + exception.toString());
        }
        return string2;
    }
}

