/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.mp3.model.idtags;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameAttachedPicture;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameComment;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameLinkedInformation;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FramePrivate;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameRawBytes;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameRecommendedBufferSize;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameSynchronizedText;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameTextInformation;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameURLLink;
import com.wowza.wms.media.mp3.model.idtags.ID3V2Utils;
import com.wowza.wms.media.mp3.model.idtags.IID3V2Frame;

public abstract class ID3V2FrameBase
implements IID3V2Frame {
    public static final int HEADERSIZE = 10;
    public static final int TEXTENCODING_ISO_8859_1 = 0;
    public static final int TEXTENCODING_UTF16 = 1;
    public static final int TEXTENCODING_UTF16BE = 2;
    public static final int TEXTENCODING_UTF8 = 3;
    public static final String TAG_UNKN = "UNKN";
    public static final String TAG_PRIV = "PRIV";
    public static final String TAG_APIC = "APIC";
    public static final String TAG_LINK = "LINK";
    public static final String TAG_SYLT = "SYLT";
    public static final String TAG_RBUF = "RBUF";
    public static final String TAG_TALB = "TALB";
    public static final String TAG_TBPM = "TBPM";
    public static final String TAG_TCOM = "TCOM";
    public static final String TAG_TCON = "TCON";
    public static final String TAG_TCOP = "TCOP";
    public static final String TAG_TDEN = "TDEN";
    public static final String TAG_TDLY = "TDLY";
    public static final String TAG_TDOR = "TDOR";
    public static final String TAG_TDRC = "TDRC";
    public static final String TAG_TDRL = "TDRL";
    public static final String TAG_TDTG = "TDTG";
    public static final String TAG_TENC = "TENC";
    public static final String TAG_TEXT = "TEXT";
    public static final String TAG_TFLT = "TFLT";
    public static final String TAG_TIPL = "TIPL";
    public static final String TAG_TIT1 = "TIT1";
    public static final String TAG_TIT2 = "TIT2";
    public static final String TAG_TIT3 = "TIT3";
    public static final String TAG_TKEY = "TKEY";
    public static final String TAG_TLAN = "TLAN";
    public static final String TAG_TLEN = "TLEN";
    public static final String TAG_TMCL = "TMCL";
    public static final String TAG_TMED = "TMED";
    public static final String TAG_TMOO = "TMOO";
    public static final String TAG_TOAL = "TOAL";
    public static final String TAG_TOFN = "TOFN";
    public static final String TAG_TOLY = "TOLY";
    public static final String TAG_TOPE = "TOPE";
    public static final String TAG_TOWN = "TOWN";
    public static final String TAG_TPE1 = "TPE1";
    public static final String TAG_TPE2 = "TPE2";
    public static final String TAG_TPE3 = "TPE3";
    public static final String TAG_TPE4 = "TPE4";
    public static final String TAG_TPOS = "TPOS";
    public static final String TAG_TPRO = "TPRO";
    public static final String TAG_TPUB = "TPUB";
    public static final String TAG_TRCK = "TRCK";
    public static final String TAG_TRSN = "TRSN";
    public static final String TAG_TRSO = "TRSO";
    public static final String TAG_TSOA = "TSOA";
    public static final String TAG_TSOP = "TSOP";
    public static final String TAG_TSOT = "TSOT";
    public static final String TAG_TSRC = "TSRC";
    public static final String TAG_TSSE = "TSSE";
    public static final String TAG_TSST = "TSST";
    public static final String TAG_WCOM = "WCOM";
    public static final String TAG_WCOP = "WCOP";
    public static final String TAG_WOAF = "WOAF";
    public static final String TAG_WOAR = "WOAR";
    public static final String TAG_WOAS = "WOAS";
    public static final String TAG_WORS = "WORS";
    public static final String TAG_WPAY = "WPAY";
    public static final String TAG_WPUB = "WPUB";
    public static final String TAG_TXXX = "TXXX";
    public static final String TAG_COMM = "COMM";
    public static final String TAG_WXXX = "WXXX";
    public static final int FLAGS_DEFAULT = 0;
    private String idStr = "UNKN";
    private int flags = 0;

    public ID3V2FrameBase(String string, int n) {
        this.idStr = string;
        this.flags = n;
    }

    public static int serializeStringLen(String string) {
        int n = string.length();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            n = byArray.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string == null ? 1 : n + 1;
    }

    public static String trimTrailingZero(String string) {
        byte[] byArray = new byte[1];
        if (string.endsWith(new String(byArray))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static int serializeString(String string, byte[] byArray, int n) {
        int n2 = 0;
        try {
            if (string == null) {
                byArray[n] = 0;
                ++n2;
            } else {
                if (string.length() > 0) {
                    byte[] byArray2 = string.getBytes("UTF-8");
                    System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                    n2 += byArray2.length;
                }
                byArray[n + n2] = 0;
                ++n2;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameBase.serializeString: " + exception.toString());
        }
        return n2;
    }

    public static String deserializeString(byte[] byArray, int n, int n2) {
        String string = null;
        int n3 = 0;
        boolean bl = false;
        while (n + n3 < n2) {
            if (byArray[n + n3] == 0) {
                bl = true;
                break;
            }
            ++n3;
        }
        if (bl) {
            string = BufferUtils.byteArrayToString(byArray, n, n3);
        }
        return string;
    }

    public static ID3V2FrameBase deserializeFrame(byte[] byArray, int n, int n2) {
        ID3V2FrameBase iD3V2FrameBase = null;
        try {
            if (n2 - n >= 10) {
                String string = BufferUtils.byteArrayToString(byArray, n, 4);
                int n3 = ID3V2Utils.byteArrayToIntSafeSync(byArray, n += 4, 4);
                int n4 = BufferUtils.byteArrayToInt(byArray, n += 4, 2);
                if (n2 - (n += 2) >= n3) {
                    if (string.equals(TAG_PRIV)) {
                        iD3V2FrameBase = new ID3V2FramePrivate(string, n4);
                        iD3V2FrameBase.deserializeBody(byArray, n, n + n3);
                    } else if (string.equals(TAG_APIC)) {
                        iD3V2FrameBase = new ID3V2FrameAttachedPicture(string, n4);
                        iD3V2FrameBase.deserializeBody(byArray, n, n + n3);
                    } else if (string.equals(TAG_LINK)) {
                        iD3V2FrameBase = new ID3V2FrameLinkedInformation(string, n4);
                        iD3V2FrameBase.deserializeBody(byArray, n, n + n3);
                    } else if (string.equals(TAG_SYLT)) {
                        iD3V2FrameBase = new ID3V2FrameSynchronizedText(string, n4);
                        iD3V2FrameBase.deserializeBody(byArray, n, n + n3);
                    } else if (string.equals(TAG_RBUF)) {
                        iD3V2FrameBase = new ID3V2FrameRecommendedBufferSize(string, n4);
                        iD3V2FrameBase.deserializeBody(byArray, n, n + n3);
                    } else if (string.equals(TAG_WXXX) || string.equals(TAG_TXXX) || string.equals(TAG_COMM)) {
                        iD3V2FrameBase = new ID3V2FrameComment(string, n4);
                        iD3V2FrameBase.deserializeBody(byArray, n, n + n3);
                    } else if (string.startsWith("T")) {
                        iD3V2FrameBase = new ID3V2FrameTextInformation(string, n4);
                        iD3V2FrameBase.deserializeBody(byArray, n, n + n3);
                    } else if (string.startsWith("W")) {
                        iD3V2FrameBase = new ID3V2FrameURLLink(string, n4);
                        iD3V2FrameBase.deserializeBody(byArray, n, n + n3);
                    } else {
                        iD3V2FrameBase = new ID3V2FrameRawBytes(string, n4);
                        iD3V2FrameBase.deserializeBody(byArray, n, n + n3);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameBase.deserializeFrame: " + exception.toString());
        }
        return iD3V2FrameBase;
    }

    public int serialize(byte[] byArray, int n) {
        int n2 = 0;
        try {
            byte[] byArray2 = new byte[4];
            byte[] byArray3 = this.idStr.getBytes();
            System.arraycopy(byArray3, 0, byArray2, 0, Math.min(byArray3.length, 4));
            System.arraycopy(byArray2, 0, byArray, n + n2, byArray2.length);
            int n3 = this.getBodySize();
            ID3V2Utils.intToByteArraySafeSync(n3, byArray, n + (n2 += byArray2.length), 4);
            BufferUtils.intToByteArray(this.flags, byArray, n + (n2 += 4), 2);
            n2 += 2;
            n2 += this.serializeBody(byArray, n + n2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameBase.serialize: " + exception.toString());
        }
        return n2;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public void setIdStr(String string) {
        this.idStr = string;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getSize() {
        return this.getBodySize() + 10;
    }

    public String getMapIdStr() {
        return this.getIdStr();
    }
}

