/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.mp3.model.idtags;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameBase;

public class ID3V2FrameTextInformation
extends ID3V2FrameBase {
    private int textEncoding = 3;
    private String value = null;
    protected boolean addTrailingZero = false;

    public ID3V2FrameTextInformation(String string, int n) {
        super(string, n);
    }

    public ID3V2FrameTextInformation(String string) {
        super(string, 0);
    }

    public int serializeBody(byte[] byArray, int n) {
        int n2 = 0;
        try {
            byArray[n + n2] = (byte)(this.textEncoding & 0xFF);
            ++n2;
            if (this.value != null) {
                byte[] byArray2 = this.value.getBytes("UTF-8");
                System.arraycopy(byArray2, 0, byArray, n + n2, byArray2.length);
                n2 += byArray2.length;
            }
            if (this.addTrailingZero) {
                byArray[n + n2] = 0;
                ++n2;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.serializeBody: " + exception.toString());
        }
        return n2;
    }

    public void deserializeBody(byte[] byArray, int n, int n2) {
        try {
            if (n + 1 < n2) {
                int n3;
                this.textEncoding = byArray[n] & 0xFF;
                if ((n3 = n2 - ++n) > 0) {
                    this.value = BufferUtils.byteArrayToString(byArray, n, n3);
                    n += n3;
                    this.value = ID3V2FrameTextInformation.trimTrailingZero(this.value);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.deserializeBody: " + exception.toString());
        }
    }

    public int getBodySize() {
        return 1 + (this.value == null ? 0 : this.value.length()) + (this.addTrailingZero ? 1 : 0);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public int getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(int n) {
        this.textEncoding = n;
    }
}

