/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.mp3.model.idtags;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameBase;

public class ID3V2FrameURLLink
extends ID3V2FrameBase {
    private int textEncoding = 3;
    private String url = null;

    public ID3V2FrameURLLink(String string, int n) {
        super(string, n);
    }

    public ID3V2FrameURLLink(String string) {
        super(string, 0);
    }

    public int serializeBody(byte[] byArray, int n) {
        int n2 = 0;
        try {
            if (this.url != null) {
                byte[] byArray2 = this.url.getBytes("UTF-8");
                System.arraycopy(byArray2, 0, byArray, n + n2, byArray2.length);
                n2 += byArray2.length;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.serializeBody: " + exception.toString());
        }
        return n2;
    }

    public void deserializeBody(byte[] byArray, int n, int n2) {
        try {
            int n3 = n2 - n;
            if (n3 > 0) {
                this.url = BufferUtils.byteArrayToString(byArray, n, n3);
                n += n3;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.deserializeBody: " + exception.toString());
        }
    }

    public int getBodySize() {
        return this.url == null ? 0 : this.url.length();
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public int getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(int n) {
        this.textEncoding = n;
    }
}

