/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.DebugUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerBase;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerQuicktimeH264;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketCodecConfigInfo;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.util.RTPUtils;

public abstract class RTPDePacketizerVideoBase
extends RTPDePacketizerBase {
    protected boolean isFirstPacket = true;

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
    }

    protected boolean isCodecConfig(RTPTrack rTPTrack) {
        return false;
    }

    protected byte[] getCodecConfig(RTPTrack rTPTrack) {
        return null;
    }

    protected void sendPacket(RTPTrack rTPTrack, RTPPacket rTPPacket, boolean bl) {
        try {
            byte[] byArray;
            RTPPacketCodecConfigInfo rTPPacketCodecConfigInfo;
            int n = rTPTrack.getTimescale();
            boolean bl2 = this.isCodecConfig(rTPTrack);
            boolean bl3 = this.rtcpHandler.isTimeSyncReady(rTPTrack, rTPPacket.getTimecode());
            if (rTPPacket.getCodec() == 7 && !bl2 && (rTPPacketCodecConfigInfo = rTPPacket.getH264CodecConfigInfo(rTPTrack)) != null) {
                byte[] byArray2 = rTPTrack.getProfileLevelIdBytes();
                byArray = RTPUtils.formatH264CodecConfig(rTPPacketCodecConfigInfo.sps, rTPPacketCodecConfigInfo.ppss, byArray2);
                rTPTrack.setCodecConfig(byArray);
                bl2 = true;
            }
            if (!bl3 && !bl3) {
                this.checkRTCPMissingWarning();
            }
            if (bl3 && (rTPPacket.getCodec() != 7 || bl2)) {
                long l = this.rtcpHandler.convertTimeSyncTimecode(rTPPacket.getTimecode(), n);
                if (this.isFirstPacket) {
                    if (rTPPacket.getCodec() == 7) {
                        byArray = this.getCodecConfig(rTPTrack);
                        if (this.debugLog) {
                            WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).debug("RTPDePacketizerVideoBase.sendPacket: writeCodecConfig\n" + (byArray == null ? "null" : DebugUtils.formatBytes(byArray)));
                        }
                        if (byArray != null) {
                            RTPUtils.writeCodecConfig(rTPTrack, l, byArray);
                        }
                    }
                    this.isFirstPacket = false;
                }
                if (this.debugLog) {
                    rTPPacket.setDebugLog(true);
                }
                rTPPacket.write(rTPTrack, l, bl);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).error("RTPDePacketizerVideoBase.sendPacket: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

