/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.util.FLVUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerList;
import com.wowza.wms.rtp.model.RTPPacketizerItem;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPSessions;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.transport.UDPTransportManager;
import com.wowza.wms.rtsp.RTSPTunnelingSession;
import com.wowza.wms.server.Server;
import com.wowza.wms.transport.udp.UDPPortManager;
import com.wowza.wms.vhost.IVHost;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RTPContext {
    private RTPSessions sessions = null;
    private IVHost vhost = null;
    private Map<String, RTPStream> cacheRTPStreams = new HashMap<String, RTPStream>();
    private RTPDePacketizerList rtpDePacketizerList = new RTPDePacketizerList();
    private UDPPortManager udpPortManager = null;
    private Map<Integer, RTPPacketizerItem> audioPacketizers = new HashMap<Integer, RTPPacketizerItem>();
    private Map<Integer, RTPPacketizerItem> videoPacketizers = new HashMap<Integer, RTPPacketizerItem>();
    private Map<Integer, RTPPacketizerItem> streamPacketizers = new HashMap<Integer, RTPPacketizerItem>();
    private Map<String, RTSPTunnelingSession> rtspTunnelingSessions = new HashMap<String, RTSPTunnelingSession>();

    public RTPContext(IVHost iVHost) {
        this.vhost = iVHost;
        this.sessions = new RTPSessions(this.vhost);
        this.udpPortManager = Server.getInstance().getUDPPortManager();
        this.putAudioPacketizerItem(10, new RTPPacketizerItem("com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC"));
        this.putAudioPacketizerItem(2, new RTPPacketizerItem("com.wowza.wms.rtp.packetizer.RTPPacketizerRFC2250MP3"));
        this.putAudioPacketizerItem(11, new RTPPacketizerItem("com.wowza.wms.rtp.packetizer.RTPPacketizerSpeex"));
        this.putVideoPacketizerItem(7, new RTPPacketizerItem("com.wowza.wms.rtp.packetizer.RTPPacketizerRFC3984H264"));
        this.putVideoPacketizerItem(2, new RTPPacketizerItem("com.wowza.wms.rtp.packetizer.RTPPacketizerRFC2190H263"));
        this.putStreamPacketizerItem(0, new RTPPacketizerItem("com.wowza.wms.rtp.packetizer.RTPPacketizerMPEGTS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWatchdog() {
        ArrayList<RTSPTunnelingSession> arrayList = null;
        Map<String, RTSPTunnelingSession> map = this.rtspTunnelingSessions;
        synchronized (map) {
            if (this.rtspTunnelingSessions.size() > 0) {
                arrayList = new ArrayList<RTSPTunnelingSession>();
                arrayList.addAll(this.rtspTunnelingSessions.values());
            }
        }
        if (arrayList != null) {
            long l = System.currentTimeMillis();
            for (RTSPTunnelingSession rTSPTunnelingSession : arrayList) {
                long l2 = rTSPTunnelingSession.getCloseTime();
                if (l2 < 0L || l - l2 <= 10000L) continue;
                String string = rTSPTunnelingSession.getRTSPTunnelingSessionId();
                rTSPTunnelingSession.shutdown();
                Map<String, RTSPTunnelingSession> map2 = this.rtspTunnelingSessions;
                synchronized (map2) {
                    this.rtspTunnelingSessions.remove(string);
                }
            }
        }
    }

    public void init() {
    }

    public void shutdown() {
    }

    public RTPPacketizerItem getAudioPacketizerItem(IApplicationInstance iApplicationInstance, int n) {
        String string = iApplicationInstance.getRTPProperties().getPropertyStr("audioPacketizer" + FLVUtils.audioCodecToString(n), null);
        if (string != null) {
            return new RTPPacketizerItem(string);
        }
        return this.audioPacketizers.get(new Integer(n));
    }

    public void putAudioPacketizerItem(int n, RTPPacketizerItem rTPPacketizerItem) {
        this.audioPacketizers.put(new Integer(n), rTPPacketizerItem);
    }

    public RTPPacketizerItem getVideoPacketizerItem(IApplicationInstance iApplicationInstance, int n) {
        String string = iApplicationInstance.getRTPProperties().getPropertyStr("videoPacketizer" + FLVUtils.videoCodecToString(n), null);
        if (string != null) {
            return new RTPPacketizerItem(string);
        }
        return this.videoPacketizers.get(new Integer(n));
    }

    public void putVideoPacketizerItem(int n, RTPPacketizerItem rTPPacketizerItem) {
        this.videoPacketizers.put(new Integer(n), rTPPacketizerItem);
    }

    public RTPPacketizerItem getStreamPacketizerItem(IApplicationInstance iApplicationInstance, int n) {
        String string = iApplicationInstance.getRTPProperties().getPropertyStr("streamPacketizer" + FLVUtils.streamCodecToString(n), null);
        if (string != null) {
            return new RTPPacketizerItem(string);
        }
        return this.streamPacketizers.get(new Integer(n));
    }

    public void putStreamPacketizerItem(int n, RTPPacketizerItem rTPPacketizerItem) {
        this.streamPacketizers.put(new Integer(n), rTPPacketizerItem);
    }

    public RTPSessions getSessions() {
        return this.sessions;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    public UDPTransportManager getUDPTransportManager() {
        return this.vhost.getUDPTransportManager();
    }

    public Object getLock() {
        return this.udpPortManager.getLock();
    }

    public boolean acquireSocketAddress(SocketAddress socketAddress) {
        return this.udpPortManager.acquireSocketAddress(socketAddress);
    }

    public boolean releaseSocketAddress(SocketAddress socketAddress) {
        return this.udpPortManager.releaseSocketAddress(socketAddress);
    }

    public int acquireUDPPortPair(int n) {
        return this.udpPortManager.acquireUDPPortPair(n);
    }

    public int[] expandToPortPair(int n) {
        return this.udpPortManager.expandToPortPair(n);
    }

    public int acquireUDPPortPair() {
        return this.udpPortManager.acquireUDPPortPair();
    }

    public void releaseUDPPortPair(int n) {
        this.udpPortManager.releaseUDPPortPair(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheRTPStream(RTPStream rTPStream) {
        Map<String, RTPStream> map = this.cacheRTPStreams;
        synchronized (map) {
            this.cacheRTPStreams.put(rTPStream.getStreamId(), rTPStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPStream uncacheRTPStream(String string) {
        RTPStream rTPStream = null;
        Map<String, RTPStream> map = this.cacheRTPStreams;
        synchronized (map) {
            rTPStream = this.cacheRTPStreams.remove(string);
        }
        return rTPStream;
    }

    public RTPDePacketizerList getDePacketizerList() {
        return this.rtpDePacketizerList;
    }

    public String getDePacketizerName(RTPTrack rTPTrack) {
        String string = null;
        List<String> list = this.rtpDePacketizerList.getDePacketizerItemNames();
        for (String string2 : list) {
            RTPDePacketizerItem rTPDePacketizerItem = this.rtpDePacketizerList.getDePacketizerItem(string2);
            IRTPDePacketizer iRTPDePacketizer = rTPDePacketizerItem.getInstance();
            if (iRTPDePacketizer == null || !iRTPDePacketizer.canHandle(rTPTrack)) continue;
            string = string2;
            break;
        }
        return string;
    }

    public Object getRTSPTunnelingLock() {
        return this.rtspTunnelingSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTSPTunnelingSession getRTSPTunnelingSession(String string) {
        Map<String, RTSPTunnelingSession> map = this.rtspTunnelingSessions;
        synchronized (map) {
            return this.rtspTunnelingSessions.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTSPTunnelingSession removeRTSPTunnelingSession(String string) {
        Map<String, RTSPTunnelingSession> map = this.rtspTunnelingSessions;
        synchronized (map) {
            return this.rtspTunnelingSessions.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsRTSPTunnelingSession(String string) {
        Map<String, RTSPTunnelingSession> map = this.rtspTunnelingSessions;
        synchronized (map) {
            return this.rtspTunnelingSessions.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRTSPTunnelingSession(String string, RTSPTunnelingSession rTSPTunnelingSession) {
        Map<String, RTSPTunnelingSession> map = this.rtspTunnelingSessions;
        synchronized (map) {
            this.rtspTunnelingSessions.put(string, rTSPTunnelingSession);
        }
    }

    public void shutdownRTPSession(RTPSession rTPSession) {
        String string = rTPSession.getSessionId();
        try {
            RTPSessions rTPSessions = this.getSessions();
            rTPSessions.notifySessionDestroy(rTPSession.getAppInstance(), rTPSession);
            rTPSession.shutdown();
            rTPSessions.removeSession(rTPSession);
            if (rTPSession.isLoggedConnect()) {
                rTPSession.updateLoggingValues();
                WMSLoggerFactory.getLoggerObj(rTPSession.getAppInstance()).info(null, null, "rtsp", "disconnect", 200, string);
                rTPSession.clearLoggingValues();
                rTPSession.setLoggedConnect(false);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("RTPContext.shutdownRTPSession[" + string + "]: " + exception.toString());
        }
    }
}

