/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerAudioBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerSpeex
extends RTPPacketizerAudioBase
implements IRTPPacketizer {
    protected int maxPacketSize = 1438;
    protected List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    protected int timescale = -1;
    protected int channels = -1;

    public RTPPacketizerSpeex() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
        this.sdpTypeId = 97;
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n = 0;
        n += this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            int n2;
            int n3;
            if (aMFPacket.getSize() >= 2 && (n3 = FLVUtils.getAudioCodec(n2 = aMFPacket.getFirstByte())) == 11) {
                int n4;
                byte[] byArray = aMFPacket.getData();
                int n5 = 1;
                int n6 = aMFPacket.getSize() - n5;
                int n7 = rTPTrack.getTimescale();
                int n8 = 0;
                do {
                    if ((n4 = this.maxPacketSize) > n6 - n8) {
                        n4 = n6 - n8;
                    }
                    int n9 = 0;
                    if (n4 % 4 > 0) {
                        n9 = 4 - n4 % 4;
                    }
                    int n10 = 12 + n4 + n9;
                    byte[] byArray2 = new byte[n10];
                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray2, n10, l * (long)n7 / 1000L));
                    System.arraycopy(byArray, n5 + n8, byArray2, 12, n4);
                    for (int i = 0; i < n9; ++i) {
                        byArray2[12 + n4 + i] = (byte)(i == 0 ? 127 : 255);
                    }
                } while ((n8 += n4) < n6);
                n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerSpeex.class).error("RTPPacketizerSpeex.handleAMFPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return n;
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, AMFPacket aMFPacket2, int n, int n2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        this.channels = 1;
        this.timescale = n2;
        try {
            if (aMFPacket != null) {
                object = aMFPacket.getData();
                int n3 = 1;
                int n4 = aMFPacket.getSize() - n3;
                if (this.timescale <= 0) {
                    this.timescale = 16000;
                }
                if ((object[0] & 1) == 1) {
                    this.channels = 2;
                }
            }
            stringBuffer.append("a=rtpmap:" + this.sdpTypeId + " SPEEX/" + this.timescale + "/" + this.channels + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerSpeex.class).error("RTPPacketizerSpeex.handleAMFPacket: " + exception.toString());
        }
        object = new RTPDescribeInfo();
        ((RTPDescribeInfo)object).setSDPStr(stringBuffer.toString());
        ((RTPDescribeInfo)object).setTimescale(this.timescale);
        ((RTPDescribeInfo)object).setChannels(this.channels);
        ((RTPDescribeInfo)object).setSDPTypeId(this.sdpTypeId);
        return object;
    }
}

