/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.util.BufferUtils;
import com.wowza.util.HTTPUtils;
import com.wowza.util.MD5DigestUtils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubSes {
    public static final int ENCKEYBITLENGTH = 128;
    public static final int ENCKEYBYTELENGTH = 16;
    private Map<String, String> cookies = new HashMap<String, String>();
    private String nonce = null;
    private boolean authenticated = false;
    private KeyPair dhKeyPair = null;
    private byte[] encKey = null;
    private SecretKeySpec encKeySpec = null;
    private String serverNonce = null;
    private String serverRealm = null;
    private String serialNumber = null;
    private String macAddress = null;
    private String wowzaProVersion = null;
    private String encStr = null;

    public Map<String, String> processHeaders(Map<String, List<String>> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (map == null) {
            return hashMap;
        }
        for (String string : map.keySet()) {
            for (String string2 : map.get(string)) {
                String[] stringArray;
                String string3;
                String string4;
                String string5;
                int n;
                if (string == null) {
                    int n2 = string2.indexOf(" ");
                    n = string2.indexOf(" ", n2 + 1);
                    if (n2 < 0 || n < 0) continue;
                    string5 = string2.substring(0, n2);
                    string4 = string2.substring(n2 + 1, n);
                    string3 = string2.substring(n + 1);
                    hashMap.put("header-protocol", string5);
                    hashMap.put("header-status", string4);
                    hashMap.put("header-message", string3);
                    continue;
                }
                if (string.equalsIgnoreCase(RTMPRequestAdapter.fN(ModuleConnect.getNS(11)))) {
                    String[] stringArray2 = string2.split("[;]");
                    if (stringArray2.length <= 0) continue;
                    n = stringArray2[0].indexOf("=");
                    string5 = stringArray2[0].substring(0, n).trim();
                    string4 = stringArray2[0].substring(n + 1).trim();
                    this.cookies.put(string5, string4);
                    continue;
                }
                if (!string.equalsIgnoreCase(RTMPRequestAdapter.fN(ModuleConnect.getNS(10))) || (stringArray = HTTPUtils.splitPragmas(string2)) == null) continue;
                for (n = 0; n < stringArray.length; ++n) {
                    string5 = stringArray[n];
                    int n3 = string5.indexOf("=");
                    if (n3 < 0) continue;
                    string3 = string5.substring(0, n3).trim();
                    String string6 = string5.substring(n3 + 1).trim();
                    if (string6.charAt(0) == '\"') {
                        string6 = string6.substring(1);
                    }
                    if (string6.charAt(string6.length() - 1) == '\"') {
                        string6 = string6.substring(0, string6.length() - 1);
                    }
                    hashMap.put(string3, string6);
                }
            }
        }
        return hashMap;
    }

    public String getValidateResponse(String string, String string2) {
        String string3 = null;
        try {
            string3 = MD5DigestUtils.generateHash(string + ":" + this.encStr + ":" + string2);
        }
        catch (Exception exception) {
            System.out.println("SubscriptionSession.getValidateResponse: " + exception.toString());
        }
        return string3;
    }

    public String generateNonce() {
        if (this.nonce == null) {
            this.nonce = MD5DigestUtils.generateHash(System.currentTimeMillis() + ":" + RTMPRequestAdapter.fN(ModuleConnect.getNS(3)));
        }
        return this.nonce;
    }

    public String getAuhtorizeResponse(String string, String string2) {
        String string3 = null;
        try {
            string3 = MD5DigestUtils.generateHash(string + ":" + RTMPRequestAdapter.fN(ModuleConnect.getNS(2)) + ":" + RTMPRequestAdapter.fN(ModuleConnect.getNS(3)) + ":" + string2);
        }
        catch (Exception exception) {
            System.out.println("SubscriptionSession.getAuhtorizeResponse: " + exception.toString());
        }
        return string3;
    }

    public boolean authorize(String string, String string2) {
        try {
            this.authenticated = string.equalsIgnoreCase(this.getAuhtorizeResponse(this.nonce, string2));
        }
        catch (Exception exception) {
            System.out.println("SubscriptionSession.authorize: " + exception.toString());
        }
        return this.authenticated;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getCookieValues() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.cookies.keySet()) {
            String string2 = this.cookies.get(string);
            if (stringBuffer.length() > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(string + "=" + string2);
        }
        return stringBuffer.toString();
    }

    public String getDHKey() {
        String string = null;
        try {
            BigInteger bigInteger = new BigInteger(RTMPRequestAdapter.fN(ModuleConnect.getNS(1)), 16);
            BigInteger bigInteger2 = BigInteger.valueOf(2L);
            DHParameterSpec dHParameterSpec = new DHParameterSpec(bigInteger, bigInteger2, 1023);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RTMPRequestAdapter.fN(ModuleConnect.getNS(6)));
            keyPairGenerator.initialize(dHParameterSpec);
            this.dhKeyPair = keyPairGenerator.genKeyPair();
            DHPublicKey dHPublicKey = (DHPublicKey)this.dhKeyPair.getPublic();
            byte[] byArray = BufferUtils.decodeHexString(dHPublicKey.getY().toString(16));
            string = BufferUtils.encodeHexString(byArray);
        }
        catch (Exception exception) {
            System.out.println("SubscriptionSession.getDHKey: " + exception.toString());
        }
        return string;
    }

    public void calculateEncryptionKey(String string) {
        try {
            BigInteger bigInteger = new BigInteger(RTMPRequestAdapter.fN(ModuleConnect.getNS(1)), 16);
            BigInteger bigInteger2 = BigInteger.valueOf(2L);
            KeyFactory keyFactory = KeyFactory.getInstance(RTMPRequestAdapter.fN(ModuleConnect.getNS(6)));
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(new BigInteger(string, 16), bigInteger, bigInteger2);
            DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(dHPublicKeySpec);
            KeyAgreement keyAgreement = KeyAgreement.getInstance(RTMPRequestAdapter.fN(ModuleConnect.getNS(6)));
            keyAgreement.init(this.dhKeyPair.getPrivate());
            keyAgreement.doPhase(dHPublicKey, true);
            byte[] byArray = keyAgreement.generateSecret();
            this.encStr = BufferUtils.encodeHexString(byArray);
            this.encKey = new byte[16];
            System.arraycopy(byArray, 0, this.encKey, 0, this.encKey.length);
            KeyGenerator keyGenerator = KeyGenerator.getInstance(RTMPRequestAdapter.fN(ModuleConnect.getNS(7)));
            keyGenerator.init(128);
            this.encKeySpec = new SecretKeySpec(this.encKey, RTMPRequestAdapter.fN(ModuleConnect.getNS(7)));
        }
        catch (Exception exception) {
            System.out.println("SubscriptionSession.calculateEncryptionKey: " + exception.toString());
        }
    }

    public byte[] getEncKey() {
        return this.encKey;
    }

    public SecretKeySpec getEncKeySpec() {
        return this.encKeySpec;
    }

    public byte[] decodeFromStr(String string) {
        byte[] byArray = BufferUtils.decodeHexString(string);
        if (byArray != null) {
            return this.decode(byArray, 0, byArray.length);
        }
        return null;
    }

    public byte[] decode(byte[] byArray, int n, int n2) {
        if (this.encKeySpec == null) {
            return null;
        }
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance(RTMPRequestAdapter.fN(ModuleConnect.getNS(7)));
            cipher.init(2, this.encKeySpec);
            byArray2 = cipher.doFinal(byArray, n, n2);
        }
        catch (Exception exception) {
            System.out.println("SubscriptionSession.decode: " + exception.toString());
        }
        return byArray2;
    }

    public String encodeToStr(byte[] byArray, int n, int n2) {
        String string = null;
        byte[] byArray2 = this.encode(byArray, n, n2);
        if (byArray2 != null) {
            string = BufferUtils.encodeHexString(byArray2);
        }
        return string;
    }

    public byte[] encode(byte[] byArray, int n, int n2) {
        if (this.encKeySpec == null) {
            return null;
        }
        byte[] byArray2 = null;
        try {
            Cipher cipher = Cipher.getInstance(RTMPRequestAdapter.fN(ModuleConnect.getNS(7)));
            cipher.init(1, this.encKeySpec);
            byArray2 = cipher.doFinal(byArray, n, n2);
        }
        catch (Exception exception) {
            System.out.println("SubscriptionSession.encode: " + exception.toString());
        }
        return byArray2;
    }

    public String getServerNonce() {
        return this.serverNonce;
    }

    public void setServerNonce(String string) {
        this.serverNonce = string;
    }

    public String getServerRealm() {
        return this.serverRealm;
    }

    public void setServerRealm(String string) {
        this.serverRealm = string;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String string) {
        this.macAddress = string;
    }

    public String getWowzaProVersion() {
        return this.wowzaProVersion;
    }

    public void setWowzaProVersion(String string) {
        this.wowzaProVersion = string;
    }
}

