/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.livetranscoder;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.livetranscoder.ILiveStreamTranscoder;
import com.wowza.wms.stream.livetranscoder.LiveStreamTranscoderItem;

public class LiveStreamTranscoderFactory {
    public static ILiveStreamTranscoder createInstance(IMediaStream iMediaStream, LiveStreamTranscoderItem liveStreamTranscoderItem) {
        ILiveStreamTranscoder iLiveStreamTranscoder = null;
        try {
            String string = iMediaStream.getName();
            String string2 = liveStreamTranscoderItem.getName();
            String string3 = liveStreamTranscoderItem.getBaseClass();
            IApplicationInstance iApplicationInstance = iMediaStream.getStreams().getAppInstance();
            Class<?> clazz = Class.forName(string3);
            if (clazz == null) {
                WMSLoggerFactory.getLogger(null).warn("LiveStreamTranscoderFactory.createInstance: Class not found: " + string3);
            } else {
                iLiveStreamTranscoder = (ILiveStreamTranscoder)clazz.newInstance();
                if (iLiveStreamTranscoder == null) {
                    WMSLoggerFactory.getLogger(null).warn("LiveStreamTranscoderFactory.createInstance: Instance not created: " + string3);
                } else {
                    iApplicationInstance.notifyLiveStreamTranscoderCreate(iLiveStreamTranscoder, iMediaStream);
                    iLiveStreamTranscoder.init(string, string2, iApplicationInstance, liveStreamTranscoderItem);
                    iApplicationInstance.notifyLiveStreamTranscoderInit(iLiveStreamTranscoder, iMediaStream);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("LiveStreamTranscoderFactory.createInstance: " + exception.toString());
            exception.printStackTrace();
        }
        return iLiveStreamTranscoder;
    }
}

