/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.HTTPUtils;
import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.AuthenticationItem;
import com.wowza.wms.authentication.AuthenticationList;
import com.wowza.wms.authentication.IAuthenticateUsernamePasswordProvider;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationUtils {
    public static IAuthenticateUsernamePasswordProvider createUsernamePasswordProvider(String string) {
        IAuthenticateUsernamePasswordProvider iAuthenticateUsernamePasswordProvider = null;
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz != null) {
                iAuthenticateUsernamePasswordProvider = (IAuthenticateUsernamePasswordProvider)clazz.newInstance();
            } else {
                WMSLoggerFactory.getLogger(AuthenticationUtils.class).warn("IAuthenticateUsernamePasswordProvider.createUsernamePasswordProvider: Error creating UsernamePasswordProvider[" + string + "]");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AuthenticationUtils.class).error("IAuthenticateUsernamePasswordProvider.createUsernamePasswordProvider: Error creating UsernamePasswordProvider[" + string + "]: " + exception.toString());
        }
        return iAuthenticateUsernamePasswordProvider;
    }

    private static String removeQuotes(String string) {
        return AuthenticationUtils.removeQuotes(string, false);
    }

    private static String removeQuotes(String string, boolean bl) {
        if (string.length() > 0 && string.charAt(0) != '\"' && !bl) {
            return string;
        }
        if (string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        return new String();
    }

    public static Map<String, String> parseAuthenticationValues(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = HTTPUtils.splitPragmas(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = string2.indexOf(61);
            if (n < 0) continue;
            String string3 = string2.substring(0, n).trim().toLowerCase();
            String string4 = string2.substring(n + 1).trim();
            if (string3.length() <= 0) continue;
            string4 = "realm".equals(string3) ? AuthenticationUtils.removeQuotes(string4, true) : AuthenticationUtils.removeQuotes(string4);
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public static int passwordFileFormatNameToId(String string) {
        int n = 0;
        if (string.toLowerCase().equals("clear")) {
            n = 1;
        }
        return n;
    }

    public static String passwordFileFormatIdToName(int n) {
        switch (n) {
            case 1: {
                return "clear";
            }
        }
        return "unkown";
    }

    private static void loadAuthenticationMethods(AuthenticationList authenticationList, Element element) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string = "/Root/Authentication/Methods/Method";
            XPathExpression xPathExpression = xPath.compile(string);
            String string2 = "Properties/Property";
            XPathExpression xPathExpression2 = xPath.compile(string2);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Object object;
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    Node node2 = XMLUtils.getNodeByTagName(element2, "Name");
                    Node node3 = XMLUtils.getNodeByTagName(element2, "Class");
                    Node node4 = XMLUtils.getNodeByTagName(element2, "Description");
                    if (node2 == null || node3 == null) continue;
                    Object object2 = XMLUtils.getNodeValue(node2);
                    String string3 = XMLUtils.getNodeValue(node3);
                    String string4 = null;
                    if (node4 != null) {
                        string4 = XMLUtils.getNodeValue(node4);
                    }
                    if (authenticationList.exists((String)object2)) {
                        int n = 1;
                        while (authenticationList.exists((String)(object = (String)object2 + "[" + n + "]"))) {
                            ++n;
                        }
                        object2 = object;
                    }
                    object = new AuthenticationItem((String)object2, string3);
                    if (string4 != null) {
                        ((AuthenticationItem)object).setDescription(string4);
                    }
                    WMSProperties wMSProperties = ((AuthenticationItem)object).getProperties();
                    NodeList nodeList2 = (NodeList)xPathExpression2.evaluate(element2, XPathConstants.NODESET);
                    if (nodeList2 != null) {
                        XMLUtils.loadConfigProperies(nodeList2, wMSProperties);
                    }
                    authenticationList.put((String)object2, (AuthenticationItem)object);
                }
            } else {
                WMSLoggerFactory.getLogger(RTPUtils.class).error("loadConfigFile: error parsing RTP config file: XPath " + string + " missing");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("error parsing RTP properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(IVHost iVHost, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                AuthenticationUtils.loadAuthenticationMethods(iVHost.getAuthenticationList(), element);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("error parsing RTP properties (" + string + "): " + exception.toString());
            exception.printStackTrace();
        }
    }
}

