/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.IVHostNotify;
import com.wowza.wms.vhost.VHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VHostSingleton {
    private static Map vhosts = new HashMap();
    private static List vhostListeners = new ArrayList();
    private static IServer server = null;

    public static IVHost getInstance(String string) {
        return VHostSingleton.getInstance(string, false);
    }

    public static IVHost getInstance(String string, boolean bl) {
        if (vhosts.get(string) == null && bl) {
            VHost vHost = new VHost(string);
            vhosts.put(string, vHost);
            if (server != null) {
                ((Server)server).onNewVHost(vHost);
            }
            VHostSingleton.notifyVHostCreate(vHost);
        }
        return (IVHost)vhosts.get(string);
    }

    public static void init(String string, String string2) {
        IVHost iVHost = (IVHost)vhosts.get(string);
        if (iVHost != null) {
            iVHost.init(string2);
            WMSLoggerFactory.initContextLogging(iVHost);
            WMSLoggerFactory.getLoggerObj(iVHost).info(null, null, "vhost", "vhost-start", 200, string);
            VHostSingleton.notifyVHostInit(iVHost);
        }
    }

    public static void setServer(IServer iServer) {
        server = iServer;
    }

    public static void shutdown(String string) {
        IVHost iVHost = (IVHost)vhosts.get(string);
        if (iVHost != null) {
            WMSLoggerFactory.getLoggerObj(iVHost).info(null, null, "vhost", "vhost-stop", 200, string);
        } else {
            WMSLoggerFactory.getLogger(VHostSingleton.class).info(null, null, "vhost", "vhost-stop", 200, string);
        }
        VHostSingleton.notifyVHostShutdownStart(iVHost);
        if (iVHost != null) {
            iVHost.shutdown();
        }
        vhosts.remove(string);
        VHostSingleton.notifyVHostShutdownComplete(iVHost);
    }

    public static List getVHostNames() {
        return new ArrayList(vhosts.keySet());
    }

    public static void remove(String string) {
        vhosts.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVHostListener(IVHostNotify iVHostNotify) {
        List list = vhostListeners;
        synchronized (list) {
            vhostListeners.add(iVHostNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeApplicationListener(IVHostNotify iVHostNotify) {
        List list = vhostListeners;
        synchronized (list) {
            vhostListeners.remove(iVHostNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyVHostClientConnect(IVHost iVHost, IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ArrayList arrayList = null;
        List list = vhostListeners;
        synchronized (list) {
            arrayList = new ArrayList(vhostListeners);
        }
        for (IVHostNotify iVHostNotify : arrayList) {
            iVHostNotify.onVHostClientConnect(iVHost, iClient, requestFunction, aMFDataList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyVHostCreate(IVHost iVHost) {
        ArrayList arrayList = null;
        List list = vhostListeners;
        synchronized (list) {
            arrayList = new ArrayList(vhostListeners);
        }
        for (IVHostNotify iVHostNotify : arrayList) {
            iVHostNotify.onVHostCreate(iVHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyVHostInit(IVHost iVHost) {
        ArrayList arrayList = null;
        List list = vhostListeners;
        synchronized (list) {
            arrayList = new ArrayList(vhostListeners);
        }
        for (IVHostNotify iVHostNotify : arrayList) {
            iVHostNotify.onVHostInit(iVHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyVHostShutdownStart(IVHost iVHost) {
        ArrayList arrayList = null;
        List list = vhostListeners;
        synchronized (list) {
            arrayList = new ArrayList(vhostListeners);
        }
        for (IVHostNotify iVHostNotify : arrayList) {
            iVHostNotify.onVHostShutdownStart(iVHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyVHostShutdownComplete(IVHost iVHost) {
        ArrayList arrayList = null;
        List list = vhostListeners;
        synchronized (list) {
            arrayList = new ArrayList(vhostListeners);
        }
        for (IVHostNotify iVHostNotify : arrayList) {
            iVHostNotify.onVHostShutdownComplete(iVHost);
        }
    }
}

