/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.dvr;

import com.wowza.util.BufferUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.DvrPlayerAdapterBase;
import com.wowza.wms.dvr.IDvrManifest;
import com.wowza.wms.dvr.IDvrStore;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerAdapterSmoothStreamer;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.stream.MediaStreamMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrPlayerAdapterSmoothStreaming
extends DvrPlayerAdapterBase {
    private static final Object CLASSNAME = "DvrPlayerAdapterSmoothStreaming";

    public byte[] getAbsolutePlaylist(String string, IApplicationInstance iApplicationInstance, String string2, String string3, long l) {
        if (string == null || iApplicationInstance == null || string2 == null || string3 == null) {
            return null;
        }
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string2, false);
        return this.getAbsolutePlaylist(iDvrStore, string3, l);
    }

    public byte[] getAbsolutePlaylist(IDvrStore iDvrStore, String string, long l) {
        if (iDvrStore == null || string == null) {
            return null;
        }
        String string2 = iDvrStore.getDvrStoreName();
        int n = iDvrStore.getMinimumAvailableChunks();
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DvrPlayerAdapterSmoothStreaming.class);
        wMSLogger.info(String.format("%s.getAbsolutePlaylist() dvr=%s streamName=%s t=%d", CLASSNAME, iDvrStore, string, l));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("\n");
        stringBuffer.append(String.format("<SmoothStreamingMedia MajorVersion=\"2\" MinorVersion=\"1\" Duration=\"0\" Timescale=\"10000000\" LookAheadFragmentCount=\"%d\" DVRWindowLength=\"0\" IsLive=\"TRUE\">", n)).append("\n");
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string, false);
        if (iDvrStreamStore == null) {
            return null;
        }
        long l2 = this.determineDvrStartTime(l, iDvrStreamStore);
        long l3 = iDvrStreamStore.calculateClosestTime(8, l2);
        DvrChunk dvrChunk = iDvrStore.getDvrChunkAtTime(string, 8, l3);
        DvrChunk dvrChunk2 = iDvrStore.getDvrChunkAtTime(string, 9, l2);
        IDvrManifest iDvrManifest = iDvrStreamStore.getManifest();
        List list = iDvrManifest.getDvrEntriesAtTime(9, l2);
        stringBuffer.append(this.getVideoManifest(list, dvrChunk2, string2));
        List list2 = iDvrManifest.getDvrEntriesAtTime(8, l3);
        stringBuffer.append(this.getAudioManifest(list2, dvrChunk, string2));
        stringBuffer.append("</SmoothStreamingMedia>\n");
        return stringBuffer.toString().getBytes();
    }

    public byte[] getDeltaPlaylist(String string, IApplicationInstance iApplicationInstance, String string2, String string3, long l) {
        if (string == null || iApplicationInstance == null || string2 == null || string3 == null) {
            return null;
        }
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string2, false);
        return this.getDeltaPlaylist(iDvrStore, string3, l);
    }

    public byte[] getDeltaPlaylist(IDvrStore iDvrStore, String string, long l) {
        if (iDvrStore == null || string == null) {
            return null;
        }
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string, false);
        long l2 = iDvrStreamStore.getTimeController().getCurrentTime();
        long l3 = l2 + l * 1000L;
        if (l3 < 0L) {
            l3 = 0L;
        }
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(DvrPlayerAdapterSmoothStreaming.class);
        wMSLogger.info(String.format("%s.getDeltaPlaylist() dvrTime=%d delta=%d t=%d", CLASSNAME, l2, l, l3));
        return this.getAbsolutePlaylist(iDvrStore, string, l3);
    }

    private String getAudioManifest(List<DvrManifestEntry> list, DvrChunk dvrChunk, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        if (n > 0) {
            MediaCodecInfoAudio mediaCodecInfoAudio = (MediaCodecInfoAudio)dvrChunk.getMediaInfoAudio();
            int n2 = mediaCodecInfoAudio.getCodecId();
            int n3 = mediaCodecInfoAudio.getAudioSampleFrequency();
            byte[] byArray = mediaCodecInfoAudio.getCodecConfig();
            String string2 = BufferUtils.encodeHexString((byte[])byArray);
            int n4 = dvrChunk.getBitrate();
            String string3 = "AACL";
            String string4 = "255";
            if (n2 == 10) {
                string3 = "AACL";
                string4 = "255";
            } else if (n2 == 2) {
                string3 = "WMAP";
                string4 = "85";
            }
            String string5 = String.format("QualityLevels({bitrate})/Fragments(audio={start time})/WowzaSessions({sessionid}).isma?DVR=%s", string);
            stringBuffer.append(String.format("<StreamIndex Type=\"audio\" Chunks=\"%d\" QualityLevels=\"1\" Timescale=\"10000000\" Url=\"%s\">", n, string5));
            stringBuffer.append("\n");
            stringBuffer.append(String.format("<QualityLevel Bitrate=\"%d\" FourCC=\"%s\" SamplingRate=\"%d\" Channels=\"%d\" BitsPerSample=\"16\" PacketSize=\"2\" AudioTag=\"%s\" CodecPrivateData=\"%s\" />", n4, string3, n3, mediaCodecInfoAudio.getAudioChannels(), string4, string2)).append("\n");
            stringBuffer.append(this.recordsToManifestChunks(list));
            stringBuffer.append("</StreamIndex>").append("\n");
        }
        return stringBuffer.toString();
    }

    private String getVideoManifest(List<DvrManifestEntry> list, DvrChunk dvrChunk, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        if (n > 0) {
            MediaCodecInfoVideo mediaCodecInfoVideo = (MediaCodecInfoVideo)dvrChunk.getMediaInfoVideo();
            int n2 = mediaCodecInfoVideo.getDisplayHeight();
            int n3 = mediaCodecInfoVideo.getDisplayWidth();
            byte[] byArray = mediaCodecInfoVideo.getCodecConfig();
            String string2 = "";
            H264CodecConfigParts h264CodecConfigParts = H264Utils.breakApartAVCC((byte[])byArray, (int)0, (int)byArray.length);
            if (h264CodecConfigParts != null) {
                byte[] byArray2 = H264Utils.configPartsToSmoothPrivateData((H264CodecConfigParts)h264CodecConfigParts);
                string2 = "CodecPrivateData=\"" + BufferUtils.encodeHexString((byte[])byArray2) + "\"";
            }
            int n4 = dvrChunk.getBitrate();
            String string3 = "H264";
            String string4 = String.format("QualityLevels({bitrate})/Fragments(video={start time})/WowzaSessions({sessionid}).ismv?DVR=%s", string);
            stringBuffer.append(String.format("<StreamIndex Type=\"video\" Chunks=\"%d\" QualityLevels=\"1\" MaxWidth=\"%d\" MaxHeight=\"%d\" DisplayWidth=\"%d\" DisplayHeight=\"%d\" Timescale=\"10000000\" Url=\"%s\">", n, n3, n2, n3, n2, string4));
            stringBuffer.append("\n");
            stringBuffer.append(String.format("<QualityLevel Index=\"0\" Bitrate=\"%d\" FourCC=\"%s\" MaxWidth=\"%d\" MaxHeight=\"%d\" %s />", n4, string3, n3, n2, string2)).append("\n");
            stringBuffer.append(this.recordsToManifestChunks(list));
            stringBuffer.append("</StreamIndex>").append("\n");
        }
        return stringBuffer.toString();
    }

    private String recordsToManifestChunks(List<DvrManifestEntry> list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                DvrManifestEntry dvrManifestEntry = list.get(i);
                long l = dvrManifestEntry.getStartTimecode();
                long l2 = dvrManifestEntry.getStopTimecode();
                String string = String.format("<c t=\"%d\" d=\"%d\"/>", l * 10000L, (l2 - l) * 10000L);
                stringBuffer.append(string).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public Object convertDvrChunks(DvrManifestEntry dvrManifestEntry, DvrChunk dvrChunk, DvrManifestEntry dvrManifestEntry2, DvrChunk dvrChunk2) {
        WMSLoggerFactory.getLogger(HTTPStreamerAdapterSmoothStreamer.class).info(CLASSNAME + ".convertDvrChunk vidChunk=" + dvrChunk);
        return null;
    }
}

