/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.net.SocketAddress;
import java.util.Set;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceListener;
import org.apache.mina.common.support.IoServiceListenerSupport;

public abstract class BaseIoService
implements IoService {
    private IoFilterChainBuilder filterChainBuilder = new DefaultIoFilterChainBuilder();
    private final IoServiceListenerSupport listeners = new IoServiceListenerSupport();

    protected BaseIoService() {
    }

    public IoFilterChainBuilder getFilterChainBuilder() {
        return this.filterChainBuilder;
    }

    public void setFilterChainBuilder(IoFilterChainBuilder ioFilterChainBuilder) {
        if (ioFilterChainBuilder == null) {
            ioFilterChainBuilder = new DefaultIoFilterChainBuilder();
        }
        this.filterChainBuilder = ioFilterChainBuilder;
    }

    public DefaultIoFilterChainBuilder getFilterChain() {
        if (this.filterChainBuilder instanceof DefaultIoFilterChainBuilder) {
            return (DefaultIoFilterChainBuilder)this.filterChainBuilder;
        }
        throw new IllegalStateException("Current filter chain builder is not a DefaultIoFilterChainBuilder.");
    }

    public void addListener(IoServiceListener ioServiceListener) {
        this.getListeners().add(ioServiceListener);
    }

    public void removeListener(IoServiceListener ioServiceListener) {
        this.getListeners().remove(ioServiceListener);
    }

    public Set getManagedServiceAddresses() {
        return this.getListeners().getManagedServiceAddresses();
    }

    public Set getManagedSessions(SocketAddress socketAddress) {
        return this.getListeners().getManagedSessions(socketAddress);
    }

    public boolean isManaged(SocketAddress socketAddress) {
        return this.getListeners().isManaged(socketAddress);
    }

    protected IoServiceListenerSupport getListeners() {
        return this.listeners;
    }
}

