/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.dvr;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.dvr.DvrChunk;
import com.wowza.wms.dvr.DvrChunkToAMFPacketParser;
import com.wowza.wms.dvr.DvrManifestEntry;
import com.wowza.wms.dvr.DvrPlayerAdapterBase;
import com.wowza.wms.dvr.IDvrManifest;
import com.wowza.wms.dvr.IDvrStore;
import com.wowza.wms.dvr.IDvrStreamStore;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoPacketHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoTSHolder;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.CupertinoTSPacketizer;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.LiveStreamPacketizerCupertinoUtils;
import com.wowza.wms.media.model.IMediaCodecInfo;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.stream.MediaStreamMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DvrPlayerAdapterCupertino
extends DvrPlayerAdapterBase {
    private static final Class<DvrPlayerAdapterCupertino> CLASS = DvrPlayerAdapterCupertino.class;
    private static final boolean debug = false;
    private static final Object CLASSNAME = "DvrPlayerAdapterCupertino";
    private CupertinoTSPacketizer tsPacketizer = new CupertinoTSPacketizer();

    public byte[] getAbsolutePlaylist(IDvrStore iDvrStore, String string, long l) {
        if (iDvrStore == null || string == null) {
            return null;
        }
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string, false);
        if (iDvrStreamStore == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#EXTM3U\n");
        stringBuffer.append("#EXT-X-ALLOW-CACHE:NO\n");
        stringBuffer.append("#EXT-X-TARGETDURATION:2\n");
        stringBuffer.append("#EXT-X-MEDIA-SEQUENCE:1\n");
        IDvrManifest iDvrManifest = iDvrStreamStore.getManifest();
        List list = iDvrManifest.getDvrEntriesAtTime(9, l);
        stringBuffer.append(this.getVideoManifest(list));
        return stringBuffer.toString().getBytes();
    }

    public byte[] getAbsolutePlaylist(String string, IApplicationInstance iApplicationInstance, String string2, String string3, long l) {
        if (string == null || iApplicationInstance == null || string2 == null || string3 == null) {
            return null;
        }
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string2, false);
        return this.getAbsolutePlaylist(iDvrStore, string3, l);
    }

    public byte[] getDeltaPlaylist(IDvrStore iDvrStore, String string, long l) {
        if (iDvrStore == null || string == null) {
            return null;
        }
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string, false);
        if (iDvrStreamStore == null) {
            return null;
        }
        return this.getDeltaPlaylist(iDvrStore, string, l);
    }

    public byte[] getDeltaPlaylist(String string, IApplicationInstance iApplicationInstance, String string2, String string3, long l) {
        if (string == null || iApplicationInstance == null || string2 == null || string3 == null) {
            return null;
        }
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        IDvrStore iDvrStore = mediaStreamMap.getDvrStore(string2, false);
        IDvrStreamStore iDvrStreamStore = iDvrStore.getStreamStore(string3, false);
        long l2 = iDvrStreamStore.getTimeController().getCurrentTime();
        long l3 = l2 + l * 1000L;
        if (l3 < 0L) {
            l3 = 0L;
        }
        return this.getAbsolutePlaylist(string, iApplicationInstance, string2, string3, l3);
    }

    private void addToChunk(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, CupertinoPacketHolder cupertinoPacketHolder, int n) {
        CupertinoTSHolder cupertinoTSHolder = null;
        if (cupertinoPacketHolder.getType() == 8) {
            byte[] byArray = null;
            byArray = n == 2 ? this.tsPacketizer.audioPacketsToMP3(cupertinoPacketHolder.getHolders()) : (n == 3 ? this.tsPacketizer.audioPacketsToAAC(cupertinoPacketHolder.getHolders()) : this.tsPacketizer.audioPacketsToTS(cupertinoPacketHolder.getHolders()));
            if (byArray != null) {
                cupertinoTSHolder = new CupertinoTSHolder(8, cupertinoPacketHolder.getCodec(), byArray, 0, byArray.length, cupertinoPacketHolder.getTimecode(), cupertinoPacketHolder.getTimecode90());
                cupertinoTSHolder.setDataLen(cupertinoPacketHolder.getDataLen());
            }
        } else if (cupertinoPacketHolder.getType() == 9) {
            if (cupertinoPacketHolder.isCodecConfig()) {
                this.tsPacketizer.videoCodecConfigIngest(cupertinoPacketHolder.getPacket());
            } else {
                byte[] byArray = this.tsPacketizer.videoPacketToTS(cupertinoPacketHolder);
                if (byArray != null) {
                    cupertinoTSHolder = new CupertinoTSHolder(9, cupertinoPacketHolder.getCodec(), byArray, 0, byArray.length, cupertinoPacketHolder.getTimecode(), cupertinoPacketHolder.getTimecode90());
                    cupertinoTSHolder.setDataLen(cupertinoPacketHolder.getDataLen());
                    cupertinoTSHolder.setKey(cupertinoPacketHolder.isKey());
                }
            }
        } else if (cupertinoPacketHolder.getType() == 18) {
            // empty if block
        }
        this.encryptAndAddTS(liveStreamPacketizerCupertinoChunk, cupertinoTSHolder);
    }

    private String getVideoManifest(List<DvrManifestEntry> list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                DvrManifestEntry dvrManifestEntry = list.get(i);
                long l = dvrManifestEntry.getStopTimecode() - dvrManifestEntry.getStartTimecode();
                stringBuffer.append("#EXTINF:" + LiveStreamPacketizerCupertinoUtils.millisToSecondsDuration(l) + "," + "\n");
                stringBuffer.append(String.format("dvr_%d.ts?%s", dvrManifestEntry.getIndex(), "{query}")).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public Object convertDvrChunks(DvrManifestEntry dvrManifestEntry, DvrChunk dvrChunk, DvrManifestEntry dvrManifestEntry2, DvrChunk dvrChunk2) {
        Object object;
        int n;
        byte[] byArray;
        if (dvrManifestEntry == null || dvrChunk == null || dvrManifestEntry2 == null || dvrChunk2 == null) {
            return null;
        }
        int n2 = 1;
        long l = dvrManifestEntry.getStartTimecode();
        long l2 = dvrManifestEntry.getStopTimecode();
        long l3 = l * 90L;
        LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk = new LiveStreamPacketizerCupertinoChunk(0);
        liveStreamPacketizerCupertinoChunk.setStartTimecode(l);
        liveStreamPacketizerCupertinoChunk.setCacheable(false);
        liveStreamPacketizerCupertinoChunk.setEncUrl(null);
        liveStreamPacketizerCupertinoChunk.setEncRepeaterBytes(null);
        liveStreamPacketizerCupertinoChunk.setStreamMode(n2);
        liveStreamPacketizerCupertinoChunk.setDuration(l2 - l);
        IMediaCodecInfo iMediaCodecInfo = dvrChunk2.getMediaInfoAudio();
        liveStreamPacketizerCupertinoChunk.setCodecInfoAudio((MediaCodecInfoAudio)iMediaCodecInfo);
        liveStreamPacketizerCupertinoChunk.setCodecInfoVideo((MediaCodecInfoVideo)dvrChunk.getMediaInfoVideo());
        int n3 = 10;
        if (iMediaCodecInfo != null) {
            n3 = iMediaCodecInfo.getCodecId();
        }
        if ((byArray = this.getCupertinoHeader(n2, n = 7, n3)) != null) {
            object = new CupertinoTSHolder(18, -1, byArray, 0, byArray.length, l, l3);
            this.encryptAndAddTS(liveStreamPacketizerCupertinoChunk, (CupertinoTSHolder)object);
        }
        object = new DvrChunkToAMFPacketParser();
        List list = object.createAMFPacketsFromAVChunk(dvrChunk);
        for (Object object2 : list) {
            CupertinoPacketHolder cupertinoPacketHolder2 = this.packetToHolder((AMFPacket)object2);
            this.addToChunk(liveStreamPacketizerCupertinoChunk, cupertinoPacketHolder2, n2);
        }
        list = object.createAMFPacketsFromAVChunk(dvrChunk2);
        CupertinoPacketHolder cupertinoPacketHolder = new CupertinoPacketHolder();
        cupertinoPacketHolder.setType(8);
        for (CupertinoPacketHolder cupertinoPacketHolder2 : list) {
            CupertinoPacketHolder cupertinoPacketHolder3 = this.packetToHolder((AMFPacket)cupertinoPacketHolder2);
            cupertinoPacketHolder.addHolder(cupertinoPacketHolder3);
        }
        this.addToChunk(liveStreamPacketizerCupertinoChunk, cupertinoPacketHolder, n2);
        liveStreamPacketizerCupertinoChunk.setAudioCount(cupertinoPacketHolder.getPacketCount());
        return liveStreamPacketizerCupertinoChunk;
    }

    public CupertinoPacketHolder packetToHolder(AMFPacket aMFPacket) {
        long l = aMFPacket.getAbsTimecode();
        boolean bl = FLVUtils.isAudioCodecConfig((AMFPacket)aMFPacket) || FLVUtils.isVideoCodecConfig((AMFPacket)aMFPacket);
        int n = aMFPacket.getType();
        int n2 = 0;
        if (n == 8) {
            n2 = FLVUtils.getAudioCodec((AMFPacket)aMFPacket);
        } else if (n == 9) {
            n2 = FLVUtils.getVideoCodec((AMFPacket)aMFPacket);
        }
        CupertinoPacketHolder cupertinoPacketHolder = new CupertinoPacketHolder(aMFPacket, n, n2, bl, l, l * 90L);
        if (n == 9) {
            cupertinoPacketHolder.setKey(FLVUtils.isVideoKeyFrame((AMFPacket)aMFPacket));
        }
        return cupertinoPacketHolder;
    }

    private byte[] getCupertinoHeader(int n, int n2, int n3) {
        byte[] byArray = null;
        if (n == 1) {
            byArray = this.tsPacketizer.getTSHeader(n2, n3);
        }
        return byArray;
    }

    private void encryptAndAddTS(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, CupertinoTSHolder cupertinoTSHolder) {
        if (cupertinoTSHolder != null) {
            this.addToChunkTS(liveStreamPacketizerCupertinoChunk, cupertinoTSHolder);
        }
    }

    private void addToChunkTS(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, CupertinoTSHolder cupertinoTSHolder) {
        if (liveStreamPacketizerCupertinoChunk != null) {
            byte[] byArray = cupertinoTSHolder.getBlock();
            switch (cupertinoTSHolder.getType()) {
                case 8: {
                    liveStreamPacketizerCupertinoChunk.incAudioCount();
                    break;
                }
                case 9: {
                    liveStreamPacketizerCupertinoChunk.incVideoCount();
                    if (!cupertinoTSHolder.isKey()) break;
                    liveStreamPacketizerCupertinoChunk.incVideoKeyCount();
                }
            }
            liveStreamPacketizerCupertinoChunk.addBlock(byArray, cupertinoTSHolder.getOffset(), cupertinoTSHolder.getLen());
            liveStreamPacketizerCupertinoChunk.incDataSize(cupertinoTSHolder.getDataLen());
        }
    }
}

